/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.connection;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionFactory;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;

public final class ConnectionFactoryTimeoutDecorator
implements IConnectionFactory {
    private final IConnectionFactory factory;
    private final Timer timer;
    private final int timeout;
    private final int checkPeriod;
    private final XQELogger errorLogger;
    private final ConcurrentLinkedQueue<ConnectionAttemptRecord> connectingQueue = new ConcurrentLinkedQueue();

    public static IConnectionFactory decorateIfNecessary(IConnectionFactory aFactory, Properties properties) {
        if (Integer.parseInt(properties.getProperty("connectionAttemptTimeout")) == -1) {
            return aFactory;
        }
        return new ConnectionFactoryTimeoutDecorator(aFactory, properties);
    }

    private ConnectionFactoryTimeoutDecorator(IConnectionFactory aFactory, Properties properties) {
        this(aFactory, properties, XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "QueryService", LogLevel.CRITICAL));
    }

    public ConnectionFactoryTimeoutDecorator(IConnectionFactory aFactory, Properties properties, XQELogger logger) {
        this.factory = aFactory;
        this.timer = (Timer)properties.get("timer");
        this.timeout = Integer.parseInt(properties.getProperty("connectionAttemptTimeout"));
        this.checkPeriod = Integer.parseInt(properties.getProperty("connectionAttemptCheckPeriod"));
        this.timer.schedule((TimerTask)new CheckConnectionAttemptTask(), this.checkPeriod, (long)this.checkPeriod);
        this.errorLogger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object createConnection(ConnectionParameters connectionParameters) {
        ConnectionAttemptRecord rec = new ConnectionAttemptRecord(connectionParameters);
        this.connectingQueue.add(rec);
        try {
            Object object = this.factory.createConnection(connectionParameters);
            return object;
        }
        finally {
            this.connectingQueue.remove(rec);
        }
    }

    @Override
    public void destroyConnection(IPooledConnection pooledConnection) {
        this.factory.destroyConnection(pooledConnection);
    }

    class ConnectionAttemptRecord {
        final long creation = System.currentTimeMillis();
        final ConnectionParameters params;

        ConnectionAttemptRecord(ConnectionParameters connParams) {
            this.params = connParams;
        }

        public String toString() {
            return String.format("The connection %1$s has been trying to connect for %2$d (ms)", this.params.toString(), System.currentTimeMillis() - this.creation);
        }

        public boolean createdBefore(long timestamp) {
            return this.creation <= timestamp;
        }
    }

    class CheckConnectionAttemptTask
    extends TimerTask {
        CheckConnectionAttemptTask() {
        }

        @Override
        public void run() {
            long timestamp = System.currentTimeMillis() - (long)ConnectionFactoryTimeoutDecorator.this.timeout;
            for (ConnectionAttemptRecord record : ConnectionFactoryTimeoutDecorator.this.connectingQueue) {
                if (!record.createdBefore(timestamp)) continue;
                ConnectionFactoryTimeoutDecorator.this.errorLogger.log(record.toString());
                ConnectionFactoryTimeoutDecorator.this.connectingQueue.remove(record);
            }
        }
    }
}

