/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.connection;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.connection.ConnectionFactoryLogDecorator;
import com.cognos.xqe.data.providers.connection.PooledConnectionLogDecorator;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionFactory;
import com.cognos.xqe.pool.connection.IConnectionPool;
import com.cognos.xqe.pool.connection.IConnectionSelector;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.pool.connection.poolfactory.IProviderConnectionPool;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.Map;
import java.util.Set;

public class ConnectionPoolLogger
implements IConnectionPool {
    public static final LogLevel LOGGING_LEVEL = LogLevel.INFO;
    public static final String CONNECTION_POOL_EVENT_GROUP = "Connection.Pool";
    public static final String CONNECTION_FACTORY_EVENT_GROUP = "Connection.Factory";
    private static final String OPEN = "(";
    private static final String CLOSE = ")";
    private static final String CLOSE_OPEN = ")(";
    private final IConnectionPool mConnectionPool;
    private final IExecutionEnvironment mExecutionEnvironment;
    private final XQELogger mConnectionPoolLogger;
    private final XQELogger mConnectionFactoryLogger;
    private final XQELogger ipfConnectionLogger;

    public ConnectionPoolLogger(IConnectionPool connectionPool, IExecutionEnvironment executionEnvironment) {
        this.mConnectionPool = connectionPool;
        this.mExecutionEnvironment = executionEnvironment;
        this.mConnectionPoolLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", CONNECTION_POOL_EVENT_GROUP, LOGGING_LEVEL);
        this.mConnectionFactoryLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", CONNECTION_FACTORY_EVENT_GROUP, LOGGING_LEVEL);
        this.ipfConnectionLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "QueryService.Connection", LogLevel.TRACE);
    }

    @Override
    public IPooledConnection borrowConnection(String adapterName, ConnectionParameters connectionParameters, IConnectionSelector connectionSelector, IConnectionFactory connectionFactory) {
        ConnectionFactoryLogDecorator connectionFactoryLogDecorator = new ConnectionFactoryLogDecorator(connectionFactory, this.mConnectionFactoryLogger, this.mExecutionEnvironment);
        if (this.mConnectionPoolLogger.isOn() || this.ipfConnectionLogger.isOn()) {
            StringBuilder buffer = new StringBuilder("borrowConnection in");
            buffer.append(OPEN).append(adapterName).append(CLOSE_OPEN).append(connectionParameters.toString()).append(CLOSE);
            String msg = buffer.toString();
            this.mConnectionPoolLogger.log(msg);
            this.ipfConnectionLogger.log(msg);
        }
        IPooledConnection pooledConnection = this.mConnectionPool.borrowConnection(adapterName, connectionParameters, connectionSelector, connectionFactoryLogDecorator);
        if (this.mConnectionPoolLogger.isOn() || this.ipfConnectionLogger.isOn()) {
            StringBuilder buffer = new StringBuilder("borrowConnection out");
            buffer.append(OPEN).append(adapterName).append(CLOSE_OPEN).append(connectionParameters.toString()).append(CLOSE).append(pooledConnection);
            String msg = buffer.toString();
            this.mConnectionPoolLogger.log(msg);
            this.ipfConnectionLogger.log(msg);
        }
        return new PooledConnectionLogDecorator(pooledConnection, this.mExecutionEnvironment);
    }

    @Override
    public IProviderConnectionPool getOrCreateProviderConnectionPool(String providerName) {
        return this.mConnectionPool.getOrCreateProviderConnectionPool(providerName);
    }

    @Override
    public void release() {
        this.mConnectionPoolLogger.log("release in");
        this.mConnectionPool.release();
        this.mConnectionPoolLogger.log("release out");
    }

    @Override
    public Map<String, Integer> getBorrowedConnectionStatistics() {
        return this.mConnectionPool.getBorrowedConnectionStatistics();
    }

    @Override
    public Map<String, Integer> getIdleConnectionStatistics() {
        return this.mConnectionPool.getIdleConnectionStatistics();
    }

    @Override
    public Map<String, Map<IPooledConnection, Set<Object>>> getCachingStatistics() {
        return this.mConnectionPool.getCachingStatistics();
    }

    @Override
    public void returnAllBorrowedConnections() {
        this.mConnectionPoolLogger.log("returnAllBorrowedConnections in");
        this.mConnectionPool.returnAllBorrowedConnections();
        this.mConnectionPoolLogger.log("returnAllBorrowedConnections out");
    }

    @Override
    public void closeAllIdleConnections() {
        this.mConnectionPoolLogger.log("closeAllIdleConnections in");
        this.mConnectionPool.closeAllIdleConnections();
        this.mConnectionPoolLogger.log("closeAllIdleConnections out");
    }
}

