/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.connection;

import com.cognos.xqe.data.model.ICubePasswordSignon;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.model.IUsernamePasswordSignon;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import java.util.Map;

public class ConnectionStringBuilder {
    private static final String EQUALS = "=";
    private static final String SEMICOLUMN = ";";
    private static final String CONN_STR_PARAM_LOCAL = ";LOCAL;";
    private static final String PLACEHOLDER = "%s";
    private static final String USER_ID_REQUIRED_MARKER = "^User ID:";
    private static final String PASSWORD_REQUIRED_MARKER = "^?Password:";
    private static final String SERVER = "SERVER";
    private static final String CATALOG = "CATALOG";
    private static final String CUBE = "CUBE";
    private static final String UID = "UID";
    private static final String PWD = "PWD";
    private static final String SSL = "SSL";
    private static final String SERVER_TYPE = "serverType";
    private static final String LOGON_GROUP = "logonGroup";
    private static final String SYSID = "sysid";
    private static final String SYSNR = "sysnr";
    private static final String CLIENT = "client";
    private static final String CODE_PAGE = "codePage";
    private static final String LCID = "LCID";
    private static final String TRUSTED_CONNECTION = "Trusted_Connection";
    private static final String WIN_PATH = "WIN_PATH";
    private static final String UNIX_PATH = "UNIX_PATH";
    private static final String TM1_ADMIN_HOST = "TM1AdminHost";
    private static final String TM1_SERVER_NAME = "TM1ServerName";
    public static final String TM1_PROTOCOL = "TM1Protocol";
    public static final String TM1_SERVER_PORT = "TM1ServerPort";

    @Deprecated
    public static String getConnectionString(Map<String, String> params) {
        String providerType = params.get("PROVIDER_TYPE");
        String connStr = "";
        if ("BW".equals(providerType)) {
            connStr = ConnectionStringBuilder.buildSBWODPConnectionString(params);
        } else if ("XI".equals(providerType) || "X5".equals(providerType) || "X8".equals(providerType) || "XO".equals(providerType)) {
            connStr = ConnectionStringBuilder.buildXMLAConnectionString(params);
        } else if ("PC".equals(providerType)) {
            connStr = ConnectionStringBuilder.buildPCConnectionString(params);
        } else if ("TM".equals(providerType)) {
            connStr = ConnectionStringBuilder.buildTM1ConnectionString(params);
        } else if ("TMR".equals(providerType)) {
            connStr = ConnectionStringBuilder.buildTMRConnectionString(params);
        } else if (DataSourceTypeEnum.isEssbase(providerType)) {
            connStr = ConnectionStringBuilder.buildEBConnectionString(params);
        } else if (DataSourceTypeEnum.isODBOMSAS(providerType)) {
            connStr = ConnectionStringBuilder.buildODBOConnectionString(params);
        } else {
            throw new RuntimeException("Unsupported Provider Type: " + providerType);
        }
        return connStr;
    }

    public static String substituteSignonInConnectionString(String connectionString, IDataSourceConnectionSignon signon) {
        String result;
        block8: {
            block7: {
                result = null;
                if (null == signon || null == connectionString) break block7;
                switch (signon.getType()) {
                    case USERNAME_PASSWORD: {
                        String connString = connectionString;
                        if (!connectionString.contains(USER_ID_REQUIRED_MARKER) || !connectionString.contains(PASSWORD_REQUIRED_MARKER)) {
                            connString = "^User ID:^?Password:" + connectionString;
                        }
                        IUsernamePasswordSignon useridSignon = (IUsernamePasswordSignon)signon;
                        result = connString.replaceAll(";UID=%s", ";UID=" + useridSignon.getUserName());
                        if (useridSignon.getPassword() != null && useridSignon.getPassword().hasValue()) {
                            result = result.replaceAll(";PWD=%s", ";PWD=" + useridSignon.getPassword().hashCode());
                            break;
                        }
                        break block8;
                    }
                    case CUBE_PASSWORD: {
                        ICubePasswordSignon cubpasswSignon = (ICubePasswordSignon)signon;
                        if (cubpasswSignon.getPassword() != null) {
                            result = connectionString.replaceAll(";cubePassword=%s", ";cubePassword=" + cubpasswSignon.getPassword().hashCode());
                            break;
                        }
                        break block8;
                    }
                    default: {
                        result = connectionString;
                        break;
                    }
                }
                break block8;
            }
            result = connectionString;
        }
        return result;
    }

    private static String buildTM1ConnectionString(Map<String, String> params) {
        StringBuilder buffer = new StringBuilder();
        ConnectionStringBuilder.writeProviderType(params, buffer);
        ConnectionStringBuilder.writeConnectionProperty(TM1_ADMIN_HOST, params.get(TM1_ADMIN_HOST), buffer);
        ConnectionStringBuilder.writeConnectionProperty(TM1_SERVER_NAME, params.get(TM1_SERVER_NAME), buffer);
        ConnectionStringBuilder.writeCredentialPlaceHolders(params, buffer);
        return buffer.toString();
    }

    private static String buildTMRConnectionString(Map<String, String> params) {
        StringBuilder buffer = new StringBuilder();
        ConnectionStringBuilder.writeProviderType(params, buffer);
        ConnectionStringBuilder.writeConnectionProperty(TM1_ADMIN_HOST, params.get(TM1_ADMIN_HOST), buffer);
        ConnectionStringBuilder.writeConnectionProperty(TM1_SERVER_NAME, params.get(TM1_SERVER_NAME), buffer);
        ConnectionStringBuilder.writeConnectionProperty(TM1_PROTOCOL, params.get(TM1_PROTOCOL), buffer);
        ConnectionStringBuilder.writeConnectionProperty(TM1_SERVER_PORT, params.get(TM1_SERVER_PORT), buffer);
        ConnectionStringBuilder.writeCredentialPlaceHolders(params, buffer);
        return buffer.toString();
    }

    private static String buildPCConnectionString(Map<String, String> params) {
        StringBuilder buffer = new StringBuilder();
        ConnectionStringBuilder.writeProviderType(params, buffer);
        ConnectionStringBuilder.writeConnectionProperty(WIN_PATH, params.get(WIN_PATH), buffer);
        ConnectionStringBuilder.writeConnectionProperty(UNIX_PATH, UNIX_PATH, buffer);
        ConnectionStringBuilder.writeCredentialPlaceHolders(params, buffer);
        return buffer.toString();
    }

    private static String buildODBOConnectionString(Map<String, String> params) {
        StringBuilder buffer = new StringBuilder();
        ConnectionStringBuilder.writeProviderType(params, buffer);
        ConnectionStringBuilder.writeConnectionProperty(SERVER, params.get(SERVER), buffer);
        String tmp = params.get(CATALOG);
        if (tmp != null) {
            ConnectionStringBuilder.writeConnectionProperty(CATALOG, tmp, buffer);
        }
        if ((tmp = params.get(LCID)) != null) {
            ConnectionStringBuilder.writeConnectionProperty(LCID, tmp, buffer);
        }
        if ((tmp = params.get(TRUSTED_CONNECTION)) != null) {
            ConnectionStringBuilder.writeConnectionProperty(TRUSTED_CONNECTION, tmp, buffer);
        }
        ConnectionStringBuilder.writeCredentialPlaceHolders(params, buffer);
        return buffer.toString();
    }

    private static String buildSBWODPConnectionString(Map<String, String> params) {
        StringBuilder buffer = new StringBuilder();
        ConnectionStringBuilder.writeProviderType(params, buffer);
        ConnectionStringBuilder.writeConnectionProperty(SERVER, params.get(SERVER), buffer);
        ConnectionStringBuilder.writeConnectionProperty(SERVER_TYPE, params.get(SERVER_TYPE), buffer);
        String tmp = params.get(CATALOG);
        if (null != tmp) {
            ConnectionStringBuilder.writeConnectionProperty(CATALOG, tmp, buffer);
        }
        if (null != (tmp = params.get(CUBE))) {
            ConnectionStringBuilder.writeConnectionProperty(CUBE, tmp, buffer);
        }
        if (null != (tmp = params.get(LOGON_GROUP))) {
            ConnectionStringBuilder.writeConnectionProperty(LOGON_GROUP, tmp, buffer);
        }
        if (null != (tmp = params.get(SYSID))) {
            ConnectionStringBuilder.writeConnectionProperty(SYSID, tmp, buffer);
        }
        if (null != (tmp = params.get(SYSNR))) {
            ConnectionStringBuilder.writeConnectionProperty(SYSNR, tmp, buffer);
        }
        ConnectionStringBuilder.writeConnectionProperty(CLIENT, params.get(CLIENT), buffer);
        ConnectionStringBuilder.writeConnectionProperty(CODE_PAGE, params.get(CODE_PAGE), buffer);
        ConnectionStringBuilder.writeCredentialPlaceHolders(params, buffer);
        return buffer.toString();
    }

    private static String buildXMLAConnectionString(Map<String, String> params) {
        StringBuilder buffer = new StringBuilder();
        ConnectionStringBuilder.writeProviderType(params, buffer);
        ConnectionStringBuilder.writeConnectionProperty(SERVER, params.get(SERVER), buffer);
        String tmp = params.get(CATALOG);
        if (tmp != null) {
            ConnectionStringBuilder.writeConnectionProperty(CATALOG, tmp, buffer);
        }
        if (null != (tmp = params.get(SSL))) {
            ConnectionStringBuilder.writeConnectionProperty(SSL, tmp, buffer);
        }
        ConnectionStringBuilder.writeCredentialPlaceHolders(params, buffer);
        return buffer.toString();
    }

    private static String buildEBConnectionString(Map<String, String> params) {
        StringBuilder buffer = new StringBuilder();
        ConnectionStringBuilder.writeProviderType(params, buffer);
        ConnectionStringBuilder.writeConnectionProperty(SERVER, params.get(SERVER), buffer);
        String tmp = params.get(CATALOG);
        if (tmp != null) {
            ConnectionStringBuilder.writeConnectionProperty(CATALOG, tmp, buffer);
        }
        if ((tmp = params.get(CUBE)) != null) {
            ConnectionStringBuilder.writeConnectionProperty(CUBE, tmp, buffer);
        }
        ConnectionStringBuilder.writeCredentialPlaceHolders(params, buffer);
        return buffer.toString();
    }

    private static void writeProviderType(Map<String, String> params, StringBuilder buffer) {
        String providerType = params.get("PROVIDER_TYPE");
        if (null == providerType) {
            throw new NullPointerException("providerType was null");
        }
        buffer.append(CONN_STR_PARAM_LOCAL);
        buffer.append(params.get("PROVIDER_TYPE"));
        buffer.append(SEMICOLUMN);
    }

    private static void writeCredentialPlaceHolders(Map<String, String> params, StringBuilder buffer) {
        String tmp = params.get(UID);
        if (tmp != null) {
            ConnectionStringBuilder.writeConnectionProperty(UID, PLACEHOLDER, buffer);
        }
        if ((tmp = params.get(PWD)) != null) {
            ConnectionStringBuilder.writeConnectionProperty(PWD, PLACEHOLDER, buffer);
        }
    }

    private static void writeConnectionProperty(String name, String value, StringBuilder buffer) {
        if (null == name) {
            throw new NullPointerException("name was null");
        }
        if (null == value) {
            throw new NullPointerException("value was null");
        }
        buffer.append(name);
        buffer.append(EQUALS);
        buffer.append(value);
        buffer.append(SEMICOLUMN);
    }
}

