/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.connection;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.connection.ConnectionPoolLogger;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;

public class PooledConnectionLogDecorator
implements IPooledConnection {
    private final IPooledConnection mPooledConnection;
    private final IExecutionEnvironment mExecutionEnvironment;
    private final XQELogger mLogger;

    public PooledConnectionLogDecorator(IPooledConnection pooledConnection, IExecutionEnvironment executionEnvironment) {
        this.mPooledConnection = pooledConnection;
        this.mLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Connection.Pool", ConnectionPoolLogger.LOGGING_LEVEL);
        this.mExecutionEnvironment = executionEnvironment;
    }

    @Override
    public Object getConnection() {
        return this.mPooledConnection.getConnection();
    }

    @Override
    public int getCurrentUseCount() {
        return this.mPooledConnection.getCurrentUseCount();
    }

    @Override
    public void returnConnection() {
        this.mLogger.log("returnConnection in " + this.mPooledConnection);
        this.mPooledConnection.returnConnection();
        this.mLogger.log("returnConnection out " + this.mPooledConnection);
    }

    @Override
    public void setNotReusable() {
        this.mLogger.log("setNotReusable in " + this.mPooledConnection);
        this.mPooledConnection.setNotReusable();
        this.mLogger.log("setNotReusable out " + this.mPooledConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean aliveSince(long timeMillis) {
        this.mLogger.log("aliveSince in " + this.mPooledConnection);
        try {
            boolean bl = this.mPooledConnection.aliveSince(timeMillis);
            return bl;
        }
        finally {
            this.mLogger.log("aliveSince out " + this.mPooledConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean idleSince(long timeMillis) {
        this.mLogger.log("idleSince in " + this.mPooledConnection);
        try {
            boolean bl = this.mPooledConnection.idleSince(timeMillis);
            return bl;
        }
        finally {
            this.mLogger.log("idleSince out " + this.mPooledConnection);
        }
    }

    public IExecutionEnvironment getExecutionEnvironment() {
        return this.mExecutionEnvironment;
    }

    @Override
    public long getLastReturnedTimeMillis() {
        return 0L;
    }
}

