/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.connection.properties;

import com.cognos.xqe.data.providers.connection.properties.IValueConstraint;
import com.cognos.xqe.util.xml.stax.ChildElementIterator;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class ChoiceConstraint
implements IValueConstraint {
    private static final String CHOICE = "choice";
    private static final String VALUE = "value";
    private static final String IGNORE_CASE = "ignoreCase";
    private final String[] choices;
    private final boolean ignoreCase;

    public ChoiceConstraint(String[] theChoices, boolean doIgnoreCase) {
        this.choices = theChoices;
        this.ignoreCase = doIgnoreCase;
    }

    @Override
    public boolean isValid(String value) {
        for (String choice : this.choices) {
            if (!(this.ignoreCase ? choice.equalsIgnoreCase(value) : choice.equals(value))) continue;
            return true;
        }
        return false;
    }

    public static ChoiceConstraint parseFromXML(XMLStreamReader reader) throws XMLStreamException {
        reader.require(1, null, CHOICE);
        String ignoreCase = reader.getAttributeValue(null, IGNORE_CASE);
        ArrayList<String> choiceList = new ArrayList<String>();
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            reader.require(1, null, VALUE);
            choiceList.add(reader.getElementText());
        }
        return new ChoiceConstraint(choiceList.toArray(new String[0]), "true".equals(ignoreCase));
    }
}

