/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.connection.properties;

import com.cognos.xqe.data.providers.connection.properties.ConnectionProperties;
import com.cognos.xqe.data.providers.connection.properties.IUseCondition;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class PropertyNotExistsCondition
implements IUseCondition {
    private static final String PROPERTY_NOT_EXISTS = "propertyNotExists";
    private static final String TARGET_NAME = "targetName";
    private final String targetName;

    public PropertyNotExistsCondition(String theTargetName) {
        this.targetName = theTargetName;
    }

    @Override
    public boolean isRequired(String propertyName, ConnectionProperties properties) {
        if (!properties.contains(this.targetName)) {
            return true;
        }
        String value = properties.getValue(this.targetName);
        return null == value || value.length() == 0;
    }

    public static PropertyNotExistsCondition parseFromXML(XMLStreamReader reader) throws XMLStreamException {
        reader.require(1, null, PROPERTY_NOT_EXISTS);
        String targetName = reader.getAttributeValue(null, TARGET_NAME);
        StaxUtil.skipElement(reader);
        return new PropertyNotExistsCondition(targetName);
    }
}

