/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.filedatasource;

import com.cognos.xqe.data.providers.filedatasource.ConnectionStringParserException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class ConnStrParser {
    public static final String PROP_CUBE = "CUBE";
    public static final String PROP_SERVER = "SERVER";
    public static final String PROP_SERVER_SC = "server";
    public static final String PROP_WINDATASOURCE = "winDataSource";
    public static final String PROP_WIN_PATH = "WIN_PATH";
    public static final String PROP_UNIXDATASOURCE = "unixDataSource";
    public static final String PROP_UNIX_PATH = "UNIX_PATH";
    public static final String PROP_LOCALE = "LCID";
    public static final String PROP_CATALOG = "CATALOG";
    public static final String PROP_SERVER_TYPE = "serverType";
    public static final String PROP_SYSTEM_NR = "sysnr";
    public static final String PROP_LOGON_GRP = "logonGroup";
    public static final String PROP_SYSTEM_ID = "sysid";
    public static final String PROP_CODE_PG = "codePage";
    public static final String PROP_ROUTER_STR = "routerString";
    public static final String PROP_DEST = "dest";
    public static final String PROP_CLIENT = "client";
    public static final String PROP_SSL = "SSL";
    public static final String STR_VALUE = "value";
    public static final String STR_NAME = "name";
    public static final String STR_PASSWORD = "password";
    public static final String STR_USERNAME = "username";
    public static final String STR_USERCLASSIDS = "userClassIds";
    public static final String STR_CUBEPWD = "cubePassword";
    public static final String STR_CUBEPWD_REP = ";cubePassword=%s";
    public static final String STR_CUBEPWD_EQ = ";cubePassword=";
    public static final String STR_CONNECTION_STRING = "connectionString";
    public static final String STR_CONNECTION = "connection";
    public static final String STR_SSOTICKET = "SSOTicket";
    public static final String STR_UID_REP = ";UID=%s";
    public static final String STR_PWD_REP = ";PWD=%s";
    public static final String STR_UID_EQ = ";UID=";
    public static final String STR_PWD_EQ = ";PWD=";
    private static final String SEMI_COLON = ";";
    public static final String PROP_TM1ADMINHOST = "TM1AdminHost";
    public static final String PROP_TM1SERVERNAME = "TM1ServerName";
    public static final String PROP_TM1REST_PROTOCOL = "TM1Protocol";
    public static final String PROP_TM1REST_SERVERPORT = "TM1ServerPort";
    private String dataSourceType;
    private String connStr;
    private Map<String, Object> properties = new HashMap<String, Object>();

    public void parse(String connectionString) throws ConnectionStringParserException {
        if (connectionString == null) {
            throw new ConnectionStringParserException();
        }
        int part = 0;
        StringTokenizer strtok = new StringTokenizer(connectionString, SEMI_COLON, true);
        while (strtok.hasMoreTokens()) {
            String token = strtok.nextToken();
            if (SEMI_COLON.equals(token)) {
                ++part;
                continue;
            }
            if (part == 0) continue;
            if (part == 1) {
                if (token.equals("LOCAL")) continue;
                throw new ConnectionStringParserException();
            }
            if (part == 2) {
                this.dataSourceType = token;
                continue;
            }
            int equalsPos = token.indexOf(61);
            if (equalsPos == -1) continue;
            String name = token.substring(0, equalsPos);
            String value = token.substring(equalsPos + 1);
            this.properties.put(name, value);
        }
        if (this.dataSourceType == null) {
            throw new ConnectionStringParserException();
        }
    }

    public String getDataSourceType() {
        return this.dataSourceType;
    }

    public String getConnStr() {
        return this.connStr;
    }

    public String getProperty(String name) {
        String result = (String)this.properties.get(name);
        if (result != null) {
            return result;
        }
        return "";
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }
}

