/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.filedatasource;

import com.cognos.xqe.ast.v5.utils.SimpleSaxParser;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.providers.filedatasource.ConnectionStringParserException;
import com.cognos.xqe.data.providers.filedatasource.GenericDataSource;
import com.cognos.xqe.data.providers.filedatasource.GenericDataSourceManagerException;
import com.cognos.xqe.data.providers.filedatasource.IGenericDataSource;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.XQEDebugLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class GenericDataSourceManager {
    protected static final String STR_DATASOURCES = "dataSources";
    protected List<IGenericDataSource> dataSources = new ArrayList<IGenericDataSource>();
    protected RequestEnvironment reqEnv = null;
    protected String dsFileName = "../configuration/xqe.datasources.xml";
    protected static GenericDataSourceManager dsmgr = null;

    protected GenericDataSourceManager() {
    }

    public static GenericDataSourceManager getInstance() {
        if (dsmgr == null) {
            dsmgr = new GenericDataSourceManager();
            dsmgr.readDataSourcesFromFile();
        }
        return dsmgr;
    }

    public void setDataSourceFileName(String dataSourceFileName) {
        this.dsFileName = dataSourceFileName;
    }

    protected void readDataSourcesFromFile() {
        File dsFile = new File(this.dsFileName);
        SimpleSaxParser saxParser = new SimpleSaxParser();
        try {
            saxParser.parseStream(new FileInputStream(dsFile));
        }
        catch (FileNotFoundException e) {
            throw new XQERuntimeException(e);
        }
        Document doc = saxParser.getDocument();
        Element dataSourcesElement = doc.getRootElement().element(STR_DATASOURCES);
        List userDataSourceElements = dataSourcesElement.elements();
        for (int i = 0; i < userDataSourceElements.size(); ++i) {
            try {
                GenericDataSource dataSource = GenericDataSource.load((Element)userDataSourceElements.get(i));
                this.dataSources.add(dataSource);
                continue;
            }
            catch (ConnectionStringParserException e) {
                throw new XQERuntimeException(e);
            }
        }
    }

    public void addUserDataSource(GenericDataSource dataSource) throws GenericDataSourceManagerException {
        if (this.dataSources.contains(dataSource)) {
            return;
        }
        for (int i = 0; i < this.dataSources.size(); ++i) {
            IGenericDataSource ds = this.dataSources.get(i);
            if (!ds.getName().equals(dataSource.getName())) continue;
            throw new GenericDataSourceManagerException();
        }
        this.dataSources.add(dataSource);
    }

    public void removeDataSource(GenericDataSource dataSource) {
        this.dataSources.remove(dataSource);
    }

    public IGenericDataSource[] getDataSources() {
        return this.dataSources.toArray(new IGenericDataSource[0]);
    }

    public IGenericDataSource findDataSource(String name) {
        for (int i = 0; i < this.dataSources.size(); ++i) {
            if (!this.dataSources.get(i).getName().equals(name)) continue;
            return this.dataSources.get(i);
        }
        return null;
    }

    public IGenericDataSource findDataSource(String name, String userName) {
        for (int i = 0; i < this.dataSources.size(); ++i) {
            IGenericDataSource ds = this.dataSources.get(i);
            if (!ds.getName().equals(name) || !ds.getUserName().equalsIgnoreCase(userName)) continue;
            return this.dataSources.get(i);
        }
        return null;
    }

    public void dumpDataSourceName() {
        for (int i = 0; i < this.dataSources.size(); ++i) {
            XQEDebugLog.out.println(this.dataSources.get(i).getName());
        }
    }
}

