/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap;

import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.QueryArguments;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.runtree.olap.querytemplates.MemberQuery;
import com.cognos.xqe.util.LocaleConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class MDXQueryArguments
implements QueryArguments {
    private final Locale runLocale;
    private Locale designLocale = null;
    private final MDXQuery mdxQuery;
    private final IDataSource dataSource;
    private final List<MDXAxisInfo> axesInfo;

    public MDXQueryArguments(IDataSource theDataSource, MDXQuery theMDQuerySpec, Locale theRunLocale, Locale locale) {
        this.mdxQuery = theMDQuerySpec;
        this.dataSource = theDataSource;
        this.axesInfo = new ArrayList<MDXAxisInfo>();
        this.designLocale = locale;
        this.runLocale = theRunLocale;
        for (MDXEdge edge : this.mdxQuery.getEdges()) {
            MDXAxisInfo axisInfo = new MDXAxisInfo();
            List<IQueryItem> customMemberProperties = edge.getDimensionProperties().getCustomMemberProperties();
            MDXLevelInfo edgeLevelInfo = edge.getLevelInfo();
            for (IHierarchy hierarchy : edgeLevelInfo.getHierarchyInfo().getProjectedHierarchies()) {
                ArrayList<IQueryItem> properties = new ArrayList<IQueryItem>();
                for (IQueryItem customMemberProperty : customMemberProperties) {
                    if (!customMemberProperty.getHierarchy().equals(hierarchy)) continue;
                    properties.add(customMemberProperty);
                }
                MDXHierarchyInfo hierarchyInfo = new MDXHierarchyInfo(hierarchy, edgeLevelInfo.getProjectedLevels(hierarchy), properties);
                axisInfo.addMDXHierarchyInfo(hierarchyInfo);
            }
            this.addMDXAxisInfo(axisInfo);
        }
    }

    @Override
    public IDataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public Locale getDesignLocale() {
        if (null != this.designLocale) {
            return this.designLocale;
        }
        return this.getRunLocale();
    }

    @Override
    public Locale getRunLocale() {
        return this.runLocale;
    }

    public MDXQuery getMDXQuery() {
        return this.mdxQuery;
    }

    public ICube getCube() {
        return this.mdxQuery.getReferencedCube();
    }

    public String getMDXText() {
        return this.mdxQuery.getMDX();
    }

    public String getKeyDate() {
        DateValue tempDate = DataValueFactory.createDateValue();
        DateValue fromDate = DataValueFactory.createDateValue();
        DateValue toDate = DataValueFactory.createDateValue();
        if (this.mdxQuery.isCustomMemberQuery()) {
            return ((MemberQuery)this.mdxQuery).getKeyDate();
        }
        if (!this.mdxQuery.validateChildCategories()) {
            return null;
        }
        Set<IHierarchy> hierarchySet = this.mdxQuery.getReferencedHierarchiesOnEdgesAndDimLine();
        for (IHierarchy hierarchy : hierarchySet) {
            tempDate.set(hierarchy.getProperty("Valid_From"));
            if (!tempDate.isNull() && (fromDate.isNull() || tempDate.compareTo(fromDate) < 0)) {
                fromDate.copyFrom(tempDate);
            }
            tempDate.set(hierarchy.getProperty("Valid_To"));
            if (tempDate == null || !toDate.isNull() && tempDate.compareTo(toDate) <= 0) continue;
            toDate.copyFrom(tempDate);
        }
        IDataSourceCapabilities capabilities = this.getDataSource().getCapabilities();
        return MetadataUtil.getKeydateWithConfig(fromDate, toDate, capabilities.isSupported("use.valid.from"));
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("MDXQueryArguments[");
        buffer.append("dataSource=").append(this.getDataSource().toString());
        buffer.append(", mdx=").append(this.getMDXText());
        buffer.append(", cube=").append(this.getCube().getCaption());
        buffer.append(", runLocale=").append(LocaleConverter.toString(this.getRunLocale()));
        buffer.append(", designLocale=").append(LocaleConverter.toString(this.getDesignLocale()));
        buffer.append(']');
        return buffer.toString();
    }

    public int getNumberOfAxes() {
        return this.mdxQuery.getNumberOfEdges();
    }

    public MDXAxisInfo getMDXAxisInfo(int axisIndex) {
        if (axisIndex < 0 || axisIndex >= this.axesInfo.size()) {
            return null;
        }
        return this.axesInfo.get(axisIndex);
    }

    private void addMDXAxisInfo(MDXAxisInfo axisInfo) {
        this.axesInfo.add(axisInfo);
    }

    public class MDXHierarchyInfo {
        private IHierarchy hierarchy;
        private List<ILevel> projectedLevels;
        private HashMap<Integer, List<IQueryItem>> projectedCustomProperties;

        MDXHierarchyInfo(IHierarchy theHierarchy, List<ILevel> theProjectedLevels, List<IQueryItem> theProjectedCustomProperties) {
            this.hierarchy = theHierarchy;
            this.projectedLevels = theProjectedLevels;
            this.projectedCustomProperties = new HashMap();
            for (IQueryItem property : theProjectedCustomProperties) {
                ArrayList<Integer> propertyLevelIndices = new ArrayList<Integer>();
                if (property.getLevel() != null) {
                    propertyLevelIndices.add(property.getLevel().getIndex());
                } else {
                    for (ILevel level : theProjectedLevels) {
                        propertyLevelIndices.add(level.getIndex());
                    }
                }
                for (Integer levelIndex : propertyLevelIndices) {
                    List<IQueryItem> levelProperties = this.getProjectedLevelCustomProperties(levelIndex);
                    if (levelProperties == null) {
                        levelProperties = new ArrayList<IQueryItem>();
                        this.projectedCustomProperties.put(levelIndex, levelProperties);
                    }
                    levelProperties.add(property);
                }
            }
        }

        public IHierarchy getHierarchy() {
            return this.hierarchy;
        }

        public List<ILevel> getProjectedLevels() {
            return this.projectedLevels;
        }

        public List<IQueryItem> getProjectedLevelCustomProperties(int levelIndex) {
            return this.projectedCustomProperties.get(levelIndex);
        }

        IQueryItem getProjectedCustomProperty(int levelIndex, String providerName) {
            List<IQueryItem> levelCustomProperties = this.getProjectedLevelCustomProperties(levelIndex);
            if (levelCustomProperties != null) {
                for (IQueryItem property : levelCustomProperties) {
                    if (!property.getUniqueName().equals(providerName)) continue;
                    return property;
                }
            }
            return null;
        }
    }

    public class MDXAxisInfo {
        private List<MDXHierarchyInfo> projectedHierarchies = new ArrayList<MDXHierarchyInfo>();

        MDXAxisInfo() {
        }

        public List<MDXHierarchyInfo> getProjectedHierarchies() {
            return this.projectedHierarchies;
        }

        public int getNumberOfHierarchies() {
            return this.projectedHierarchies.size();
        }

        public MDXHierarchyInfo getMDXHierarchyInfo(int tuplePosition) {
            if (this.projectedHierarchies.size() > 0) {
                return this.projectedHierarchies.get(tuplePosition);
            }
            return null;
        }

        private void addMDXHierarchyInfo(MDXHierarchyInfo hierarchyInfo) {
            this.projectedHierarchies.add(hierarchyInfo);
        }
    }
}

