/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.MetadataOperation;
import com.cognos.xqe.data.providers.olap.OLAPDataProviderBase;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.cache.OlapMetadataCacheService;
import com.cognos.xqe.data.providers.olap.securecache.SALContext;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.EnumSet;

public abstract class MetadataProviderBase
implements IOLAPMetadataProvider {
    private final OLAPDataProviderBase mDataProvider;
    private final XQELogger mLogger = XQELog.getLogger(ServiceEnumeration.XQEODP, "XQEODP", "Resources", LogLevel.ERROR);

    public MetadataProviderBase(OLAPDataProviderBase provider) {
        this.mDataProvider = provider;
    }

    @Override
    public void invalidateCaches(IRestrictions restrictions) {
        OlapMetadataCacheService.getInstance().clearCache(this.getCacheParameters(restrictions));
    }

    @Override
    public SALContext getMetadataQueryContext(String userId, MetadataOperation opType, short securityContextMode, IRestrictions restrictions) {
        return new SALContext(null, null, null);
    }

    @Override
    public boolean isReplacementVariableUsedFor(IRestrictions restrictions) {
        return false;
    }

    @Override
    public boolean isReplacementVariableSpecified() {
        return false;
    }

    @Override
    public final void release() {
        try {
            this.releaseImpl();
        }
        catch (Throwable e) {
            this.mLogger.log(e);
        }
    }

    public abstract void releaseImpl();

    public OLAPDataProviderBase getDataProvider() {
        return this.mDataProvider;
    }

    public static void validateRequiredRestrictions(MetadataOperation mdOperation, IRestrictions restrictions) {
        switch (mdOperation) {
            case ACTIONS: {
                MetadataProviderBase.validateRequiredRestrictions(restrictions, IOLAPMetadataProvider.ACTIONS_RESTRICTIONS);
                break;
            }
            case ALIASES: {
                MetadataProviderBase.validateRequiredRestrictions(restrictions, IOLAPMetadataProvider.ALIASES_RESTRICTIONS);
                break;
            }
            case CUBES: {
                MetadataProviderBase.validateRequiredRestrictions(restrictions, IOLAPMetadataProvider.CUBES_RESTRICTIONS);
                break;
            }
            case DIMENSIONS: {
                MetadataProviderBase.validateRequiredRestrictions(restrictions, IOLAPMetadataProvider.DIMENSIONS_RESTRICTIONS);
                break;
            }
            case HIERARCHIES: {
                MetadataProviderBase.validateRequiredRestrictions(restrictions, IOLAPMetadataProvider.HIERARCHIES_RESTRICTIONS);
                break;
            }
            case HIERARCHYROOTMEMBERS: {
                MetadataProviderBase.validateRequiredRestrictions(restrictions, IOLAPMetadataProvider.HIERARCHY_ROOT_MEMBERS_RESTRICTIONS);
                break;
            }
            case LEVELS: {
                MetadataProviderBase.validateRequiredRestrictions(restrictions, IOLAPMetadataProvider.LEVELS_RESTRICTIONS);
                break;
            }
            case MACROS: {
                MetadataProviderBase.validateRequiredRestrictions(restrictions, IOLAPMetadataProvider.MACROS_RESTRICTIONS);
                break;
            }
            case MEASURES: {
                MetadataProviderBase.validateRequiredRestrictions(restrictions, IOLAPMetadataProvider.MEASURES_RESTRICTIONS);
                break;
            }
            case MEMBERS: {
                MetadataProviderBase.validateRequiredRestrictions(restrictions, IOLAPMetadataProvider.MEMBERS_RESTRICTIONS);
                break;
            }
            case NAMEDSETMEMBERS: {
                MetadataProviderBase.validateRequiredRestrictions(restrictions, IOLAPMetadataProvider.NAMEDSETMEMBERS_RESTRICTIONS);
                break;
            }
            case NAMEDSETLEVELUNIQUENAMES: {
                MetadataProviderBase.validateRequiredRestrictions(restrictions, IOLAPMetadataProvider.NAMEDSETLEVELUNIQUENAMES_RESTRICTIONS);
                break;
            }
            case NAMEDSETS: {
                MetadataProviderBase.validateRequiredRestrictions(restrictions, IOLAPMetadataProvider.NAMEDSETS_RESTRICTIONS);
                break;
            }
            case HIERARCHYNAMEDSETS: {
                MetadataProviderBase.validateRequiredRestrictions(restrictions, IOLAPMetadataProvider.HIERARCHY_NAMEDSETS_RESTRICTIONS);
                break;
            }
            case PROPERTIES: {
                MetadataProviderBase.validateRequiredRestrictions(restrictions, IOLAPMetadataProvider.PROPERTIES_RESTRICTIONS);
                break;
            }
            case VARIABLES: {
                MetadataProviderBase.validateRequiredRestrictions(restrictions, IOLAPMetadataProvider.VARIABLES_RESTRICTIONS);
                break;
            }
        }
    }

    private static void validateRequiredRestrictions(IRestrictions restrictions, EnumSet<RestrictionType> requiredRestrictions) {
        for (RestrictionType type : requiredRestrictions) {
            if (restrictions.contains(type)) continue;
            throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionMissing, type.toString());
        }
    }
}

