/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.xml.serializer.XMLElement;
import com.cognos.xqe.util.xml.serializer.XMLElementMap;
import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;

@XMLElement
public class MetadataRestriction
implements IRestrictions {
    private static final String LOG_MSG_RESTRICTION_TYPE = "RestrictionType ";
    private static final String DEFAULT_EVENT_GROUP = "Metadata.Restrictions";
    private static final String BAD_RESTRICTION_TYPE_MESSAGE = "Restriction %s is of type %s, not %s\n";
    @XMLElementMap(itemName="restriction", keyName="name", valName="value")
    EnumMap<RestrictionType, Object> restrictions = new EnumMap(RestrictionType.class);

    @Override
    public void add(RestrictionType restriction, Object value) {
        if (!restriction.isValueAssignableFromObject(value)) {
            StringWriter sw = new StringWriter();
            PrintWriter w = new PrintWriter(new BufferedWriter(sw));
            w.format(BAD_RESTRICTION_TYPE_MESSAGE, new Object[]{restriction, restriction.getValueClass(), value.getClass()});
            throw new ClassCastException(sw.toString());
        }
        this.validate(restriction, value);
        this.restrictions.put(restriction, value);
    }

    private void validate(RestrictionType restriction, Object value) {
        if (value == null) {
            XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", DEFAULT_EVENT_GROUP, LogLevel.ERROR);
            if (logger.isOn()) {
                logger.log(LOG_MSG_RESTRICTION_TYPE + restriction.name() + " doesn't support null value.");
            }
            throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionIllegalValue, restriction.name(), (String)value);
        }
        if (String.class.isAssignableFrom(restriction.valueClass)) {
            String val = (String)value;
            if (val.length() == 0) {
                XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", DEFAULT_EVENT_GROUP, LogLevel.ERROR);
                if (logger.isOn()) {
                    logger.log(LOG_MSG_RESTRICTION_TYPE + restriction.name() + " doesn't support empty String value.");
                }
                throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionIllegalValue, restriction.name(), value.toString());
            }
        } else if (Integer.class.isAssignableFrom(restriction.valueClass)) {
            switch (restriction) {
                case LEVEL_NUMBER: 
                case FROM: 
                case SIZE: {
                    Integer val = (Integer)value;
                    if (val >= 0) break;
                    XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", DEFAULT_EVENT_GROUP, LogLevel.ERROR);
                    if (logger.isOn()) {
                        logger.log(LOG_MSG_RESTRICTION_TYPE + restriction.name() + " doesn't support negative Integer value.");
                    }
                    throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionIllegalValue, restriction.name(), value.toString());
                }
            }
        }
    }

    @Override
    public boolean contains(RestrictionType type) {
        return this.restrictions.containsKey((Object)type);
    }

    @Override
    public EnumSet<RestrictionType> contains(EnumSet<RestrictionType> types) {
        ArrayList<RestrictionType> missingTypes = new ArrayList<RestrictionType>();
        for (RestrictionType type : types) {
            if (this.restrictions.containsKey((Object)type)) continue;
            missingTypes.add(type);
        }
        if (missingTypes.isEmpty()) {
            return null;
        }
        return EnumSet.copyOf(missingTypes);
    }

    @Override
    public void remove(RestrictionType type) {
        this.restrictions.remove((Object)type);
    }

    @Override
    public void replace(RestrictionType type, Object value) {
        this.validate(type, value);
        this.remove(type);
        this.add(type, value);
    }

    @Override
    public void clear() {
        this.restrictions.clear();
    }

    @Override
    public IRestrictions duplicate() {
        MetadataRestriction answer = new MetadataRestriction();
        answer.restrictions.putAll(this.restrictions);
        return answer;
    }

    @Override
    public IRestrictions duplicate(RestrictionType ... types) {
        MetadataRestriction answer = new MetadataRestriction();
        for (RestrictionType type : types) {
            Object value = this.restrictions.get((Object)type);
            if (null == value) continue;
            answer.add(type, value);
        }
        return answer;
    }

    @Override
    public <T> T getValueOf(RestrictionType restriction) {
        return this.getValueOf(restriction, null);
    }

    @Override
    public <T> T getValueOf(RestrictionType restriction, T defaultValue) {
        if (!restriction.isValueAssignableFromObject(defaultValue)) {
            StringWriter sw = new StringWriter();
            PrintWriter w = new PrintWriter(new BufferedWriter(sw));
            w.format(BAD_RESTRICTION_TYPE_MESSAGE, new Object[]{restriction, restriction.getValueClass(), defaultValue.getClass()});
            throw new ClassCastException(sw.toString());
        }
        Object answer = defaultValue;
        if (this.restrictions.containsKey((Object)restriction)) {
            Object temp = this.restrictions.get((Object)restriction);
            if (!restriction.isValueAssignableFromObject(temp)) {
                StringWriter sw = new StringWriter();
                PrintWriter w = new PrintWriter(new BufferedWriter(sw));
                w.format(BAD_RESTRICTION_TYPE_MESSAGE, new Object[]{restriction, restriction.getValueClass(), temp.getClass()});
                throw new ClassCastException(sw.toString());
            }
            answer = temp;
        }
        return answer;
    }

    @Override
    public <T> T getTypedValueOf(RestrictionType restriction, Class<T> valueType) {
        if (!restriction.isValueAssignableFromClass(valueType)) {
            StringWriter sw = new StringWriter();
            PrintWriter w = new PrintWriter(new BufferedWriter(sw));
            w.format(BAD_RESTRICTION_TYPE_MESSAGE, new Object[]{restriction, restriction.getValueClass(), valueType});
            throw new ClassCastException(sw.toString());
        }
        Object answer = null;
        if (this.restrictions.containsKey((Object)restriction)) {
            Object temp = this.restrictions.get((Object)restriction);
            if (!restriction.isValueAssignableFromObject(temp)) {
                StringWriter sw = new StringWriter();
                PrintWriter w = new PrintWriter(new BufferedWriter(sw));
                w.format(BAD_RESTRICTION_TYPE_MESSAGE, new Object[]{restriction, restriction.getValueClass(), temp.getClass()});
                throw new ClassCastException(sw.toString());
            }
            answer = temp;
        }
        return (T)answer;
    }

    public String toString() {
        return this.restrictions.toString();
    }
}

