/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.MetadataOperation;
import com.cognos.xqe.data.providers.olap.cache.CacheParameters;
import com.cognos.xqe.data.providers.olap.securecache.SALContext;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.record.ActionRecord;
import com.cognos.xqe.metadata.record.AliasRecord;
import com.cognos.xqe.metadata.record.CatalogRecord;
import com.cognos.xqe.metadata.record.CubeRecord;
import com.cognos.xqe.metadata.record.DimensionRecord;
import com.cognos.xqe.metadata.record.HierarchyNamedSetRecord;
import com.cognos.xqe.metadata.record.HierarchyRecord;
import com.cognos.xqe.metadata.record.LevelRecord;
import com.cognos.xqe.metadata.record.MacroRecord;
import com.cognos.xqe.metadata.record.MeasureRecord;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.metadata.record.NamedSetRecord;
import com.cognos.xqe.metadata.record.PropertyRecord;
import com.cognos.xqe.metadata.record.VariableRecord;
import com.cognos.xqe.runtree.ma.MAMunValidationException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.xml.serializer.DefaultProcessor;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TracingOLAPMetadataProvider
implements IOLAPMetadataProvider {
    private static final boolean DEV_ENABLE_METRICS = false;
    private static final String LOG_MSG_BEGIN = "Metadata query started for ";
    private static final String LOG_MSG_END = "Metadata query completed for ";
    private static final String LOG_MSG_FAILED = "Metadata query failed for ";
    private static final String LOG_MSG_RELEASED = "OLAP metadata provider was released: ";
    private static final String LOG_MSG_COLON_SPACE = ": ";
    private static final String DATASOURCELOCALES = "DATASOURCELOCALES";
    private static final String NAMEDSETLEVELUNIQUENAMES = "NAMEDSETLEVELUNIQUENAMES";
    private static final String CUBEDEFAULTMEASURE = "CUBEDEFAULTMEASURE";
    private static final String NEWLINE = System.getProperty("line.separator");
    private final IOLAPMetadataProvider provider;
    private final String subGroup;
    private final XQELogger metadataLogger;
    private final XQELogger metadataRecordsLogger;
    private final XQELogger ipfMetadataLogger;
    private static Map<MetadataOperation, GroupOperationMetrics> metrics = null;

    public TracingOLAPMetadataProvider(IOLAPMetadataProvider theProvider, String theComponentName) {
        this(theProvider, theComponentName, null);
    }

    public TracingOLAPMetadataProvider(IOLAPMetadataProvider theProvider, String theComponentName, String theSubGroup) {
        this.provider = theProvider;
        this.subGroup = theSubGroup;
        this.metadataLogger = XQELog.getLogger(ServiceEnumeration.XQEODP, theComponentName, "Metadata", LogLevel.INFO);
        this.metadataRecordsLogger = XQELog.getLogger(ServiceEnumeration.XQEODP, theComponentName, "Metadata.Records", LogLevel.TRACE);
        this.ipfMetadataLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "QueryService.Metadata", LogLevel.TRACE);
    }

    @Override
    public CacheParameters getCacheParameters(IRestrictions restrictions) {
        return this.provider.getCacheParameters(restrictions);
    }

    @Override
    public void invalidateCaches(IRestrictions restrictions) {
        if (this.metadataRecordsLogger.isOn(LogLevel.TRACE)) {
            StringBuilder logBuffer = new StringBuilder();
            if (null != this.subGroup) {
                logBuffer.append(this.subGroup).append(LOG_MSG_COLON_SPACE);
            }
            logBuffer.append("Invalidating caches for ").append(this.provider.toString());
            this.metadataRecordsLogger.log(LogLevel.TRACE, logBuffer.toString());
        }
        this.provider.invalidateCaches(restrictions);
    }

    @Override
    public SALContext getMetadataQueryContext(String userId, MetadataOperation opType, short securityContextMode, IRestrictions restrictions) {
        return this.provider.getMetadataQueryContext(userId, opType, securityContextMode, restrictions);
    }

    @Override
    public boolean isReplacementVariableUsedFor(IRestrictions restrictions) {
        return this.provider.isReplacementVariableUsedFor(restrictions);
    }

    @Override
    public boolean isReplacementVariableSpecified() {
        return this.provider.isReplacementVariableSpecified();
    }

    @Override
    public List<ActionRecord> getActions(IRestrictions restrictions) {
        return this.invokeOperation(MetadataOperation.ACTIONS, restrictions);
    }

    @Override
    public List<AliasRecord> getAliases(IRestrictions restrictions) {
        return this.invokeOperation(MetadataOperation.ALIASES, restrictions);
    }

    @Override
    public List<CatalogRecord> getCatalogs(IRestrictions restrictions) {
        return this.invokeOperation(MetadataOperation.CATALOGS, restrictions);
    }

    @Override
    public List<CubeRecord> getCubes(IRestrictions restrictions) {
        return this.invokeOperation(MetadataOperation.CUBES, restrictions);
    }

    @Override
    public String getCubeDefaultMeasure(IRestrictions restrictions) {
        String answer = null;
        this.logMetadataBegin(restrictions, CUBEDEFAULTMEASURE);
        try {
            answer = this.provider.getCubeDefaultMeasure(restrictions);
        }
        catch (RuntimeException ex) {
            this.logMetadataException(ex, CUBEDEFAULTMEASURE);
            throw ex;
        }
        finally {
            this.logMetadataEnd(CUBEDEFAULTMEASURE);
        }
        this.logMetadataResponse(answer);
        return answer;
    }

    private void logMetadataResponse(Object answer) {
        if (this.metadataRecordsLogger.isOn(LogLevel.TRACE) || this.ipfMetadataLogger.isOn()) {
            StringBuilder logBuffer = new StringBuilder();
            if (null != this.subGroup) {
                logBuffer.append(this.subGroup).append(LOG_MSG_COLON_SPACE);
            }
            this.dumpToString(answer, logBuffer);
            String msg = logBuffer.toString();
            this.metadataRecordsLogger.log(LogLevel.TRACE, msg);
            this.ipfMetadataLogger.log(msg);
        }
    }

    private void logMetadataEnd(String metadataType) {
        if (this.metadataLogger.isOn(LogLevel.TRACE) || this.ipfMetadataLogger.isOn()) {
            StringBuilder logBuffer = new StringBuilder();
            if (null != this.subGroup) {
                logBuffer.append(this.subGroup).append(LOG_MSG_COLON_SPACE);
            }
            logBuffer.append(LOG_MSG_END).append(metadataType);
            String msg = logBuffer.toString();
            this.metadataLogger.log(LogLevel.TRACE, OperationEnum.END, msg);
            this.ipfMetadataLogger.log(OperationEnum.END, msg);
        }
    }

    private void logMetadataBegin(IRestrictions restrictions, String metadataType) {
        if (this.metadataLogger.isOn(LogLevel.INFO) || this.ipfMetadataLogger.isOn()) {
            StringBuilder logBuffer = new StringBuilder();
            if (null != this.subGroup) {
                logBuffer.append(this.subGroup).append(LOG_MSG_COLON_SPACE);
            }
            logBuffer.append(LOG_MSG_BEGIN).append(metadataType);
            logBuffer.append(". Restrictions: ");
            this.dumpToString(restrictions, logBuffer);
            String msg = logBuffer.toString();
            this.metadataLogger.log(LogLevel.INFO, OperationEnum.START, msg);
            this.ipfMetadataLogger.log(OperationEnum.START, msg);
        }
    }

    @Override
    public List<String> getDatasourceLocales(IRestrictions restrictions) {
        List<String> answer = null;
        this.logMetadataBegin(restrictions, DATASOURCELOCALES);
        try {
            answer = this.provider.getDatasourceLocales(restrictions);
        }
        catch (RuntimeException ex) {
            this.logMetadataException(ex, DATASOURCELOCALES);
            throw ex;
        }
        finally {
            this.logMetadataEnd(DATASOURCELOCALES);
        }
        this.logMetadataResponse(answer);
        return answer;
    }

    private void logMetadataException(RuntimeException ex, String metadataType) {
        if (this.metadataLogger.isOn(LogLevel.ERROR)) {
            StringBuilder logBuffer = new StringBuilder();
            if (null != this.subGroup) {
                logBuffer.append(this.subGroup).append(LOG_MSG_COLON_SPACE);
            }
            logBuffer.append(LOG_MSG_FAILED).append(metadataType);
            this.metadataLogger.log(LogLevel.ERROR, logBuffer.toString(), (Throwable)ex);
        }
    }

    @Override
    public List<DimensionRecord> getDimensions(IRestrictions restrictions) {
        return this.invokeOperation(MetadataOperation.DIMENSIONS, restrictions);
    }

    @Override
    public List<HierarchyRecord> getHierarchies(IRestrictions restrictions) {
        return this.invokeOperation(MetadataOperation.HIERARCHIES, restrictions);
    }

    @Override
    public List<MemberRecord> getHierarchyRootMembers(IRestrictions restrictions) {
        return this.invokeOperation(MetadataOperation.HIERARCHYROOTMEMBERS, restrictions);
    }

    @Override
    public List<LevelRecord> getLevels(IRestrictions restrictions) {
        return this.invokeOperation(MetadataOperation.LEVELS, restrictions);
    }

    @Override
    public List<MacroRecord> getMacros(IRestrictions restrictions) {
        return this.invokeOperation(MetadataOperation.MACROS, restrictions);
    }

    @Override
    public List<MeasureRecord> getMeasures(IRestrictions restrictions) {
        return this.invokeOperation(MetadataOperation.MEASURES, restrictions);
    }

    @Override
    public List<MemberRecord> getMembers(IRestrictions restrictions) {
        return this.invokeOperation(MetadataOperation.MEMBERS, restrictions);
    }

    @Override
    public List<MemberRecord> getNamedSetMembers(IRestrictions restrictions) {
        return this.invokeOperation(MetadataOperation.NAMEDSETMEMBERS, restrictions);
    }

    @Override
    public List<String> getNamedSetLevelUniqueNames(IRestrictions restrictions) {
        List<String> answer = null;
        this.logMetadataBegin(restrictions, NAMEDSETLEVELUNIQUENAMES);
        try {
            answer = this.provider.getNamedSetLevelUniqueNames(restrictions);
        }
        catch (RuntimeException ex) {
            this.logMetadataException(ex, NAMEDSETLEVELUNIQUENAMES);
            throw ex;
        }
        finally {
            this.logMetadataEnd(NAMEDSETLEVELUNIQUENAMES);
        }
        this.logMetadataResponse(answer);
        return answer;
    }

    @Override
    public List<NamedSetRecord> getNamedSets(IRestrictions restrictions) {
        return this.invokeOperation(MetadataOperation.NAMEDSETS, restrictions);
    }

    @Override
    public List<HierarchyNamedSetRecord> getHierarchyNamedSets(IRestrictions restrictions) {
        return this.invokeOperation(MetadataOperation.HIERARCHYNAMEDSETS, restrictions);
    }

    @Override
    public List<PropertyRecord> getProperties(IRestrictions restrictions) {
        return this.invokeOperation(MetadataOperation.PROPERTIES, restrictions);
    }

    @Override
    public List<VariableRecord> getVariables(IRestrictions restrictions) {
        return this.invokeOperation(MetadataOperation.VARIABLES, restrictions);
    }

    @Override
    public void release() {
        this.provider.release();
        if (this.metadataLogger.isOn(LogLevel.INFO) || this.ipfMetadataLogger.isOn()) {
            StringBuilder logBuffer = new StringBuilder();
            if (null != this.subGroup) {
                logBuffer.append(this.subGroup).append(LOG_MSG_COLON_SPACE);
            }
            logBuffer.append(LOG_MSG_RELEASED).append(this.provider.toString());
            String msg = logBuffer.toString();
            this.metadataLogger.log(msg);
            this.ipfMetadataLogger.log(msg);
        }
    }

    public String toString() {
        return this.provider.toString();
    }

    public boolean equals(Object o) {
        return this.provider.equals(o);
    }

    public int hashCode() {
        return this.provider.hashCode();
    }

    private <T extends MetadataRecord> List<T> invokeOperation(MetadataOperation mdOperation, IRestrictions restrictions) {
        List<MetadataRecord> answer = null;
        this.logMetadataBegin(restrictions, mdOperation.name());
        long startTime = System.currentTimeMillis();
        try {
            answer = MetadataOperation.invoke(mdOperation, this.provider, restrictions);
        }
        catch (MAMunValidationException maEx) {
            throw maEx;
        }
        catch (RuntimeException ex) {
            this.logMetadataException(ex, mdOperation.name());
            throw ex;
        }
        finally {
            this.logMetadataEnd(mdOperation.name());
        }
        this.logMetadataResponse(answer);
        return answer;
    }

    private void dumpToString(Object obj, StringBuilder buffer) {
        StringWriter writer = new StringWriter();
        DefaultProcessor proc = new DefaultProcessor();
        try {
            proc.serialize(obj, writer);
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(e);
        }
        buffer.append(writer.getBuffer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeOperationMetrics() {
        Class<TracingOLAPMetadataProvider> clazz = TracingOLAPMetadataProvider.class;
        synchronized (TracingOLAPMetadataProvider.class) {
            metrics = new HashMap<MetadataOperation, GroupOperationMetrics>(MetadataOperation.values().length);
            for (MetadataOperation op : MetadataOperation.values()) {
                metrics.put(op, new GroupOperationMetrics());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printOperationMetrics() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Metadata Operation Metrics for ").append(this.subGroup).append(NEWLINE);
        Class<TracingOLAPMetadataProvider> clazz = TracingOLAPMetadataProvider.class;
        synchronized (TracingOLAPMetadataProvider.class) {
            for (MetadataOperation op : MetadataOperation.values()) {
                GroupOperationMetrics opMetrics = metrics.get((Object)op);
                if (opMetrics.getCallCount(this.subGroup) <= 0) continue;
                buffer.append((Object)op).append(": Call Count = ").append(opMetrics.getCallCount(this.subGroup));
                buffer.append(", Total Time = ").append(opMetrics.getTotalTime(this.subGroup)).append(NEWLINE);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            XQEDebugLog.out.println(buffer);
            XQEDebugLog.out.flush();
            return;
        }
    }

    @Override
    public List<MemberRecord> getHierarchyCalculatedMembers(IRestrictions restrictions) {
        return this.invokeOperation(MetadataOperation.HIERARCHYCALCULATEDMEMBERS, restrictions);
    }

    private static class OperationMetrics {
        private int callCount = 0;
        private long totalTime = 0L;

        private OperationMetrics() {
        }

        public int getCallCount() {
            return this.callCount;
        }

        public void incrementCallCount() {
            ++this.callCount;
        }

        public long getTotalTime() {
            return this.totalTime;
        }

        public void addTime(long time) {
            this.totalTime += time;
        }
    }

    private static class GroupOperationMetrics {
        private Map<String, OperationMetrics> groupMetrics = new HashMap<String, OperationMetrics>();

        private GroupOperationMetrics() {
        }

        private OperationMetrics getMetricsForGroup(String groupName) {
            OperationMetrics opMetrics = this.groupMetrics.get(groupName);
            if (null == opMetrics) {
                opMetrics = new OperationMetrics();
                this.groupMetrics.put(groupName, opMetrics);
            }
            return opMetrics;
        }

        public int getCallCount(String groupName) {
            return this.getMetricsForGroup(groupName).getCallCount();
        }

        public void incrementCallCount(String groupName) {
            this.getMetricsForGroup(groupName).incrementCallCount();
        }

        public long getTotalTime(String groupName) {
            return this.getMetricsForGroup(groupName).getTotalTime();
        }

        public void addTime(String groupName, long time) {
            this.getMetricsForGroup(groupName).addTime(time);
        }
    }
}

