/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.cache;

import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.MetadataOperation;
import com.cognos.xqe.data.providers.olap.cache.CacheParameters;
import com.cognos.xqe.data.providers.olap.cache.IOLAPMetadataCache;
import com.cognos.xqe.data.providers.olap.cache.IOLAPMetadataCacheFactory;
import com.cognos.xqe.data.providers.olap.securecache.MemberStorage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractOLAPMetadataCache
implements IOLAPMetadataCache {
    private final IOLAPMetadataCacheFactory factory;
    private final CacheParameters parameters;
    private volatile boolean closed = false;
    private volatile long lastFlushTime = System.currentTimeMillis();
    private volatile long lastAccessTime = System.currentTimeMillis();
    private volatile long lastModTime = System.currentTimeMillis();
    protected final AtomicBoolean dirty = new AtomicBoolean(false);
    private XQELogger logger = null;
    private MemberStorage memberStorage = null;
    private String versionId = null;

    public AbstractOLAPMetadataCache(IOLAPMetadataCacheFactory theFactory, CacheParameters theParameters) {
        this.factory = theFactory;
        this.parameters = theParameters;
    }

    protected XQELogger getLogger() {
        if (null == this.logger) {
            this.logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "OlapMetadataCache", LogLevel.INFO);
        }
        return this.logger;
    }

    @Override
    public final long getLastFlushTime() {
        return this.lastFlushTime;
    }

    @Override
    public final long getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public final long getLastModTime() {
        return this.lastModTime;
    }

    @Override
    public String getVersionId() {
        return this.versionId;
    }

    @Override
    public void setVersionId(String theVersionId) {
        this.versionId = theVersionId;
    }

    @Override
    public final IOLAPMetadataCacheFactory getFactory() {
        return this.factory;
    }

    @Override
    public final CacheParameters getParameters() {
        return this.parameters;
    }

    @Override
    public final synchronized boolean invalidate(MetadataOperation operation, IRestrictions restrictions) {
        this.assertNotClosed();
        if (this.getLogger().isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            this.appendClassName(buffer);
            buffer.append("Invalidating metadata ");
            this.appendMDOperation(operation, restrictions, buffer);
            buffer.append(" in cache ");
            this.appendCacheParameters(buffer);
            this.getLogger().log(LogLevel.INFO, buffer.toString());
        }
        this.lastAccessTime = System.currentTimeMillis();
        if (this.invalidateImpl(operation, restrictions)) {
            this.dirty.set(true);
            this.lastModTime = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    @Override
    public final synchronized void clear() {
        this.assertNotClosed();
        if (this.getLogger().isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            this.appendClassName(buffer);
            buffer.append("Clearing cache ");
            this.appendCacheParameters(buffer);
            this.getLogger().log(LogLevel.INFO, buffer.toString());
        }
        this.dirty.set(true);
        this.lastAccessTime = System.currentTimeMillis();
        this.lastModTime = System.currentTimeMillis();
        this.clearImpl();
    }

    @Override
    public final synchronized boolean isClosed() {
        return this.closed;
    }

    @Override
    public final synchronized void close() {
        if (!this.closed) {
            if (this.getLogger().isOn(LogLevel.INFO)) {
                StringBuilder buffer = new StringBuilder();
                this.appendClassName(buffer);
                buffer.append("Closing cache ");
                this.appendCacheParameters(buffer);
                this.getLogger().log(LogLevel.INFO, buffer.toString());
            }
            this.closed = true;
            if (null != this.memberStorage) {
                try {
                    this.memberStorage.close();
                }
                catch (CacheException ex) {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)ex);
                }
                this.memberStorage = null;
            }
            this.closeImpl();
        }
    }

    @Override
    public final synchronized boolean needsFlushing() {
        return this.dirty.get();
    }

    @Override
    public final synchronized void flush() {
        this.assertNotClosed();
        if (this.getLogger().isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            this.appendClassName(buffer);
            buffer.append("Flushing cache ");
            this.appendCacheParameters(buffer);
            this.getLogger().log(LogLevel.INFO, buffer.toString());
        }
        this.dirty.set(false);
        this.lastAccessTime = System.currentTimeMillis();
        if (null != this.memberStorage) {
            try {
                this.memberStorage.flush();
            }
            catch (CacheException ex) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)ex);
            }
        }
        this.flushImpl();
    }

    @Override
    public final synchronized <T extends MetadataRecord> List<T> getMetadata(MetadataOperation operation, IRestrictions restrictions) {
        this.assertNotClosed();
        if (this.getLogger().isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            this.appendClassName(buffer);
            buffer.append("Retrieving metadata ");
            this.appendMDOperation(operation, restrictions, buffer);
            buffer.append(" from cache ");
            this.appendCacheParameters(buffer);
            this.getLogger().log(LogLevel.INFO, buffer.toString());
        }
        this.lastAccessTime = System.currentTimeMillis();
        List<T> answer = this.getMetadataImpl(operation, restrictions);
        if (this.getLogger().isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            this.appendClassName(buffer);
            if (null == answer) {
                buffer.append("No records found in cache ");
            } else {
                buffer.append("Found ").append(answer.size()).append(" records in cache");
            }
            this.appendCacheParameters(buffer);
            this.getLogger().log(LogLevel.INFO, buffer.toString());
        }
        if (null != answer && !answer.isEmpty() && this.getLogger().isOn(LogLevel.TRACE)) {
            this.getLogger().log(LogLevel.TRACE, answer.toString());
        }
        return answer;
    }

    @Override
    public final synchronized <T extends MetadataRecord> void putMetadata(MetadataOperation operation, IRestrictions restrictions, List<T> records) {
        this.assertNotClosed();
        if (this.getLogger().isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            this.appendClassName(buffer);
            buffer.append("Putting metadata ");
            this.appendMDOperation(operation, restrictions, buffer);
            buffer.append(" into cache ");
            this.appendCacheParameters(buffer);
            this.getLogger().log(LogLevel.INFO, buffer.toString());
        }
        if (null != records && this.getLogger().isOn(LogLevel.TRACE)) {
            this.getLogger().log(LogLevel.TRACE, records.toString());
        }
        this.dirty.set(true);
        this.lastAccessTime = System.currentTimeMillis();
        this.lastModTime = System.currentTimeMillis();
        this.putMetadataImpl(operation, restrictions, records);
    }

    @Override
    public synchronized void stampLastAccessTime() {
        this.assertNotClosed();
        this.lastAccessTime = System.currentTimeMillis();
    }

    @Override
    public synchronized void markCacheAsDirty() {
        this.assertNotClosed();
        this.dirty.set(true);
        this.lastAccessTime = System.currentTimeMillis();
        this.lastModTime = System.currentTimeMillis();
    }

    protected abstract boolean invalidateImpl(MetadataOperation var1, IRestrictions var2);

    protected abstract void clearImpl();

    protected abstract void closeImpl();

    protected abstract void flushImpl();

    protected abstract <T extends MetadataRecord> List<T> getMetadataImpl(MetadataOperation var1, IRestrictions var2);

    protected abstract <T extends MetadataRecord> void putMetadataImpl(MetadataOperation var1, IRestrictions var2, List<T> var3);

    protected void assertNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("Cache was closed");
        }
    }

    private void appendClassName(StringBuilder buffer) {
        buffer.append(this.getClass().getName()).append(": ");
    }

    private void appendCacheParameters(StringBuilder buffer) {
        buffer.append('{').append(this.parameters.toString()).append('}');
    }

    private void appendMDOperation(MetadataOperation operation, IRestrictions restrictions, StringBuilder buffer) {
        buffer.append('[').append(operation.toString()).append(restrictions.toString()).append(']');
    }
}

