/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.cache;

import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionParameter;
import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class CacheParameters
implements Serializable {
    public static final String FACTORY_NAME = "FACTORY_NAME";
    public static final String FLUSH_INTERVAL = "FLUSH_INTERVAL";
    public static final String CACHE_TIMEOUT = "CACHE_TIMEOUT";
    private static final long serialVersionUID = 1L;
    private final Map<String, Object> params = new TreeMap<String, Object>();
    private int cachedHashCode = Integer.MIN_VALUE;

    public int size() {
        return this.params.size();
    }

    public boolean isEmpty() {
        return 0 == this.size();
    }

    public boolean contains(String name) {
        return this.params.containsKey(name);
    }

    public Object get(String name) {
        return this.params.get(name);
    }

    public String getString(String name) {
        Object value = this.get(name);
        if (null == value) {
            return null;
        }
        return value.toString();
    }

    public String getString(String name, String defaultValue) {
        Object value = this.get(name);
        if (null == value) {
            return defaultValue;
        }
        return value.toString();
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        Object value = this.get(name);
        if (null == value) {
            return defaultValue;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        return (Boolean)value;
    }

    public int getInt(String name, int defaultValue) {
        Object value = this.get(name);
        if (null == value) {
            return defaultValue;
        }
        if (value instanceof String) {
            return Integer.valueOf((String)value);
        }
        return ((Number)value).intValue();
    }

    public long getLong(String name, long defaultValue) {
        Object value = this.get(name);
        if (null == value) {
            return defaultValue;
        }
        if (value instanceof String) {
            return Long.valueOf((String)value);
        }
        return ((Number)value).longValue();
    }

    public float getFloat(String name, float defaultValue) {
        Object value = this.get(name);
        if (null == value) {
            return defaultValue;
        }
        if (value instanceof String) {
            return Float.valueOf((String)value).floatValue();
        }
        return ((Number)value).floatValue();
    }

    public double getDouble(String name, double defaultValue) {
        Object value = this.get(name);
        if (null == value) {
            return defaultValue;
        }
        if (value instanceof String) {
            return Double.valueOf((String)value);
        }
        return ((Number)value).doubleValue();
    }

    public Object put(String name, Object value) {
        this.cachedHashCode = Integer.MIN_VALUE;
        return this.params.put(name, value);
    }

    public void put(IConnectionParameter<?> param) {
        this.put(param.name(), param.value());
    }

    public void put(ConnectionParameters connParams) {
        for (IConnectionParameter<?> param : connParams) {
            if (!param.isMatchable()) continue;
            this.put(param);
        }
    }

    public Object remove(String name) {
        Object removedObj = this.params.remove(name);
        if (null != removedObj) {
            this.cachedHashCode = Integer.MIN_VALUE;
        }
        return removedObj;
    }

    public void clear() {
        this.cachedHashCode = Integer.MIN_VALUE;
        this.params.clear();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        buffer.append('{');
        for (Map.Entry<String, Object> param : this.params.entrySet()) {
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(param.toString());
        }
        buffer.append('}');
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CacheParameters)) {
            return false;
        }
        CacheParameters otherCacheParams = (CacheParameters)o;
        return this.params.equals(otherCacheParams.params);
    }

    public int hashCode() {
        if (Integer.MIN_VALUE != this.cachedHashCode) {
            return this.cachedHashCode;
        }
        HashCodeBuilder hcb = new HashCodeBuilder();
        for (Map.Entry<String, Object> entry : this.params.entrySet()) {
            hcb.append((Object)entry.getKey());
            hcb.append(entry.getValue());
        }
        this.cachedHashCode = hcb.toHashCode();
        if (Integer.MIN_VALUE == this.cachedHashCode) {
            this.cachedHashCode = 0;
        }
        return this.cachedHashCode;
    }
}

