/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.cache;

import com.cognos.xqe.bibushandler.XQEService;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.providers.olap.cache.AbstractOLAPMetadataCache;
import com.cognos.xqe.data.providers.olap.cache.CacheParameters;
import com.cognos.xqe.data.providers.olap.cache.DummyOLAPMetadataCacheFactory;
import com.cognos.xqe.data.providers.olap.cache.IOLAPMetadataCache;
import com.cognos.xqe.data.providers.olap.cache.IOLAPMetadataCacheFactory;
import com.cognos.xqe.data.providers.olap.cache.config.CacheServiceConfiguration;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.SingletonHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class OlapMetadataCacheService {
    private static final String CONFIG_FILE_PATH = "/xqe.olapcacheservice.xml";
    private XQELogger logger = null;
    private File configFile = null;
    private final Map<CacheParameters, CacheEntry> entries = new HashMap<CacheParameters, CacheEntry>();
    private Thread maintenanceThread = null;
    private volatile boolean maintenanceThreadRunning = false;
    private CacheServiceConfiguration configuration = null;
    private long configFileLastModified = 0L;
    private static SingletonHelper<OlapMetadataCacheService> singletonHelper = new SingletonHelper<OlapMetadataCacheService>(){

        @Override
        protected OlapMetadataCacheService newInstance() {
            return new OlapMetadataCacheService();
        }

        @Override
        protected void releaseImpl(OlapMetadataCacheService theInstance) {
            theInstance.release();
        }

        @Override
        protected void initializeImpl(OlapMetadataCacheService theInstance) {
            theInstance.initialize();
        }
    };

    private OlapMetadataCacheService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadConfigurations() {
        CacheServiceConfiguration newConfiguration = new CacheServiceConfiguration();
        if (!this.configFile.exists()) {
            newConfiguration.loadDefaultConfig();
        } else {
            newConfiguration.reloadFile(this.configFile);
        }
        this.configuration = newConfiguration;
        this.configFileLastModified = this.configFile.lastModified();
        if (this.maintenanceThreadRunning) {
            OlapMetadataCacheService olapMetadataCacheService = this;
            synchronized (olapMetadataCacheService) {
                this.notify();
            }
        }
    }

    public void reloadConfigurations(File customConfigFile) {
        if (null == customConfigFile) {
            throw new NullPointerException("customConfigFile was null");
        }
        this.configFile = customConfigFile;
        this.reloadConfigurations();
    }

    public CacheServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    public IOLAPMetadataCache getCache(CacheParameters parameters) {
        return this.getCache(parameters, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOLAPMetadataCache getCache(CacheParameters parameters, boolean noForcedInitialization) {
        IOLAPMetadataCache result = null;
        Map<CacheParameters, CacheEntry> map = this.entries;
        synchronized (map) {
            CacheEntry entry = this.entries.get(parameters);
            if (null == entry || entry.getCache().isClosed()) {
                StringBuilder logBuffer;
                String factoryName;
                IOLAPMetadataCacheFactory factory;
                if (noForcedInitialization) {
                    return null;
                }
                if (this.logger.isOn(LogLevel.INFO)) {
                    StringBuilder logBuffer2 = new StringBuilder();
                    logBuffer2.append("Creating new cache for parameters ").append(parameters.toString());
                    this.logger.log(LogLevel.INFO, logBuffer2.toString());
                }
                if (null == (factory = this.configuration.getCacheFactory(factoryName = parameters.getString("FACTORY_NAME")))) {
                    if (null != factoryName) {
                        if (this.logger.isOn(LogLevel.WARN)) {
                            logBuffer = new StringBuilder();
                            logBuffer.append("Factory with name ").append(factoryName);
                            logBuffer.append(" was not configured; falling back to default factory.");
                            this.logger.log(LogLevel.WARN, logBuffer.toString());
                        }
                        factory = this.configuration.getCacheFactory(null);
                    }
                    if (null == factory) {
                        if (this.logger.isOn(LogLevel.WARN)) {
                            logBuffer = new StringBuilder();
                            logBuffer.append("No factory was found; falling back to dummy factory.");
                            this.logger.log(LogLevel.WARN, logBuffer.toString());
                        }
                        factory = new DummyOLAPMetadataCacheFactory();
                    }
                }
                if (this.logger.isOn(LogLevel.TRACE)) {
                    logBuffer = new StringBuilder();
                    logBuffer.append("Using factory ").append(factory.getClass().toString());
                    this.logger.log(LogLevel.TRACE, logBuffer.toString());
                }
                entry = new CacheEntry(factory.getCache(parameters));
                this.configureCache(entry, parameters);
                this.entries.put(parameters, entry);
            } else {
                ((AbstractOLAPMetadataCache)entry.getCache()).stampLastAccessTime();
            }
            result = entry.getCache();
        }
        return result;
    }

    public void flushCache(CacheParameters parameters) {
        IOLAPMetadataCache cache = this.getCache(parameters, true);
        if (null != cache) {
            cache.flush();
        }
    }

    public void clearCache(CacheParameters parameters) {
        IOLAPMetadataCache cache = this.getCache(parameters, true);
        if (null != cache) {
            cache.clear();
        }
    }

    public void closeCache(CacheParameters parameters) {
        IOLAPMetadataCache cache = this.getCache(parameters, true);
        if (null != cache) {
            cache.close();
        }
    }

    private void configureCache(CacheEntry cache, CacheParameters parameters) {
        long flushInterval = this.configuration.getFlushInterval();
        long cacheTimout = this.configuration.getCacheTimeout();
        if (parameters.contains("FLUSH_INTERVAL")) {
            flushInterval = parameters.getLong("FLUSH_INTERVAL", -1L);
        }
        if (parameters.contains("CACHE_TIMEOUT")) {
            cacheTimout = parameters.getLong("CACHE_TIMEOUT", -1L);
        }
        if (this.logger.isOn(LogLevel.TRACE)) {
            StringBuilder logBuffer = new StringBuilder();
            logBuffer.append("Configuring cache with flushInterval=").append(flushInterval);
            logBuffer.append(", cacheTimeout=").append(cacheTimout);
            this.logger.log(LogLevel.TRACE, logBuffer.toString());
        }
        cache.setFlushInterval(flushInterval);
        cache.setCacheTimeout(cacheTimout);
    }

    private void initialize() {
        if (!XQEService.isInitialized()) {
            throw new XQERuntimeException(XQEMessageKeys.INI_XQEServiceWasNotInitialized);
        }
        this.logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "OlapMetadataCacheService", LogLevel.INFO);
        this.logger.log(LogLevel.INFO, "Initializing OlapMetadataCacheService");
        try {
            XQEConfiguration xqeConfig = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            this.configFile = new File(xqeConfig.getConfigDirectory() + CONFIG_FILE_PATH);
            this.reloadConfigurations();
            this.maintenanceThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    OlapMetadataCacheService.this.logger.log(LogLevel.INFO, "Starting maintenance task");
                    OlapMetadataCacheService.this.maintenanceTask();
                    OlapMetadataCacheService.this.logger.log(LogLevel.INFO, "Terminated maintenance task");
                }
            });
            this.maintenanceThreadRunning = true;
            this.maintenanceThread.start();
        }
        catch (RuntimeException ex) {
            if (this.logger.isOn(LogLevel.ERROR)) {
                this.logger.log(LogLevel.ERROR, "An error occurred during initialization:\n", (Throwable)ex);
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release() {
        Object object;
        this.logger.log(LogLevel.INFO, "Releasing OlapMetadataCacheService");
        if (this.maintenanceThreadRunning) {
            this.maintenanceThreadRunning = false;
            object = this;
            synchronized (object) {
                this.notify();
            }
            try {
                this.maintenanceThread.join();
            }
            catch (InterruptedException ex) {
                this.logger.log(LogLevel.WARN, (Throwable)ex);
            }
        }
        object = this.entries;
        synchronized (object) {
            for (CacheEntry entry : this.entries.values()) {
                try {
                    IOLAPMetadataCache cache = entry.getCache();
                    if (cache.isClosed()) continue;
                    cache.flush();
                    cache.close();
                }
                catch (RuntimeException ex) {
                    this.logger.log(LogLevel.ERROR, (Throwable)ex);
                }
            }
            this.entries.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maintenanceTask() {
        ArrayList<CacheEntry> flushableCaches = new ArrayList<CacheEntry>();
        ArrayList<CacheEntry> expiredCaches = new ArrayList<CacheEntry>();
        ArrayList<CacheEntry> closedCaches = new ArrayList<CacheEntry>();
        while (this.maintenanceThreadRunning) {
            try {
                block28: {
                    block27: {
                        try {
                            long sleepTime = this.configuration.getMaintenanceInterval();
                            if (sleepTime < 1L) {
                                sleepTime = 1L;
                            }
                            OlapMetadataCacheService olapMetadataCacheService = this;
                            synchronized (olapMetadataCacheService) {
                                this.wait(sleepTime);
                            }
                        }
                        catch (InterruptedException ex) {
                            if (this.maintenanceThreadRunning) break block27;
                            return;
                        }
                    }
                    this.logger.log(LogLevel.TRACE, "Maintenance thread woke up");
                    if (this.configFile.exists() && this.configFileLastModified != this.configFile.lastModified()) {
                        this.logger.log(LogLevel.WARN, "Detected modification in configuation file");
                        try {
                            this.reloadConfigurations();
                        }
                        catch (Throwable ex) {
                            if (!this.logger.isOn(LogLevel.ERROR)) break block28;
                            this.logger.log(LogLevel.ERROR, "Exception caught while reloading configuration file:\n", ex);
                        }
                    }
                }
                flushableCaches.clear();
                expiredCaches.clear();
                closedCaches.clear();
                Map<CacheParameters, CacheEntry> ex = this.entries;
                synchronized (ex) {
                    IOLAPMetadataCache cache;
                    for (CacheEntry entry : this.entries.values()) {
                        cache = entry.getCache();
                        if (cache.isClosed()) {
                            closedCaches.add(entry);
                            continue;
                        }
                        long lastAccessEllapsed = System.currentTimeMillis() - cache.getLastAccessTime();
                        if (entry.getCacheTimeout() > 0L && lastAccessEllapsed > entry.getCacheTimeout()) {
                            expiredCaches.add(entry);
                            continue;
                        }
                        long flushedEllapsed = System.currentTimeMillis() - cache.getLastFlushTime();
                        if (!cache.needsFlushing() || entry.getFlushInterval() <= 0L || flushedEllapsed <= entry.getFlushInterval()) continue;
                        flushableCaches.add(entry);
                    }
                    for (CacheEntry entry : closedCaches) {
                        this.entries.remove(entry.getCache().getParameters());
                    }
                    closedCaches.clear();
                    for (CacheEntry entry : flushableCaches) {
                        cache = entry.getCache();
                        try {
                            if (cache.isClosed()) continue;
                            cache.flush();
                        }
                        catch (RuntimeException ex2) {
                            this.logger.log(LogLevel.ERROR, (Throwable)ex2);
                        }
                    }
                    flushableCaches.clear();
                    for (CacheEntry entry : expiredCaches) {
                        cache = entry.getCache();
                        if (this.logger.isOn(LogLevel.WARN)) {
                            StringBuilder logBuffer = new StringBuilder();
                            logBuffer.append("Expiring cache with parameters ").append(cache.getParameters());
                            this.logger.log(LogLevel.WARN, logBuffer.toString());
                        }
                        try {
                            if (!cache.isClosed()) {
                                cache.flush();
                                cache.close();
                            }
                        }
                        catch (RuntimeException ex3) {
                            this.logger.log(LogLevel.ERROR, (Throwable)ex3);
                        }
                        this.entries.remove(cache.getParameters());
                    }
                    expiredCaches.clear();
                }
            }
            catch (RuntimeException ex) {
                if (!this.logger.isOn(LogLevel.ERROR)) continue;
                this.logger.log(LogLevel.ERROR, "Unhandled exception caught in maintenance task loop:\n", (Throwable)ex);
            }
        }
    }

    public static OlapMetadataCacheService getInstance() {
        return singletonHelper.getInstance();
    }

    public static void releaseInstance() {
        singletonHelper.releaseInstance();
    }

    private final class CacheEntry {
        private final IOLAPMetadataCache implementation;
        private long flushInterval = -1L;
        private long cacheTimeout = -1L;

        private CacheEntry(IOLAPMetadataCache theImplementation) {
            this.implementation = theImplementation;
        }

        public long getFlushInterval() {
            return this.flushInterval;
        }

        public void setFlushInterval(long theFlushInterval) {
            this.flushInterval = theFlushInterval;
        }

        public long getCacheTimeout() {
            return this.cacheTimeout;
        }

        public void setCacheTimeout(long theCacheTimeout) {
            this.cacheTimeout = theCacheTimeout;
        }

        public IOLAPMetadataCache getCache() {
            return this.implementation;
        }
    }
}

