/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.cache.xindice;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.providers.olap.cache.AbstractOLAPMetadataCacheFactory;
import com.cognos.xqe.data.providers.olap.cache.CacheParameters;
import com.cognos.xqe.data.providers.olap.cache.IOLAPMetadataCache;
import com.cognos.xqe.data.providers.olap.cache.xindice.CacheConfig;
import com.cognos.xqe.data.providers.olap.cache.xindice.XindiceOLAPMetadataCache;
import com.cognos.xqe.exception.XQERuntimeException;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class XindiceOLAPMetadataCacheFactory
extends AbstractOLAPMetadataCacheFactory {
    private static final String CACHE_FILENAME_ENCODING = "UTF-8";
    private static final String ARG_DATA_DIRECTORY = "dataDirectory";
    private static final String ARG_PERSISTENT = "persistent";
    private static final String ARG_PERSISTENT_LIFETIME = "persistentLifetime";
    private static final String ARG_AUTO_FLUSHED = "autoFlushed";
    private static final String ARG_COMPRESSED = "compressed";
    private static final String ARG_ENCRYPTED = "encrypted";
    private String defaultDataDirectory = null;
    private boolean defaultIsPersistent = false;
    private long defaultPersistentLifetime = -1L;
    private boolean defaultIsAutoFlushed = false;
    private boolean defaultIsCompressed = false;
    private boolean defaultIsEncrypted = false;

    @Override
    public IOLAPMetadataCache getCache(CacheParameters params) {
        String dataDirectory = params.getString(ARG_DATA_DIRECTORY, this.defaultDataDirectory);
        boolean isPersistent = params.getBoolean(ARG_PERSISTENT, this.defaultIsPersistent);
        long persistentLifetime = params.getLong(ARG_PERSISTENT_LIFETIME, this.defaultPersistentLifetime);
        boolean isAutoFlushed = params.getBoolean(ARG_AUTO_FLUSHED, this.defaultIsAutoFlushed);
        boolean isCompressed = params.getBoolean(ARG_COMPRESSED, this.defaultIsCompressed);
        boolean isEncrypted = params.getBoolean(ARG_ENCRYPTED, this.defaultIsEncrypted);
        String cacheName = null;
        try {
            cacheName = URLEncoder.encode(params.toString(), CACHE_FILENAME_ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            throw new XQERuntimeException(ex);
        }
        CacheConfig configuration = new CacheConfig();
        configuration.setCacheDataDirectory(new File(dataDirectory));
        configuration.setCacheName(cacheName);
        configuration.setAutoFlushed(isAutoFlushed);
        configuration.setPersistent(isPersistent);
        configuration.setPersistentLifetime(persistentLifetime);
        configuration.setCompressed(isCompressed);
        configuration.setEncrypted(isEncrypted);
        return new XindiceOLAPMetadataCache(this, params, configuration);
    }

    @Override
    public void setArguments(Map<String, Object> arguments) {
        Boolean isPersistent;
        super.setArguments(arguments);
        this.defaultDataDirectory = (String)arguments.get(ARG_DATA_DIRECTORY);
        if (null == this.defaultDataDirectory) {
            XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            StringBuilder dataDirPathBuilder = new StringBuilder(config.getXqeDataDirectory());
            dataDirPathBuilder.append(File.separatorChar);
            dataDirPathBuilder.append("olap_metadata_cache");
            this.defaultDataDirectory = dataDirPathBuilder.toString();
        }
        this.defaultIsPersistent = null != (isPersistent = (Boolean)arguments.get(ARG_PERSISTENT)) ? isPersistent : false;
        Long persistentLifetime = (Long)arguments.get(ARG_PERSISTENT_LIFETIME);
        this.defaultPersistentLifetime = null != persistentLifetime ? persistentLifetime : -1L;
        Boolean isAutoFlushed = (Boolean)arguments.get(ARG_AUTO_FLUSHED);
        this.defaultIsAutoFlushed = null != isAutoFlushed ? isAutoFlushed : false;
        Boolean isCompressed = (Boolean)arguments.get(ARG_COMPRESSED);
        this.defaultIsCompressed = null != isCompressed ? isCompressed : false;
        Boolean isEncrypted = (Boolean)arguments.get(ARG_ENCRYPTED);
        this.defaultIsEncrypted = null != isEncrypted ? isEncrypted : false;
    }
}

