/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.securecache;

import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.data.providers.olap.securecache.DMRMemberStoragePerLevel;
import com.cognos.xqe.data.providers.olap.securecache.MemberStorage;
import com.cognos.xqe.data.providers.olap.securecache.SecureCacheConfigurationManager;
import com.cognos.xqe.exception.RequestCanceledException;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICatalog;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.SecurityContext;
import com.cognos.xqe.util.pool.XQEXMLOutputFactoryPool;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public final class DMRMemberStorage
extends MemberStorage {
    private static final String STRING_COMMA = ",";
    private static final String MEMBER_COUNT = "memberCount";
    private final String packageName;
    private final MemberStorage.DimContextKey dmrDimContextKey;
    private ConcurrentMap<Integer, DMRMemberStoragePerLevel> levelStorages = new ConcurrentHashMap<Integer, DMRMemberStoragePerLevel>();
    private AtomicInteger uniqueKey = new AtomicInteger(0);

    public DMRMemberStorage(List<IModelDataSource> ds, String runLocale, String modName, String packName, SecurityContext sContext) {
        try {
            storageMapLock.lockInterruptibly();
            DMRMemberStorageIdentifier memStorageIdentifier = new DMRMemberStorageIdentifier(modName, runLocale, ds, sContext);
            this.packageName = packName;
            this.memberStorageIdentifier = memStorageIdentifier;
            if (memberStorageMap.containsKey(memStorageIdentifier)) {
                throw new XQERuntimeException();
            }
            StringBuilder sb = new StringBuilder().append(memStorageIdentifier.hashCode());
            this.uniqueCacheName = sb.toString();
            DataSourceInfo dsInfo = (DataSourceInfo)memStorageIdentifier.datasourceInfos.get(0);
            this.storageConfig = SecureCacheConfigurationManager.getInstance().getMemberStorageConfiguration(memStorageIdentifier.getDataSourceType(), dsInfo.dataSourceName, dsInfo.catalogName, dsInfo.cubeName);
            this.staticCache = super.isStaticallyCached();
            this.dmrDimContextKey = new MemberStorage.DimContextKey(this, "DMR", "DMR");
            this.initialize();
        }
        catch (InterruptedException e) {
            throw new RequestCanceledException();
        }
        finally {
            storageMapLock.unlock();
        }
    }

    public ArrayList<DataSourceInfo> getDMRDataSources() {
        return ((DMRMemberStorageIdentifier)this.memberStorageIdentifier).getDataSourceInfos();
    }

    public String getPackageName() {
        return this.packageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static MemberStorage getMemberStorage(List<IModelDataSource> modelDatasources, String runLocale, String modelName, String packageName, SecurityContext securityContext) {
        MemberStorage store = null;
        DMRMemberStorageIdentifier memberStorageIdentifier = new DMRMemberStorageIdentifier(modelName, runLocale, modelDatasources, securityContext);
        while (true) {
            storageMapLock.lock();
            try {
                store = (MemberStorage)memberStorageMap.get(memberStorageIdentifier);
                if (store == null) {
                    store = new DMRMemberStorage(modelDatasources, runLocale, modelName, packageName, securityContext);
                    infoLogger.log("Created MemberStorage " + store);
                    memberStorageMap.put(memberStorageIdentifier, store);
                }
            }
            finally {
                storageMapLock.unlock();
            }
            if (store.incrementUsageCount()) {
                return store;
            }
            if (!store.isStale() || !store.isBeingFlushed()) continue;
            store.awaitFlush();
        }
    }

    public static boolean flushStorageForPackage(String packageId) {
        List<Map.Entry<MemberStorage.MemberStorageIdentifier, MemberStorage>> entries = DMRMemberStorage.getDMRMemberStorageEntriesForPackage(packageId);
        try {
            storageMapLock.lockInterruptibly();
            for (Map.Entry<MemberStorage.MemberStorageIdentifier, MemberStorage> entry : entries) {
                memberStorageMap.remove(entry.getKey());
            }
        }
        catch (InterruptedException e) {
            throw new XQERuntimeException(e);
        }
        finally {
            storageMapLock.unlock();
        }
        for (Map.Entry<MemberStorage.MemberStorageIdentifier, MemberStorage> entry : entries) {
            try {
                entry.getValue().flush();
            }
            catch (CacheException e) {
                throw new XQERuntimeException(e);
            }
        }
        return true;
    }

    public static String dumpStorageStateForPackage(String packageId) {
        List<Map.Entry<MemberStorage.MemberStorageIdentifier, MemberStorage>> memberStorageSorted = DMRMemberStorage.getDMRMemberStorageEntriesForPackage(packageId);
        String dumpFilePath = DMRMemberStorage.getDumpFilePath(DMRMemberStorage.getDumpFileNameForPackage(packageId));
        try {
            XMLOutputFactory factory = XQEXMLOutputFactoryPool.getInstance().borrowXMLOutputFactory();
            FileOutputStream opStream = new FileOutputStream(dumpFilePath);
            XMLStreamWriter writer = factory.createXMLStreamWriter(opStream, "UTF-8");
            writer.writeStartDocument();
            writer.writeStartElement("xqeCacheMetric");
            if (memberStorageSorted.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("No cached cube found matching the criteria:");
                sb.append(" ");
                sb.append("package");
                sb.append(" ");
                sb.append("name = ");
                sb.append(packageId);
                writer.writeCharacters(sb.toString());
                writer.writeEndElement();
                writer.writeEndDocument();
                XQEXMLOutputFactoryPool.getInstance().returnXMLOutputFactory(factory);
                opStream.close();
                return dumpFilePath;
            }
            DMRMemberStorage.writeStorageState(memberStorageSorted, writer);
            XQEXMLOutputFactoryPool.getInstance().returnXMLOutputFactory(factory);
            opStream.close();
        }
        catch (FileNotFoundException e) {
            errorLogger.log(e);
        }
        catch (XMLStreamException e) {
            errorLogger.log(e);
        }
        catch (Exception e) {
            errorLogger.log(e);
        }
        return dumpFilePath;
    }

    protected static List<Map.Entry<MemberStorage.MemberStorageIdentifier, MemberStorage>> getDMRMemberStorageEntriesForPackage(String packageId) {
        String packageIdentifier = packageId;
        if (packageIdentifier == null) {
            packageIdentifier = "";
        }
        boolean allDMRMemberStorages = "*".equals(packageIdentifier);
        boolean matchPackageUsingModelPath = packageIdentifier.contains("[@");
        Set entries = memberStorageMap.entrySet();
        ArrayList<Map.Entry<MemberStorage.MemberStorageIdentifier, MemberStorage>> toReturn = new ArrayList<Map.Entry<MemberStorage.MemberStorageIdentifier, MemberStorage>>();
        try {
            storageMapLock.lockInterruptibly();
            for (Map.Entry entry : entries) {
                if (!((MemberStorage.MemberStorageIdentifier)entry.getKey()).getDataSourceType().equals("DMR")) continue;
                if (allDMRMemberStorages) {
                    toReturn.add(entry);
                    continue;
                }
                if (matchPackageUsingModelPath) {
                    if (!((MemberStorage.MemberStorageIdentifier)entry.getKey()).getModelName().equals(packageIdentifier)) continue;
                    toReturn.add(entry);
                    continue;
                }
                if (!((DMRMemberStorage)entry.getValue()).getPackageName().equals(packageIdentifier)) continue;
                toReturn.add(entry);
            }
        }
        catch (InterruptedException e) {
            throw new XQERuntimeException(e);
        }
        finally {
            storageMapLock.unlock();
        }
        Collections.sort(toReturn, new Comparator<Map.Entry<MemberStorage.MemberStorageIdentifier, MemberStorage>>(){

            @Override
            public int compare(Map.Entry<MemberStorage.MemberStorageIdentifier, MemberStorage> o1, Map.Entry<MemberStorage.MemberStorageIdentifier, MemberStorage> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        return toReturn;
    }

    private static StringBuilder getDumpFileNameForPackage(String packageId) {
        String packageIdentifier = packageId;
        if (packageIdentifier == null) {
            packageIdentifier = "";
        }
        if (packageIdentifier.contains("[@")) {
            String tempStr = packageIdentifier.substring(packageIdentifier.lastIndexOf("package[@name=") + 2, packageIdentifier.length() - 1);
            StringBuilder sb = new StringBuilder();
            char[] chars = tempStr.toCharArray();
            int i = 0;
            while (i < chars.length && "_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890".indexOf(chars[i]) >= 0) {
                sb.append(chars[i]);
            }
            packageIdentifier = sb.toString();
        }
        StringBuilder filename = new StringBuilder("SALDump");
        filename.append("_");
        filename.append("DMR");
        filename.append("_");
        filename.append("PKG");
        if (packageIdentifier.equals("*")) {
            filename.append("_");
            filename.append("all");
        } else {
            filename.append("_");
            filename.append(packageIdentifier);
        }
        return filename;
    }

    public static boolean flushStorageForDS(String dataSourceName) {
        List<Map.Entry<MemberStorage.MemberStorageIdentifier, MemberStorage>> entries = DMRMemberStorage.getDMRMemberStorageEntriesForDS(dataSourceName);
        try {
            storageMapLock.lockInterruptibly();
            for (Map.Entry<MemberStorage.MemberStorageIdentifier, MemberStorage> entry : entries) {
                memberStorageMap.remove(entry.getKey());
            }
        }
        catch (InterruptedException e) {
            throw new XQERuntimeException(e);
        }
        finally {
            storageMapLock.unlock();
        }
        for (Map.Entry<MemberStorage.MemberStorageIdentifier, MemberStorage> entry : entries) {
            try {
                entry.getValue().flush();
            }
            catch (CacheException e) {
                throw new XQERuntimeException(e);
            }
        }
        return true;
    }

    public static String dumpStorageStateForDS(String dataSourceName) {
        List<Map.Entry<MemberStorage.MemberStorageIdentifier, MemberStorage>> memberStorageSorted = DMRMemberStorage.getDMRMemberStorageEntriesForDS(dataSourceName);
        String dumpFilePath = DMRMemberStorage.getDumpFilePath(DMRMemberStorage.getDumpFileNameForDS(dataSourceName));
        try {
            XMLOutputFactory factory = XQEXMLOutputFactoryPool.getInstance().borrowXMLOutputFactory();
            FileOutputStream opStream = new FileOutputStream(dumpFilePath);
            XMLStreamWriter writer = factory.createXMLStreamWriter(opStream, "UTF-8");
            writer.writeStartDocument();
            writer.writeStartElement("xqeCacheMetric");
            if (memberStorageSorted.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("No cached cube found matching the criteria:");
                sb.append(" ");
                sb.append("dataSource");
                sb.append(" ");
                sb.append("name = ");
                sb.append(dataSourceName);
                writer.writeCharacters(sb.toString());
                writer.writeEndElement();
                writer.writeEndDocument();
                XQEXMLOutputFactoryPool.getInstance().returnXMLOutputFactory(factory);
                opStream.close();
                return dumpFilePath;
            }
            DMRMemberStorage.writeStorageState(memberStorageSorted, writer);
            XQEXMLOutputFactoryPool.getInstance().returnXMLOutputFactory(factory);
            opStream.close();
        }
        catch (FileNotFoundException e) {
            errorLogger.log(e);
        }
        catch (XMLStreamException e) {
            errorLogger.log(e);
        }
        catch (Exception e) {
            errorLogger.log(e);
        }
        return dumpFilePath;
    }

    protected static List<Map.Entry<MemberStorage.MemberStorageIdentifier, MemberStorage>> getDMRMemberStorageEntriesForDS(String dataSourceName) {
        boolean allDMRMemberStorages = "*".equals(dataSourceName);
        Set entries = memberStorageMap.entrySet();
        ArrayList<Map.Entry<MemberStorage.MemberStorageIdentifier, MemberStorage>> toReturn = new ArrayList<Map.Entry<MemberStorage.MemberStorageIdentifier, MemberStorage>>();
        try {
            storageMapLock.lockInterruptibly();
            for (Map.Entry entry : entries) {
                if (!((MemberStorage.MemberStorageIdentifier)entry.getKey()).getDataSourceType().equals("DMR")) continue;
                if (allDMRMemberStorages) {
                    toReturn.add(entry);
                    continue;
                }
                if (!((MemberStorage.MemberStorageIdentifier)entry.getKey()).qualifies(dataSourceName, "*", "*")) continue;
                toReturn.add(entry);
            }
        }
        catch (InterruptedException e) {
            throw new XQERuntimeException(e);
        }
        finally {
            storageMapLock.unlock();
        }
        Collections.sort(toReturn, new Comparator<Map.Entry<MemberStorage.MemberStorageIdentifier, MemberStorage>>(){

            @Override
            public int compare(Map.Entry<MemberStorage.MemberStorageIdentifier, MemberStorage> o1, Map.Entry<MemberStorage.MemberStorageIdentifier, MemberStorage> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        return toReturn;
    }

    private static StringBuilder getDumpFileNameForDS(String dataSourceName) {
        StringBuilder filename = new StringBuilder("SALDump");
        filename.append("_");
        filename.append("DMR");
        filename.append("_");
        filename.append("DS");
        if (dataSourceName.equals("*")) {
            filename.append("_");
            filename.append("all");
        } else {
            filename.append("_");
            filename.append(dataSourceName);
        }
        return filename;
    }

    public void recordNewMemberRequest() {
        this.recordNewRequest(this.dmrDimContextKey);
    }

    public void recordMemberCacheMiss() {
        this.recordCacheMiss(this.dmrDimContextKey);
    }

    public List<DMRMemberStoragePerLevel> getDMRMemberStoragePerLevels() {
        ArrayList<DMRMemberStoragePerLevel> r = new ArrayList<DMRMemberStoragePerLevel>();
        for (DMRMemberStoragePerLevel s : this.levelStorages.values()) {
            r.add(s);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DMRMemberStoragePerLevel getLevelStorage(String levelUniqueName) {
        int levelId = this.getId(levelUniqueName);
        DMRMemberStoragePerLevel levelStorage = (DMRMemberStoragePerLevel)this.levelStorages.get(levelId);
        if (levelStorage != null) {
            return levelStorage;
        }
        DMRMemberStorage dMRMemberStorage = this;
        synchronized (dMRMemberStorage) {
            levelStorage = (DMRMemberStoragePerLevel)this.levelStorages.get(levelId);
            if (levelStorage != null) {
                return levelStorage;
            }
            levelStorage = new DMRMemberStoragePerLevel(this, levelId, levelUniqueName);
            this.levelStorages.put(levelId, levelStorage);
            return levelStorage;
        }
    }

    protected int getNewMemberID() {
        return this.uniqueKey.getAndIncrement();
    }

    @Override
    protected void closeOthers() {
        for (DMRMemberStoragePerLevel a : this.levelStorages.values()) {
            try {
                a.close();
            }
            catch (CacheException e) {
                throw new XQERuntimeException(e);
            }
        }
        this.levelStorages = null;
    }

    public DMRMemberStorageIdentifier getIdentifier() {
        return (DMRMemberStorageIdentifier)this.memberStorageIdentifier;
    }

    @Override
    public void dumpDimensionInfo(XMLStreamWriter writer) throws XMLStreamException {
        StringBuilder sb = new StringBuilder();
        sb.append("List of memberCount in each level in the cube.");
        writer.writeComment(sb.toString());
        TreeMap<String, Integer> levelName2MemberCount = new TreeMap<String, Integer>();
        for (DMRMemberStoragePerLevel dMRMemberStoragePerLevel : this.levelStorages.values()) {
            levelName2MemberCount.put(dMRMemberStoragePerLevel.getLevelUniqueName(), dMRMemberStoragePerLevel.getNumberOfMembers());
        }
        for (Map.Entry entry : levelName2MemberCount.entrySet()) {
            writer.writeStartElement("level");
            writer.writeStartElement("name");
            writer.writeCharacters((String)entry.getKey());
            writer.writeEndElement();
            writer.writeStartElement(MEMBER_COUNT);
            writer.writeCharacters(Integer.toString((Integer)entry.getValue()));
            writer.writeEndElement();
            writer.writeEndElement();
        }
    }

    public static class DMRMemberStorageIdentifier
    extends MemberStorage.MemberStorageIdentifier {
        private final ArrayList<DataSourceInfo> datasourceInfos;
        private final String runLocale;
        private final SecurityContext securityContext;
        private static final String SEPARATOR = "; ";

        public DMRMemberStorageIdentifier(String modelName, String rLocale, List<IModelDataSource> ds, SecurityContext sContext) {
            super("DMR", modelName);
            this.runLocale = rLocale;
            this.datasourceInfos = new ArrayList();
            for (IModelDataSource datasource : ds) {
                ICatalog catalog = datasource.getCatalog();
                ICube cube = datasource.getCube();
                String catalogName = "";
                if (catalog != null) {
                    catalogName = catalog.getName();
                }
                String cubeName = "";
                if (cube != null) {
                    cubeName = cube.getName();
                }
                DataSourceInfo dsInfo = new DataSourceInfo(datasource.getName(), catalogName, cubeName);
                this.datasourceInfos.add(dsInfo);
            }
            Collections.sort(this.datasourceInfos);
            this.securityContext = sContext;
        }

        public DMRMemberStorageIdentifier(String modelName, String rLocale, ArrayList<DataSourceInfo> dsInfo, SecurityContext sContext) {
            super("DMR", modelName);
            this.runLocale = rLocale;
            this.datasourceInfos = (ArrayList)dsInfo.clone();
            this.securityContext = sContext;
        }

        @Override
        public boolean equals(Object o) {
            boolean equalsFlag;
            if (this == o) {
                return true;
            }
            if (!(o instanceof DMRMemberStorageIdentifier)) {
                return false;
            }
            DMRMemberStorageIdentifier key = (DMRMemberStorageIdentifier)o;
            boolean bl = equalsFlag = this.getDataSourceType().equals(key.getDataSourceType()) && this.getModelName().equals(key.getModelName()) && this.runLocale.equals(key.runLocale) && this.isStale() == key.isStale();
            if (!equalsFlag) {
                return false;
            }
            for (int i = 0; i < this.datasourceInfos.size(); ++i) {
                if (this.datasourceInfos.get(i).equals(key.datasourceInfos.get(i))) continue;
                return false;
            }
            return this.securityContext.equals(key.securityContext);
        }

        @Override
        public int hashCode() {
            int hash = 1;
            hash = hash * 31 + this.getDataSourceType().hashCode();
            for (DataSourceInfo dsInfo : this.datasourceInfos) {
                hash = hash * 31 + dsInfo.hashCode();
            }
            hash = hash * 31 + this.getModelName().hashCode();
            hash = hash * 31 + this.runLocale.hashCode();
            hash = hash * 31 + new Boolean(!this.isStale()).hashCode();
            hash = hash * 31 + this.securityContext.hashCode();
            return hash;
        }

        @Override
        public String getDataSourceName() {
            StringBuilder sb = new StringBuilder();
            for (DataSourceInfo dsInfo : this.datasourceInfos) {
                sb.append(dsInfo.dataSourceName);
                sb.append(SEPARATOR);
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }

        @Override
        public String getCatalogName() {
            StringBuilder sb = new StringBuilder();
            for (DataSourceInfo dsInfo : this.datasourceInfos) {
                sb.append(dsInfo.catalogName);
                sb.append(SEPARATOR);
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }

        @Override
        public String getCubeName() {
            StringBuilder sb = new StringBuilder();
            for (DataSourceInfo dsInfo : this.datasourceInfos) {
                sb.append(dsInfo.cubeName);
                sb.append(SEPARATOR);
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }

        public ArrayList<DataSourceInfo> getDataSourceInfos() {
            return this.datasourceInfos;
        }

        @Override
        protected boolean qualifies(String dataSourceName, String catalogName, String cubeName) {
            for (DataSourceInfo dsInfo : this.datasourceInfos) {
                boolean cubeMatched;
                String cname;
                String catname;
                String dsname = dsInfo.dataSourceName;
                if (dsname == null && dataSourceName != null || (catname = dsInfo.catalogName) == null && catalogName != null || (cname = dsInfo.cubeName) == null && cubeName != null) continue;
                boolean datasrcMatched = "*".equals(dataSourceName) || dsname != null && dsname.equals(dataSourceName);
                boolean catMatched = "*".equals(catalogName) || catname != null && catname.equals(catalogName);
                boolean bl = cubeMatched = "*".equals(cubeName) || cname != null && cname.equals(cubeName);
                if (!datasrcMatched || !catMatched || !cubeMatched) continue;
                return true;
            }
            return false;
        }

        @Override
        public int compareTo(MemberStorage.MemberStorageIdentifier other) {
            if (!(other instanceof DMRMemberStorageIdentifier)) {
                return -1;
            }
            int comp = this.getDataSourceType().compareToIgnoreCase(other.getDataSourceType());
            if (comp != 0) {
                return comp;
            }
            comp = this.getModelName().compareToIgnoreCase(other.getModelName());
            if (comp != 0) {
                return comp;
            }
            DMRMemberStorageIdentifier memberStorageId = (DMRMemberStorageIdentifier)other;
            int otherDsSize = memberStorageId.datasourceInfos.size();
            for (int i = 0; i < this.datasourceInfos.size(); ++i) {
                if (otherDsSize == i) {
                    return -1;
                }
                comp = this.datasourceInfos.get(i).compareTo(memberStorageId.datasourceInfos.get(i));
                if (comp == 0) continue;
                return comp;
            }
            if (otherDsSize > this.datasourceInfos.size()) {
                return 1;
            }
            return 0;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(this.getModelName());
            sb.append(DMRMemberStorage.STRING_COMMA);
            if (this.runLocale != null) {
                sb.append(this.runLocale);
                sb.append(DMRMemberStorage.STRING_COMMA);
            }
            if (this.datasourceInfos != null) {
                sb.append(this.datasourceInfos.toString());
            }
            return sb.toString();
        }
    }

    static class DataSourceInfo
    implements Comparable<DataSourceInfo> {
        String dataSourceName;
        String catalogName;
        String cubeName;

        DataSourceInfo(String ds, String catalog, String cube) {
            this.dataSourceName = ds;
            this.catalogName = catalog;
            this.cubeName = cube;
        }

        public int hashCode() {
            int hash = 1;
            hash = hash * 31 + this.dataSourceName.hashCode();
            hash = hash * 31 + this.catalogName.hashCode();
            hash = hash * 31 + this.cubeName.hashCode();
            return hash;
        }

        public boolean equals(Object o) {
            if (!(o instanceof DataSourceInfo)) {
                return false;
            }
            DataSourceInfo other = (DataSourceInfo)o;
            return other.catalogName.equals(this.catalogName) && other.cubeName.equals(this.cubeName) && other.dataSourceName.equals(this.dataSourceName);
        }

        @Override
        public int compareTo(DataSourceInfo dsInfo) {
            int comp = this.dataSourceName.compareToIgnoreCase(dsInfo.dataSourceName);
            if (comp != 0) {
                return comp;
            }
            comp = this.catalogName.compareToIgnoreCase(dsInfo.catalogName);
            if (comp != 0) {
                return comp;
            }
            comp = this.cubeName.compareToIgnoreCase(dsInfo.cubeName);
            if (comp != 0) {
                return comp;
            }
            return 0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.dataSourceName != null) {
                sb.append(this.dataSourceName);
                sb.append(DMRMemberStorage.STRING_COMMA);
            }
            if (this.catalogName != null) {
                sb.append(this.catalogName);
                sb.append(DMRMemberStorage.STRING_COMMA);
            }
            if (this.cubeName != null) {
                sb.append(this.cubeName);
                sb.append(DMRMemberStorage.STRING_COMMA);
            }
            return sb.toString();
        }
    }
}

