/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.securecache;

import com.cognos.xqe.cache.CacheEngineFactory;
import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.cache.ICacheEngine;
import com.cognos.xqe.cache.ICacheableObject;
import com.cognos.xqe.cache.util.CacheableNameValueBasedArray;
import com.cognos.xqe.cache.util.ICacheableNameValueBasedContent;
import com.cognos.xqe.data.providers.olap.securecache.DMRMemberStorage;
import com.cognos.xqe.data.providers.olap.securecache.MemberStorage;
import com.cognos.xqe.data.providers.olap.securecache.MemberStorageKey;
import com.cognos.xqe.data.providers.olap.securecache.SALDynamicFieldsList;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.record.IDynamicField;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMemberProxy;
import com.cognos.xqe.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class DMRMemberStoragePerLevel {
    private final DMRMemberStorage owner;
    private final ConcurrentMap<UniqueKey, ConcurrentMap<String, UniqueKey>> membersInLevel = new ConcurrentHashMap<UniqueKey, ConcurrentMap<String, UniqueKey>>();
    private final String levelUniqueName;
    private ConcurrentMap<Integer, ConcurrentMap<UniqueKey, ICacheableObject>> objs = new ConcurrentHashMap<Integer, ConcurrentMap<UniqueKey, ICacheableObject>>();
    private final ICacheEngine cache;

    protected DMRMemberStoragePerLevel(DMRMemberStorage o, int id, String levelUniName) {
        this.owner = o;
        this.levelUniqueName = levelUniName;
        String cacheName = FileUtil.makeJavaIdentifier(this.owner.uniqueCacheName);
        String cacheDir = MemberStorage.getCacheDir();
        File f = new File(cacheDir);
        if (!f.exists() && !f.mkdirs()) {
            throw new XQERuntimeException(XQEMessageKeys.CSH_DirectoryCreationError, cacheDir);
        }
        String fn = "[" + FileUtil.makeJavaIdentifier(cacheName) + "]_membercache_level_" + id;
        boolean replace = false;
        if (this.owner.isDiskCached()) {
            replace = (Boolean)this.owner.getStorageConfigValue("replaceExistingFiles");
            try {
                this.cache = CacheEngineFactory.createDiskCache(cacheDir, fn, replace);
            }
            catch (CacheException e) {
                throw new XQERuntimeException(e);
            }
        } else if (this.owner.isDynamicallyCached()) {
            int maxMembers = (Integer)this.owner.getStorageConfigValue("maxMembers");
            replace = (Boolean)this.owner.getStorageConfigValue("replaceExistingFiles");
            try {
                this.cache = CacheEngineFactory.createDynamicCache(maxMembers, fn, cacheDir, replace);
            }
            catch (CacheException e) {
                throw new XQERuntimeException(e);
            }
        } else {
            this.cache = CacheEngineFactory.createStaticCache();
        }
    }

    public void close() throws CacheException {
        this.objs = null;
        this.cache.close();
    }

    public void openBuffer(Integer contextId) {
        if (this.objs == null) {
            return;
        }
        if (this.objs.get(contextId) == null) {
            this.objs.put(contextId, new ConcurrentHashMap());
        }
    }

    public void flushToCache(Integer contextId) {
        if (this.objs == null) {
            return;
        }
        ConcurrentMap b = (ConcurrentMap)this.objs.get(contextId);
        if (b != null) {
            try {
                this.cache.cacheAll(new ArrayList<ICacheableObject>(b.values()));
                for (UniqueKey k : b.keySet()) {
                    k.bInCache = true;
                }
            }
            catch (CacheException e) {
                this.objs = null;
                this.owner.markAsFlushCandidate();
                throw new XQERuntimeException(e);
            }
            this.objs.remove(contextId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemberStorageKey cacheRootMember(DMRMember dmrMember) {
        if (!this.membersInLevel.isEmpty()) {
            return (MemberStorageKey)this.membersInLevel.keySet().iterator().next();
        }
        DMRMemberStoragePerLevel dMRMemberStoragePerLevel = this;
        synchronized (dMRMemberStoragePerLevel) {
            if (!this.membersInLevel.isEmpty()) {
                return (MemberStorageKey)this.membersInLevel.keySet().iterator().next();
            }
            UniqueKey key = new UniqueKey(true, dmrMember.getName(), this.owner.getNewMemberID());
            try {
                this.cache.cacheObject(this.createCacheableObject(key, dmrMember));
            }
            catch (CacheException e) {
                this.objs = null;
                this.owner.markAsFlushCandidate();
                throw new XQERuntimeException(e);
            }
            ConcurrentHashMap<String, UniqueKey> v = new ConcurrentHashMap<String, UniqueKey>();
            v.put(dmrMember.getName(), key);
            this.membersInLevel.put(key, v);
            return key;
        }
    }

    protected CacheableNameValueBasedArray createCacheableObject(UniqueKey key, DMRMember dmrMember) {
        HashMap<String, Object> memberProps = new HashMap<String, Object>();
        memberProps.put("MEMBER_BUSINESS_KEY", dmrMember.getBusinessKeyValue());
        memberProps.put("CAPTION", dmrMember.getCaption());
        memberProps.put("MEMBER_CAPTION_VALUE", dmrMember.getCaptionValue());
        List<IDynamicField> emptyList = Collections.emptyList();
        SALDynamicFieldsList fields = new SALDynamicFieldsList(emptyList);
        Set<String> fieldSet = dmrMember.getAvailableProperties();
        for (String fieldName : fieldSet) {
            Object value = dmrMember.getProperty(fieldName);
            if (value == null) continue;
            fields.updateDynamicField(fieldName, value);
        }
        memberProps.put("DYNAMIC_FIELDS", fields);
        return new CacheableNameValueBasedArray(key, memberProps);
    }

    public MemberStorageKey cacheMember(DMRMember dmrMember, DMRMemberProxy parentMember, Integer contextId) {
        if (this.objs == null) {
            return null;
        }
        ConcurrentMap b = (ConcurrentMap)this.objs.get(contextId);
        if (b == null) {
            return null;
        }
        UniqueKey key = this.getOrCreateChildUniqueKey((UniqueKey)parentMember.getCacheKey(), dmrMember.getName());
        if (key.bInCache) {
            this.insertNewPropertyIfNotExist(b, key, dmrMember);
        } else {
            b.put(key, this.createCacheableObject(key, dmrMember));
        }
        return key;
    }

    private UniqueKey getOrCreateChildUniqueKey(UniqueKey parentKey, String childName) {
        UniqueKey pre;
        UniqueKey k;
        ConcurrentMap pre2;
        ConcurrentMap<String, UniqueKey> mp = (ConcurrentHashMap)this.membersInLevel.get(parentKey);
        if (mp == null && (pre2 = (ConcurrentMap)this.membersInLevel.putIfAbsent(parentKey, mp = new ConcurrentHashMap())) != null) {
            mp = pre2;
        }
        if ((k = (UniqueKey)mp.get(childName)) == null && (pre = mp.putIfAbsent(childName, k = new UniqueKey(false, childName, this.owner.getNewMemberID()))) != null) {
            k = pre;
        }
        return k;
    }

    private void insertNewPropertyIfNotExist(ConcurrentMap<UniqueKey, ICacheableObject> b, UniqueKey key, DMRMember dmrMember) {
        try {
            ICacheableNameValueBasedContent propertyData = (ICacheableNameValueBasedContent)this.cache.get(key);
            Object propValue = propertyData.get("CAPTION");
            if (propValue != null && !dmrMember.getCaptionValue().getString().equals(propValue.toString())) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_DuplicateMember, dmrMember.getHierarchy().getV5UniqueName(), (Object)dmrMember.getV5UniqueName(), propValue, (Object)dmrMember.getCaptionValue());
            }
            SALDynamicFieldsList dynamicFields = (SALDynamicFieldsList)propertyData.get("DYNAMIC_FIELDS");
            boolean bInsert = false;
            Set<String> fieldSet = dmrMember.getAvailableProperties();
            for (String fieldName : fieldSet) {
                Object value = dmrMember.getProperty(fieldName);
                if (value == null || dynamicFields.containsFieldName(fieldName)) continue;
                dynamicFields.updateDynamicField(fieldName, value);
                bInsert = true;
            }
            if (bInsert) {
                b.putIfAbsent(key, propertyData);
            }
        }
        catch (CacheException e) {
            this.objs = null;
            this.owner.markAsFlushCandidate();
            throw new XQERuntimeException(e);
        }
    }

    public Object getMemberPropValueFromCache(MemberStorageKey key, String propName, boolean dynamic, Integer contextId) {
        ICacheableNameValueBasedContent propertyData;
        if (this.objs == null) {
            return null;
        }
        ConcurrentMap b = (ConcurrentMap)this.objs.get(contextId);
        if (b != null && (propertyData = (ICacheableNameValueBasedContent)b.get(key)) != null) {
            if (!dynamic) {
                return propertyData.get(propName);
            }
            SALDynamicFieldsList dynamicFields = (SALDynamicFieldsList)propertyData.get("DYNAMIC_FIELDS");
            return dynamicFields.getFieldValue(propName);
        }
        if (((UniqueKey)key).bInCache) {
            try {
                propertyData = (ICacheableNameValueBasedContent)this.cache.get(key);
                if (!dynamic) {
                    return propertyData.get(propName);
                }
                SALDynamicFieldsList dynamicFields = (SALDynamicFieldsList)propertyData.get("DYNAMIC_FIELDS");
                return dynamicFields.getFieldValue(propName);
            }
            catch (CacheException e) {
                this.owner.markAsFlushCandidate();
                throw new XQERuntimeException(e);
            }
        }
        return null;
    }

    public Object getDynamicPropValueFromBufferOrAddNullValue(MemberStorageKey key, String propName, Integer contextId) {
        if (this.objs == null) {
            return null;
        }
        ConcurrentMap b = (ConcurrentMap)this.objs.get(contextId);
        if (b == null) {
            return null;
        }
        ICacheableNameValueBasedContent propertyData = (ICacheableNameValueBasedContent)b.get(key);
        if (propertyData == null && ((UniqueKey)key).bInCache) {
            try {
                propertyData = (ICacheableNameValueBasedContent)this.cache.get(key);
            }
            catch (CacheException e) {
                this.objs = null;
                this.owner.markAsFlushCandidate();
                throw new XQERuntimeException(e);
            }
        }
        Value o = DMRMember.DEFAULT_BUSINESSKEY;
        if (propertyData != null) {
            SALDynamicFieldsList dynamicFields = (SALDynamicFieldsList)propertyData.get("DYNAMIC_FIELDS");
            if (!dynamicFields.containsFieldName(propName)) {
                dynamicFields.updateDynamicField(propName, o);
                b.putIfAbsent((UniqueKey)key, propertyData);
                return o;
            }
            return dynamicFields.getFieldValue(propName);
        }
        return null;
    }

    public boolean hasDynamicPropertyInCache(MemberStorageKey key, String propName, Integer contextId) {
        SALDynamicFieldsList dynamicFields;
        ICacheableNameValueBasedContent propertyData;
        if (this.objs == null) {
            return false;
        }
        ConcurrentMap b = (ConcurrentMap)this.objs.get(contextId);
        if (b != null && (propertyData = (ICacheableNameValueBasedContent)b.get(key)) != null && (dynamicFields = (SALDynamicFieldsList)propertyData.get("DYNAMIC_FIELDS")).containsFieldName(propName)) {
            return true;
        }
        if (((UniqueKey)key).bInCache) {
            try {
                propertyData = (ICacheableNameValueBasedContent)this.cache.get(key);
                if (propertyData != null && (dynamicFields = (SALDynamicFieldsList)propertyData.get("DYNAMIC_FIELDS")).containsFieldName(propName)) {
                    return true;
                }
            }
            catch (CacheException e) {
                this.objs = null;
                this.owner.markAsFlushCandidate();
                throw new XQERuntimeException(e);
            }
        }
        return false;
    }

    public void setDynamicPropertyIfNotExist(MemberStorageKey key, String propName, Object propValue, Integer contextId) {
        if (this.objs == null) {
            return;
        }
        ConcurrentMap b = (ConcurrentMap)this.objs.get(contextId);
        if (b == null) {
            return;
        }
        ICacheableNameValueBasedContent propertyData = (ICacheableNameValueBasedContent)b.get(key);
        if (propertyData != null) {
            SALDynamicFieldsList dynamicFields = (SALDynamicFieldsList)propertyData.get("DYNAMIC_FIELDS");
            if (!dynamicFields.containsFieldName(propName)) {
                dynamicFields.updateDynamicField(propName, propValue);
            }
        } else if (((UniqueKey)key).bInCache) {
            try {
                propertyData = (ICacheableNameValueBasedContent)this.cache.get(key);
                if (propertyData == null) {
                    return;
                }
                SALDynamicFieldsList dynamicFields = (SALDynamicFieldsList)propertyData.get("DYNAMIC_FIELDS");
                if (!dynamicFields.containsFieldName(propName)) {
                    dynamicFields.updateDynamicField(propName, propValue);
                    b.putIfAbsent((UniqueKey)key, propertyData);
                }
            }
            catch (CacheException e) {
                this.objs = null;
                this.owner.markAsFlushCandidate();
                throw new XQERuntimeException(e);
            }
        }
    }

    public String getLevelUniqueName() {
        return this.levelUniqueName;
    }

    public int getNumberOfMembers() {
        int n = 0;
        for (ConcurrentMap mp : this.membersInLevel.values()) {
            n += mp.size();
        }
        return n;
    }

    public Object[] getTempObjects() {
        Object[] tempObj = new Object[]{this.membersInLevel, this.objs};
        return tempObj;
    }

    public int getNewMemberID() {
        return this.owner.getNewMemberID();
    }

    public final class UniqueKey
    extends MemberStorageKey {
        private static final long serialVersionUID = 3877976397791423709L;
        protected volatile boolean bInCache;
        protected String memberName;

        protected UniqueKey(boolean flag, String name, int id) {
            super(0x1000000000000000L, 0, id);
            this.bInCache = false;
            this.memberName = name;
            this.bInCache = flag;
        }

        public String getMUN() {
            return this.memberName;
        }

        @Override
        public void writeToStream(ObjectOutputStream out) throws IOException {
            super.writeToStream(out);
            out.writeUTF(this.memberName);
            out.writeBoolean(this.bInCache);
        }

        @Override
        public void readFromStream(ObjectInputStream in) throws IOException, ClassNotFoundException {
            super.readFromStream(in);
            this.memberName = in.readUTF();
            this.bInCache = in.readBoolean();
        }
    }
}

