/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.securecache;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.xqe.cache.BTreeStringKeyIndexer;
import com.cognos.xqe.cache.CacheEngineFactory;
import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.cache.HashMapStringKeyIndexer;
import com.cognos.xqe.cache.ICacheEngine;
import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.cache.ICacheableObject;
import com.cognos.xqe.cache.StringKeyIndexer;
import com.cognos.xqe.cache.StringKeyIndexerKey;
import com.cognos.xqe.cache.util.CacheableNameValueBasedArray;
import com.cognos.xqe.cache.util.ICacheableNameValueBasedContent;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQECCLConfigurationFactory;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.securecache.DMRMemberStorage;
import com.cognos.xqe.data.providers.olap.securecache.MemberStorageConfig;
import com.cognos.xqe.data.providers.olap.securecache.MemberStorageKey;
import com.cognos.xqe.data.providers.olap.securecache.MemberStorageMemberKey;
import com.cognos.xqe.data.providers.olap.securecache.SALDynamicFieldsList;
import com.cognos.xqe.data.providers.olap.securecache.SALQueryContextBitSet;
import com.cognos.xqe.data.providers.olap.securecache.SALQueryContextOrdinalList;
import com.cognos.xqe.data.providers.olap.securecache.SecureCacheConfigurationManager;
import com.cognos.xqe.data.providers.olap.securecache.TM1MemberStorage;
import com.cognos.xqe.exception.RequestCanceledException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.RollupTypeEnum;
import com.cognos.xqe.metadata.TreeOperatorEnum;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.query.engine.ICubeTimestamps;
import com.cognos.xqe.runtree.olap.mdx.metadata.CubeManager;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.CubeContextManager;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.FileUtil;
import com.cognos.xqe.util.LocalizedString;
import com.cognos.xqe.util.StringSubstitutionEngine;
import com.cognos.xqe.util.pool.XQEXMLOutputFactoryPool;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axis.encoding.Base64;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class MemberStorage {
    protected static final String WILD_CARD = "*";
    protected static final String MODEL_PATH_INDICATOR = "[@";
    private static final String MEMBER_STORAGE_DIR_NAME = "MemberStorage";
    private static final int NUMBER_OF_SECONDS_IN_MINUTE = 60;
    private static final int ONE_MILLI_SECOND = 1000;
    public static final int DESCENDANTS_LEAF = 1000;
    private static final int TRUE = 1;
    private static final int FALSE = -1000000;
    ICubeTimestamps previousMetadataCubeTimestamps = null;
    ICubeTimestamps currentMetadataCubeTimestamps = null;
    private static final String XML_EXT = ".xml";
    protected static Map<MemberStorageIdentifier, MemberStorage> memberStorageMap = new HashMap<MemberStorageIdentifier, MemberStorage>();
    protected static Lock storageMapLock = new ReentrantLock();
    private StringKeyIndexer indexer;
    private ICacheEngine cache;
    private List<Integer> queryCtxIds;
    private Lock queryCtxIdsLock = new ReentrantLock();
    private volatile int memRefCount;
    protected long timestamp;
    private boolean queryContextTestsRunning = false;
    private Lock memRefCountAccessLock;
    private ConcurrentMap<ICacheKey, ReadWriteLock> objectReadWriteLocks = new ConcurrentHashMap<ICacheKey, ReadWriteLock>();
    private AtomicBoolean cacheClosed = new AtomicBoolean(false);
    protected MemberStorageIdentifier memberStorageIdentifier;
    protected String uniqueCacheName;
    private Map<String, List<ICacheKey>> partiallyOrFullycachedDimensions = new HashMap<String, List<ICacheKey>>();
    private Lock dimensionLock = new ReentrantLock();
    private Map<String, String> supportedLocales = null;
    private static Map<String, Long> cacheSizeMap = new HashMap<String, Long>();
    private static Lock cacheSizeLock = new ReentrantLock();
    private static final String LEFT_BRACE = "[";
    private static final String RIGHT_BRACE = "]";
    private Lock memberStorageUsageLock = new ReentrantLock();
    private volatile int memberStorageUsageCount = 0;
    private Lock memberStorageFlushingLock = new ReentrantLock();
    private volatile boolean isBeingFlushed = false;
    private Condition memStorageIsBeingFlushedCondition = this.memberStorageFlushingLock.newCondition();
    private ConcurrentMap<DimContextKey, AtomicLong> totalRequests = new ConcurrentHashMap<DimContextKey, AtomicLong>();
    private ConcurrentMap<DimContextKey, AtomicLong> cacheMiss = new ConcurrentHashMap<DimContextKey, AtomicLong>();
    static XQELogger errorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    protected static XQELogger infoLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "MemberStorage", LogLevel.INFO);
    protected MemberStorageConfig storageConfig;
    protected boolean staticCache;
    private long creationTickCount = 0L;
    protected static final int NUMBER_31 = 31;
    protected IDataSource mDataSource;
    protected static final String DMR_DATASOURCE_TYPE = "DMR";
    public static final String PARENT_UNIQUE_NAME = "PARENT_UNIQUE_NAME";
    public static final String PARENT_LEVEL_NUMBER = "PARENT_LEVEL";
    public static final String PARENT_COUNT = "PARENT_COUNT";
    public static final String CHILD_CARDINALITY = "CHILD_CARDINALITY";
    public static final String ROLLUP_TYPE = "ROLLUP_TYPE";
    public static final String MEMBER_TYPE = "MEMBER_TYPE";
    public static final String LEVEL_NUMBER = "LEVEL_NUMBER";
    public static final String LEVEL_UNIQUE_NAME = "LEVEL_UNIQUE_NAME";
    public static final String HIERARCHY_UNIQUE_NAME = "HIERARCHY_UNIQUE_NAME";
    public static final String DIMENSION_UNIQUE_NAME = "DIMENSION_UNIQUE_NAME";
    public static final String CUBE_NAME = "CUBE_NAME";
    public static final String SCHEMA_NAME = "SCHEMA_NAME";
    public static final String CATALOG_NAME = "CATALOG_NAME";
    public static final String MEMBER_UNIQUE_ID = "MEMBER_UNIQUE_ID";
    public static final String MEMBER_UNIQUE_NAME = "MEMBER_UNIQUE_NAME";
    public static final String DESCRIPTION = "DESCRIPTION";
    public static final String CAPTION = "CAPTION";
    public static final String MEMBER_CAPTION = "MEMBER_CAPTION";
    public static final String MEMBER_NAME = "MEMBER_NAME";
    public static final String MEMBER_KEY = "MEMBER_CACHE_KEY";
    public static final String CONTEXT_KEY = "CONTEXT_KEY";
    public static final String CONTEXT_ID = "CONTEXT_ID";
    public static final String CONTEXT_LEVELS = "CONTEXT_LEVELS";
    public static final String CONTEXT_LEVEL_KEY = "CONTEXT_LEVEL_KEY";
    public static final String QUERY_CTX_LEVEL_COMPLETE_BITMAP = "QUERY_CTX_LEVEL_COMPLETE_BITMAP";
    public static final String CONTEXT_LEVEL_MEMBER_REFS = "CTX_LEVEL_MEMBER_REFS_KEY_SET";
    public static final String CONTEXT_LEVEL_MEMBER_REFS_NO_QRY_CTX = "CTX_LEVEL_MEMBER_REFS_NO_QRY_CTX_LIST";
    public static final String PARENT_MEMBER_REF_KEY = "PARENT_MEMBER_REF_KEY";
    public static final String CHILDREN_MEMBER_REFS = "CHILD_MEMBER_REFS_KEY_SET";
    public static final String CHILDREN_MEMBER_REFS_NO_QRY_CTX = "CHILDREN_MEMBER_REFS_NO_QRY_CTX_LIST";
    public static final String QUERY_CTX_CHILDREN_COMPLETE_BITMAP = "QUERY_CTX_CHILDREN_COMPLETE_BITMAP";
    public static final String EXISTS_IN_QUERY_CTX_BITMAP = "EXISTS_IN_QUERY_CTX_BITMAP";
    public static final String QUERY_CTX_ORDINAL_LIST = "QUERY_CTX_ORDINAL_LIST";
    public static final String QUERY_CTX_PC_ORDINAL_LIST = "QUERY_CTX_PC_ORDINAL_LIST";
    private static final String TREEOPSET_COMPLETE_IN_QUERY_CTX_BITMAP = "TREEOPSET_COMPLETE_IN_QUERY_CTX_BITMAP";
    private static final String TREEOP_COMPLETION_FLAGS = "TREEOP_COMPLETION_FLAGS";
    private static final int NUMBER_OF_TREEOPENUM_TYPES = MetadataUtil.TREEOPENUMALL.size();
    public static final String DYNAMIC_FIELDS = "DYNAMIC_FIELDS";
    public static final String HIERARCHY_CACHE_KEY = "HIERARCHY_CACHE_KEY";
    public static final String SAL_QUERY_CONTEXT_TESTS = "queryContextTests";
    private static String[] allPropertyNames = new String[]{"PARENT_UNIQUE_NAME", "PARENT_LEVEL", "PARENT_COUNT", "CHILD_CARDINALITY", "ROLLUP_TYPE", "MEMBER_TYPE", "LEVEL_NUMBER", "LEVEL_UNIQUE_NAME", "HIERARCHY_UNIQUE_NAME", "DIMENSION_UNIQUE_NAME", "CUBE_NAME", "SCHEMA_NAME", "CATALOG_NAME", "MEMBER_UNIQUE_ID", "MEMBER_UNIQUE_NAME", "DESCRIPTION", "CAPTION", "MEMBER_NAME", "MEMBER_CACHE_KEY", "CONTEXT_KEY", "CONTEXT_ID", "CONTEXT_LEVELS", "CONTEXT_LEVEL_KEY", "QUERY_CTX_LEVEL_COMPLETE_BITMAP", "CTX_LEVEL_MEMBER_REFS_KEY_SET", "CTX_LEVEL_MEMBER_REFS_NO_QRY_CTX_LIST", "PARENT_MEMBER_REF_KEY", "CHILD_MEMBER_REFS_KEY_SET", "CHILDREN_MEMBER_REFS_NO_QRY_CTX_LIST", "QUERY_CTX_CHILDREN_COMPLETE_BITMAP", "TREEOPSET_COMPLETE_IN_QUERY_CTX_BITMAP", "EXISTS_IN_QUERY_CTX_BITMAP", "QUERY_CTX_ORDINAL_LIST", "QUERY_CTX_PC_ORDINAL_LIST", "TREEOP_COMPLETION_FLAGS", "HIERARCHY_CACHE_KEY"};
    private static String[] simpleStoragePropertyNames = new String[]{"PARENT_UNIQUE_NAME", "PARENT_LEVEL", "PARENT_COUNT", "CHILD_CARDINALITY", "ROLLUP_TYPE", "MEMBER_TYPE", "LEVEL_NUMBER", "LEVEL_UNIQUE_NAME", "HIERARCHY_UNIQUE_NAME", "DIMENSION_UNIQUE_NAME", "CUBE_NAME", "SCHEMA_NAME", "CATALOG_NAME", "MEMBER_UNIQUE_ID", "MEMBER_UNIQUE_NAME", "DESCRIPTION", "CAPTION", "MEMBER_NAME", "MEMBER_CACHE_KEY", "CONTEXT_KEY", "CONTEXT_ID", "CONTEXT_LEVEL_KEY", "PARENT_MEMBER_REF_KEY", "HIERARCHY_CACHE_KEY"};
    protected static final String MISSING_VALUE = ";,missing,;";
    static final String DATA_SOURCE = "dataSource";
    static final String CUBE = "cube";
    static final String CATALOG = "catalog";
    static final String PACKAGE = "package";
    private static final String DIMENSION = "dimension";
    protected static final String NAME = "name = ";
    protected static final String SPACE = " ";
    protected static final String DUMP_ERROR_MESSAGE = "No cached cube found matching the criteria:";
    protected static final String DUMP_FILE_NAME_PREFIX = "SALDump";
    protected static final String DUMP_FILE_CHAR_ENCODING = "UTF-8";
    private static final String TOTAL_REQUESTS = "totalrequests";
    private static final String CACHE_HIT_COUNT = "cachehitcount";
    private static final String CACHE_MISS_COUNT = "cachemisscount";
    protected static final String XQE_CACHE_METRIC = "xqeCacheMetric";
    private static final String SECURITY_CONTEXT = "securitycontext";
    public static final String LEVEL = "level";
    private static final String MODEL_NAME = "model";
    public static final String DATA_SOURCE_TYPE = "type";
    protected static final String SEPARATOR = "_";
    protected static final String ALL = "all";
    protected static final String VALUE = "value";
    public static final String NAME_TAG = "name";

    protected static String getCacheDir() {
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        return config.getXqeTempDirectory() + File.separator + MEMBER_STORAGE_DIR_NAME;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MemberStorage)) {
            return false;
        }
        return this.getTimestamp() == ((MemberStorage)o).getTimestamp() && this.getMemberStorageId().equals(((MemberStorage)o).getMemberStorageId());
    }

    public int hashCode() {
        return this.getMemberStorageId().hashCode();
    }

    protected MemberStorage(IDataSource dataSource, String dsName, String catName, String cName, String modName, String runLocale) {
        this.mDataSource = dataSource;
        String dsType = dataSource.getType();
        try {
            MemberStorageIdentifier memStorageIdentifier;
            this.timestamp = System.currentTimeMillis();
            storageMapLock.lockInterruptibly();
            this.memberStorageIdentifier = memStorageIdentifier = MemberStorage.buildMemberStorageIdentifier(dsType, dsName, catName, cName, modName, true, runLocale);
            if (memberStorageMap.containsKey(memStorageIdentifier)) {
                throw new XQERuntimeException();
            }
            StringBuilder sb = new StringBuilder().append(memStorageIdentifier.hashCode());
            this.uniqueCacheName = sb.toString();
            this.storageConfig = SecureCacheConfigurationManager.getInstance().getMemberStorageConfiguration(dsType, dsName, catName, cName);
            this.staticCache = this.isStaticallyCached();
            this.initialize();
        }
        catch (InterruptedException e) {
            throw new RequestCanceledException();
        }
        finally {
            storageMapLock.unlock();
        }
    }

    public MemberStorage() {
    }

    protected void initialize() {
        String cacheName = FileUtil.makeJavaIdentifier(this.uniqueCacheName);
        if (this.isDynamicallyCached() || this.isDiskCached()) {
            Boolean replace = (Boolean)this.getStorageConfigValue("replaceExistingFiles");
            this.indexer = new BTreeStringKeyIndexer(MemberStorage.getCacheDir(), cacheName, replace);
        } else {
            this.indexer = new HashMapStringKeyIndexer();
        }
        this.cache = this.initializeCache(cacheName);
        this.queryCtxIds = new ArrayList<Integer>();
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        if (config.getBooleanProperty(SAL_QUERY_CONTEXT_TESTS, false)) {
            this.queryContextTestsRunning = true;
            this.memRefCountAccessLock = new ReentrantLock();
        }
        this.creationTickCount = System.currentTimeMillis();
    }

    public void flush() throws CacheException {
        block14: {
            try {
                this.memberStorageUsageLock.lockInterruptibly();
                if (this.isInUse()) {
                    infoLogger.log("Marking stale in flush() as member storage is in use for " + this);
                    this.markAsFlushCandidate();
                    break block14;
                }
                try {
                    this.indicatePendingFlushAction();
                    infoLogger.log("Starting MemberStorage flush for " + this);
                    try {
                        cacheSizeLock.lockInterruptibly();
                        cacheSizeMap.remove(this.uniqueCacheName);
                    }
                    catch (InterruptedException e) {
                        throw new XQERuntimeException(e);
                    }
                    finally {
                        cacheSizeLock.unlock();
                    }
                    this.partiallyOrFullycachedDimensions.clear();
                    this.totalRequests.clear();
                    this.cacheMiss.clear();
                    this.objectReadWriteLocks.clear();
                    this.destroyStorage();
                    infoLogger.log("MemberStorage flush completed for " + this);
                }
                finally {
                    this.indicateFlushActionDone();
                }
            }
            catch (InterruptedException e) {
                throw new XQERuntimeException(e);
            }
            finally {
                this.memberStorageUsageLock.unlock();
            }
        }
    }

    public void close() throws CacheException {
        try {
            this.memberStorageUsageLock.lockInterruptibly();
            if (this.isInUse()) {
                this.markAsFlushCandidate();
            } else {
                this.indexer.close();
                this.cache.close();
                this.cacheClosed.set(true);
                this.closeOthers();
            }
        }
        catch (InterruptedException e) {
            throw new XQERuntimeException(e);
        }
        finally {
            this.memberStorageUsageLock.unlock();
        }
    }

    protected void closeOthers() {
    }

    public static boolean flushAllStorages() {
        return MemberStorage.flushStorage(WILD_CARD, WILD_CARD, WILD_CARD);
    }

    public static String dumpAllStorages() {
        return MemberStorage.dumpStorageState(WILD_CARD, WILD_CARD, WILD_CARD);
    }

    private Map<String, List<ICacheKey>> getCachedDimensions() {
        return this.partiallyOrFullycachedDimensions;
    }

    public Map<String, String> getSupportedLocales() {
        return this.supportedLocales;
    }

    public synchronized void initSupportedLocales(Map<String, String> localeMap) {
        if (this.supportedLocales == null) {
            this.supportedLocales = localeMap;
        }
    }

    private Lock acquireObjectLock(ICacheKey cacheKey, CacheLockType lockType) {
        ReadWriteLock rwLock;
        ReadWriteLock readWriteLock = (ReadWriteLock)this.objectReadWriteLocks.get(cacheKey);
        if (readWriteLock == null && (rwLock = this.objectReadWriteLocks.putIfAbsent(cacheKey, readWriteLock = new ReentrantReadWriteLock())) != null) {
            readWriteLock = rwLock;
        }
        Lock lock = lockType == CacheLockType.READ_LOCK ? readWriteLock.readLock() : readWriteLock.writeLock();
        lock.lock();
        return lock;
    }

    private void releaseObjectLock(Lock lock) {
        if (lock != null) {
            lock.unlock();
        }
    }

    private ICacheKey getLockCacheKey(ICacheKey cacheKey) {
        ICacheKey lockCacheKey = null;
        if (((MemberStorageKey)cacheKey).isHierarchyKey()) {
            lockCacheKey = cacheKey;
        } else if (((MemberStorageKey)cacheKey).isMemberKey()) {
            String mun = ((MemberStorageMemberKey)cacheKey).getMUN();
            String hun = mun.substring(0, mun.indexOf(RIGHT_BRACE) + 1);
            lockCacheKey = this.createHierarchyCacheKey(hun);
        } else {
            int contextId = ((MemberStorageKey)cacheKey).getContextId();
            lockCacheKey = MemberStorageKey.createContextKey(contextId);
        }
        return lockCacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static MemberStorage getMemberStorage(IDataSource dataSource, String dataSourceName, String catalogName, String runLocale, String cubeName, String modelName) {
        String dataSourceType = dataSource.getType();
        if (cubeName == null || catalogName == null) {
            throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionMissing, RestrictionType.CUBE.toString());
        }
        MemberStorage store = null;
        MemberStorageIdentifier memStorageIdentifier = MemberStorage.buildMemberStorageIdentifier(dataSourceType, dataSourceName, catalogName, cubeName, modelName, true, runLocale);
        while (true) {
            storageMapLock.lock();
            try {
                store = memberStorageMap.get(memStorageIdentifier);
                if (store == null) {
                    store = dataSourceType.equals("TM") || dataSourceType.equals("TMR") ? new TM1MemberStorage(dataSource, dataSourceName, catalogName, cubeName, modelName, runLocale) : new MemberStorage(dataSource, dataSourceName, catalogName, cubeName, modelName, runLocale);
                    infoLogger.log("Created MemberStorage " + store);
                    memberStorageMap.put(memStorageIdentifier, store);
                }
            }
            finally {
                storageMapLock.unlock();
            }
            if (store.incrementUsageCount()) {
                return store;
            }
            if (!store.isStale() || !store.isBeingFlushed()) continue;
            store.awaitFlush();
        }
    }

    private void destroyStorage() {
        if (this.getDataSourceType().equals(DMR_DATASOURCE_TYPE)) {
            infoLogger.log("Removing all DMR cube contexts associated with member storage: " + this);
            CubeContextManager dmrCubeContextManager = CubeContextManager.getCubeContextManager();
            dmrCubeContextManager.removeMemberStorageCubes(this);
        } else {
            infoLogger.log("Removing all LOLAP cubes associated with member storage: " + this);
            CubeManager cubeManager = CubeManager.getCubeManager();
            cubeManager.removeMemberStorageCubes(this);
        }
        try {
            this.close();
        }
        catch (CacheException e) {
            throw new XQERuntimeException(e);
        }
    }

    private ICacheEngine initializeCache(String cacheName) {
        if (this.cache == null) {
            String cacheDir = MemberStorage.getCacheDir();
            File f = new File(cacheDir);
            if (!f.exists() && !f.mkdirs()) {
                throw new XQERuntimeException(XQEMessageKeys.CSH_DirectoryCreationError, cacheDir);
            }
            String fn = LEFT_BRACE + FileUtil.makeJavaIdentifier(cacheName) + RIGHT_BRACE + "_membercache";
            boolean replace = false;
            if (this.isDiskCached()) {
                replace = (Boolean)this.getStorageConfigValue("replaceExistingFiles");
                try {
                    this.cache = CacheEngineFactory.createDiskCache(cacheDir, fn, replace);
                }
                catch (CacheException e) {
                    throw new XQERuntimeException(e);
                }
            } else if (this.isDynamicallyCached()) {
                int maxMembers = (Integer)this.getStorageConfigValue("maxMembers");
                replace = (Boolean)this.getStorageConfigValue("replaceExistingFiles");
                try {
                    this.cache = CacheEngineFactory.createDynamicCache(maxMembers, fn, cacheDir, replace);
                }
                catch (CacheException e) {
                    throw new XQERuntimeException(e);
                }
            } else {
                this.cache = CacheEngineFactory.createStaticCache();
            }
        }
        return this.cache;
    }

    protected boolean isDynamicallyCached() {
        String cacheType = this.getStorageType();
        if (cacheType == null) {
            return false;
        }
        return cacheType.equals("dynamic");
    }

    protected boolean isDiskCached() {
        String cacheType = this.getStorageType();
        if (cacheType == null) {
            return false;
        }
        return cacheType.equals("disk");
    }

    protected boolean isStaticallyCached() {
        String cacheType = this.getStorageType();
        if (cacheType == null) {
            return true;
        }
        return cacheType.equals("static");
    }

    private String getStorageType() {
        Object propValue = this.storageConfig.getCacheStorageProperty("cacheType");
        return (String)propValue;
    }

    protected Object getStorageConfigValue(String property) {
        Object propValue = this.storageConfig.getCacheStorageProperty(property);
        return propValue;
    }

    protected int getId(String name) {
        return (int)this.indexer.getIndex(name);
    }

    protected MemberStorageKey createMemberCacheKey(String memberUniqueName) {
        StringKeyIndexerKey key = this.indexer.createKey(memberUniqueName);
        int id = (int)this.indexer.getIndex(key);
        return MemberStorageMemberKey.createMemberKey(key, id);
    }

    protected MemberStorageKey createMemberCacheKey(int memberId) {
        return MemberStorageKey.createNonContextualKey(memberId);
    }

    protected MemberStorageKey createHierarchyCacheKey(String hierarchyName) {
        return MemberStorageKey.createHierarchyKey(this.getId(hierarchyName));
    }

    protected MemberStorageKey createContextCacheKey(String strContextId) {
        return MemberStorageKey.createContextKey(this.getId(strContextId));
    }

    protected MemberStorageKey createMemberReferenceCacheKey(MemberStorageKey contextCacheKey, String memberUniqueName) {
        return MemberStorageKey.createMemberRefKey(contextCacheKey.getContextId(), this.getId(memberUniqueName));
    }

    protected MemberStorageKey createMemberReferenceCacheKey(MemberStorageKey contextCacheKey, MemberStorageKey memberStorageKey) {
        return MemberStorageKey.createMemberRefKey(contextCacheKey.getContextId(), memberStorageKey.getMemberId());
    }

    protected MemberStorageKey createContextLevelCacheKey(MemberStorageKey contextCacheKey, String levelUniqueName) {
        return MemberStorageKey.createContextLevelKey(contextCacheKey.getContextId(), this.getId(levelUniqueName));
    }

    protected boolean exists(ICacheKey cacheKey) {
        try {
            return this.cache.contains(cacheKey);
        }
        catch (CacheException e) {
            this.markAsFlushCandidate();
            throw new XQERuntimeException(e);
        }
    }

    protected void cacheMember(ICacheKey memberKey, ICacheKey hierKey, MemberRecord record, boolean initName, boolean initCaption, boolean initDescription, boolean refreshMemberPropsIsRequired, TreeSet<String> propNames) {
        if (hierKey == null) {
            hierKey = this.createHierarchyCacheKey(record.getHierarchyUniqueName());
        }
        Lock writeLock = null;
        try {
            List<CachedProperty> properties;
            writeLock = this.acquireObjectLock(hierKey, CacheLockType.WRITE_LOCK);
            if (!this.exists(memberKey)) {
                String dataSourceType = this.getDataSourceType();
                HashMap<String, Object> memberProps = new HashMap<String, Object>();
                memberProps.put(HIERARCHY_CACHE_KEY, hierKey);
                if (!dataSourceType.equals(DMR_DATASOURCE_TYPE)) {
                    memberProps.put(MEMBER_UNIQUE_ID, record.getUniqueId());
                }
                if (initName) {
                    memberProps.put(MEMBER_NAME, record.getName());
                } else if (refreshMemberPropsIsRequired || !dataSourceType.equals(DMR_DATASOURCE_TYPE)) {
                    memberProps.put(MEMBER_NAME, null);
                }
                if (initCaption) {
                    memberProps.put(CAPTION, record.getCaption());
                } else if (refreshMemberPropsIsRequired) {
                    memberProps.put(CAPTION, null);
                }
                if (initDescription) {
                    memberProps.put(DESCRIPTION, record.getDescription());
                } else if (refreshMemberPropsIsRequired) {
                    memberProps.put(DESCRIPTION, MISSING_VALUE);
                }
                memberProps.put(ROLLUP_TYPE, (Object)record.getRollupType());
                MemberTypeEnum memberType = record.getType();
                if (!dataSourceType.equals("EB") && memberType == MemberTypeEnum.REGULAR) {
                    memberType = null;
                }
                if (memberType != null) {
                    memberProps.put(MEMBER_TYPE, (Object)memberType);
                }
                SALDynamicFieldsList fields = new SALDynamicFieldsList(record.getDynamicFields());
                memberProps.put(DYNAMIC_FIELDS, fields);
                this.cacheObject(new CacheableNameValueBasedArray(memberKey, memberProps));
                if (!this.cache.contains(hierKey)) {
                    HashMap<String, Object> hierProps = new HashMap<String, Object>();
                    hierProps.put(SCHEMA_NAME, record.getSchemaName());
                    hierProps.put(DIMENSION_UNIQUE_NAME, record.getDimensionUniqueName());
                    hierProps.put(HIERARCHY_UNIQUE_NAME, record.getHierarchyUniqueName());
                    this.cacheObject(new CacheableNameValueBasedArray(hierKey, hierProps));
                }
            } else if (propNames != null && (properties = this.getPropertiesFromMemberRecord(propNames, record)).size() > 0) {
                this.updateCachedMemberProperties(memberKey, properties);
            }
        }
        catch (CacheException e) {
            this.markAsFlushCandidate();
            throw new XQERuntimeException(e);
        }
        finally {
            this.releaseObjectLock(writeLock);
        }
    }

    protected List<CachedProperty> getPropertiesFromMemberRecord(TreeSet<String> propNames, MemberRecord memberRecord) {
        ArrayList<CachedProperty> memProps = new ArrayList<CachedProperty>();
        for (String propName : propNames) {
            CachedProperty prop = new CachedProperty();
            if (propName.equals(MEMBER_NAME)) {
                prop.setPropertyName(propName);
                prop.setPropertyValue(memberRecord.getName());
                prop.setDynamic(false);
            } else if (DESCRIPTION.equals(propName) || "memberDescription".equals(propName)) {
                prop.setPropertyName(DESCRIPTION);
                prop.setPropertyValue(memberRecord.getDescription());
                prop.setDynamic(false);
            } else if (propName.equals(CAPTION) || propName.equals(MEMBER_CAPTION)) {
                prop.setPropertyName(CAPTION);
                prop.setPropertyValue(memberRecord.getCaption());
                prop.setDynamic(false);
            } else if (propName.equals(MEMBER_TYPE)) {
                prop.setPropertyName(propName);
                prop.setPropertyValue((Object)memberRecord.getType());
                prop.setDynamic(false);
            } else {
                Object propValue = memberRecord.getDynamicField(propName);
                String dun = memberRecord.getDimensionUniqueName();
                String temp = propName;
                if (!propName.startsWith(LEFT_BRACE) && !propName.contains("].[")) {
                    temp = dun + ".[" + propName + RIGHT_BRACE;
                }
                if (propValue == null) {
                    propValue = memberRecord.getDynamicField(temp);
                }
                if (propValue != null || propValue == null && (memberRecord.isDynamicFieldNull(propName) || memberRecord.isDynamicFieldNull(temp))) {
                    prop.setPropertyName(temp);
                    prop.setPropertyValue(propValue);
                    prop.setDynamic(true);
                }
            }
            if (prop.getPropertyName() == null) continue;
            memProps.add(prop);
        }
        return memProps;
    }

    private void cacheObject(ICacheableObject objArray) {
        try {
            this.cache.cacheObject(objArray);
        }
        catch (CacheException e) {
            this.markAsFlushCandidate();
            throw new XQERuntimeException(e);
        }
    }

    private MemberRecord getMember(MemberStorageKey memCachekey, ICacheKey hierKey, boolean includeDynamicFields) {
        Lock readLock = null;
        try {
            SALDynamicFieldsList salDynFields;
            String tmpStr;
            readLock = this.acquireObjectLock(hierKey, CacheLockType.READ_LOCK);
            CacheableNameValueBasedArray memberData = (CacheableNameValueBasedArray)this.cache.get(memCachekey);
            ICacheKey hierarchyKey = (ICacheKey)memberData.get(HIERARCHY_CACHE_KEY);
            CacheableNameValueBasedArray hierData = (CacheableNameValueBasedArray)this.cache.get(hierarchyKey);
            MemberRecord record = new MemberRecord();
            record.setCubeName(this.memberStorageIdentifier.getCubeName());
            record.setUniqueName(((MemberStorageMemberKey)memCachekey).getMUN());
            if (!this.getDataSourceType().equals(DMR_DATASOURCE_TYPE)) {
                record.setUniqueId((String)memberData.get(MEMBER_UNIQUE_ID));
            }
            if ((tmpStr = (String)memberData.get(MEMBER_NAME)) != null) {
                record.setName(tmpStr);
            }
            if ((tmpStr = (String)memberData.get(DESCRIPTION)) != null && tmpStr.equals(MISSING_VALUE)) {
                tmpStr = null;
            }
            record.setDescription(tmpStr);
            LocalizedString caption = (LocalizedString)memberData.get(CAPTION);
            if (caption != null) {
                record.setCaption(caption);
            }
            record.setCatalogName(this.memberStorageIdentifier.getCatalogName());
            record.setSchemaName((String)hierData.get(SCHEMA_NAME));
            record.setDimensionUniqueName((String)hierData.get(DIMENSION_UNIQUE_NAME));
            record.setHierarchyUniqueName((String)hierData.get(HIERARCHY_UNIQUE_NAME));
            MemberTypeEnum memberType = (MemberTypeEnum)((Object)memberData.get(MEMBER_TYPE));
            if (memberType != null) {
                record.setType(memberType);
            }
            RollupTypeEnum rollupType = (RollupTypeEnum)((Object)memberData.get(ROLLUP_TYPE));
            record.setRollupType(rollupType);
            if (includeDynamicFields && (salDynFields = (SALDynamicFieldsList)memberData.get(DYNAMIC_FIELDS)) != null) {
                salDynFields.setDynamicFieldsInMemberRecord(record);
            }
            MemberRecord memberRecord = record;
            return memberRecord;
        }
        catch (CacheException e) {
            this.markAsFlushCandidate();
            throw new XQERuntimeException(e);
        }
        finally {
            this.releaseObjectLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheContext(MemberStorageKey contextKey, String contextId) {
        Lock writeLock = null;
        try {
            writeLock = this.acquireObjectLock(contextKey, CacheLockType.WRITE_LOCK);
            if (!this.exists(contextKey)) {
                HashMap<String, Object> props = new HashMap<String, Object>();
                props.put(CONTEXT_ID, contextId);
                props.put(CONTEXT_LEVELS, new ArrayList());
                this.cacheObject(new CacheableNameValueBasedArray(contextKey, props));
            }
        }
        finally {
            this.releaseObjectLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheContextLevel(MemberStorageKey contextLevelKey, MemberStorageKey contextKey, String lun, int levNo) {
        block6: {
            Lock writeLock = null;
            try {
                writeLock = this.acquireObjectLock(contextKey, CacheLockType.WRITE_LOCK);
                if (this.exists(contextLevelKey)) break block6;
                HashMap<String, Object> contextLevelProps = new HashMap<String, Object>();
                contextLevelProps.put(CONTEXT_KEY, contextKey);
                contextLevelProps.put(CONTEXT_LEVEL_MEMBER_REFS, new ArrayList());
                contextLevelProps.put(CONTEXT_LEVEL_MEMBER_REFS_NO_QRY_CTX, new ArrayList());
                contextLevelProps.put(QUERY_CTX_LEVEL_COMPLETE_BITMAP, new SALQueryContextBitSet());
                contextLevelProps.put(LEVEL_UNIQUE_NAME, lun);
                contextLevelProps.put(LEVEL_NUMBER, levNo);
                this.cacheObject(new CacheableNameValueBasedArray(contextLevelKey, contextLevelProps));
                try {
                    ICacheableNameValueBasedContent context = (ICacheableNameValueBasedContent)this.cache.get(contextKey);
                    List contextLevels = (List)context.get(CONTEXT_LEVELS);
                    contextLevels.add(contextLevelKey);
                    if (!this.staticCache) {
                        context.put(CONTEXT_LEVELS, (Object)contextLevels);
                        this.cacheObject(context);
                    }
                }
                catch (CacheException e) {
                    this.markAsFlushCandidate();
                    throw new XQERuntimeException(e);
                }
            }
            finally {
                this.releaseObjectLock(writeLock);
            }
        }
    }

    protected void setLevelCompleteStatus(ICacheKey contextLevelKey, ICacheKey contextKey, String queryContext, boolean levelCompleteStatus) {
        Lock updaterLock = null;
        try {
            updaterLock = this.acquireObjectLock(contextKey, CacheLockType.WRITE_LOCK);
            ICacheableNameValueBasedContent contextLevel = (ICacheableNameValueBasedContent)this.cache.get(contextLevelKey);
            SALQueryContextBitSet queryCtxLevelCompleteBitmap = (SALQueryContextBitSet)contextLevel.get(QUERY_CTX_LEVEL_COMPLETE_BITMAP);
            queryCtxLevelCompleteBitmap.set(this.getQueryContextIndex(queryContext), levelCompleteStatus);
            if (!this.staticCache) {
                contextLevel.put(QUERY_CTX_LEVEL_COMPLETE_BITMAP, (Object)queryCtxLevelCompleteBitmap);
                this.cacheObject(contextLevel);
            }
        }
        catch (CacheException e) {
            this.markAsFlushCandidate();
            throw new XQERuntimeException(e);
        }
        finally {
            this.releaseObjectLock(updaterLock);
        }
    }

    protected void updateDimensionInfo(String dimUName, ICacheKey levelCacheKey) {
        try {
            this.dimensionLock.lockInterruptibly();
            if (!this.partiallyOrFullycachedDimensions.containsKey(dimUName)) {
                this.partiallyOrFullycachedDimensions.put(dimUName, new ArrayList());
            }
            if (levelCacheKey != null) {
                List<ICacheKey> levelList = this.partiallyOrFullycachedDimensions.get(dimUName);
                levelList.add(levelCacheKey);
            }
        }
        catch (InterruptedException ie) {
            throw new XQERuntimeException(ie);
        }
        finally {
            this.dimensionLock.unlock();
        }
    }

    protected boolean isLevelMarkedComplete(ICacheKey levCacheKey, String queryContext) {
        return this.memRefsListIsCompleteForQueryCtx(levCacheKey, QUERY_CTX_LEVEL_COMPLETE_BITMAP, queryContext);
    }

    protected List<ICacheKey> getLevelMemberRefs(MemberStorageKey levCacheKey, MemberStorageKey contextKey, String queryContext) {
        return this.getMemberRefsForQueryContext(levCacheKey, contextKey, queryContext, CONTEXT_LEVEL_MEMBER_REFS, CONTEXT_LEVEL_MEMBER_REFS_NO_QRY_CTX, QUERY_CTX_LEVEL_COMPLETE_BITMAP, QUERY_CTX_ORDINAL_LIST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheMemberReference(MemberStorageKey memberRefKey, MemberStorageKey memberKey, MemberStorageKey parentMemberRefKey, MemberStorageKey contextLevelKey, MemberStorageKey contextKey, MemberRecord memberRecord) {
        Lock writeLock = null;
        try {
            writeLock = this.acquireObjectLock(contextKey, CacheLockType.WRITE_LOCK);
            if (!this.exists(memberRefKey)) {
                HashMap<String, Object> memberRefProps = new HashMap<String, Object>();
                this.initMemberRefProperties(memberRefProps, memberRefKey, memberKey, parentMemberRefKey, contextLevelKey, memberRecord);
                memberRefProps.put(CHILDREN_MEMBER_REFS, new ArrayList());
                this.cacheObject(new CacheableNameValueBasedArray(memberRefKey, memberRefProps));
                if (this.queryContextTestsRunning) {
                    this.incrementMemberRefCount();
                }
            }
        }
        finally {
            this.releaseObjectLock(writeLock);
        }
    }

    private void incrementMemberRefCount() {
        try {
            this.memRefCountAccessLock.lockInterruptibly();
            ++this.memRefCount;
        }
        catch (InterruptedException e) {
            throw new XQERuntimeException(e);
        }
        finally {
            this.memRefCountAccessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateIncompleteMemberRef(MemberStorageKey memberRefKey, MemberStorageKey memberKey, MemberStorageKey parentMemberRefKey, MemberStorageKey contextLevelKey, MemberStorageKey contextKey, MemberRecord memberRecord) {
        block5: {
            Lock updaterLock = null;
            try {
                updaterLock = this.acquireObjectLock(contextKey, CacheLockType.WRITE_LOCK);
                if (this.isMemberRefComplete(memberRefKey)) break block5;
                try {
                    ICacheableNameValueBasedContent memberRefProps = (ICacheableNameValueBasedContent)this.cache.get(memberRefKey);
                    this.initMemberRefProperties(memberRefProps, memberRefKey, memberKey, parentMemberRefKey, contextLevelKey, memberRecord);
                    this.cacheObject(memberRefProps);
                }
                catch (CacheException e) {
                    this.markAsFlushCandidate();
                    throw new XQERuntimeException(e);
                }
            }
            finally {
                this.releaseObjectLock(updaterLock);
            }
        }
    }

    protected void setTreeOpCompleteForMemberRef(MemberStorageKey memberRefKey, TreeOperatorEnum treeOp, String queryContext) {
        this.setTreeOpCompleteForMemberRef(memberRefKey, treeOp, 1, queryContext);
    }

    protected void setTreeOpCompleteForMemberRef(MemberStorageKey memberRefKey, TreeOperatorEnum treeOp, int complitionFlag, String queryContext) {
        Lock updaterLock = null;
        try {
            updaterLock = this.acquireObjectLock(memberRefKey, CacheLockType.WRITE_LOCK);
            ICacheableNameValueBasedContent memberRef = (ICacheableNameValueBasedContent)this.cache.get(memberRefKey);
            int[] treeOpCompletionFlags = (int[])memberRef.get(TREEOP_COMPLETION_FLAGS);
            treeOpCompletionFlags[treeOp.ordinal()] = complitionFlag;
            SALQueryContextBitSet treeOpCompleteBitmap = (SALQueryContextBitSet)memberRef.get(TREEOPSET_COMPLETE_IN_QUERY_CTX_BITMAP);
            int index = this.getQueryContextIndex(queryContext);
            if (treeOpCompleteBitmap == null) {
                treeOpCompleteBitmap = new SALQueryContextBitSet();
            }
            if (!treeOpCompleteBitmap.isSet(index)) {
                treeOpCompleteBitmap.set(index, true);
            }
            this.cacheObject(memberRef);
        }
        catch (CacheException e) {
            this.markAsFlushCandidate();
            throw new XQERuntimeException(e);
        }
        finally {
            this.releaseObjectLock(updaterLock);
        }
    }

    protected boolean isTreeOpSetCompleteForMemberRef(MemberStorageKey memberRefKey, EnumSet<TreeOperatorEnum> treeOpSet, int levelDistance, String queryContext) {
        try {
            ICacheableNameValueBasedContent memberRef = (ICacheableNameValueBasedContent)this.cache.get(memberRefKey);
            int[] treeOpCompletionFlags = (int[])memberRef.get(TREEOP_COMPLETION_FLAGS);
            boolean isComplete = true;
            for (TreeOperatorEnum treeOp : treeOpSet) {
                if (treeOp == TreeOperatorEnum.SELF) continue;
                if (treeOp == TreeOperatorEnum.DESCENDANTS) {
                    isComplete = levelDistance <= treeOpCompletionFlags[treeOp.ordinal()];
                } else {
                    boolean bl = isComplete = treeOpCompletionFlags[treeOp.ordinal()] == 1;
                }
                if (isComplete) continue;
                return false;
            }
            return this.memRefsListIsCompleteForQueryCtx(memberRefKey, TREEOPSET_COMPLETE_IN_QUERY_CTX_BITMAP, queryContext);
        }
        catch (CacheException e) {
            this.markAsFlushCandidate();
            throw new XQERuntimeException(e);
        }
    }

    private void initMemberTreeOpCompletionFlags(Map<String, Object> memberRefProps) {
        int[] treeOpCompletionFlags = new int[NUMBER_OF_TREEOPENUM_TYPES];
        for (int i = 0; i < NUMBER_OF_TREEOPENUM_TYPES; ++i) {
            treeOpCompletionFlags[i] = i == TreeOperatorEnum.SELF.ordinal() ? 1 : -1000000;
        }
        memberRefProps.put(TREEOP_COMPLETION_FLAGS, treeOpCompletionFlags);
    }

    private void initMemberRefProperties(Map<String, Object> memberRefProps, MemberStorageKey memberRefKey, MemberStorageKey memberKey, MemberStorageKey parentMemberRefKey, MemberStorageKey contextLevelKey, MemberRecord memberRecord) {
        this.initMemberTreeOpCompletionFlags(memberRefProps);
        memberRefProps.put(TREEOPSET_COMPLETE_IN_QUERY_CTX_BITMAP, new SALQueryContextBitSet());
        memberRefProps.put(PARENT_MEMBER_REF_KEY, parentMemberRefKey);
        if (parentMemberRefKey != null) {
            this.updateChildMemberRefsInParent(parentMemberRefKey, memberRefKey);
        }
        memberRefProps.put(PARENT_LEVEL_NUMBER, memberRecord.getParentLevelNumber());
        memberRefProps.put(PARENT_UNIQUE_NAME, memberRecord.getParentUniqueName());
        memberRefProps.put(PARENT_COUNT, memberRecord.getParentCount());
        memberRefProps.put(QUERY_CTX_CHILDREN_COMPLETE_BITMAP, new SALQueryContextBitSet());
        memberRefProps.put(CHILD_CARDINALITY, memberRecord.getChildCardinality());
        memberRefProps.put(CHILDREN_MEMBER_REFS_NO_QRY_CTX, new ArrayList());
        memberRefProps.put(EXISTS_IN_QUERY_CTX_BITMAP, new SALQueryContextBitSet());
        memberRefProps.put(QUERY_CTX_ORDINAL_LIST, new SALQueryContextOrdinalList());
        memberRefProps.put(QUERY_CTX_PC_ORDINAL_LIST, new SALQueryContextOrdinalList());
        memberRefProps.put(CONTEXT_LEVEL_KEY, contextLevelKey);
        this.updateContextLevelMemberRefs(contextLevelKey, memberRefKey);
        memberRefProps.put(MEMBER_KEY, memberKey);
    }

    protected boolean isMemberRefComplete(ICacheKey memberRefCacheKey) {
        Lock readLock = null;
        ICacheKey contextKey = this.getLockCacheKey(memberRefCacheKey);
        try {
            readLock = this.acquireObjectLock(contextKey, CacheLockType.READ_LOCK);
            ICacheableNameValueBasedContent memberRef = (ICacheableNameValueBasedContent)this.cache.get(memberRefCacheKey);
            int[] treeOpCompletionFlags = (int[])memberRef.get(TREEOP_COMPLETION_FLAGS);
            boolean bl = treeOpCompletionFlags[TreeOperatorEnum.SELF.ordinal()] == 1;
            return bl;
        }
        catch (CacheException e) {
            this.markAsFlushCandidate();
            throw new XQERuntimeException(e);
        }
        finally {
            this.releaseObjectLock(readLock);
        }
    }

    private void updateChildMemberRefsInParent(MemberStorageKey parentMemberRefKey, MemberStorageKey childMemberRefKey) {
        try {
            if (parentMemberRefKey != null) {
                List<MemberStorageKey> childMemberRefsList;
                ICacheableNameValueBasedContent parentMemberRef = null;
                boolean incompleteParentMemberRefCreated = false;
                if (this.exists(parentMemberRefKey)) {
                    parentMemberRef = (ICacheableNameValueBasedContent)this.cache.get(parentMemberRefKey);
                    childMemberRefsList = (List)parentMemberRef.get(CHILDREN_MEMBER_REFS);
                } else {
                    childMemberRefsList = new ArrayList();
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    this.initIncompleteParentMemberRef(props);
                    parentMemberRef = new CacheableNameValueBasedArray(parentMemberRefKey, props);
                    incompleteParentMemberRefCreated = true;
                }
                childMemberRefsList.add(childMemberRefKey);
                if (incompleteParentMemberRefCreated || !this.staticCache) {
                    parentMemberRef.put(CHILDREN_MEMBER_REFS, (Object)childMemberRefsList);
                    this.cacheObject(parentMemberRef);
                }
            }
        }
        catch (CacheException e) {
            this.markAsFlushCandidate();
            throw new XQERuntimeException(e);
        }
    }

    private void initIncompleteParentMemberRef(Map<String, Object> props) {
        Object treeOpCompletionFlagsObj = props.get(TREEOP_COMPLETION_FLAGS);
        if (treeOpCompletionFlagsObj == null) {
            this.initMemberTreeOpCompletionFlags(props);
            treeOpCompletionFlagsObj = props.get(TREEOP_COMPLETION_FLAGS);
        }
        ((int[])treeOpCompletionFlagsObj)[TreeOperatorEnum.SELF.ordinal()] = -1000000;
        props.put(PARENT_MEMBER_REF_KEY, null);
        props.put(PARENT_LEVEL_NUMBER, null);
        props.put(PARENT_UNIQUE_NAME, null);
        props.put(PARENT_COUNT, null);
        props.put(QUERY_CTX_CHILDREN_COMPLETE_BITMAP, null);
        props.put(TREEOPSET_COMPLETE_IN_QUERY_CTX_BITMAP, null);
        props.put(CHILD_CARDINALITY, null);
        props.put(CHILDREN_MEMBER_REFS_NO_QRY_CTX, null);
        props.put(EXISTS_IN_QUERY_CTX_BITMAP, null);
        props.put(QUERY_CTX_ORDINAL_LIST, null);
        props.put(QUERY_CTX_PC_ORDINAL_LIST, null);
        props.put(CONTEXT_LEVEL_KEY, null);
        props.put(MEMBER_KEY, null);
    }

    private void updateContextLevelMemberRefs(MemberStorageKey contextLevelKey, MemberStorageKey memberRefKey) {
        try {
            ICacheableNameValueBasedContent contextLevel = (ICacheableNameValueBasedContent)this.cache.get(contextLevelKey);
            ArrayList levelMemberRefsList = (ArrayList)contextLevel.get(CONTEXT_LEVEL_MEMBER_REFS);
            levelMemberRefsList.add(memberRefKey);
            if (!this.staticCache) {
                contextLevel.put(CONTEXT_LEVEL_MEMBER_REFS, (Object)levelMemberRefsList);
                this.cacheObject(contextLevel);
            }
        }
        catch (CacheException e) {
            this.markAsFlushCandidate();
            throw new XQERuntimeException(e);
        }
    }

    protected boolean memberRefChildrenComplete(MemberStorageKey memRefKey, String queryContext) {
        boolean childrenComplete = false;
        if (this.exists(memRefKey) && this.isMemberRefComplete(memRefKey)) {
            childrenComplete = this.memRefChildrenCompleteForQueryCtx(memRefKey, queryContext);
        }
        return childrenComplete;
    }

    private boolean memRefChildrenCompleteForQueryCtx(ICacheKey memRefKey, String queryContext) {
        return this.memRefsListIsCompleteForQueryCtx(memRefKey, QUERY_CTX_CHILDREN_COMPLETE_BITMAP, queryContext);
    }

    private boolean memRefsListIsCompleteForQueryCtx(ICacheKey cacheKey, String memberRefsCompleteInQryCtxPropName, String queryContext) {
        boolean listIsComplete = false;
        int index = this.getQueryContextIndex(queryContext);
        Lock readLock = null;
        ICacheKey contextKey = this.getLockCacheKey(cacheKey);
        try {
            readLock = this.acquireObjectLock(contextKey, CacheLockType.READ_LOCK);
            ICacheableNameValueBasedContent cacheableObject = (ICacheableNameValueBasedContent)this.cache.get(cacheKey);
            SALQueryContextBitSet queryCtxListCompleteBitmap = (SALQueryContextBitSet)cacheableObject.get(memberRefsCompleteInQryCtxPropName);
            if (queryCtxListCompleteBitmap != null) {
                listIsComplete = queryCtxListCompleteBitmap.isSet(index);
            }
        }
        catch (CacheException e) {
            this.markAsFlushCandidate();
            throw new XQERuntimeException(e);
        }
        finally {
            this.releaseObjectLock(readLock);
        }
        return listIsComplete;
    }

    protected void setChildrenCompleteStatus(ICacheKey parentMemRefKey, ICacheKey contextKey, String queryContext, boolean childrenCompleteStatus) {
        Lock updaterLock = null;
        try {
            updaterLock = this.acquireObjectLock(contextKey, CacheLockType.WRITE_LOCK);
            ICacheableNameValueBasedContent parentMemberRef = (ICacheableNameValueBasedContent)this.cache.get(parentMemRefKey);
            SALQueryContextBitSet queryCtxChildrenCompleteBitmap = (SALQueryContextBitSet)parentMemberRef.get(QUERY_CTX_CHILDREN_COMPLETE_BITMAP);
            queryCtxChildrenCompleteBitmap.set(this.getQueryContextIndex(queryContext), childrenCompleteStatus);
            if (!this.staticCache) {
                parentMemberRef.put(QUERY_CTX_CHILDREN_COMPLETE_BITMAP, (Object)queryCtxChildrenCompleteBitmap);
                this.cacheObject(parentMemberRef);
            }
        }
        catch (CacheException e) {
            this.markAsFlushCandidate();
            throw new XQERuntimeException(e);
        }
        finally {
            this.releaseObjectLock(updaterLock);
        }
    }

    protected List<ICacheKey> getChildMemberRefs(ICacheKey parentMemRefKey, ICacheKey contextKey, String queryContext) {
        return this.getMemberRefsForQueryContext(parentMemRefKey, contextKey, queryContext, CHILDREN_MEMBER_REFS, CHILDREN_MEMBER_REFS_NO_QRY_CTX, QUERY_CTX_CHILDREN_COMPLETE_BITMAP, QUERY_CTX_PC_ORDINAL_LIST);
    }

    protected void getDescendantMemberRefs(ICacheKey memRefKey, ICacheKey contextKey, String queryContext, List<ICacheKey> descendantMemberRefs, boolean incluideself) {
        if (incluideself) {
            descendantMemberRefs.add(memRefKey);
        }
        List<ICacheKey> childreRefs = this.getChildMemberRefs(memRefKey, contextKey, queryContext);
        for (ICacheKey childRefkey : childreRefs) {
            this.getDescendantMemberRefs(childRefkey, contextKey, queryContext, descendantMemberRefs, true);
        }
    }

    protected MemberStorageKey getParentMemberReference(MemberStorageKey memberRefKey) {
        Lock readLock = null;
        ICacheKey contextKey = this.getLockCacheKey(memberRefKey);
        try {
            readLock = this.acquireObjectLock(contextKey, CacheLockType.READ_LOCK);
            ICacheableNameValueBasedContent memberRef = (ICacheableNameValueBasedContent)this.cache.get(memberRefKey);
            MemberStorageKey memberStorageKey = (MemberStorageKey)memberRef.get(PARENT_MEMBER_REF_KEY);
            return memberStorageKey;
        }
        catch (CacheException e) {
            this.markAsFlushCandidate();
            throw new XQERuntimeException(e);
        }
        finally {
            this.releaseObjectLock(readLock);
        }
    }

    protected MemberRecord getMemberFromReference(ICacheKey memRefCacheKey, ICacheKey hierKey, boolean includeDynamicFields) {
        MemberStorageKey memKey = (MemberStorageKey)this.getPropValueFromCache(memRefCacheKey, MEMBER_KEY);
        ICacheKey hierCacheKey = hierKey == null ? this.getLockCacheKey(memKey) : hierKey;
        MemberRecord record = this.getMember(memKey, hierCacheKey, includeDynamicFields);
        Lock readLock = null;
        ICacheKey contextKey = this.getLockCacheKey(memRefCacheKey);
        try {
            readLock = this.acquireObjectLock(contextKey, CacheLockType.READ_LOCK);
            ICacheableNameValueBasedContent memberRef = (ICacheableNameValueBasedContent)this.cache.get(memRefCacheKey);
            ICacheKey ctxLevelKey = (ICacheKey)memberRef.get(CONTEXT_LEVEL_KEY);
            ICacheableNameValueBasedContent levelRef = (ICacheableNameValueBasedContent)this.cache.get(ctxLevelKey);
            record.setLevelUniqueName((String)levelRef.get(LEVEL_UNIQUE_NAME));
            record.setLevelNumber((Integer)levelRef.get(LEVEL_NUMBER));
            record.setParentCount((Integer)memberRef.get(PARENT_COUNT));
            record.setParentLevelNumber((Integer)memberRef.get(PARENT_LEVEL_NUMBER));
            record.setParentUniqueName((String)memberRef.get(PARENT_UNIQUE_NAME));
            record.setChildCardinality((Integer)memberRef.get(CHILD_CARDINALITY));
            MemberRecord memberRecord = record;
            return memberRecord;
        }
        catch (CacheException e) {
            this.markAsFlushCandidate();
            throw new XQERuntimeException(e);
        }
        finally {
            this.releaseObjectLock(readLock);
        }
    }

    private ArrayList<ICacheKey> filterMemberRefsForQueryContext(String queryContext, ICacheKey contextKey, List<ICacheKey> memberRefKeys) {
        ArrayList<ICacheKey> memRefKeysForQueryCtx = new ArrayList<ICacheKey>();
        int queryContextIndex = this.getQueryContextIndex(queryContext);
        for (ICacheKey memRef : memberRefKeys) {
            if (!this.memberRefExistsInQueryContext(queryContextIndex, memRef, contextKey)) continue;
            memRefKeysForQueryCtx.add(memRef);
        }
        return memRefKeysForQueryCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ICacheKey> getMemberRefsForQueryContext(ICacheKey cacheKey, ICacheKey contextKey, String queryContext, String memberRefsSetPropName, String memberRefsNoQueryCtxPropName, String memberRefsCompleteInQryCtxPropName, String qryCtxOrdListPropName) {
        List<ICacheKey> memberRefsResultList;
        block13: {
            memberRefsResultList = new ArrayList<ICacheKey>();
            Lock readLock = null;
            try {
                readLock = this.acquireObjectLock(contextKey, CacheLockType.READ_LOCK);
                ICacheableNameValueBasedContent cacheableObject = (ICacheableNameValueBasedContent)this.cache.get(cacheKey);
                ArrayList memberRefsList = (ArrayList)cacheableObject.get(memberRefsSetPropName);
                List<ICacheKey> memberRefsNoQueryCtxList = (List<ICacheKey>)cacheableObject.get(memberRefsNoQueryCtxPropName);
                if (memberRefsNoQueryCtxList.isEmpty() && memberRefsList.isEmpty()) {
                    ArrayList<ICacheKey> arrayList = memberRefsResultList;
                    return arrayList;
                }
                String qryCtxOrdListPropUsedForSorting = qryCtxOrdListPropName;
                if (qryCtxOrdListPropUsedForSorting.equals(QUERY_CTX_PC_ORDINAL_LIST) && !this.memRefChildrenCompleteForQueryCtx(cacheKey, queryContext)) {
                    qryCtxOrdListPropUsedForSorting = QUERY_CTX_ORDINAL_LIST;
                }
                if (!memberRefsNoQueryCtxList.isEmpty() || this.containedInQueryCtxIdList(this.getId("queryCtx=NO_QUERY_CTX")) && this.memRefsListIsCompleteForQueryCtx(cacheKey, memberRefsCompleteInQryCtxPropName, "queryCtx=NO_QUERY_CTX")) {
                    if (memberRefsNoQueryCtxList.isEmpty()) {
                        Lock updaterLock = null;
                        try {
                            this.releaseObjectLock(readLock);
                            readLock = null;
                            updaterLock = this.acquireObjectLock(contextKey, CacheLockType.WRITE_LOCK);
                            memberRefsNoQueryCtxList = this.getSortedMemberRefsListForQueryContext("queryCtx=NO_QUERY_CTX", contextKey, memberRefsList, qryCtxOrdListPropUsedForSorting);
                            memberRefsList.clear();
                            if (!this.staticCache) {
                                cacheableObject.put(memberRefsSetPropName, (Object)memberRefsList);
                            }
                            cacheableObject.put(memberRefsNoQueryCtxPropName, (Object)memberRefsNoQueryCtxList);
                            this.cacheObject(cacheableObject);
                            this.releaseObjectLock(updaterLock);
                        }
                        catch (Throwable throwable) {
                            this.releaseObjectLock(updaterLock);
                            throw throwable;
                        }
                    }
                    memberRefsResultList = queryContext.equals("queryCtx=NO_QUERY_CTX") ? memberRefsNoQueryCtxList : this.filterMemberRefsForQueryContext(queryContext, contextKey, memberRefsNoQueryCtxList);
                    break block13;
                }
                memberRefsResultList = this.getSortedMemberRefsListForQueryContext(queryContext, contextKey, memberRefsList, qryCtxOrdListPropUsedForSorting);
            }
            catch (CacheException e) {
                this.markAsFlushCandidate();
                throw new XQERuntimeException(e);
            }
            finally {
                this.releaseObjectLock(readLock);
            }
        }
        return memberRefsResultList;
    }

    private List<ICacheKey> getSortedMemberRefsListForQueryContext(String queryContext, ICacheKey contextKey, ArrayList<ICacheKey> memberRefsList, String qryCtxOrdListPropName) {
        if (!queryContext.equals("queryCtx=NO_QUERY_CTX")) {
            memberRefsList = this.filterMemberRefsForQueryContext(queryContext, contextKey, memberRefsList);
        }
        ICacheKey[] memberRefs = memberRefsList.toArray(new ICacheKey[0]);
        Arrays.sort(memberRefs, new MemberRefOrdinalComparator(this, queryContext, qryCtxOrdListPropName));
        return Arrays.asList(memberRefs);
    }

    protected List<MemberRecord> getMemberRecords(List<ICacheKey> memRefCacheKeys, ICacheKey hierKey, boolean includeDynamicFields) {
        ArrayList<MemberRecord> memberRecords = new ArrayList<MemberRecord>();
        for (ICacheKey cacheKey : memRefCacheKeys) {
            memberRecords.add(this.getMemberFromReference(cacheKey, hierKey, includeDynamicFields));
        }
        return memberRecords;
    }

    private static void initializeSimpleProperties() {
        Arrays.sort(simpleStoragePropertyNames);
    }

    private static boolean isSimpleStorageProperty(String propertyName) {
        return Arrays.binarySearch(simpleStoragePropertyNames, propertyName) > -1;
    }

    protected Object getPropValueFromCache(ICacheKey cacheKey, String propName) {
        Object cachedPropertyValue = null;
        CachedProperty cachedProperty = this.getCachedProperty(cacheKey, propName);
        if (cachedProperty != null) {
            cachedPropertyValue = cachedProperty.getPropertyValue();
        }
        return cachedPropertyValue;
    }

    protected CachedProperty getCachedProperty(ICacheKey cacheKey, String propName) {
        CachedProperty cachedProp;
        String internalPropName = propName;
        if (propName.equals(MEMBER_CAPTION)) {
            internalPropName = CAPTION;
        }
        if (cacheKey == null) {
            StringBuilder strBldr = new StringBuilder("Null cache key encountered for ");
            strBldr.append(this.toString());
            strBldr.append(" that is ");
            if (!this.isStale()) {
                strBldr.append("not");
            }
            strBldr.append(" stale");
            if (this.cacheClosed.get()) {
                strBldr.append(" and flushed (closed)");
            }
            errorLogger.log(strBldr.toString());
        }
        if (cacheKey != null && ((MemberStorageKey)cacheKey).isMemberKey() && internalPropName.equals(MEMBER_KEY)) {
            cachedProp = new CachedProperty();
            cachedProp.setPropertyValue(cacheKey);
            return cachedProp;
        }
        if (cacheKey != null && ((MemberStorageKey)cacheKey).isMemberKey() && internalPropName.equals(MEMBER_UNIQUE_NAME)) {
            cachedProp = new CachedProperty();
            cachedProp.setPropertyValue(((MemberStorageMemberKey)cacheKey).getMUN());
            return cachedProp;
        }
        Lock readLock = null;
        ICacheKey lockCacheKey = null;
        if (!MemberStorage.isSimpleStorageProperty(internalPropName)) {
            lockCacheKey = this.getLockCacheKey(cacheKey);
        }
        ICacheableNameValueBasedContent propertyData = null;
        CachedProperty cachedProperty = null;
        Map<String, Object> propertyValues = null;
        try {
            if (lockCacheKey != null) {
                readLock = this.acquireObjectLock(lockCacheKey, CacheLockType.READ_LOCK);
            }
            if ((propertyData = (ICacheableNameValueBasedContent)this.cache.get(cacheKey)) != null) {
                propertyValues = propertyData.getContent();
            }
            if (propertyValues != null) {
                SALDynamicFieldsList salDynamicFields;
                if (propertyValues.containsKey(internalPropName)) {
                    boolean propIsMissing = false;
                    Object propValue = propertyValues.get(internalPropName);
                    if (propValue == null) {
                        if (internalPropName.equals(MEMBER_NAME) || internalPropName.equals(CAPTION)) {
                            propIsMissing = true;
                        }
                    } else if (internalPropName.equals(DESCRIPTION) && propValue.equals(MISSING_VALUE)) {
                        propIsMissing = true;
                    } else if (internalPropName.equals(MEMBER_TYPE) && propValue.equals((Object)MemberTypeEnum.UNKNOWN)) {
                        propIsMissing = true;
                    }
                    if (!propIsMissing) {
                        cachedProperty = new CachedProperty();
                        cachedProperty.setPropertyValue(propValue);
                    }
                } else if (!internalPropName.equals(MEMBER_TYPE) && !internalPropName.equals(CAPTION) && !internalPropName.equals(DESCRIPTION) && ((MemberStorageKey)cacheKey).isMemberKey() && (salDynamicFields = (SALDynamicFieldsList)propertyValues.get(DYNAMIC_FIELDS)) != null && (cachedProperty = salDynamicFields.checkForDynamicField(internalPropName, false)) == null) {
                    cachedProperty = salDynamicFields.checkForDynamicField(internalPropName, true);
                }
            }
            this.releaseObjectLock(readLock);
        }
        catch (CacheException e) {
            try {
                this.markAsFlushCandidate();
                throw new XQERuntimeException(e);
            }
            catch (Throwable throwable) {
                this.releaseObjectLock(readLock);
                throw throwable;
            }
        }
        return cachedProperty;
    }

    int getQueryContextIndex(String queryContext) {
        int queryCtxIndex = -1;
        int id = this.getId(queryContext);
        try {
            this.queryCtxIdsLock.lockInterruptibly();
            queryCtxIndex = this.queryCtxIds.indexOf(id);
            if (queryCtxIndex == -1) {
                this.queryCtxIds.add(id);
                queryCtxIndex = this.queryCtxIds.size() - 1;
            }
        }
        catch (InterruptedException e) {
            throw new RequestCanceledException();
        }
        finally {
            this.queryCtxIdsLock.unlock();
        }
        return queryCtxIndex;
    }

    private boolean containedInQueryCtxIdList(int id) {
        try {
            this.queryCtxIdsLock.lockInterruptibly();
            boolean bl = this.queryCtxIds.contains(id);
            return bl;
        }
        catch (InterruptedException e) {
            throw new RequestCanceledException();
        }
        finally {
            this.queryCtxIdsLock.unlock();
        }
    }

    protected boolean memberRefIsFullyCachedInContext(String queryContext, ICacheKey memRefKey, ICacheKey contextKey) {
        boolean fullyCachedInContext = false;
        if (this.exists(memRefKey) && this.isMemberRefComplete(memRefKey) && (queryContext.equals("queryCtx=NO_QUERY_CTX") || this.memberRefExistsInQueryContext(this.getQueryContextIndex(queryContext), memRefKey, contextKey))) {
            fullyCachedInContext = true;
        }
        return fullyCachedInContext;
    }

    private boolean memberRefExistsInQueryContext(int queryContextIndex, ICacheKey memRefKey, ICacheKey contextKey) {
        boolean memRefExistsInQueryCtx = false;
        Lock readLock = null;
        try {
            SALQueryContextBitSet existsInQueryCtxBitmap;
            readLock = this.acquireObjectLock(contextKey, CacheLockType.READ_LOCK);
            ICacheableNameValueBasedContent memberRef = (ICacheableNameValueBasedContent)this.cache.get(memRefKey);
            if (memberRef != null && (existsInQueryCtxBitmap = (SALQueryContextBitSet)memberRef.get(EXISTS_IN_QUERY_CTX_BITMAP)) != null) {
                memRefExistsInQueryCtx = existsInQueryCtxBitmap.isSet(queryContextIndex);
            }
        }
        catch (CacheException e) {
            this.markAsFlushCandidate();
            throw new XQERuntimeException(e);
        }
        finally {
            this.releaseObjectLock(readLock);
        }
        return memRefExistsInQueryCtx;
    }

    private int getOrdinalInQueryContext(int queryContextIndex, ICacheKey memRefKey, String qryCtxOrdListPropName) {
        int ordinal = -1;
        try {
            SALQueryContextOrdinalList queryCtxOrdinalList;
            ICacheableNameValueBasedContent memberRef = (ICacheableNameValueBasedContent)this.cache.get(memRefKey);
            if (memberRef != null && (queryCtxOrdinalList = (SALQueryContextOrdinalList)memberRef.get(qryCtxOrdListPropName)) != null) {
                ordinal = queryCtxOrdinalList.get(queryContextIndex);
            }
        }
        catch (CacheException e) {
            this.markAsFlushCandidate();
            throw new XQERuntimeException(e);
        }
        return ordinal;
    }

    protected void updateMemberRefExistenceInQueryContext(int queryContextIndex, ICacheKey memberRefKey, ICacheKey contextKey, int ordinal, String qryCtxOrdListPropName) {
        Lock updaterLock = null;
        try {
            updaterLock = this.acquireObjectLock(contextKey, CacheLockType.WRITE_LOCK);
            ICacheableNameValueBasedContent memberReference = (ICacheableNameValueBasedContent)this.cache.get(memberRefKey);
            SALQueryContextBitSet existsInQueryCtxBitmap = (SALQueryContextBitSet)memberReference.get(EXISTS_IN_QUERY_CTX_BITMAP);
            existsInQueryCtxBitmap.set(queryContextIndex, true);
            SALQueryContextOrdinalList queryCtxOrdinalList = null;
            if (ordinal != -1 && qryCtxOrdListPropName != null) {
                queryCtxOrdinalList = (SALQueryContextOrdinalList)memberReference.get(qryCtxOrdListPropName);
                queryCtxOrdinalList.set(queryContextIndex, ordinal);
            }
            if (!this.staticCache) {
                memberReference.put(EXISTS_IN_QUERY_CTX_BITMAP, (Object)existsInQueryCtxBitmap);
                if (queryCtxOrdinalList != null) {
                    memberReference.put(qryCtxOrdListPropName, (Object)queryCtxOrdinalList);
                }
                this.cacheObject(memberReference);
            }
        }
        catch (CacheException e) {
            this.markAsFlushCandidate();
            throw new XQERuntimeException(e);
        }
        finally {
            this.releaseObjectLock(updaterLock);
        }
    }

    protected int getMemberRefCount() {
        int count = 0;
        try {
            this.memRefCountAccessLock.lockInterruptibly();
            count = this.memRefCount;
        }
        catch (InterruptedException e) {
            throw new XQERuntimeException(e);
        }
        finally {
            this.memRefCountAccessLock.unlock();
        }
        return count;
    }

    protected boolean isQueryContextTestRunning() {
        return this.queryContextTestsRunning;
    }

    protected void updateCachedMemberProperties(ICacheKey memKey, List<CachedProperty> memberProperties) {
        ICacheKey hierKey = this.getLockCacheKey(memKey);
        Lock updaterLock = null;
        try {
            updaterLock = this.acquireObjectLock(hierKey, CacheLockType.WRITE_LOCK);
            ICacheableNameValueBasedContent propertyData = (ICacheableNameValueBasedContent)this.cache.get(memKey);
            if (propertyData != null) {
                for (CachedProperty memberProperty : memberProperties) {
                    String propertyName = memberProperty.getPropertyName();
                    Object propValue = memberProperty.getPropertyValue();
                    if (memberProperty.isDynamic()) {
                        SALDynamicFieldsList dynamicFields = (SALDynamicFieldsList)propertyData.get(DYNAMIC_FIELDS);
                        if (dynamicFields == null) continue;
                        dynamicFields.updateDynamicField(propertyName, propValue);
                        continue;
                    }
                    if (propertyName.equals(MEMBER_NAME)) {
                        propertyData.put(MEMBER_NAME, propValue);
                        continue;
                    }
                    if (propertyName.equals(DESCRIPTION)) {
                        propertyData.put(DESCRIPTION, propValue);
                        continue;
                    }
                    if (propertyName.equals(CAPTION)) {
                        propertyData.put(CAPTION, propValue);
                        continue;
                    }
                    if (propertyName.equals(MEMBER_TYPE)) {
                        propertyData.put(MEMBER_TYPE, propValue);
                        continue;
                    }
                    throw new XQERuntimeException(XQEMessageKeys.MD_InvalidMemberPropertyName, propValue.toString());
                }
                this.cacheObject(propertyData);
            }
        }
        catch (CacheException e) {
            this.markAsFlushCandidate();
            throw new XQERuntimeException(e);
        }
        finally {
            this.releaseObjectLock(updaterLock);
        }
    }

    public String getCubeName() {
        return this.memberStorageIdentifier.getCubeName();
    }

    public String getCatalogName() {
        return this.memberStorageIdentifier.getCatalogName();
    }

    public String getDataSourceName() {
        return this.memberStorageIdentifier.getDataSourceName();
    }

    public String getDataSourceType() {
        return this.memberStorageIdentifier.getDataSourceType();
    }

    public String getModelName() {
        return this.memberStorageIdentifier.getModelName();
    }

    protected boolean isStale() {
        return this.memberStorageIdentifier.isStale();
    }

    public MemberStorageIdentifier getMemberStorageId() {
        return this.memberStorageIdentifier;
    }

    private String getUniqueCacheName() {
        return this.uniqueCacheName;
    }

    private static List<MemberStorage> getStorages(String dataSourceName, String catalogName, String cubeName) {
        Collection<MemberStorage> storages = null;
        ArrayList<MemberStorage> matchingStorages = new ArrayList<MemberStorage>();
        try {
            storageMapLock.lockInterruptibly();
            storages = memberStorageMap.values();
            for (MemberStorage storage : storages) {
                MemberStorageIdentifier mstid = storage.getMemberStorageId();
                if (!mstid.getDataSourceName().equals(dataSourceName) || !mstid.getCatalogName().equals(catalogName) || !mstid.getCubeName().equals(cubeName)) continue;
                matchingStorages.add(storage);
            }
        }
        catch (InterruptedException e) {
            throw new XQERuntimeException(e);
        }
        finally {
            storageMapLock.unlock();
        }
        return matchingStorages;
    }

    public static Collection<String> getDataSources() {
        Collection<MemberStorage> storageObjects = null;
        TreeSet<String> dataSources = new TreeSet<String>();
        try {
            storageMapLock.lockInterruptibly();
            storageObjects = memberStorageMap.values();
            for (MemberStorage storage : storageObjects) {
                MemberStorageIdentifier mstid = storage.getMemberStorageId();
                dataSources.add(mstid.getDataSourceName());
            }
            TreeSet<String> treeSet = dataSources;
            return treeSet;
        }
        catch (InterruptedException e) {
            throw new XQERuntimeException(e);
        }
        finally {
            storageMapLock.unlock();
        }
    }

    public static Collection<String> getCatalogs(String dataSourceName) {
        Collection<MemberStorage> storageObjects = null;
        TreeSet<String> catalogs = new TreeSet<String>();
        try {
            storageMapLock.lockInterruptibly();
            storageObjects = memberStorageMap.values();
            for (MemberStorage storage : storageObjects) {
                MemberStorageIdentifier mstid = storage.getMemberStorageId();
                if (!mstid.getDataSourceName().equals(dataSourceName)) continue;
                catalogs.add(mstid.getCatalogName());
            }
            TreeSet<String> treeSet = catalogs;
            return treeSet;
        }
        catch (InterruptedException e) {
            throw new XQERuntimeException(e);
        }
        finally {
            storageMapLock.unlock();
        }
    }

    public static Collection<String> getCubes(String dataSourceName, String catalogName) {
        Collection<MemberStorage> storageObjects = null;
        TreeSet<String> cubes = new TreeSet<String>();
        try {
            storageMapLock.lockInterruptibly();
            storageObjects = memberStorageMap.values();
            for (MemberStorage storage : storageObjects) {
                MemberStorageIdentifier mstid = storage.getMemberStorageId();
                if (!mstid.getDataSourceName().equals(dataSourceName) || !mstid.getCatalogName().equals(catalogName)) continue;
                cubes.add(mstid.getCubeName());
            }
            TreeSet<String> treeSet = cubes;
            return treeSet;
        }
        catch (InterruptedException e) {
            throw new XQERuntimeException(e);
        }
        finally {
            storageMapLock.unlock();
        }
    }

    public Collection<String> getDimensions() {
        TreeSet<String> dimensions = new TreeSet<String>();
        try {
            this.dimensionLock.lockInterruptibly();
            dimensions.addAll(this.getCachedDimensions().keySet());
        }
        catch (InterruptedException ie) {
            throw new XQERuntimeException(ie);
        }
        finally {
            this.dimensionLock.unlock();
        }
        return dimensions;
    }

    public Set<String> getContexts(String dimensionUName) {
        TreeSet<String> contextInfo = new TreeSet<String>();
        List<ICacheKey> levelKeyList = null;
        try {
            this.dimensionLock.lockInterruptibly();
            levelKeyList = this.partiallyOrFullycachedDimensions.get(dimensionUName);
            for (ICacheKey levelCacheKey : levelKeyList) {
                ICacheKey contextKey = (ICacheKey)this.getPropValueFromCache(levelCacheKey, CONTEXT_KEY);
                String levelContextID = this.getPropValueFromCache(contextKey, CONTEXT_ID).toString();
                contextInfo.add(levelContextID);
            }
        }
        catch (InterruptedException ie) {
            throw new XQERuntimeException(ie);
        }
        finally {
            this.dimensionLock.unlock();
        }
        return contextInfo;
    }

    public Set<String> getLevels(String dimensionUName, String contextId) {
        TreeSet<String> levelInfo = new TreeSet<String>();
        List<ICacheKey> levelKeyList = null;
        levelKeyList = this.getCachedDimensions().get(dimensionUName);
        if (levelKeyList != null) {
            for (ICacheKey levelCacheKey : levelKeyList) {
                ICacheKey contextKey = (ICacheKey)this.getPropValueFromCache(levelCacheKey, CONTEXT_KEY);
                String levelContextID = this.getPropValueFromCache(contextKey, CONTEXT_ID).toString();
                String lun = this.getPropValueFromCache(levelCacheKey, LEVEL_UNIQUE_NAME).toString();
                if (!contextId.equals(levelContextID)) continue;
                levelInfo.add(lun);
            }
        }
        return levelInfo;
    }

    protected void recordNewRequest(String contextId, String dimUName) {
        this.recordNewRequest(new DimContextKey(contextId, dimUName));
    }

    protected void recordNewRequest(DimContextKey dimContextKey) {
        AtomicLong other;
        AtomicLong counter = (AtomicLong)this.totalRequests.get(dimContextKey);
        if (counter == null && (other = this.totalRequests.putIfAbsent(dimContextKey, counter = new AtomicLong(0L))) != null) {
            counter = other;
        }
        counter.incrementAndGet();
    }

    protected void recordCacheMiss(String contextId, String dimUName) {
        this.recordCacheMiss(new DimContextKey(contextId, dimUName));
    }

    protected void recordCacheMiss(DimContextKey dimContextKey) {
        AtomicLong other;
        AtomicLong counter = (AtomicLong)this.cacheMiss.get(dimContextKey);
        if (counter == null && (other = this.cacheMiss.putIfAbsent(dimContextKey, counter = new AtomicLong(0L))) != null) {
            counter = other;
        }
        counter.incrementAndGet();
    }

    private long getTotalRequests(String dimensionUName, String contextId) {
        DimContextKey key = new DimContextKey(contextId, dimensionUName);
        AtomicLong counter = (AtomicLong)this.totalRequests.get(key);
        if (counter != null) {
            return counter.get();
        }
        return 0L;
    }

    public long getTotalRequests() {
        long totalRequestCount = 0L;
        Collection requestCountList = this.totalRequests.values();
        for (AtomicLong counter : requestCountList) {
            totalRequestCount += counter.get();
        }
        return totalRequestCount;
    }

    private long getCacheMissCount(String dimensionUName, String contextId) {
        DimContextKey key = new DimContextKey(contextId, dimensionUName);
        AtomicLong counter = (AtomicLong)this.cacheMiss.get(key);
        if (counter != null) {
            return counter.get();
        }
        return 0L;
    }

    public long getCacheMissCount() {
        long totalRequestCount = 0L;
        Collection requestCountList = this.cacheMiss.values();
        for (AtomicLong counter : requestCountList) {
            totalRequestCount += counter.get();
        }
        return totalRequestCount;
    }

    private long getCacheHitCount(String dimensionUName, String contextId) {
        long totalRequestCount = this.getTotalRequests(dimensionUName, contextId);
        long cacheMisscount = this.getCacheMissCount(dimensionUName, contextId);
        return totalRequestCount - cacheMisscount;
    }

    public long getCacheHitCount() {
        long totalRequestCount = this.getTotalRequests();
        long cacheMisscount = this.getCacheMissCount();
        return totalRequestCount - cacheMisscount;
    }

    public static boolean flushStorage(String dataSourceName, String catalogName, String cubeName) {
        boolean flushAll = WILD_CARD.equals(dataSourceName) && WILD_CARD.equals(catalogName) && WILD_CARD.equals(cubeName);
        List<Map.Entry<MemberStorageIdentifier, MemberStorage>> entries = MemberStorage.getMemberStorageEntries(dataSourceName, catalogName, cubeName);
        try {
            storageMapLock.lockInterruptibly();
            if (flushAll) {
                memberStorageMap.clear();
            } else {
                for (Map.Entry<MemberStorageIdentifier, MemberStorage> entry : entries) {
                    memberStorageMap.remove(entry.getKey());
                }
            }
        }
        catch (InterruptedException e) {
            throw new XQERuntimeException(e);
        }
        finally {
            storageMapLock.unlock();
        }
        for (Map.Entry<MemberStorageIdentifier, MemberStorage> entry : entries) {
            try {
                entry.getValue().flush();
            }
            catch (CacheException e) {
                throw new XQERuntimeException(e);
            }
        }
        return true;
    }

    protected void updateStaleStatus() {
        if (!this.isStale()) {
            long timeElapsed;
            if (this.previousMetadataCubeTimestamps != null && this.currentMetadataCubeTimestamps != null && this.currentMetadataCubeTimestamps.compareLastSchemaUpdate(this.previousMetadataCubeTimestamps) > 0) {
                infoLogger.log("MemberStorage flush after metadata cache flush for" + this);
                this.markAsFlushCandidate();
                return;
            }
            int refreshInterval = this.storageConfig.getCacheRefreshInterval();
            if (refreshInterval >= 0 && (timeElapsed = System.currentTimeMillis() - this.creationTickCount) > (long)(refreshInterval * 60 * 1000)) {
                infoLogger.log("MemberStorage flush interval reached for " + this);
                this.markAsFlushCandidate();
            }
        }
    }

    protected void markAsFlushCandidate() {
        if (!this.isStale()) {
            storageMapLock.lock();
            try {
                infoLogger.log("Marking stale for " + this.toString());
                memberStorageMap.remove(this.memberStorageIdentifier);
                this.memberStorageIdentifier.setStale();
            }
            finally {
                storageMapLock.unlock();
            }
        }
    }

    public boolean incrementUsageCount() {
        this.updateStaleStatus();
        try {
            this.memberStorageUsageLock.lockInterruptibly();
            if (this.isStale() || this.cacheClosed.get()) {
                if (this.isStale() && this.memberStorageUsageCount == 0) {
                    infoLogger.log("Stale member storage not in use " + this);
                    this.flush();
                }
                boolean bl = false;
                return bl;
            }
            ++this.memberStorageUsageCount;
        }
        catch (InterruptedException e) {
            throw new XQERuntimeException(e);
        }
        catch (CacheException e) {
            throw new XQERuntimeException(e);
        }
        finally {
            this.memberStorageUsageLock.unlock();
        }
        return true;
    }

    public void decrementUsageCount() {
        this.memberStorageUsageLock.lock();
        try {
            --this.memberStorageUsageCount;
            if (this.memberStorageUsageCount < 1 && this.isStale() && !this.isBeingFlushed()) {
                infoLogger.log("Stale member storage no longer in use " + this);
                this.flush();
            }
            if (this.memberStorageUsageCount < 0) {
                infoLogger.log("Reference count went below zero for " + this);
            }
        }
        catch (CacheException e) {
            throw new XQERuntimeException(e);
        }
        finally {
            this.memberStorageUsageLock.unlock();
        }
    }

    private boolean isInUse() {
        try {
            this.memberStorageUsageLock.lockInterruptibly();
            boolean bl = this.memberStorageUsageCount > 0;
            return bl;
        }
        catch (InterruptedException e) {
            throw new XQERuntimeException(e);
        }
        finally {
            this.memberStorageUsageLock.unlock();
        }
    }

    public static boolean isInUse(String dataSourceType, String dataSourceName, String catalogName, String cubeName, String modelName, boolean isActive, String runLocale) {
        try {
            storageMapLock.lockInterruptibly();
            MemberStorageIdentifier memStorageIdentifier = MemberStorage.buildMemberStorageIdentifier(dataSourceType, dataSourceName, catalogName, cubeName, modelName, isActive, runLocale);
            MemberStorage memStorage = memberStorageMap.get(memStorageIdentifier);
            if (memStorage != null) {
                boolean bl = memStorage.isInUse();
                return bl;
            }
        }
        catch (InterruptedException e) {
            throw new XQERuntimeException(e);
        }
        finally {
            storageMapLock.unlock();
        }
        return false;
    }

    private void indicatePendingFlushAction() {
        try {
            this.memberStorageFlushingLock.lockInterruptibly();
            this.isBeingFlushed = true;
        }
        catch (InterruptedException e) {
            throw new XQERuntimeException(e);
        }
        finally {
            this.memberStorageFlushingLock.unlock();
        }
    }

    private void indicateFlushActionDone() {
        try {
            this.memberStorageFlushingLock.lockInterruptibly();
            this.isBeingFlushed = false;
            this.memStorageIsBeingFlushedCondition.signalAll();
        }
        catch (InterruptedException e) {
            throw new XQERuntimeException(e);
        }
        finally {
            this.memberStorageFlushingLock.unlock();
        }
    }

    protected boolean isBeingFlushed() {
        try {
            this.memberStorageFlushingLock.lockInterruptibly();
            boolean bl = this.isBeingFlushed;
            return bl;
        }
        catch (InterruptedException e) {
            throw new XQERuntimeException(e);
        }
        finally {
            this.memberStorageFlushingLock.unlock();
        }
    }

    protected void awaitFlush() {
        try {
            this.memberStorageFlushingLock.lockInterruptibly();
            while (this.isBeingFlushed()) {
                this.memStorageIsBeingFlushedCondition.await();
            }
        }
        catch (InterruptedException e) {
            throw new XQERuntimeException(e);
        }
        finally {
            this.memberStorageFlushingLock.unlock();
        }
    }

    protected MemberStorageConfig getStorageConfig() {
        return this.storageConfig;
    }

    public static MemberStorageIdentifier buildMemberStorageIdentifier(String dataSourceType, String dataSourceName, String catalogName, String cubeName, String modelName, boolean isActive, String rLocale) {
        MemberStorageIdentifier memberStorageIdentifier = new MemberStorageIdentifier(dataSourceType, modelName);
        memberStorageIdentifier.dataSourceName = dataSourceName;
        memberStorageIdentifier.catalogName = catalogName;
        memberStorageIdentifier.cubeName = cubeName;
        memberStorageIdentifier.active.set(isActive);
        memberStorageIdentifier.runLocale = rLocale;
        return memberStorageIdentifier;
    }

    public String toString() {
        return "MemberStorage_" + this.timestamp;
    }

    protected static List<Map.Entry<MemberStorageIdentifier, MemberStorage>> getMemberStorageEntries(String dataSourceName, String catalogName, String cubeName) {
        boolean all = WILD_CARD.equals(dataSourceName) && WILD_CARD.equals(catalogName) && WILD_CARD.equals(cubeName);
        Set<Map.Entry<MemberStorageIdentifier, MemberStorage>> entries = memberStorageMap.entrySet();
        ArrayList<Map.Entry<MemberStorageIdentifier, MemberStorage>> toReturn = new ArrayList<Map.Entry<MemberStorageIdentifier, MemberStorage>>();
        try {
            storageMapLock.lockInterruptibly();
            for (Map.Entry<MemberStorageIdentifier, MemberStorage> entry : entries) {
                if (all) {
                    toReturn.add(entry);
                    continue;
                }
                if (!entry.getKey().qualifies(dataSourceName, catalogName, cubeName)) continue;
                toReturn.add(entry);
            }
        }
        catch (InterruptedException e) {
            throw new XQERuntimeException(e);
        }
        finally {
            storageMapLock.unlock();
        }
        Collections.sort(toReturn, new Comparator<Map.Entry<MemberStorageIdentifier, MemberStorage>>(){

            @Override
            public int compare(Map.Entry<MemberStorageIdentifier, MemberStorage> o1, Map.Entry<MemberStorageIdentifier, MemberStorage> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        return toReturn;
    }

    public static List<MemberStorage> getMemberStorageInstances(String dataSourceName, String catalogName, String cubeName) {
        List<Map.Entry<MemberStorageIdentifier, MemberStorage>> entries = MemberStorage.getMemberStorageEntries(dataSourceName, catalogName, cubeName);
        ArrayList<MemberStorage> toReturn = new ArrayList<MemberStorage>(entries.size());
        for (Map.Entry<MemberStorageIdentifier, MemberStorage> entry : entries) {
            toReturn.add(entry.getValue());
        }
        return toReturn;
    }

    public static String dumpStorageState(String dDataSourceName, String cCatalogName, String cCubeName) {
        List<Map.Entry<MemberStorageIdentifier, MemberStorage>> memberStorageSorted = MemberStorage.getMemberStorageEntries(dDataSourceName, cCatalogName, cCubeName);
        String dumpFilePath = MemberStorage.getDumpFilePath(MemberStorage.getDumpFileName(dDataSourceName, cCatalogName, cCubeName));
        try {
            XMLOutputFactory factory = XQEXMLOutputFactoryPool.getInstance().borrowXMLOutputFactory();
            FileOutputStream opStream = new FileOutputStream(dumpFilePath);
            XMLStreamWriter writer = factory.createXMLStreamWriter(opStream, DUMP_FILE_CHAR_ENCODING);
            writer.writeStartDocument();
            writer.writeStartElement(XQE_CACHE_METRIC);
            if (memberStorageSorted.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append(DUMP_ERROR_MESSAGE);
                sb.append(SPACE);
                sb.append(DATA_SOURCE);
                sb.append(SPACE);
                sb.append(NAME);
                sb.append(dDataSourceName);
                sb.append(SPACE);
                sb.append(CATALOG);
                sb.append(SPACE);
                sb.append(NAME);
                sb.append(cCatalogName);
                sb.append(SPACE);
                sb.append(CUBE);
                sb.append(SPACE);
                sb.append(NAME);
                sb.append(cCubeName);
                writer.writeCharacters(sb.toString());
                writer.writeEndElement();
                writer.writeEndDocument();
                XQEXMLOutputFactoryPool.getInstance().returnXMLOutputFactory(factory);
                opStream.close();
                return dumpFilePath;
            }
            MemberStorage.writeStorageState(memberStorageSorted, writer);
            XQEXMLOutputFactoryPool.getInstance().returnXMLOutputFactory(factory);
            opStream.close();
        }
        catch (FileNotFoundException e) {
            errorLogger.log(e);
        }
        catch (XMLStreamException e) {
            errorLogger.log(e);
        }
        catch (Exception e) {
            errorLogger.log(e);
        }
        return dumpFilePath;
    }

    public static void writeStorageState(List<Map.Entry<MemberStorageIdentifier, MemberStorage>> memberStorageSorted, XMLStreamWriter writer) {
        String previousDatasourceName = null;
        String previousDatasourceType = null;
        String previousCatalog = null;
        String previousCube = null;
        String previousModelName = null;
        try {
            for (Map.Entry<MemberStorageIdentifier, MemberStorage> entry : memberStorageSorted) {
                MemberStorageIdentifier key = entry.getKey();
                String dataSourceName = key.getDataSourceName();
                String dataSourceType = key.getDataSourceType();
                boolean previousNulls = previousDatasourceName == null && previousDatasourceType == null;
                String catalog = key.getCatalogName();
                String cube = key.getCubeName();
                if (previousCube != null && !previousCube.equals(cube)) {
                    writer.writeEndElement();
                }
                if (previousCatalog != null && !previousCatalog.equals(catalog)) {
                    writer.writeEndElement();
                }
                if (previousDatasourceName != null && !previousDatasourceName.equals(dataSourceName) || previousDatasourceType != null && !previousDatasourceType.equals(dataSourceType)) {
                    writer.writeEndElement();
                }
                if (previousNulls || !dataSourceName.equals(previousDatasourceName) || !dataSourceType.equals(previousDatasourceType)) {
                    writer.writeStartElement(DATA_SOURCE);
                    writer.writeAttribute(DATA_SOURCE_TYPE, dataSourceType);
                    writer.writeStartElement(NAME_TAG);
                    writer.writeCharacters(dataSourceName);
                    writer.writeEndElement();
                }
                if (previousCatalog == null || !previousCatalog.equals(catalog)) {
                    writer.writeStartElement(CATALOG);
                    writer.writeStartElement(NAME_TAG);
                    writer.writeCharacters(catalog);
                    writer.writeEndElement();
                }
                if (previousCube == null || !previousCube.equals(cube)) {
                    writer.writeStartElement(CUBE);
                    writer.writeStartElement(NAME_TAG);
                    writer.writeCharacters(cube);
                    writer.writeEndElement();
                }
                String modelName = key.getModelName();
                if (previousModelName == null || !previousModelName.equals(modelName)) {
                    writer.writeStartElement(MODEL_NAME);
                    writer.writeCharacters(modelName);
                    writer.writeEndElement();
                }
                writer.writeStartElement("status");
                MemberStorage memberStorage = entry.getValue();
                String message = "";
                message = memberStorage.isStale() ? "Stale: about to be cleared from cache once pending reports using this data are complete and closed." : "Active";
                writer.writeCharacters(message);
                writer.writeEndElement();
                memberStorage.dumpCacheInfo(writer);
                memberStorage.dumpDimensionInfo(writer);
                previousDatasourceName = dataSourceName;
                previousDatasourceType = dataSourceType;
                previousCatalog = catalog;
                previousCube = cube;
                previousModelName = modelName;
            }
            writer.writeEndElement();
            writer.writeEndDocument();
        }
        catch (XMLStreamException e) {
            errorLogger.log(e);
        }
    }

    protected void dumpDimensionInfo(XMLStreamWriter writer) throws XMLStreamException {
        StringBuilder sb = new StringBuilder();
        sb.append("List of partially/Fully Cached dimensions. ");
        sb.append("If there is no level information below dimension tag it ");
        sb.append("implies the root level of the dimension is fully cached ");
        sb.append("and is fetched ");
        sb.append("from the locally available sources (MFW cube).");
        writer.writeComment(sb.toString());
        Collection<String> dimensions = this.getDimensions();
        for (String dimension : dimensions) {
            writer.writeStartElement(DIMENSION);
            writer.writeStartElement(NAME_TAG);
            writer.writeCharacters(dimension);
            writer.writeEndElement();
            Set<String> contexts = this.getContexts(dimension);
            for (String context : contexts) {
                writer.writeStartElement(SECURITY_CONTEXT);
                writer.writeStartElement(VALUE);
                String escapedStringBase64 = context;
                if (StringSubstitutionEngine.hasInvalidXMLCharacter(context)) {
                    try {
                        escapedStringBase64 = Base64.encode((byte[])context.getBytes(DUMP_FILE_CHAR_ENCODING));
                    }
                    catch (UnsupportedEncodingException e) {
                        escapedStringBase64 = "Unsupported encoding exception - keep going.";
                    }
                }
                writer.writeCharacters(escapedStringBase64);
                writer.writeEndElement();
                Set<String> levels = this.getLevels(dimension, context);
                StringBuilder sb1 = new StringBuilder();
                sb1.append("List of levels which are retrieved from underlying provider ");
                sb1.append("and marked as complete against at least one query context");
                writer.writeComment(sb1.toString());
                for (String level : levels) {
                    writer.writeStartElement(LEVEL);
                    writer.writeCharacters(level);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void dumpCacheInfo(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeComment("Cache Metrics");
        writer.writeStartElement(TOTAL_REQUESTS);
        writer.writeCharacters("" + this.getTotalRequests());
        writer.writeEndElement();
        writer.writeStartElement(CACHE_HIT_COUNT);
        writer.writeCharacters("" + this.getCacheHitCount());
        writer.writeEndElement();
        writer.writeStartElement(CACHE_MISS_COUNT);
        writer.writeCharacters("" + this.getCacheMissCount());
        writer.writeEndElement();
    }

    protected static String getDumpFilePath(StringBuilder filename) {
        StringBuilder tempFilePath = new StringBuilder(MemberStorage.getDumpFilePath());
        tempFilePath.append(File.separatorChar);
        tempFilePath.append(FileUtil.makeJavaIdentifier(filename.toString()));
        tempFilePath.append(XML_EXT);
        File f = new File(tempFilePath.toString());
        int i = 1;
        while (f.exists()) {
            if (i == 1) {
                filename.append(SEPARATOR);
                filename.append(i);
            } else {
                for (int j = 0; j < String.valueOf(i - 1).length(); ++j) {
                    filename.deleteCharAt(filename.length() - 1);
                }
                filename.append(i);
            }
            tempFilePath = new StringBuilder(MemberStorage.getDumpFilePath());
            tempFilePath.append(File.separatorChar);
            tempFilePath.append(FileUtil.makeJavaIdentifier(filename.toString()));
            tempFilePath.append(XML_EXT);
            f = new File(tempFilePath.toString());
            ++i;
        }
        return tempFilePath.toString();
    }

    private static String getDumpFilePath() {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        String logsDir = configuration.getXqeLogsDirectory();
        ICCLConfiguration cclConfig = null;
        cclConfig = XQECCLConfigurationFactory.getInstance();
        String dispatcherConfig = cclConfig.resolveEffectivePath(logsDir);
        return dispatcherConfig;
    }

    private static StringBuilder getDumpFileName(String dataSourceName, String catalogName, String cubeName) {
        StringBuilder filename = new StringBuilder(DUMP_FILE_NAME_PREFIX);
        if (dataSourceName.equals(WILD_CARD)) {
            filename.append(SEPARATOR);
            filename.append(ALL);
        } else {
            filename.append(SEPARATOR);
            filename.append(dataSourceName);
        }
        if (catalogName.equals(WILD_CARD)) {
            filename.append(SEPARATOR);
            filename.append(ALL);
        } else {
            filename.append(SEPARATOR);
            filename.append(catalogName);
        }
        if (cubeName.equals(WILD_CARD)) {
            filename.append(SEPARATOR);
            filename.append(ALL);
        } else {
            filename.append(SEPARATOR);
            filename.append(cubeName);
        }
        return filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetadataCubeTimestamps(ICubeTimestamps timestamps, MemberStorageKey memberStorageKey) {
        if (timestamps == null) {
            return;
        }
        Lock updaterLock = null;
        try {
            updaterLock = this.acquireObjectLock(memberStorageKey, CacheLockType.WRITE_LOCK);
            this.previousMetadataCubeTimestamps = this.currentMetadataCubeTimestamps == null ? timestamps : this.currentMetadataCubeTimestamps;
            this.currentMetadataCubeTimestamps = timestamps;
        }
        finally {
            this.releaseObjectLock(updaterLock);
        }
    }

    static {
        CacheableNameValueBasedArray.initializeIdMap(allPropertyNames);
        MemberStorage.initializeSimpleProperties();
    }

    private static class DataSourceMapKey {
        private String dsName;
        private String dsType;

        DataSourceMapKey(String name, String type) {
            this.dsName = name;
            this.dsType = type;
        }

        public String getDsName() {
            return this.dsName;
        }

        public String getDsType() {
            return this.dsType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DataSourceMapKey)) {
                return false;
            }
            DataSourceMapKey obj = (DataSourceMapKey)o;
            return this.dsName.equals(obj.getDsName()) && this.dsType.equals(obj.getDsType());
        }

        public int hashCode() {
            int hash = 1;
            hash = hash * 31 + this.dsName.hashCode();
            hash = hash * 31 + this.dsType.hashCode();
            return hash;
        }
    }

    public static class MemberStorageIdentifier
    implements Comparable<MemberStorageIdentifier> {
        private String dataSourceType;
        private String dataSourceName;
        private String catalogName;
        private String cubeName;
        private String modelName;
        private String stringMemberStorageIdentifier;
        private String runLocale;
        private AtomicBoolean active = new AtomicBoolean(true);

        protected MemberStorageIdentifier(String dsType, String modelN) {
            this.dataSourceType = dsType;
            this.modelName = modelN != null ? modelN : "";
        }

        public boolean equals(Object o) {
            boolean equalsFlag;
            if (this == o) {
                return true;
            }
            if (!(o instanceof MemberStorageIdentifier)) {
                return false;
            }
            MemberStorageIdentifier key = (MemberStorageIdentifier)o;
            boolean bl = equalsFlag = this.dataSourceType.equals(key.dataSourceType) && this.dataSourceName.equals(key.dataSourceName) && this.catalogName.equals(key.catalogName) && this.cubeName.equals(key.cubeName) && this.modelName.equals(key.modelName) && this.active.get() == key.active.get();
            if (!equalsFlag) {
                return equalsFlag;
            }
            equalsFlag = this.runLocale != null ? this.runLocale.equals(key.runLocale) : this.runLocale == key.runLocale;
            return equalsFlag;
        }

        public int hashCode() {
            int hash = 1;
            hash = hash * 31 + this.dataSourceType.hashCode();
            hash = hash * 31 + this.dataSourceName.hashCode();
            hash = hash * 31 + this.catalogName.hashCode();
            hash = hash * 31 + this.cubeName.hashCode();
            hash = hash * 31 + this.modelName.hashCode();
            hash = hash * 31 + new Boolean(this.active.get()).hashCode();
            if (this.runLocale != null) {
                hash = hash * 31 + this.runLocale.hashCode();
            }
            return hash;
        }

        public String toString() {
            String comma = ", ";
            StringBuilder sb = new StringBuilder("type: ");
            sb.append(this.dataSourceType);
            sb.append(", ");
            sb.append(this.dataSourceName);
            sb.append(", ");
            sb.append(this.catalogName);
            sb.append(", ");
            sb.append(this.cubeName);
            sb.append(", ");
            sb.append(this.modelName);
            sb.append(", ");
            sb.append(this.active.get());
            if (this.runLocale != null) {
                sb.append(", ");
                sb.append(this.runLocale);
            }
            return sb.toString();
        }

        public String getDataSourceType() {
            return this.dataSourceType;
        }

        protected void setDataSourceType(String dsType) {
            this.dataSourceType = dsType;
        }

        public String getDataSourceName() {
            return this.dataSourceName;
        }

        public String getCatalogName() {
            return this.catalogName;
        }

        public String getCubeName() {
            return this.cubeName;
        }

        public String getModelName() {
            return this.modelName;
        }

        public boolean isStale() {
            return !this.active.get();
        }

        public void setStale() {
            this.active.set(false);
        }

        public String getRunLocaleName() {
            return this.runLocale;
        }

        protected boolean qualifies(String dsName, String catName, String cCubeName) {
            boolean cubeMatched;
            if (dsName == null && this.dataSourceName != null) {
                return false;
            }
            if (catName == null && this.catalogName != null) {
                return false;
            }
            if (cCubeName == null && this.cubeName != null) {
                return false;
            }
            boolean datasrcMatched = MemberStorage.WILD_CARD.equals(dsName) || this.dataSourceName.equals(dsName);
            boolean catMatched = MemberStorage.WILD_CARD.equals(catName) || this.catalogName.equals(catName);
            boolean bl = cubeMatched = MemberStorage.WILD_CARD.equals(cCubeName) || this.cubeName.equals(cCubeName);
            return datasrcMatched && catMatched && cubeMatched;
        }

        @Override
        public int compareTo(MemberStorageIdentifier other) {
            if (other instanceof DMRMemberStorage.DMRMemberStorageIdentifier) {
                return 1;
            }
            int comp = this.dataSourceType.compareToIgnoreCase(other.getDataSourceType());
            if (comp != 0) {
                return comp;
            }
            comp = this.dataSourceName.compareToIgnoreCase(other.getDataSourceName());
            if (comp != 0) {
                return comp;
            }
            comp = this.catalogName.compareToIgnoreCase(other.getCatalogName());
            if (comp != 0) {
                return comp;
            }
            comp = this.cubeName.compareToIgnoreCase(other.getCubeName());
            if (comp != 0) {
                return comp;
            }
            comp = this.modelName.compareToIgnoreCase(other.getModelName());
            if (comp != 0) {
                return comp;
            }
            String otherRunLocale = other.getRunLocaleName();
            if (this.runLocale != null && otherRunLocale != null) {
                comp = this.runLocale.compareToIgnoreCase(otherRunLocale);
                if (comp != 0) {
                    return comp;
                }
            } else {
                if (this.runLocale == null && otherRunLocale != null) {
                    return -1;
                }
                if (this.runLocale != null) {
                    return 1;
                }
            }
            return 0;
        }

        public String getStringMemberStorageIdentifier() {
            if (this.stringMemberStorageIdentifier == null) {
                this.stringMemberStorageIdentifier = this.toString();
            }
            return this.stringMemberStorageIdentifier;
        }
    }

    protected static class CachedProperty {
        private String propertyName;
        private Object value;
        private boolean isDynamic;

        protected CachedProperty() {
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public void setPropertyName(String name) {
            this.propertyName = name;
        }

        public boolean isDynamic() {
            return this.isDynamic;
        }

        public void setDynamic(boolean dynamic) {
            this.isDynamic = dynamic;
        }

        public Object getPropertyValue() {
            return this.value;
        }

        public void setPropertyValue(Object propertyValue) {
            this.value = propertyValue;
        }
    }

    private class MemberRefOrdinalComparator
    implements Comparator<ICacheKey> {
        private final int queryContextIndex;
        private final MemberStorage storage;
        private final String queryContextxOrdinalListPropName;

        MemberRefOrdinalComparator(MemberStorage memberStore, String queryContext, String qryCtxOrdListPropName) {
            this.queryContextIndex = MemberStorage.this.getQueryContextIndex(queryContext);
            this.storage = memberStore;
            this.queryContextxOrdinalListPropName = qryCtxOrdListPropName;
        }

        @Override
        public int compare(ICacheKey memRefKey1, ICacheKey memRefKey2) {
            Integer ordinal1 = this.storage.getOrdinalInQueryContext(this.queryContextIndex, memRefKey1, this.queryContextxOrdinalListPropName);
            Integer ordinal2 = this.storage.getOrdinalInQueryContext(this.queryContextIndex, memRefKey2, this.queryContextxOrdinalListPropName);
            return ordinal1.compareTo(ordinal2);
        }
    }

    protected class DimContextKey {
        String contextId;
        String dimUName;
        int hashCode = -1;

        public DimContextKey(String id, String dim) {
            this.contextId = id;
            this.dimUName = dim;
        }

        public boolean equals(Object o) {
            boolean result = false;
            if (o instanceof DimContextKey) {
                DimContextKey other = (DimContextKey)o;
                if (this.contextId != null && other.contextId != null) {
                    result = this.contextId.equals(other.contextId);
                } else {
                    boolean bl = result = this.contextId == other.contextId;
                }
                result = this.dimUName != null && other.dimUName != null ? (result &= this.dimUName.equals(other.dimUName)) : (result &= this.dimUName == other.dimUName);
            }
            return result;
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                HashCodeBuilder hcb = new HashCodeBuilder();
                hcb.append((Object)this.contextId);
                hcb.append((Object)this.dimUName);
                this.hashCode = hcb.toHashCode();
                if (-1 == this.hashCode) {
                    this.hashCode = 0;
                }
            }
            return this.hashCode;
        }
    }

    static enum CacheLockType {
        READ_LOCK,
        WRITE_LOCK;

    }
}

