/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.securecache;

import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.cache.ICacheFaultHandler;
import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.cache.StringKeyIndexerKey;
import com.cognos.xqe.cache.storage.BTreeCacheStorage;
import com.cognos.xqe.cache.util.CacheableNameValueBasedArray;
import com.cognos.xqe.data.providers.olap.securecache.MemberStorageMemberKey;
import com.cognos.xqe.exception.XQERuntimeException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class MemberStorageKey
implements Serializable,
ICacheKey {
    private static final long FIRST_INT_IN_LONG_BITMASK = 0xFFFFFFF00000000L;
    private static final long SECOND_INT_IN_LONG_BITMASK = 0xFFFFFFFFL;
    private static final int HASH_CODE_MAGIC_NUMBER = 61;
    private static final long serialVersionUID = 4369142657662043463L;
    private long keyValue;
    private static final long KEY_TYPE_MASK = -1152921504606846976L;
    protected static final long NON_CONTEXTUAL_MEM_KEY = 0x1000000000000000L;
    private static final long NON_CONTEXTUAL_HIE_KEY = 0x3000000000000000L;
    private static final long CONTEXT_KEY = 0x2000000000000000L;
    private static final long CONTEXT_LEVEL_KEY = 0x4000000000000000L;
    private static final long MEMBER_REF_KEY = Long.MIN_VALUE;
    private static Class<?> cachedClass = CacheableNameValueBasedArray.class;

    public MemberStorageKey() {
        this.keyValue = -1L;
    }

    private static long buildKeyValue(long kt, int contextId, int keyId) {
        return (long)contextId << 32 & 0xFFFFFFF00000000L | (long)keyId | kt;
    }

    public int getContextId() {
        long kt = this.keyValue & 0xF000000000000000L;
        if (kt == 0x1000000000000000L || kt == 0x3000000000000000L) {
            throw new XQERuntimeException();
        }
        return (int)((this.keyValue & 0xFFFFFFF00000000L) >> 32);
    }

    public int getMemberId() {
        long kt = this.keyValue & 0xF000000000000000L;
        if (kt != 0x1000000000000000L && kt != Long.MIN_VALUE) {
            throw new XQERuntimeException();
        }
        return (int)(this.keyValue & 0xFFFFFFFFL);
    }

    public boolean isMemberKey() {
        return (this.keyValue & 0xF000000000000000L) == 0x1000000000000000L;
    }

    public boolean isHierarchyKey() {
        return (this.keyValue & 0xF000000000000000L) == 0x3000000000000000L;
    }

    protected MemberStorageKey(long ktId, int contextId, int id) {
        this.keyValue = MemberStorageKey.buildKeyValue(ktId, contextId, id);
    }

    public static MemberStorageKey createContextLevelKey(int contextId, int id) {
        return new MemberStorageKey(0x4000000000000000L, contextId, id);
    }

    public static MemberStorageKey createMemberRefKey(int contextId, int id) {
        return new MemberStorageKey(Long.MIN_VALUE, contextId, id);
    }

    public static MemberStorageKey createNonContextualKey(int id) {
        return new MemberStorageKey(0x1000000000000000L, 0, id);
    }

    public static MemberStorageKey createMemberKey(StringKeyIndexerKey key, int id) {
        return new MemberStorageMemberKey(key, id);
    }

    public static MemberStorageKey createHierarchyKey(int id) {
        return new MemberStorageKey(0x3000000000000000L, 0, id);
    }

    public static MemberStorageKey createContextKey(int contextId) {
        return new MemberStorageKey(0x2000000000000000L, contextId, 0);
    }

    public static MemberStorageKey createKeyFromLong(long value) {
        MemberStorageKey msKey = new MemberStorageKey();
        msKey.keyValue = value;
        return msKey;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MemberStorageKey) {
            return this.keyValue == ((MemberStorageKey)obj).keyValue;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return (int)this.keyValue * 61;
    }

    @Override
    public void writeToStream(ObjectOutputStream out) throws IOException {
        out.writeLong(this.keyValue);
    }

    @Override
    public void readFromStream(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.keyValue = in.readLong();
    }

    public long getKeyValue() {
        return this.keyValue;
    }

    @Override
    public ICacheKey cloneKey() {
        return this;
    }

    @Override
    public ICacheFaultHandler getFaultHandler() {
        return null;
    }

    @Override
    public byte[] getBytes() {
        return BTreeCacheStorage.convertLong(this.keyValue);
    }

    @Override
    public Class<?> getCacheableObjectClass() {
        return cachedClass;
    }

    public static void setCachedClass(Class<?> clazz) {
        cachedClass = clazz;
    }

    @Override
    public int compareTo(ICacheKey o) {
        if (o.getClass() != this.getClass()) {
            return 1;
        }
        Long value = new Long(this.keyValue);
        return value.compareTo(((MemberStorageKey)o).keyValue);
    }

    @Override
    public long getLong() {
        return this.keyValue;
    }

    @Override
    public Object getPartition() {
        return 0;
    }

    public String toString() {
        return Long.toString(this.keyValue);
    }

    private void writeObject(ObjectOutputStream out) throws IOException, CacheException {
        this.writeToStream(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, CacheException {
        this.readFromStream(in);
    }
}

