/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.securecache;

import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.data.providers.olap.securecache.MemberStorage;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.record.ExternalizeUtil;
import com.cognos.xqe.metadata.record.IDynamicField;
import com.cognos.xqe.metadata.record.IExternalizable;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class SALDynamicFieldsList
implements Serializable,
IExternalizable {
    private static final long serialVersionUID = -2646146274923548396L;
    private static ConcurrentMap<String, Integer> propToIdMap = new ConcurrentHashMap<String, Integer>();
    private static ConcurrentMap<Integer, String> idToPropMap = new ConcurrentHashMap<Integer, String>();
    private static AtomicInteger maxPropId = new AtomicInteger(0);
    private static final int SERIALIZED_OBJECT_ID = 1;
    private static final int STRING_ID = 2;
    private static final int NULL_OBJECT_ID = 3;
    private static final int VALUE_OBJECT_ID = 4;
    private int[] idArray = null;
    private Object[] valueArray = null;

    private static Integer nameToId(String name) {
        Integer propId = (Integer)propToIdMap.get(name);
        if (propId == null) {
            propId = maxPropId.getAndIncrement();
            Integer otherPropId = propToIdMap.putIfAbsent(name, propId);
            if (otherPropId != null) {
                propId = otherPropId;
            } else {
                String otherName = idToPropMap.put(propId, name);
                if (otherName != null) {
                    throw new XQERuntimeException();
                }
            }
        }
        return propId;
    }

    private static String idToName(Integer id) {
        return (String)idToPropMap.get(id);
    }

    public SALDynamicFieldsList() {
    }

    public SALDynamicFieldsList(List<IDynamicField> dynamicFields) {
        this.idArray = new int[dynamicFields.size()];
        this.valueArray = new Object[dynamicFields.size()];
        ListIterator<IDynamicField> dynamicFieldsIter = dynamicFields.listIterator();
        int i = 0;
        while (dynamicFieldsIter.hasNext()) {
            this.idArray[i++] = SALDynamicFieldsList.nameToId(dynamicFieldsIter.next().getName());
        }
        Arrays.sort(this.idArray);
        for (i = 0; i < this.idArray.length; ++i) {
            IDynamicField field = this.findDynamicField(dynamicFields, SALDynamicFieldsList.idToName(this.idArray[i]));
            this.valueArray[i] = field != null ? field.objectValue() : null;
        }
    }

    private IDynamicField findDynamicField(List<IDynamicField> dynamicFields, String fieldName) {
        if (null == dynamicFields) {
            return null;
        }
        ListIterator<IDynamicField> fieldIter = dynamicFields.listIterator();
        while (fieldIter.hasNext()) {
            IDynamicField field = (IDynamicField)fieldIter.next();
            if (field.getName() != fieldName && !field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    protected synchronized void setDynamicFieldsInMemberRecord(MemberRecord memberRecord) {
        for (int i = 0; i < this.idArray.length; ++i) {
            memberRecord.setDynamicField(SALDynamicFieldsList.idToName(this.idArray[i]), this.valueArray[i]);
        }
    }

    public synchronized int size() {
        return this.idArray.length;
    }

    @Override
    public synchronized void deexternalize(DataInput input) throws IOException {
        try {
            int i;
            int size = input.readInt();
            this.idArray = new int[size];
            this.valueArray = new Object[size];
            for (i = 0; i < size; ++i) {
                this.idArray[i] = input.readInt();
            }
            for (i = 0; i < size; ++i) {
                this.valueArray[i] = SALDynamicFieldsList.readObjectFromStream((ObjectInputStream)input);
            }
        }
        catch (ClassNotFoundException e) {
            throw new XQERuntimeException(e);
        }
        catch (CacheException e) {
            throw new XQERuntimeException(e);
        }
    }

    @Override
    public synchronized void externalize(DataOutput output) throws IOException {
        if (this.idArray == null) {
            output.writeInt(0);
        } else {
            output.writeInt(this.idArray.length);
            for (int id : this.idArray) {
                output.writeInt(id);
            }
            for (Object value : this.valueArray) {
                SALDynamicFieldsList.writeObjectToStream(value, (ObjectOutputStream)output);
            }
        }
    }

    private static void writeObjectToStream(Object value, ObjectOutputStream out) throws IOException {
        if (value instanceof String) {
            out.writeInt(2);
            out.writeInt(((String)value).length());
            out.writeChars((String)value);
        } else if (value instanceof Value) {
            out.writeInt(4);
            ExternalizeUtil.externalizeValue(out, (Value)value);
        } else if (value == null) {
            out.writeInt(3);
        } else {
            out.writeInt(1);
            out.writeObject(value);
        }
    }

    private static Object readObjectFromStream(ObjectInputStream in) throws IOException, ClassNotFoundException, CacheException {
        int objectType = in.readInt();
        int len = 0;
        switch (objectType) {
            case 1: {
                return in.readObject();
            }
            case 4: {
                return ExternalizeUtil.deexternalizeValue(in);
            }
            case 2: {
                len = in.readInt();
                StringBuilder value = new StringBuilder(len);
                for (int j = 0; j < len; ++j) {
                    value.append(in.readChar());
                }
                return value.toString();
            }
            case 3: {
                return null;
            }
        }
        throw new CacheException.InternalError();
    }

    protected synchronized Object getFieldValue(String fieldName) {
        int index = Arrays.binarySearch(this.idArray, SALDynamicFieldsList.nameToId(fieldName));
        if (index < 0) {
            return null;
        }
        return this.valueArray[index];
    }

    protected synchronized boolean containsFieldName(String fieldName) {
        return Arrays.binarySearch(this.idArray, SALDynamicFieldsList.nameToId(fieldName)) > -1;
    }

    protected synchronized void updateDynamicField(String fieldName, Object value) {
        Integer id = SALDynamicFieldsList.nameToId(fieldName);
        int index = Arrays.binarySearch(this.idArray, id);
        if (index >= 0) {
            this.valueArray[index] = value;
        } else {
            int[] newIdArray = new int[this.idArray.length + 1];
            System.arraycopy(this.idArray, 0, newIdArray, 0, this.idArray.length);
            newIdArray[this.idArray.length] = id;
            Arrays.sort(newIdArray);
            Object[] newValueArray = new Object[this.idArray.length + 1];
            int oldIndex = 0;
            int newIndex = 0;
            for (int keyId : newIdArray) {
                if (keyId == id) {
                    newValueArray[newIndex++] = value;
                    continue;
                }
                newValueArray[newIndex++] = this.valueArray[oldIndex++];
            }
            this.idArray = newIdArray;
            this.valueArray = newValueArray;
        }
    }

    protected synchronized MemberStorage.CachedProperty checkForDynamicField(String propName, Boolean allowUnqualifiedPropNames) {
        MemberStorage.CachedProperty cachedProperty = null;
        if (!allowUnqualifiedPropNames.booleanValue()) {
            if (this.containsFieldName(propName)) {
                cachedProperty = new MemberStorage.CachedProperty();
                cachedProperty.setPropertyValue(this.getFieldValue(propName));
            }
        } else {
            for (int i = 0; i < this.idArray.length; ++i) {
                String name = SALDynamicFieldsList.idToName(this.idArray[i]);
                if (!name.contains("[")) continue;
                try {
                    String[] parts = UniqueNameParser.parse(name);
                    if (parts.length <= 0 || !parts[parts.length - 1].equals(propName)) continue;
                    cachedProperty = new MemberStorage.CachedProperty();
                    cachedProperty.setPropertyValue(this.valueArray[i]);
                    return cachedProperty;
                }
                catch (UniqueNameParserException e) {
                    throw new XQERuntimeException(e);
                }
            }
        }
        return cachedProperty;
    }
}

