/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.securecache;

import com.cognos.xqe.data.providers.olap.securecache.SecureCacheConfigurationManager;
import com.cognos.xqe.util.xml.stax.ChildElementIterator;
import com.cognos.xqe.util.xml.stax.IStaxComponentHandler;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class SecureCacheConfigHandler
implements IStaxComponentHandler {
    private static final String SECURE_CACHE_CONFIGURATION = "XQESecureCacheConfiguration";
    private static final String DATASOURCES = "datasources";
    private static final String DATASOURCE = "datasource";
    private static final String SECURITY_CONTEXT_MODE = "securityContextMode";
    private static final String CLEAR_CACHE_INTERVAL = "clearCacheEveryXminutes";
    private static final String METADATA_STORAGE_TYPE = "metadataStorageType";
    private static final String MAX_OBJECTS_MEMORY = "maxObjects";
    private static final String REPLACE_EXISTING_FILES = "replaceExistingFiles";
    private static final String CUBE_SPECIFIC_OVERRIDE = "cubeSpecificOverride";
    private static final String RELOAD = "reload";
    private static final String RELOAD_ENABLED = "enabled";
    private static final String RELOAD_REFRESH_INTERVAL = "refreshInterval";
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private static final String X = "X";
    private static final String DATASOURCE_NAME = "dataSourceName";
    private static final String CATALOG_NAME = "catalogName";
    private static final String CUBE_NAME = "cubeName";
    private static final short CACHE_STORAGE_TYPE_STATIC = 1;
    private static final short CACHE_STORAGE_TYPE_DYNAMIC = 2;
    private static final short CACHE_STORAGE_TYPE_DISK = 3;
    private static final int DEFAULT_CACHE_REFRESH_INTERVAL = -1;
    private SecureCacheConfigurationManager config;

    public SecureCacheConfigHandler(SecureCacheConfigurationManager cacheConfig) {
        this.config = cacheConfig;
    }

    @Override
    public void consume(XMLStreamReader reader) throws XMLStreamException {
        StaxUtil.moveToElement(reader);
        reader.require(1, null, SECURE_CACHE_CONFIGURATION);
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            String name = reader.getLocalName();
            if (name.equals(RELOAD)) {
                this.readReloadParameters(reader);
                continue;
            }
            if (!name.equals(DATASOURCES)) continue;
            this.readDataSources(reader);
        }
    }

    private void readDataSources(XMLStreamReader reader) throws XMLStreamException {
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            String name = reader.getLocalName();
            if (!name.equals(DATASOURCE)) continue;
            this.readDataSourceDetails(reader, this.config.createNewDataSourceConfig());
        }
    }

    private void readDataSourceDetails(XMLStreamReader reader, SecureCacheConfigurationManager.DataSourceConfig dataSourceConfig) throws XMLStreamException {
        String dsType = reader.getAttributeValue(null, TYPE);
        dataSourceConfig.setDataSourceType(dsType);
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            String name = reader.getLocalName();
            if (name.equals(SECURITY_CONTEXT_MODE)) {
                dataSourceConfig.setSecurityContextMode(this.readSecurityContextMode(reader));
                continue;
            }
            if (name.equals(CLEAR_CACHE_INTERVAL)) {
                dataSourceConfig.setClearCacheInterval(this.readCacheClearInterval(reader));
                continue;
            }
            if (name.equals(METADATA_STORAGE_TYPE)) {
                dataSourceConfig.setStorageProperties(this.readStorageParameters(reader));
                continue;
            }
            if (!name.equals(CUBE_SPECIFIC_OVERRIDE)) continue;
            this.readCubeSpecificOverrides(reader, dataSourceConfig.createNewCubeConfigObject());
        }
    }

    private void readCubeSpecificOverrides(XMLStreamReader reader, SecureCacheConfigurationManager.DataSourceConfig.CubeConfig cubeConfig) throws XMLStreamException {
        cubeConfig.setDataSourceName(reader.getAttributeValue(null, DATASOURCE_NAME));
        cubeConfig.setCatalogName(reader.getAttributeValue(null, CATALOG_NAME));
        cubeConfig.setCubeName(reader.getAttributeValue(null, CUBE_NAME));
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            String name = reader.getLocalName();
            if (name.equals(SECURITY_CONTEXT_MODE)) {
                cubeConfig.setSecurityContextMode(this.readSecurityContextMode(reader));
                continue;
            }
            if (name.equals(CLEAR_CACHE_INTERVAL)) {
                cubeConfig.setClearCacheInterval(this.readCacheClearInterval(reader));
                continue;
            }
            if (!name.equals(METADATA_STORAGE_TYPE)) continue;
            cubeConfig.setStorageProperties(this.readStorageParameters(reader));
        }
    }

    private int readCacheClearInterval(XMLStreamReader reader) throws XMLStreamException {
        String refreshInterval = reader.getAttributeValue(null, X);
        reader.next();
        try {
            return Integer.parseInt(refreshInterval);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    private short readSecurityContextMode(XMLStreamReader reader) throws XMLStreamException {
        String contextMode = reader.getAttributeValue(null, VALUE);
        reader.next();
        return Short.parseShort(contextMode);
    }

    private Properties readStorageParameters(XMLStreamReader reader) throws XMLStreamException {
        Properties storageProperties = new Properties();
        String storageType = reader.getAttributeValue(null, VALUE);
        if (storageType != null) {
            short type = Short.parseShort(storageType);
            String maxMembers = reader.getAttributeValue(null, MAX_OBJECTS_MEMORY);
            String replaceExistingFiles = reader.getAttributeValue(null, REPLACE_EXISTING_FILES);
            if (type == 3) {
                storageProperties.put("cacheType", "disk");
                storageProperties.put(REPLACE_EXISTING_FILES, (Object)Boolean.parseBoolean(replaceExistingFiles));
            } else if (type == 2) {
                storageProperties.put("cacheType", "dynamic");
                storageProperties.put(REPLACE_EXISTING_FILES, (Object)Boolean.parseBoolean(replaceExistingFiles));
                storageProperties.put("maxMembers", (Object)Integer.parseInt(maxMembers));
            } else {
                storageProperties.put("cacheType", "static");
            }
        } else {
            storageProperties.put("cacheType", "static");
        }
        reader.next();
        return storageProperties;
    }

    private void readReloadParameters(XMLStreamReader reader) throws XMLStreamException {
        String reloadFlag = reader.getAttributeValue(null, RELOAD_ENABLED);
        String refreshInterval = reader.getAttributeValue(null, RELOAD_REFRESH_INTERVAL);
        reader.next();
    }
}

