/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.securecache;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.providers.olap.securecache.MemberStorage;
import com.cognos.xqe.data.providers.olap.securecache.MemberStorageConfig;
import com.cognos.xqe.data.providers.olap.securecache.SecureCacheConfigHandler;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.util.pool.XQEXMLInputFactoryPool;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.collections.map.MultiKeyMap;

public final class SecureCacheConfigurationManager {
    private static final String WILD_CARD = "*";
    private File configFile;
    private static final short DEFAULT_CONTEXT_MODE = -1;
    private static final int DEFAULT_CACHE_REFRESH_INTERVAL_UNCONFIGURED = -1;
    private static final int DEFAULT_CACHE_REFRESH_INTERVAL = 1440;
    private static final String CONFIG_FILE_PATH = "/xqe.securecache.config.xml";
    List<DataSourceConfig> dataSourceConfigList = new ArrayList<DataSourceConfig>();
    private static SecureCacheConfigurationManager cacheConfig;
    private static ReadWriteLock configLock;
    MultiKeyMap storagePropMap = new MultiKeyMap();
    Lock storagePropLock = new ReentrantLock();

    private SecureCacheConfigurationManager() {
        this.initialize();
    }

    public static synchronized SecureCacheConfigurationManager getInstance() {
        if (cacheConfig == null) {
            cacheConfig = new SecureCacheConfigurationManager();
        }
        return cacheConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemberStorageConfig getMemberStorageConfiguration(String dataSourceType, String dataSourceName, String catalogName, String cubeName) {
        try {
            configLock.readLock().lock();
            DataSourceConfig dsConfig = this.getDataSourceConfig(dataSourceType);
            short contextMode = -1;
            int cacheRefreshInterval = -1;
            Properties storageProperties = this.getDefaultStorageProperties();
            if (dsConfig != null) {
                contextMode = dsConfig.getSecurityContextMode();
                cacheRefreshInterval = dsConfig.getClearCacheInterval();
                storageProperties = dsConfig.getStorageProperties();
                DataSourceConfig.CubeConfig cubeConfig = dsConfig.getCubeConfig(dataSourceName, catalogName, cubeName);
                if (cubeConfig != null) {
                    contextMode = cubeConfig.getSecurityContextMode();
                    cacheRefreshInterval = cubeConfig.getClearCacheInterval();
                    Properties cubeStorageProperties = cubeConfig.getStorageProperties();
                    if (cubeStorageProperties != null) {
                        storageProperties = cubeStorageProperties;
                    }
                }
            }
            MemberStorageConfig memberStorageConfig = new MemberStorageConfig(storageProperties, contextMode, cacheRefreshInterval);
            return memberStorageConfig;
        }
        finally {
            configLock.readLock().unlock();
        }
    }

    private Properties getDefaultStorageProperties() {
        Properties storageProperties = new Properties();
        storageProperties.put("cacheType", "static");
        return storageProperties;
    }

    private DataSourceConfig getDataSourceConfig(String dataSourceType) {
        for (DataSourceConfig config : this.dataSourceConfigList) {
            if (!config.getDataSourceType().equals(dataSourceType)) continue;
            return config;
        }
        return null;
    }

    private void initialize() {
        XQEConfiguration xqeConfig = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        this.configFile = new File(xqeConfig.getConfigDirectory() + CONFIG_FILE_PATH);
        this.loadNewConfiguration(this.configFile);
    }

    public void forceReloadConfiguration() {
        try {
            configLock.writeLock().lock();
            this.reloadConfiguration();
        }
        finally {
            configLock.writeLock().unlock();
        }
    }

    public void loadNewConfiguration(File configurationFile) {
        try {
            configLock.writeLock().lock();
            this.configFile = configurationFile;
            this.reloadConfiguration();
        }
        finally {
            configLock.writeLock().unlock();
        }
    }

    public void loadDefaultConfiguration() {
        this.initialize();
    }

    private void reloadConfiguration() {
        this.dataSourceConfigList.clear();
        MemberStorage.flushAllStorages();
        try {
            this.storagePropLock.lockInterruptibly();
            this.storagePropMap.clear();
        }
        catch (InterruptedException ie) {
            throw new XQERuntimeException(ie);
        }
        finally {
            this.storagePropLock.unlock();
        }
        if (this.configFile == null || !this.configFile.exists()) {
            this.createDefaultConfiguration();
            return;
        }
        this.readConfiguration();
    }

    private void createDefaultConfiguration() {
        DataSourceConfig dsConfig = this.createNewDataSourceConfig();
        dsConfig.setDataSourceType("BW");
        dsConfig.setSecurityContextMode((short)1);
        dsConfig.setClearCacheInterval(1440);
        dsConfig.setStorageProperties(this.getDefaultStorageProperties());
        dsConfig = this.createNewDataSourceConfig();
        dsConfig.setDataSourceType("EB");
        dsConfig.setSecurityContextMode((short)1);
        dsConfig.setClearCacheInterval(1440);
        dsConfig.setStorageProperties(this.getDefaultStorageProperties());
        dsConfig = this.createNewDataSourceConfig();
        dsConfig.setDataSourceType("DMR");
        dsConfig.setSecurityContextMode((short)1);
        dsConfig.setClearCacheInterval(1440);
        dsConfig.setStorageProperties(this.getDefaultStorageProperties());
        dsConfig = this.createNewDataSourceConfig();
        dsConfig.setDataSourceType("TM");
        dsConfig.setSecurityContextMode((short)2);
        dsConfig.setClearCacheInterval(1440);
        dsConfig.setStorageProperties(this.getDefaultStorageProperties());
        dsConfig = this.createNewDataSourceConfig();
        dsConfig.setDataSourceType("TMR");
        dsConfig.setSecurityContextMode((short)2);
        dsConfig.setClearCacheInterval(1440);
        dsConfig.setStorageProperties(this.getDefaultStorageProperties());
    }

    private void readConfiguration() {
        RuntimeException exception;
        block12: {
            XMLInputFactory inputFactory;
            block11: {
                SecureCacheConfigHandler handler = new SecureCacheConfigHandler(this);
                InputStreamReader fileReader = null;
                inputFactory = null;
                exception = null;
                try {
                    fileReader = new InputStreamReader(new FileInputStream(this.configFile));
                    BufferedReader bufReader = new BufferedReader(fileReader);
                    inputFactory = XQEXMLInputFactoryPool.getInstance().borrowXMLInputFactory();
                    StaxUtil.configureInputFactory(inputFactory, false, true, true);
                    XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(bufReader);
                    try {
                        XQEXMLInputFactoryPool.getInstance().returnXMLInputFactory(inputFactory);
                        inputFactory = null;
                    }
                    catch (Exception ex) {
                        throw XQERuntimeException.wrap(ex);
                    }
                    handler.consume(xmlReader);
                }
                catch (Exception t) {
                    exception = XQERuntimeException.wrap(t);
                }
                if (null != fileReader) {
                    try {
                        ((Reader)fileReader).close();
                        fileReader = null;
                    }
                    catch (Exception ex) {
                        if (exception != null) break block11;
                        exception = XQERuntimeException.wrap(ex);
                    }
                }
            }
            if (null != inputFactory) {
                try {
                    XQEXMLInputFactoryPool.getInstance().returnXMLInputFactory(inputFactory);
                    inputFactory = null;
                }
                catch (Exception ex) {
                    if (exception != null) break block12;
                    exception = XQERuntimeException.wrap(ex);
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    protected DataSourceConfig createNewDataSourceConfig() {
        DataSourceConfig newConfig = new DataSourceConfig();
        this.dataSourceConfigList.add(newConfig);
        return newConfig;
    }

    static {
        configLock = new ReentrantReadWriteLock();
    }

    public final class DataSourceConfig {
        private String dataSourceType;
        private short securityContextMode;
        private int clearCacheInterval;
        private List<CubeConfig> cubeSpecificConfig = new ArrayList<CubeConfig>();
        private Properties storageProperties;

        public void setDataSourceType(String dsType) {
            this.dataSourceType = dsType;
        }

        public void setSecurityContextMode(short contextMode) {
            this.securityContextMode = contextMode;
        }

        public void setClearCacheInterval(int clearCacheInter) {
            this.clearCacheInterval = clearCacheInter;
        }

        public void setStorageProperties(Properties storageProp) {
            this.storageProperties = storageProp;
        }

        public Properties getStorageProperties() {
            return this.storageProperties;
        }

        public String getDataSourceType() {
            return this.dataSourceType;
        }

        public short getSecurityContextMode() {
            return this.securityContextMode;
        }

        public int getClearCacheInterval() {
            return this.clearCacheInterval;
        }

        private DataSourceConfig() {
        }

        protected CubeConfig createNewCubeConfigObject() {
            CubeConfig config = new CubeConfig();
            this.cubeSpecificConfig.add(config);
            return config;
        }

        private CubeConfig getCubeConfig(String dataSourceName, String catalogName, String cubeName) {
            for (CubeConfig config : this.cubeSpecificConfig) {
                if (!config.getDataSourceName().equals(dataSourceName) && !config.getDataSourceName().equals(SecureCacheConfigurationManager.WILD_CARD) || !config.getCatalogName().equals(catalogName) && !config.getCatalogName().equals(SecureCacheConfigurationManager.WILD_CARD) || !config.getCubeName().equals(cubeName) && !config.getCubeName().equals(SecureCacheConfigurationManager.WILD_CARD)) continue;
                return config;
            }
            return null;
        }

        public final class CubeConfig {
            private String dataSourceName;
            private String catalogName;
            private String cubeName;
            private short securityContextMode;
            private int clearCacheInterval;
            private Properties storageProperties;

            public void setDataSourceName(String dsName) {
                this.dataSourceName = dsName;
            }

            public void setCatalogName(String catName) {
                this.catalogName = catName;
            }

            public void setCubeName(String cName) {
                this.cubeName = cName;
            }

            public void setSecurityContextMode(short contextMode) {
                this.securityContextMode = contextMode;
            }

            public void setClearCacheInterval(int cacheRefreshInter) {
                this.clearCacheInterval = cacheRefreshInter;
            }

            public void setStorageProperties(Properties storageProp) {
                this.storageProperties = storageProp;
            }

            public Properties getStorageProperties() {
                return this.storageProperties;
            }

            public String getDataSourceName() {
                return this.dataSourceName;
            }

            public String getCatalogName() {
                return this.catalogName;
            }

            public String getCubeName() {
                return this.cubeName;
            }

            public short getSecurityContextMode() {
                return this.securityContextMode;
            }

            public int getClearCacheInterval() {
                return this.clearCacheInterval;
            }

            private CubeConfig() {
            }
        }
    }
}

