/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.securecache;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.MetadataQueryArguments;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.securecache.MemberStorage;
import com.cognos.xqe.data.providers.rscache.pool.CubeRevisionParameter;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.record.CubeRecord;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TM1MemberStorage
extends MemberStorage {
    private static final long DEFAULT_CUBE_UPDATE_CHECK_PERIOD = 10000L;
    private static final String CUBE_UPDATE_CHECK_PERIOD_KEY = "general.cubeUpdateCheckPeriod[@value]";
    private CubeRevisionParameter cubeRevision;
    long lastCubeUpdateCheckTime;
    private long cubeUpdateCheckPeriod;
    private Lock cubeUpdateLock;

    protected TM1MemberStorage(IDataSource dataSource, String dataSourceName, String catalogName, String cubeName, String modelName, String runLocale) {
        super(dataSource, dataSourceName, catalogName, cubeName, modelName, runLocale);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.cubeRevision = this.getCurrentCubeRevision();
        this.lastCubeUpdateCheckTime = System.currentTimeMillis();
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        this.cubeUpdateCheckPeriod = config.getLongProperty(CUBE_UPDATE_CHECK_PERIOD_KEY, 10000L);
        this.cubeUpdateLock = new ReentrantLock();
    }

    @Override
    protected void updateStaleStatus() {
        super.updateStaleStatus();
        if (!this.isStale()) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastCubeUpdateCheckTime < this.cubeUpdateCheckPeriod) {
                return;
            }
            try {
                this.cubeUpdateLock.lockInterruptibly();
                if (currentTime - this.lastCubeUpdateCheckTime < this.cubeUpdateCheckPeriod) {
                    return;
                }
                CubeRevisionParameter newRev = this.getCurrentCubeRevision();
                this.lastCubeUpdateCheckTime = currentTime;
                if (!newRev.equals(this.cubeRevision)) {
                    infoLogger.log("TM1 cube " + this.getCubeName() + " has been updated, marking stale " + this.toString());
                    this.markAsFlushCandidate();
                }
            }
            catch (InterruptedException e) {
                throw new XQERuntimeException(e);
            }
            finally {
                this.cubeUpdateLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CubeRevisionParameter getCurrentCubeRevision() {
        Map<String, Object> metadataProperties;
        Set projectLocales;
        ExecutionEnvironment env = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        MetadataQueryArguments mdQueryArgs = MetadataQueryArguments.buildArguments(env.getDataSource(this.getDataSourceName()), env, null);
        MetadataRestriction restrictions = new MetadataRestriction();
        restrictions.add(RestrictionType.CUBE, this.getCubeName());
        String catalog = this.getCatalogName();
        if (catalog != null) {
            restrictions.add(RestrictionType.CATALOG, catalog);
        }
        if ((projectLocales = (Set)(metadataProperties = this.mDataSource.getMetadataProperties()).get("project_locales")) != null && !projectLocales.isEmpty()) {
            ArrayList locales = new ArrayList(projectLocales);
            restrictions.add(RestrictionType.PROJECT_LOCALES, locales);
        }
        List<CubeRecord> cubes = null;
        IDataSource dataSource = env.getDataSource();
        IOLAPDataProvider provider = ProviderManager.getInstance().getOLAPProvider(dataSource.getType());
        IOLAPMetadataProvider mdProvider = null;
        try {
            mdProvider = provider.getMetadataProvider(mdQueryArgs);
            cubes = mdProvider.getCubes(restrictions);
        }
        finally {
            if (mdProvider != null) {
                mdProvider.release();
            }
        }
        if (cubes != null && cubes.size() == 1) {
            CubeRecord r = cubes.get(0);
            return TM1MemberStorage.createCubeRevisionParameter(provider.getProviderInstanceName(), r);
        }
        if (cubes != null && cubes.size() > 1) {
            for (CubeRecord cr : cubes) {
                if (!cr.getName().equals(this.getCubeName())) continue;
                return TM1MemberStorage.createCubeRevisionParameter(provider.getProviderInstanceName(), cr);
            }
        }
        return new CubeRevisionParameter(System.currentTimeMillis());
    }

    private static CubeRevisionParameter createCubeRevisionParameter(String providerName, CubeRecord record) {
        DateTimeValue revision = record.getCubeRevision();
        if (revision != null) {
            return new CubeRevisionParameter(revision.getMilliseconds());
        }
        StringBuilder buf = new StringBuilder("Cannot determine DataUpdateDate for cube ");
        buf.append(record.getName());
        errorLogger.log(buf.toString());
        return new CubeRevisionParameter(System.currentTimeMillis());
    }
}

