/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.qfwbridge;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import java.util.LinkedList;
import java.util.List;

public final class QFWException
extends XQERuntimeException {
    private static final long serialVersionUID = 1L;
    private final String mThrowableName;
    private final String mErrorCode;
    private final int mSeverity;
    private final String mDOM;
    private final String mNativeTrace;
    private boolean isLogonFailure;
    private static final List<String> LOGON_FAILURE_CODES = new LinkedList<String>();

    public QFWException(boolean logonFailure) {
        super(XQEMessageKeys.EXE_QFWBridgeError, "");
        this.mThrowableName = null;
        this.mErrorCode = null;
        this.mSeverity = 0;
        this.mDOM = null;
        this.mNativeTrace = null;
        this.isLogonFailure = logonFailure;
    }

    public QFWException(String throwableName, String errorCode, int severity, String message, String dom, String nativeTrace) {
        super(XQEMessageKeys.EXE_QFWBridgeError, message);
        this.mThrowableName = throwableName;
        this.mErrorCode = errorCode;
        this.mSeverity = severity;
        this.mDOM = dom;
        this.mNativeTrace = nativeTrace;
        this.isLogonFailure = false;
    }

    public String getThrowableName() {
        return this.mThrowableName;
    }

    public String getNativeTrace() {
        return this.mNativeTrace;
    }

    public int getSeverity() {
        return this.mSeverity;
    }

    public String getErrorCode() {
        return this.mErrorCode;
    }

    public String getDOM() {
        return this.mDOM;
    }

    public boolean isLogonFailure() {
        if (this.isLogonFailure) {
            return true;
        }
        String msg = this.getDetailMessage();
        if (msg != null) {
            for (String code : LOGON_FAILURE_CODES) {
                if (!msg.contains(code)) continue;
                return true;
            }
        }
        return false;
    }

    public String getDetailMessage() {
        if (this.getArguments() != null && this.getArguments().length > 0) {
            return (String)this.getArguments()[0];
        }
        return "";
    }

    public String getLogString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("QFWException: \n");
        if (null != this.mThrowableName && this.mThrowableName.length() > 0) {
            buffer.append("throwableName=").append(this.mThrowableName).append('\n');
        }
        if (null != this.mErrorCode && this.mErrorCode.length() > 0) {
            buffer.append("errorCode=").append(this.mErrorCode).append('\n');
        }
        if (null != this.mDOM && this.mDOM.length() > 0) {
            buffer.append("DOM=").append(this.mDOM).append('\n');
        }
        buffer.append("message=").append(this.getDetailMessage());
        if (null != this.mNativeTrace && this.mNativeTrace.length() > 0) {
            buffer.append("nativeTrace=").append(this.mNativeTrace).append('\n');
        }
        return buffer.toString();
    }

    static {
        LOGON_FAILURE_CODES.add("SystemServerClientNotFound");
        LOGON_FAILURE_CODES.add("SystemServerClientPasswordInvalid");
    }
}

