/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.qfwbridge;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.qfwbridge.DatasetInfo;
import com.cognos.xqe.data.providers.qfwbridge.QFWConnection;
import com.cognos.xqe.data.providers.qfwbridge.QFWException;
import com.cognos.xqe.data.providers.qfwbridge.QFWObject;
import com.cognos.xqe.data.providers.qfwbridge.QFWResultPart;
import com.cognos.xqe.data.providers.qfwbridge.StringIdPool;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.io.ByteBufferInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Locale;

public class QFWQuery
extends QFWObject {
    private static final XQELogger LOGGER = XQELog.getLogger(ServiceEnumeration.XQEODP, "MDDS", "QFWBridge.Query", LogLevel.TRACE);
    private final StringIdPool stringPool = new StringIdPool();
    private int stringIdCounter = 1;

    QFWQuery(QFWConnection parent, Locale errorLocale) {
        super(parent, (byte)1, 0L, errorLocale);
    }

    public void execute(String v5query) {
        LOGGER.log(OperationEnum.START, "Start execute().");
        try {
            QFWConnection connection = (QFWConnection)this.getParent();
            this.setNativeHandle(this.cExecute(connection.getNativeHandle(), v5query));
        }
        finally {
            LOGGER.log(OperationEnum.END, "Finished execute().");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getResponse() {
        LOGGER.log(OperationEnum.START, "Start getResponse().");
        try {
            long handle = this.getNativeHandle();
            ByteBuffer responseBuffer = this.cGetResponseDom(handle);
            ByteBufferInputStream byteBufferInputStream = new ByteBufferInputStream(responseBuffer);
            return byteBufferInputStream;
        }
        finally {
            LOGGER.log(OperationEnum.END, "Finished getResponse().");
        }
    }

    public int getDatasetCount() {
        LOGGER.log(OperationEnum.START, "Start getDatasetCount().");
        try {
            int result = -1;
            int n = result = this.cGetDatasetCount(this.getNativeHandle());
            return n;
        }
        finally {
            LOGGER.log(OperationEnum.END, "Finished getDatasetCount().");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatasetInfo getDatasetInfo(int index) {
        LOGGER.log(OperationEnum.START, "Start getDatasetInfo().");
        try {
            long handle = this.cGetDatasetInfo(this.getNativeHandle(), index);
            DatasetInfo dsi = null;
            if (handle != 0L) {
                dsi = new DatasetInfo(this, handle, null);
            }
            DatasetInfo datasetInfo = dsi;
            return datasetInfo;
        }
        finally {
            LOGGER.log(OperationEnum.END, "Finished getDatasetInfo().");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QFWResultPart getResultPart(int index) {
        LOGGER.log(OperationEnum.START, "Start getResultPart().");
        try {
            long handle = this.cGetResultPart(this.getNativeHandle(), index);
            QFWResultPart qrp = null;
            if (handle != 0L) {
                qrp = new QFWResultPart(this, index, handle, null);
            }
            QFWResultPart qFWResultPart = qrp;
            return qFWResultPart;
        }
        finally {
            LOGGER.log(OperationEnum.END, "Finished getResultPart().");
        }
    }

    void addString(String value) {
        this.stringPool.setString(++this.stringIdCounter, value);
    }

    String getString(int stringId) {
        return this.stringPool.getString(stringId);
    }

    public static void appendRequestID(StringBuilder stringBuilder, String requestID) {
        if (null == requestID || requestID.length() == 0) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_RequestIdMissing);
        }
        stringBuilder.append("<requestID value=\"");
        stringBuilder.append(requestID);
        stringBuilder.append("\"/>");
    }

    private native long cExecute(long var1, String var3) throws QFWException;

    private native int cGetDatasetCount(long var1) throws QFWException;

    private native long cGetDatasetInfo(long var1, int var3) throws QFWException;

    private native long cGetResultPart(long var1, int var3) throws QFWException;

    private native ByteBuffer cGetResponseDom(long var1) throws QFWException;
}

