/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.ConnectionTestQueryArguments;
import com.cognos.xqe.data.providers.relational.IRelationalDataProvider;
import com.cognos.xqe.data.providers.relational.SQLQueryArguments;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionFactory;
import com.cognos.xqe.pool.connection.IConnectionSelector;
import com.cognos.xqe.pool.connection.IExpirationPolicy;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.resource.ReleasableResourceTracker;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqe.zipi.ZipiContext;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.util.List;
import java.util.Locale;

public class TraceRelationalDataProvider
implements IRelationalDataProvider {
    private static final String RELATIONAL_DATA_PROVIDER = "Relational data provider ";
    private final IRelationalDataProvider provider;
    private final XQELogger ipfSQLLogger;
    private final XQELogger ipfProviderLogger;

    public TraceRelationalDataProvider(IRelationalDataProvider aProvider) {
        this.provider = aProvider;
        this.ipfSQLLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "QueryService.SQL", LogLevel.TRACE);
        this.ipfProviderLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "QueryService.Provider", LogLevel.TRACE);
        if (this.ipfProviderLogger.isOn()) {
            StringBuilder logBuffer = new StringBuilder(RELATIONAL_DATA_PROVIDER);
            logBuffer.append(this.provider.getProviderInstanceName()).append(" is created.");
            this.ipfSQLLogger.log(logBuffer.toString());
        }
    }

    @Override
    public IConnectionFactory getConnectionFactory() {
        return this.provider.getConnectionFactory();
    }

    @Override
    public IConnectionSelector getConnectionSelector() {
        return this.provider.getConnectionSelector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITabularResultSet query(XDataContext context, SQLQueryArguments theQueryArgument) throws XQEException, LogonFailureException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer(theQueryArgument.getDataSource(), ZipiContext.getQRDName());
        try {
            ITabularResultSet iTabularResultSet = this.tryToQuery(context, theQueryArgument);
            return iTabularResultSet;
        }
        finally {
            if (zipiTimer != null) {
                zipiTimer.stop();
            }
        }
    }

    private ITabularResultSet tryToQuery(XDataContext context, SQLQueryArguments theQueryArgument) throws XQEException, LogonFailureException {
        if (this.ipfSQLLogger.isOn()) {
            StringBuilder logBuffer = new StringBuilder();
            logBuffer.append("SQL query started with arguments ");
            logBuffer.append(theQueryArgument.toString());
            logBuffer.append("; SQL: \"");
            logBuffer.append(theQueryArgument.getSQLQuery()).append("\"");
            String msg = logBuffer.toString();
            this.ipfSQLLogger.log(OperationEnum.START, msg);
        }
        try {
            ITabularResultSet rs;
            ITabularResultSet iTabularResultSet = rs = this.provider.query(context, theQueryArgument);
            return iTabularResultSet;
        }
        catch (XQEException ex) {
            if (this.ipfSQLLogger.isOn(LogLevel.ERROR)) {
                this.ipfSQLLogger.log(LogLevel.ERROR, "SQL query failed with exception: ", (Throwable)ex);
            }
            throw ex;
        }
        catch (LogonFailureException ex) {
            if (this.ipfSQLLogger.isOn(LogLevel.ERROR)) {
                this.ipfSQLLogger.log(LogLevel.ERROR, "SQL query failed with logon failure: ", (Throwable)ex);
            }
            throw ex;
        }
        finally {
            if (this.ipfSQLLogger.isOn()) {
                this.ipfSQLLogger.log(OperationEnum.END, "SQL query completed.");
            }
        }
    }

    @Override
    public IPooledConnection borrowConnection(ConnectionParameters connectionParameters, IExecutionEnvironment executionEnvironment) {
        return this.provider.borrowConnection(connectionParameters, executionEnvironment);
    }

    @Override
    public String cognosUNToNativeUN(String providerType, IHierarchy hierarchy, String cognosUN) {
        return this.provider.cognosUNToNativeUN(providerType, hierarchy, cognosUN);
    }

    @Override
    public String getProperty(String propertyName) {
        return this.provider.getProperty(propertyName);
    }

    @Override
    public String getProviderInstanceName() {
        return this.provider.getProviderInstanceName();
    }

    @Override
    public ReleasableResourceTracker getResourceTracker() {
        return this.provider.getResourceTracker();
    }

    @Override
    public String nativeUNToCognosUN(String providerType, String nativeUN) {
        return this.provider.nativeUNToCognosUN(providerType, nativeUN);
    }

    @Override
    public List<XQEMessage> testConnection(ConnectionTestQueryArguments theQueryArguments) {
        return this.provider.testConnection(theQueryArguments);
    }

    @Override
    public void release() {
        this.provider.release();
        if (this.ipfProviderLogger.isOn()) {
            StringBuilder logBuffer = new StringBuilder(RELATIONAL_DATA_PROVIDER);
            logBuffer.append(this.provider.getProviderInstanceName()).append(" is released.");
            this.ipfSQLLogger.log(logBuffer.toString());
        }
    }

    @Override
    public void resolveDataSourceCapabilities(IExecutionEnvironment executionEnv, IDataSource dataSource, Locale exprLocale) {
        this.provider.resolveDataSourceCapabilities(executionEnv, dataSource, exprLocale);
    }

    @Override
    public IExpirationPolicy getConnectionExpirationPolicy() {
        return this.provider.getConnectionExpirationPolicy();
    }

    public IRelationalDataProvider getProvider() {
        return this.provider;
    }
}

