/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.jdbc;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration2.AbstractConfiguration;

public class JDBCConfiguration
extends AbstractConfiguration {
    public static final String TRUE_STRING = "true";
    public static final String FALSE_STRING = "false";
    public static final String CASE_STRING = "CASE";
    private Map<String, Object> properties = new HashMap<String, Object>();
    private String stringFunctions;
    private String numericFunctions;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    private static final int COL_SQL92_NOSUPPORT = 1;
    private static final int COL_SQL92_ENTRY_LEVEL = 2;
    private static final int COL_SQL92_INTERMEDIATE_LEVEL = 3;
    private static final int COL_CAPABILITY_VALUE = 4;
    private static final String[][] DB_CAPABILITIES_BOOLEAN = new String[][]{{"general.nullsOrdering", "false", "true", "true"}, {"general.nullsOrderingInWindowSpecification", "false", "false", "false"}, {"supports.expressionsInINPredicate", "false", "false", "false"}, {"supports.expressionsInSelectList", "false", "false", "false"}, {"supports.subqueriesInOnClause", "false", "false", "false"}, {"supports.withClauseInDerivedTable", "false", "false", "false"}, {"supports.integerDivision", "false", "false", "false"}, {"supports.nestedOlap", "false", "false", "false"}, {"supports.derivedColumnLists", "false", "false", "false"}, {"supports.orderByAlias", "false", "false", "false"}, {"supports.orderByName", "false", "true", "true"}, {"supports.orderByOrdinal", "false", "true", "true"}, {"supports.blobsInGroupBy", "false", "false", "false"}, {"supports.blobsInOrderBy", "false", "false", "false"}, {"supports.scalarSubqueries", "false", "true", "true"}, {"supports.emptyStringIsNull", "false", "false", "false"}, {"supports.charLiteralRoundTrip", "false", "false", "false"}, {"supports.implicitTypeConversion", "true", "true", "true"}, {"tables.derived", "false", "false", "false"}, {"tables.lateral.derived", "false", "false", "false"}, {"tables.joined", "false", "false", "true"}, {"literals.binary", "false", "false", "false"}, {"literals.blob", "false", "false", "false"}, {"literals.clob", "false", "false", "false"}, {"literals.boolean", "false", "false", "false"}, {"literals.date", "false", "false", "true"}, {"literals.time", "false", "false", "true"}, {"literals.time_with_time_zone", "false", "false", "false"}, {"literals.timestamp", "false", "false", "true"}, {"literals.timestamp_with_time_zone", "false", "false", "false"}, {"literals.interval_day", "false", "false", "false"}, {"literals.interval_day_to_hour", "false", "false", "false"}, {"literals.interval_day_to_minute", "false", "false", "false"}, {"literals.interval_day_to_second", "false", "false", "false"}, {"literals.interval_hour", "false", "false", "false"}, {"literals.interval_hour_to_minute", "false", "false", "false"}, {"literals.interval_hour_to_second", "false", "false", "false"}, {"literals.interval_minute", "false", "false", "false"}, {"literals.interval_minute_to_second", "false", "false", "false"}, {"literals.interval_second", "false", "false", "false"}, {"literals.interval_year", "false", "false", "false"}, {"literals.interval_year_to_month", "false", "false", "false"}, {"literals.interval_month", "false", "false", "false"}, {"literals.smallint", "false", "true", "true"}, {"literals.integer", "false", "true", "true"}, {"literals.long", "false", "true", "true"}, {"literals.float", "false", "true", "true"}, {"literals.double", "false", "true", "true"}, {"literals.decimal", "false", "true", "true"}, {"literals.char", "false", "true", "true"}, {"literals.nchar", "false", "false", "true"}, {"literals.varchar", "false", "true", "true"}, {"literals.nvarchar", "false", "false", "true"}, {"literals.xml", "false", "false", "false"}, {"dataType.binary", "false", "false", "false"}, {"dataType.blob", "false", "false", "false"}, {"dataType.clob", "false", "false", "false"}, {"dataType.boolean", "false", "false", "false"}, {"dataType.date", "false", "false", "true"}, {"dataType.time", "false", "false", "true"}, {"dataType.time_with_time_zone", "false", "false", "false"}, {"dataType.timestamp", "false", "false", "true"}, {"dataType.timestamp_with_time_zone", "false", "false", "false"}, {"dataType.interval_day", "false", "false", "false"}, {"dataType.interval_day_to_hour", "false", "false", "false"}, {"dataType.interval_day_to_minute", "false", "false", "false"}, {"dataType.interval_day_to_second", "false", "false", "false"}, {"dataType.interval_hour", "false", "false", "false"}, {"dataType.interval_hour_to_minute", "false", "false", "false"}, {"dataType.interval_hour_to_second", "false", "false", "false"}, {"dataType.interval_minute", "false", "false", "false"}, {"dataType.interval_minute_to_second", "false", "false", "false"}, {"dataType.interval_second", "false", "false", "false"}, {"dataType.interval_year", "false", "false", "false"}, {"dataType.interval_year_to_month", "false", "false", "false"}, {"dataType.interval_month", "false", "false", "false"}, {"dataType.smallint", "true", "true", "true"}, {"dataType.integer", "true", "true", "true"}, {"dataType.long", "true", "true", "true"}, {"dataType.float", "true", "true", "true"}, {"dataType.double", "true", "true", "true"}, {"dataType.decimal", "true", "true", "true"}, {"dataType.char", "true", "true", "true"}, {"dataType.varchar", "true", "true", "true"}, {"dataType.xml", "false", "false", "false"}, {"dataType.period", "false", "false", "false"}};
    private static final String[][] DB_CAPABILITIES_STRING = new String[][]{{"commands.Select", "true", "true", "true", "SELECT"}, {"commands.Call", "true", "true", "true", "CALL"}, {"clauses.From", "true", "true", "true", "FROM"}, {"clauses.Where", "true", "true", "true", "WHERE"}, {"clauses.GroupBy", "false", "false", "false", null}, {"clauses.Having", "false", "true", "true", "HAVING"}, {"clauses.With", "false", "false", "false", null}, {"clauses.OrderBy", "false", "true", "true", "ORDER BY"}, {"clauses.Top", "false", "false", "false", null}, {"clauses.At", "false", "false", "false", null}, {"clauses.Window", "false", "false", "false", null}, {"joins.Cross", "false", "true", "true", "%1$s CROSS JOIN %2$s"}, {"joins.Inner", "false", "true", "true", "%1$s INNER JOIN %2$s ON %3$s"}, {"joins.LeftOuter", "false", "true", "true", "%1$s LEFT OUTER JOIN %2$s ON %3$s"}, {"joins.RightOuter", "false", "true", "true", "%1$s RIGHT OUTER JOIN %2$s ON %3$s"}, {"joins.FullOuter", "false", "true", "true", "%1$s FULL OUTER JOIN %2$s ON %3$s"}, {"operators.set.Intersect", "false", "true", "true", "%1$s INTERSECT %2$s"}, {"operators.set.Intersect.all", "false", "true", "true", "%1$s INTERSECT ALL %2$s"}, {"operators.set.Except", "false", "true", "true", "%1$s EXCEPT %2$s"}, {"operators.set.Except.all", "false", "true", "true", "%1$s EXCEPT ALL %2$s"}, {"operators.logical.And", "false", "true", "true", "%1$s AND %2$s"}, {"operators.logical.Or", "false", "true", "true", "%1$s OR %2$s"}, {"operators.logical.Not", "false", "true", "true", "NOT ( %1$s )"}, {"operators.arithmetic.Add", "false", "true", "true", "%1$s + %2$s"}, {"operators.arithmetic.Subtract", "false", "true", "true", "%1$s - %2$s"}, {"operators.arithmetic.Multiply", "false", "true", "true", "%1$s * %2$s"}, {"operators.arithmetic.Divide", "false", "true", "true", "%1$s / %2$s"}, {"operators.arithmetic.Negate", "false", "true", "true", "-%1$s"}, {"operators.arithmetic.UnaryPlus", "false", "true", "true", "+%1$s"}, {"operators.arithmetic.Concat", "false", "true", "true", "%1$s || %2$s"}, {"operators.groupBy.Rollup", "false", "false", "false", null}, {"operators.groupBy.Cube", "false", "false", "false", null}, {"operators.groupBy.GroupingSets", "false", "false", "false", null}, {"predicates.comparison.LessThan", "false", "true", "true", "%1$s < %2$s"}, {"predicates.comparison.LessThanOrEquals", "false", "true", "true", "%1$s <= %2$s"}, {"predicates.comparison.Equals", "false", "true", "true", "%1$s = %2$s"}, {"predicates.comparison.NotEquals", "false", "true", "true", "%1$s <> %2$s"}, {"predicates.comparison.GreaterThan", "false", "true", "true", "%1$s > %2$s"}, {"predicates.comparison.GreaterThanOrEquals", "false", "true", "true", "%1$s >= %2$s"}, {"predicates.Between", "false", "true", "true", "%1$s BETWEEN %2$s AND %3$s"}, {"predicates.In", "false", "true", "true", "%1$s IN ( %2$s )"}, {"predicates.Overlaps", "false", "false", "true", "(%1$s, %2$s) OVERLAPS (%3$s, %4$s)"}, {"predicates.IsNull", "false", "true", "true", "%1$s IS NULL"}, {"predicates.IsNotNull", "false", "true", "true", "%1$s IS NOT NULL"}, {"predicates.Like", "false", "true", "true", "%1$s LIKE %2$s"}, {"predicates.Like.escape", "false", "true", "true", "%1$s LIKE %2$s ESCAPE %3$s"}, {"predicates.LikeRegex", "false", "false", "false", null}, {"predicates.Similar", "false", "false", "false", null}, {"predicates.Similar.escape", "false", "false", "false", null}, {"predicates.Exists", "false", "true", "true", "EXISTS %1$s"}, {"predicates.All", "false", "true", "true", "ALL %1$s"}, {"predicates.Any", "false", "true", "true", "ANY %1$s"}, {"predicates.Some", "false", "true", "true", "SOME %1$s"}, {"predicates.IsDistinctFrom", "false", "false", "false", null}, {"predicates.IsNotDistinctFrom", "false", "false", "false", null}, {"expressions.SearchedCase", "false", "false", "true", "CASE"}, {"expressions.SimpleCase", "false", "false", "true", "CASE"}, {"expressions.NullIf", "false", "false", "true", "NULLIF(%1$s, %2$s)"}, {"expressions.Coalesce", "false", "false", "true", "COALESCE(%1$s)"}, {"expressions.Cast", "false", "false", "true", "CAST(%1$s AS %2$s)"}, {"expressions.Extract.YEAR", "false", "true", "true", "EXTRACT(YEAR FROM %1$s)"}, {"expressions.Extract.MONTH", "false", "true", "true", "EXTRACT(MONTH FROM %1$s)"}, {"expressions.Extract.DAY", "false", "true", "true", "EXTRACT(DAY FROM %1$s)"}, {"expressions.Extract.HOUR", "false", "true", "true", "EXTRACT(HOUR FROM %1$s)"}, {"expressions.Extract.MINUTE", "false", "true", "true", "EXTRACT(MINUTE FROM %1$s)"}, {"expressions.Extract.SECOND", "false", "true", "true", "EXTRACT(SECOND FROM %1$s)"}, {"expressions.Extract.TIMEZONE_HOUR", "false", "true", "true", "EXTRACT(TIMEZONE_HOUR FROM %1$s)"}, {"expressions.Extract.TIMEZONE_MINUTE", "false", "true", "true", "EXTRACT(TIMEZONE_MINUTE FROM %1$s)"}, {"expressions.Trim.BOTH[any]", "false", "true", "true", "TRIM(BOTH FROM %1$s)"}, {"expressions.Trim.LEADING[any]", "false", "true", "true", "TRIM(LEADING FROM %1$s)"}, {"expressions.Trim.TRAILING[any]", "false", "true", "true", "TRIM(TRAILING FROM %1$s)"}, {"expressions.Trim.BOTH[any,any]", "false", "true", "true", "TRIM(BOTH %1$s FROM %2$s)"}, {"expressions.Trim.LEADING[any,any]", "false", "true", "true", "TRIM(LEADING %1$s FROM %2$s)"}, {"expressions.Trim.TRAILING[any,any]", "false", "true", "true", "TRIM(TRAILING %1$s FROM %2$s)"}, {"aggregates.Max", "false", "true", "true", "MAX(%1$s)"}, {"aggregates.Min", "false", "true", "true", "MIN(%1$s)"}, {"aggregates.Sum[any]", "false", "true", "true", "SUM(%1$s)"}, {"aggregates.Avg[any]", "false", "true", "true", "AVG(%1$s)"}, {"aggregates.Count", "false", "true", "true", "COUNT(%1$s)"}, {"aggregates.CountStar", "false", "true", "true", "COUNT(*)"}, {"aggregates.Max.distinct", "false", "true", "true", "MAX(DISTINCT %1$s)"}, {"aggregates.Min.distinct", "false", "true", "true", "MIN(DISTINCT %1$s)"}, {"aggregates.Sum.distinct", "false", "true", "true", "SUM(DISTINCT %1$s)"}, {"aggregates.Avg.distinct", "false", "true", "true", "AVG(DISTINCT %1$s)"}, {"aggregates.Count.distinct", "false", "true", "true", "COUNT(DISTINCT %1$s)"}, {"functions.CharLength[any]", "false", "true", "true", "CHAR_LENGTH(%1$s)"}, {"functions.OctetLength[any]", "false", "true", "true", "OCTET_LENGTH(%1$s)"}, {"functions.BitLength[any]", "false", "false", "false", null}, {"functions.Upper[any]", "false", "false", "false", null}, {"functions.Lower[any]", "false", "false", "false", null}, {"functions.Substring[any,any]", "false", "true", "true", "SUBSTRING(%1$s FROM %2$s)"}, {"functions.Substring[any,any,any]", "false", "true", "true", "SUBSTRING(%1$s FROM %2$s FOR %3$s)"}, {"functions.Position[any,any]", "false", "false", "false", null}, {"functions.Index[any,any]", "false", "false", "false", null}, {"functions.Ascii[any]", "false", "false", "false", null}, {"functions.Translate[any,any]", "false", "false", "false", null}, {"functions.CurrentDate", "false", "false", "true", "CURRENT_DATE"}, {"functions.CurrentTime", "false", "false", "true", "CURRENT_TIME"}, {"functions.CurrentTimestamp", "false", "false", "true", "CURRENT_TIMESTAMP"}, {"functions.LocalTime", "false", "false", "false", null}, {"functions.LocalTimestamp", "false", "false", "false", null}, {"functions.CurrentTime[numeric]", "false", "false", "true", "CURRENT_TIME(%1$s)"}, {"functions.CurrentTimestamp[numeric]", "false", "false", "true", "CURRENT_TIMESTAMP(%1$s)"}, {"functions.LocalTime[numeric]", "false", "false", "false", null}, {"functions.LocalTimestamp[numeric]", "false", "false", "false", null}};

    public void setJDBCCapabilities(DatabaseMetaData metadata) {
        try {
            this.stringFunctions = metadata.getStringFunctions();
            this.numericFunctions = metadata.getNumericFunctions();
            this.addBooleanProperty("JDBC", true);
            this.addBooleanProperty("UseNativeSQLSyntax", false);
            this.properties.put("product.name", metadata.getDatabaseProductName());
            this.properties.put("product.version", metadata.getDatabaseProductVersion());
            this.properties.put("driver.name", metadata.getDriverName());
            this.properties.put("driver.version", metadata.getDriverVersion());
            this.properties.put("driver.majorVersion", String.valueOf(metadata.getDriverMajorVersion()));
            this.properties.put("driver.minorVersion", String.valueOf(metadata.getDriverMinorVersion()));
            this.properties.put("jdbc.majorVersion", String.valueOf(metadata.getJDBCMinorVersion()));
            this.properties.put("jdbc.minorVersion", String.valueOf(metadata.getJDBCMinorVersion()));
            this.properties.put("limits.maxBinaryLiteralLength", String.valueOf(metadata.getMaxBinaryLiteralLength()));
            this.properties.put("limits.maxCharLiteralLength", String.valueOf(metadata.getMaxCharLiteralLength()));
            this.properties.put("limits.maxColumnNameLength", String.valueOf(metadata.getMaxColumnNameLength()));
            this.properties.put("limits.maxColumnsInGroupBy", String.valueOf(metadata.getMaxColumnsInGroupBy()));
            this.properties.put("limits.maxColumnsInIndex", String.valueOf(metadata.getMaxColumnsInIndex()));
            this.properties.put("limits.maxColumnsInOrderBy", String.valueOf(metadata.getMaxColumnsInOrderBy()));
            this.properties.put("limits.maxColumnsInSelect", String.valueOf(metadata.getMaxColumnsInSelect()));
            this.properties.put("limits.maxColumnsInTable", String.valueOf(metadata.getMaxColumnsInTable()));
            this.properties.put("limits.maxConnections", String.valueOf(metadata.getMaxConnections()));
            this.properties.put("limits.maxCursorNameLength", String.valueOf(metadata.getMaxCursorNameLength()));
            this.properties.put("limits.maxIndexLength", String.valueOf(metadata.getMaxIndexLength()));
            this.properties.put("limits.maxSchemaNameLength", String.valueOf(metadata.getMaxSchemaNameLength()));
            this.properties.put("limits.maxProcedureNameLength", String.valueOf(metadata.getMaxProcedureNameLength()));
            this.properties.put("limits.maxCatalogNameLength", String.valueOf(metadata.getMaxCatalogNameLength()));
            this.properties.put("limits.maxRowSize", String.valueOf(metadata.getMaxRowSize()));
            this.properties.put("limits.maxStatementLength", String.valueOf(metadata.getMaxStatementLength()));
            this.properties.put("limits.maxStatements", String.valueOf(metadata.getMaxStatements()));
            this.properties.put("limits.maxTableNameLength", String.valueOf(metadata.getMaxTableNameLength()));
            this.properties.put("limits.maxTablesInSelect", String.valueOf(metadata.getMaxTablesInSelect()));
            this.properties.put("limits.maxUserNameLength", String.valueOf(metadata.getMaxUserNameLength()));
            this.properties.put("limits.defaultTransactionIsolation", String.valueOf(metadata.getDefaultTransactionIsolation()));
            this.addBooleanProperty("general.nullsAreSortedHigh", metadata.nullsAreSortedHigh());
            this.addBooleanProperty("general.nullsAreSortedLow", metadata.nullsAreSortedLow());
            this.addBooleanProperty("general.nullsAreSortedAtStart", metadata.nullsAreSortedAtStart());
            this.addBooleanProperty("general.nullsAreSortedAtEnd", metadata.nullsAreSortedAtEnd());
            this.addBooleanProperty("supports.columnAliasing", metadata.supportsColumnAliasing());
            this.addBooleanProperty("supports.tableCorrelationNames", metadata.supportsTableCorrelationNames());
            this.addBooleanProperty("supports.expressionsInOrderBy", metadata.supportsExpressionsInOrderBy());
            this.addBooleanProperty("supports.likeEscapeClause", metadata.supportsLikeEscapeClause());
            this.addBooleanProperty("supports.outerJoins", metadata.supportsOuterJoins());
            this.addBooleanProperty("supports.fullOuterJoins", metadata.supportsFullOuterJoins());
            this.addBooleanProperty("supports.limitedOuterJoins", metadata.supportsLimitedOuterJoins());
            this.addBooleanProperty("supports.subqueriesInComparisons", metadata.supportsSubqueriesInComparisons());
            this.addBooleanProperty("supports.subqueriesInExists", metadata.supportsSubqueriesInExists());
            this.addBooleanProperty("supports.subqueriesInIns", metadata.supportsSubqueriesInIns());
            this.addBooleanProperty("supports.subqueriesInQuantifieds", metadata.supportsSubqueriesInQuantifieds());
            this.addBooleanProperty("supports.correlatedSubqueries", metadata.supportsCorrelatedSubqueries());
            this.addBooleanProperty("supports.transactions", metadata.supportsTransactions());
            this.addBooleanProperty("supports.mixedCaseIdentifiers", metadata.supportsMixedCaseIdentifiers());
            this.addBooleanProperty("supports.mixedCaseQuotedIdentifiers", metadata.supportsMixedCaseQuotedIdentifiers());
            this.addBooleanProperty("supports.schemasInDataManipulation", metadata.supportsSchemasInDataManipulation());
            this.addBooleanProperty("supports.isolationLevelNone", metadata.supportsTransactionIsolationLevel(0));
            this.addBooleanProperty("supports.isolationLevelReadUncommitted", metadata.supportsTransactionIsolationLevel(1));
            this.addBooleanProperty("supports.isolationLevelReadCommitted", metadata.supportsTransactionIsolationLevel(2));
            this.addBooleanProperty("supports.isolationLevelRepeatableRead", metadata.supportsTransactionIsolationLevel(4));
            this.addBooleanProperty("supports.isolationLevelSerializable", metadata.supportsTransactionIsolationLevel(8));
            this.addBooleanProperty("supports.ansiSQL92_entry_level", metadata.supportsANSI92EntryLevelSQL());
            this.addBooleanProperty("supports.ansiSQL92_intermediate_level", metadata.supportsANSI92IntermediateSQL());
            this.addBooleanProperty("supports.ansiSQL92_fullSQL", metadata.supportsANSI92FullSQL());
            this.addBooleanProperty("supports.minimum_SQL_grammar", metadata.supportsMinimumSQLGrammar());
            this.addBooleanProperty("supports.core_SQL_grammar", metadata.supportsCoreSQLGrammar());
            this.addBooleanProperty("supports.extended_SQL_grammar", metadata.supportsExtendedSQLGrammar());
            this.addStringProperty("clauses.groupBy", "GROUP BY", metadata.supportsGroupBy());
            this.addStringProperty("operators.set.Union", "%1$s UNION %2$s", metadata.supportsUnion());
            this.addStringProperty("operators.set.Union.all", "%1$s UNION ALL %2$s", metadata.supportsUnionAll());
            this.properties.put("delimiters.identifierQuoteString", metadata.getIdentifierQuoteString());
            this.properties.put("delimiters.catalogSeparator", metadata.getCatalogSeparator());
            this.properties.put("delimiters.searchStringEscape", metadata.getSearchStringEscape());
        }
        catch (SQLException e) {
            mErrorLogger.log(e);
        }
    }

    public void setDefaultCapabilities(DatabaseMetaData metadata) {
        try {
            if (metadata.supportsANSI92IntermediateSQL()) {
                this.setANSI92SQLProperties(metadata, 3);
            } else if (metadata.supportsANSI92EntryLevelSQL()) {
                this.setANSI92SQLProperties(metadata, 2);
            } else {
                this.setANSI92SQLProperties(metadata, 1);
            }
        }
        catch (SQLException e) {
            mErrorLogger.log(e);
        }
    }

    protected void setANSI92SQLProperties(DatabaseMetaData metadata, int level) {
        int indx;
        for (indx = 0; indx < DB_CAPABILITIES_BOOLEAN.length; ++indx) {
            if (DB_CAPABILITIES_BOOLEAN[indx][level].equals(TRUE_STRING)) {
                this.addBooleanProperty(DB_CAPABILITIES_BOOLEAN[indx][0], true);
                continue;
            }
            this.addBooleanProperty(DB_CAPABILITIES_BOOLEAN[indx][0], false);
        }
        for (indx = 0; indx < DB_CAPABILITIES_STRING.length; ++indx) {
            if (DB_CAPABILITIES_STRING[indx][level].equals(TRUE_STRING)) {
                this.properties.put(DB_CAPABILITIES_STRING[indx][0], DB_CAPABILITIES_STRING[indx][4]);
                continue;
            }
            this.properties.put(DB_CAPABILITIES_STRING[indx][0], null);
        }
    }

    protected void setDatatypesProperties(DatabaseMetaData metadata) {
        boolean ncharSupport = false;
        boolean nvarcharSupport = false;
        try {
            ResultSet rs = metadata.getTypeInfo();
            while (rs.next()) {
                int dataType = rs.getInt(2);
                switch (dataType) {
                    case -15: {
                        ncharSupport = true;
                        break;
                    }
                    case -9: {
                        nvarcharSupport = true;
                        break;
                    }
                }
            }
            rs.close();
            if (!ncharSupport) {
                this.addBooleanProperty("dataType.nchar", false);
            }
            if (!nvarcharSupport) {
                this.addBooleanProperty("dataType.nvarchar", false);
            }
        }
        catch (SQLException e) {
            mErrorLogger.log(e);
        }
    }

    protected void addStringProperty(String key, String value, boolean isSupport) {
        if (isSupport) {
            this.properties.put(key, value);
        } else {
            this.properties.put(key, "");
        }
    }

    protected void addBooleanProperty(String key, boolean isSupport) {
        if (isSupport) {
            this.properties.put(key, TRUE_STRING);
        } else {
            this.properties.put(key, FALSE_STRING);
        }
    }

    protected void addPropertyDirect(String key, Object obj) {
        this.properties.put(key, obj);
    }

    protected void clearPropertyDirect(String key) {
        this.properties.remove(key);
    }

    protected boolean containsKeyInternal(String key) {
        return this.properties.containsKey(key);
    }

    protected Object getPropertyInternal(String key) {
        return this.properties.get(key);
    }

    protected Iterator<String> getKeysInternal() {
        return this.properties.keySet().iterator();
    }

    protected boolean isEmptyInternal() {
        return this.properties.isEmpty();
    }

    public String getStringFunctions() {
        return this.stringFunctions;
    }

    public String getNumericFunctions() {
        return this.numericFunctions;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("\n");
        Set<String> keySet = this.properties.keySet();
        Iterator<String> it = keySet.iterator();
        buffer.append('\n');
        while (it.hasNext()) {
            String key = it.next();
            buffer.append(String.format("%s=%s%n", key, this.properties.get(key)));
        }
        return buffer.toString();
    }
}

