/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.jdbc;

import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogTypedLogger;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLIdentifier;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.bibushandler.Commands;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.datasource.DelegatedCredentialSignon;
import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.collators.CollatorPoolFactory;
import com.cognos.xqe.data.model.CapabilitiesKey;
import com.cognos.xqe.data.model.CapabilitiesKeyParts;
import com.cognos.xqe.data.model.IApiTokenSignon;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.IDataSourceConnectionCommandBlock;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.model.IOIDCSignon;
import com.cognos.xqe.data.model.IUsernamePasswordSignon;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.providers.IDataProvider;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.connection.ConnectionStringParser;
import com.cognos.xqe.data.providers.relational.AbstractConnection;
import com.cognos.xqe.data.providers.relational.IRelationalConnection;
import com.cognos.xqe.data.providers.relational.SQLQueryArguments;
import com.cognos.xqe.data.providers.relational.TraceRelationalDataProvider;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCConfiguration;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCDataProvider;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCException;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCIsolationLevel;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCLog;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCTabularResult;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCTraceStreamHandler;
import com.cognos.xqe.data.providers.relational.jdbc.XQEConnectionWrapper;
import com.cognos.xqe.data.providers.relational.jdbc.XQEDriverWrapper;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntervalQualifier;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.XmlValue;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.exception.XQEUnrecoverableConnectionException;
import com.cognos.xqe.hooks.HookEnvironment;
import com.cognos.xqe.hooks.HookEvent;
import com.cognos.xqe.hooks.HookManager;
import com.cognos.xqe.pool.connection.IInstrumentedPooledConnection;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.IColumnInfo;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.caching.CachedResultSet;
import com.cognos.xqe.resultsets.caching.CachedResultSetManager;
import com.cognos.xqe.resultsets.tabular.RowsetInfo;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.XSql;
import com.cognos.xqe.security.IEncryptedObject;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.appender.XQEIPFAppender;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.transformation.relational.binding.exceptions.BindNativeSQLException;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.KerberosConnectionHelper;
import com.cognos.xqe.util.Timer;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.usage.UsageTrackingService;
import com.cognos.xqe.util.usage.indicators.IUsageIndicator;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorCategory;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorType;
import com.cognos.xqebifw.bibushandler.datasource.JCAMImpersonator;
import com.ibm.cognos.jdbc.adaptor.ConnectionFactory;
import com.ibm.cognos.jdbc.adaptor.IAdaptorConnection;
import com.ibm.cognos.jdbc.adaptor.sqlexception.SQLCognosInvalidLogonException;
import com.ibm.cognos.jdbc.adaptor.sqlexception.SQLCognosUnrecoverableConnectionException;
import com.ibm.cognos.jdbc.adaptor.util.UncertifiedAdaptorException;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.net.URL;
import java.security.PrivilegedAction;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.SimpleFormatter;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.configuration2.AbstractConfiguration;

public class JDBCConnection
extends AbstractConnection
implements IInstrumentedPooledConnection,
IRelationalConnection {
    private static final String STR_BYTES = " bytes";
    private static final String STR_KB = " KB";
    private static final String JAAS_NOSSO_LOGIN_CONFIGURATION = "com.cognos.biserver.security.xqe.jdbc";
    public static final String JAVA_KRB5 = "java_krb5";
    public static final String IBMCOGNOS_AUTHENTICATION = "ibmcognos.authentication";
    public static final String IBMCOGNOS_AUTHENTICATION_JAVA_KRB5 = "ibmcognos.authentication=java_krb5";
    public static final String IBMCOGNOS_MAX_VARCHAR_SIZE = "ibmcognos.maxvarcharsize";
    private static final String CAMID_PREFIX = "CAMID(\"";
    private static final String CAMID_SUFFIX = "\")";
    private static final String OIDC_SUPPORTED = "oidc.supported";
    public static final String IBMCOGNOS_MAXROWSRETRIEVED = "ibmcognos.maxRowsRetrieved";
    public static final String[] OIDC_CONN_STRIGN_PARAMETERS = new String[]{"oidc.supported"};
    public static final Set<String> ALLOWED_OIDC_CONN_STRIGN_PARAMETERS = new HashSet<String>(Arrays.asList(OIDC_CONN_STRIGN_PARAMETERS));
    private static final String OIDC_NAMESPACE = "oidc.namespace";
    private static final String OIDC_ACCESS_TOKEN = "oidc.atoken";
    private static final String OIDC_ID_TOKEN = "oidc.idtoken";
    private static final String TRUE = "TRUE";
    private static final String TRANSFORMUID_CLASSIC = "@TRANSFORMUID=TRUE";
    private static final String TRANSFORMUID = "@TRANSFORMUID";
    private static final String FETCHBUFFERSIZE = "ibmcognos.fetchBufferSize";
    private static final String IBMCOGNOS_QUALIFIERLIST = "ibmcognos.qualifier_list";
    private static final String IBMCOGNOS_CASTTONVARCHAR = "ibmcognos.castToNationalVarchar";
    private static final String BACKSLASH = "\\";
    private static final String ATCHAR = "@";
    private static final String DATABASE_CHARSET_NAME = "databaseCharSetName";
    public static final String DATABASE_COLLATION_SEQUENCE_NAME = "databaseCollationSequenceName";
    public static final String CONNECTION_COLLATION_SEQUENCE_NAME = "connectionCollationSequenceName";
    public static final String DATASOURCE_TYPES_FORMAT = "datasource.type.%1$s";
    public static final String DATASOURCE_SPLIT_FORMAT = "datasource.type.%1$s.separator";
    public static final String DATASOURCE_MAPPING_FORMAT = "datasource.type.%1$s.mapping";
    public static final String ADAPTOR_FACTORY_PROP = "adaptor.factory";
    protected static final String CONNECTION_SIGNON = "signon";
    private static final String LOADED_JDBC_DRIVER = "Loaded JDBC driver [%1$s]";
    private static final String DRIVER_BLACKLISTED = "Driver (%s) version %s blacklisted as specified by %s.";
    private static final String SERVER_BLACKLISTED = "Database %s version %s at (%s) blacklisted as specified by %s.";
    private static final String DRIVER_GREYLISTED = "Driver (%s) version %s greylisted (to be deprecated) as specified by %s. ";
    private static final String SERVER_GREYLISTED = "Database %s version %s at (%s) greylisted (to be deprecated) as specified by %s.";
    protected static final String COMMAND_BLOCK_EXECUTION_COMPLETED = "[%1$x] Command block execution completed.";
    protected static final String COMMAND_BLOCK_EXECUTION_STARTED = "[%1$x] Command block execution started [%2$s].";
    protected static final String USER_ID_REQUIRED_MARKER = "^User ID:";
    protected static final String PASSWORD_REQUIRED_MARKER = "^?Password:";
    protected static final String PARAMETER_BINDING_LOG_STR = "Parameter binding: position = %1$d, sqltype = %2$d, value = %3$s";
    protected static final String PASSWORD_CONNECTION_PROP = "password";
    protected static final String USER_CONNECTION_PROP = "user";
    protected static final String AUTHKEY_CONNECTION_PROP = "authKey";
    protected static final String SECRETKEY_CONNECTION_PROP = "secretKey";
    protected String url;
    protected Driver driver;
    protected String userId;
    protected String password;
    protected String authKey = null;
    protected String secretKey = null;
    protected boolean passwordRequired = false;
    protected boolean useridRequired = true;
    protected IAdaptorConnection connection;
    protected final Properties connectionProps = new Properties();
    protected String cryptoHandle = null;
    public static final String ENCRYPTED_SIGNON_STRING = "encryptedSignon";
    public static final String LOCALSORT = "LOCALSORT";
    private static final String LEVEL = "LEVEL";
    private static final String CONNECTION_STRING_DELIMETER = "IBM_JD_CNX_STR:";
    public static final String COLON = ":";
    public static final String DOT = ".";
    protected static final String QUESTIONMARK = "?";
    protected static final String VERSION_FORMAT = "%1$d.%2$d";
    private static final int MIN_FETCH_BUFFER_SIZE = 10240;
    private static final int MAX_FETCH_BUFFER_SIZE = 0xA00000;
    private static int defaultFetchBufferSize;
    private static final int ONE_HUNDRED = 100;
    private static final int KILO = 1024;
    private static final int DEFAULT_FETCH_BUFFER_SIZE = 102400;
    private static final int DEFAULT_ALLROWS_FETCH_BUFFER_SIZE = 0x200000;
    private static final int MAX_FETCH_BUFFER_CONFIG = 0x1FFFFF;
    private static final XQELogger CMD_BLOCK_CACHE_LOGGER;
    private static final int FETCH_SIZE = 100;
    private static final int MIN_FETCH_SIZE = 10;
    private static final int MAX_FETCH_SIZE = 25600;
    private String databaseProductName = null;
    private String databaseProductVersion = null;
    private String subtype = null;
    private String jdbcDriverName = null;
    private String jdbcDriverVersion = null;
    private long elapsedTime;
    private String jdbcTraceFileName = null;
    private int fetchBufferSize = -1;
    private int maxVarCharSize = -1;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private HashMap<String, AbstractConfiguration> configs = new HashMap();
    private String mOIDCIdToken = null;
    private IEncryptedObject<String> mOIDCAccessToken = null;
    private String mOIDCNamespaceName = null;
    protected String connectionString;
    private String connectionStringNoSignon;
    private String jdbcCnxString;
    private String driverName;
    private String driverVersion;
    private IDataSourceCapabilities capabilities;
    private List<IDataSourceConnectionCommandBlock> openSessionCommandBlocks = null;
    private List<IDataSourceConnectionCommandBlock> closeSessionCommandBlocks = null;
    private boolean sessionIsOpen = false;
    private boolean configDeferCloseSession = true;
    private List<IDataSourceConnectionCommandBlock> closeConnectionCommandBlocks = null;
    private int maxStatements;
    private int nActiveStatements;
    private CachedResultSetManager cacheMgr;
    private boolean allowUnsupportedJDBCDatasourceVersions;
    private boolean allowDeprecatedJDBCDatasourceVersions;
    protected Boolean userSwitched = false;
    private boolean localTransformUid = false;
    private boolean isKerberized = false;
    private List<String> qualifierList = null;
    private boolean castToNvarchar = false;
    private long maxRowsRetrieved = 0L;

    public JDBCConnection(IDataSource dataSource) {
        super(dataSource);
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        boolean cachingEnabled = config.getBooleanProperty("general.cacheResultSets[@enabled]", true);
        int memory = config.getIntProperty("general.cacheResultSets[@maxMemory]", 64);
        int threshold = config.getIntProperty("general.cacheResultSets[@threshold]", 10);
        this.allowUnsupportedJDBCDatasourceVersions = config.getBooleanProperty("general.allowUnsupportedJDBCDatasourceVersions", false);
        this.allowDeprecatedJDBCDatasourceVersions = config.getBooleanProperty("general.allowDeprecatedJDBCDatasourceVersions", true);
        XQELogger infoLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "CacheManager", LogLevel.INFO);
        if (this.allowUnsupportedJDBCDatasourceVersions) {
            infoLogger.log("Override to allow unsupported JDBC datasource versions detected.");
        }
        this.cacheMgr = new CachedResultSetManager(cachingEnabled, memory, threshold);
        if (cachingEnabled) {
            infoLogger.log(String.format("Native result set caching is enabled [maxMemory=%1$d, threshold=%2$d].", memory, threshold));
        } else {
            infoLogger.log(String.format("Native result set caching is disabled.", new Object[0]));
        }
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public String getConnectionString() {
        return this.connectionString;
    }

    public String getConnectionStringNoSignon() {
        return this.connectionStringNoSignon;
    }

    public String getJdbcConnectionString() {
        return this.jdbcCnxString;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getDriverClassName() {
        return this.driverName;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public IDataSourceCapabilities getCapabilities() {
        return this.capabilities;
    }

    @Override
    public String getConnectionCollationSequence() {
        return (String)this.getProperty(CONNECTION_COLLATION_SEQUENCE_NAME);
    }

    @Override
    public String getDatabaseCollationSequence() {
        return (String)this.getProperty(DATABASE_COLLATION_SEQUENCE_NAME);
    }

    private void setDatabaseCollationSequence(String collationName) {
        this.setProperty(DATABASE_COLLATION_SEQUENCE_NAME, collationName);
    }

    public void setCurrentJDBCTraceFileName(String jdbcTraceFName) {
        this.jdbcTraceFileName = jdbcTraceFName;
    }

    public String getCurrentJDBCTraceFileName() {
        return this.jdbcTraceFileName;
    }

    public void parseConnectionString(String inConnectionString) throws JDBCException {
        String[] ibmCognosProperties;
        String theConnectionString = null;
        this.jdbcCnxString = null;
        IDataSourceConnection dsConnection = this.dataSource.getDataSourceConnection();
        ArrayList<IXQEQueryNode> messageContext = new ArrayList<IXQEQueryNode>();
        if (inConnectionString.contains(CONNECTION_STRING_DELIMETER)) {
            String[] tokens = inConnectionString.split(CONNECTION_STRING_DELIMETER);
            if (tokens.length < 2) {
                XQEMessage message = new XQEMessage(XQEMessageKeys.JDB_BadConnectionString, this.dataSource.getCMDataSourceName(), this.dataSource.getDataSourceConnection().getName(), messageContext);
                throw new XQERuntimeException(message);
            }
            theConnectionString = tokens[1];
        } else {
            theConnectionString = inConnectionString;
        }
        if (!theConnectionString.contains("URL=jdbc:")) {
            XQEMessage message = new XQEMessage(XQEMessageKeys.JDB_BadConnectionString, this.dataSource.getCMDataSourceName(), this.dataSource.getDataSourceConnection().getName(), messageContext);
            throw new XQERuntimeException(message);
        }
        this.jdbcCnxString = theConnectionString;
        if (null == this.jdbcCnxString) {
            LogonFailureException logonFailureExceptione = new LogonFailureException(LogonFailureException.SubCodeEnum.INVALID_CONN_STRING);
            logonFailureExceptione.setDataSource(this.dataSource);
            throw logonFailureExceptione;
        }
        if (this.jdbcCnxString.contains(TRANSFORMUID_CLASSIC)) {
            this.localTransformUid = true;
            this.jdbcCnxString = this.jdbcCnxString.replace(TRANSFORMUID_CLASSIC, "");
        }
        if (this.jdbcCnxString.contains(PASSWORD_REQUIRED_MARKER)) {
            this.passwordRequired = true;
        }
        if (!this.jdbcCnxString.contains(USER_ID_REQUIRED_MARKER)) {
            this.useridRequired = false;
        }
        String driverSplitter = ";DRIVER_NAME=";
        String[] tokens = this.jdbcCnxString.split(";DRIVER_NAME=");
        if (tokens.length != 2) {
            throw new XQERuntimeException(XQEMessageKeys.DAT_InvalidConnectionString, ";DRIVER_NAME=");
        }
        this.url = tokens[0].substring(tokens[0].indexOf("jdbc:"));
        String semicolon = ";";
        for (String property : ibmCognosProperties = new String[]{IBMCOGNOS_AUTHENTICATION, IBMCOGNOS_AUTHENTICATION_JAVA_KRB5, IBMCOGNOS_MAX_VARCHAR_SIZE, FETCHBUFFERSIZE, IBMCOGNOS_QUALIFIERLIST, IBMCOGNOS_CASTTONVARCHAR, IBMCOGNOS_MAXROWSRETRIEVED}) {
            if (!this.url.toLowerCase().contains(property.toLowerCase())) continue;
            String nonModifiedUrl = this.url = this.url.endsWith(";") ? this.url : this.url + ";";
            int indexProperty = this.url.toLowerCase().indexOf(property.toLowerCase());
            String urlAfterProperty = this.url.substring(this.url.indexOf(";", indexProperty), this.url.length());
            if (urlAfterProperty.startsWith(";")) {
                urlAfterProperty = urlAfterProperty.substring(1);
            }
            tokens[1] = tokens[1] + ";" + nonModifiedUrl.substring(indexProperty, this.url.indexOf(";", indexProperty));
            this.url = this.url.substring(0, indexProperty) + urlAfterProperty;
            this.url = this.url.endsWith(COLON) ? this.url.substring(0, this.url.length() - 1) : (this.url.endsWith(";") ? this.url : this.url + ";");
        }
        String[] parts = tokens[1].split(";");
        this.driverName = parts[0];
        if (parts.length >= 2) {
            String collationName = null;
            String level = null;
            for (int i = 1; i < parts.length; ++i) {
                String msg;
                XQELogger errorLogger;
                String[] params = parts[i].split("=");
                if (params.length <= 1) continue;
                params[0] = params[0].trim();
                if (LOCALSORT.equalsIgnoreCase(params[0])) {
                    collationName = params[1];
                    continue;
                }
                if (LEVEL.equalsIgnoreCase(params[0])) {
                    level = params[1];
                    continue;
                }
                if (TRANSFORMUID.equalsIgnoreCase(params[0])) {
                    if (!TRUE.equalsIgnoreCase(params[1])) continue;
                    this.localTransformUid = true;
                    continue;
                }
                if (FETCHBUFFERSIZE.equalsIgnoreCase(params[0])) {
                    this.fetchBufferSize = Integer.parseInt(params[1]);
                    continue;
                }
                if (IBMCOGNOS_MAX_VARCHAR_SIZE.equalsIgnoreCase(params[0])) {
                    try {
                        this.maxVarCharSize = Integer.parseInt(params[1]);
                    }
                    catch (NumberFormatException ex) {
                        errorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
                        msg = "The database connection property 'ibmcognos.maxvarcharsize' was not given a valid integer value. It will be ignored.";
                        errorLogger.log(LogLevel.ERROR, msg);
                        this.maxVarCharSize = -1;
                    }
                    continue;
                }
                if (IBMCOGNOS_QUALIFIERLIST.equalsIgnoreCase(params[0])) {
                    this.qualifierList = Arrays.asList(params[1].trim().split("\\s*,\\s*"));
                    continue;
                }
                if (IBMCOGNOS_CASTTONVARCHAR.equalsIgnoreCase(params[0])) {
                    if (!TRUE.equalsIgnoreCase(params[1])) continue;
                    this.castToNvarchar = true;
                    continue;
                }
                if (IBMCOGNOS_MAXROWSRETRIEVED.equalsIgnoreCase(params[0])) {
                    try {
                        this.maxRowsRetrieved = Long.parseLong(params[1]);
                    }
                    catch (NumberFormatException ex) {
                        errorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
                        msg = "The database connection property 'ibmcognos.maxRowsRetrieved' was not given a valid long value. It will be ignored.";
                        errorLogger.log(LogLevel.ERROR, msg);
                        this.maxRowsRetrieved = 0L;
                    }
                    continue;
                }
                this.connectionProps.setProperty(params[0], params[1]);
            }
            if (collationName != null) {
                if (level != null) {
                    String collationFullName = collationName + COLON + CollatorPoolFactory.getCollationLevel(level);
                    dsConnection.setConnectionParameter(LOCALSORT, collationFullName);
                } else {
                    dsConnection.setConnectionParameter(LOCALSORT, collationName);
                }
            }
        }
        if (theConnectionString.contains("IBMCOGNOS_SG_DEST")) {
            ExecutionEnvironment env = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
            if (env == null) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
            }
            this.connectionProps.setProperty("IBMCOGNOS_PASSPORT", ((RequestEnvironment)env.getRequestEnvironment()).getCAMPassport());
        }
        Map<String, String> oidcConnectionParams = ConnectionStringParser.parse(this.connectionString, ALLOWED_OIDC_CONN_STRIGN_PARAMETERS);
        for (Map.Entry<String, String> entry : oidcConnectionParams.entrySet()) {
            if (!ALLOWED_OIDC_CONN_STRIGN_PARAMETERS.contains(entry.getKey())) continue;
            this.connectionProps.setProperty(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void driverConnect(Locale runLocale) throws JDBCException {
        if (UsageTrackingService.isEnabled()) {
            Timer timer = new Timer();
            timer.start();
            try {
                this.driverConnect();
            }
            finally {
                timer.stop();
                IUsageIndicator indicatorForConnectTime = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.JDBC_CONNECT_TIME, this.url);
                if (indicatorForConnectTime != null) {
                    indicatorForConnectTime.add(timer.getElapsedTimeInMilliseconds());
                }
            }
        } else {
            this.driverConnect();
        }
        IUsageIndicator indicator = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.JDBC_CONNECTIONS_ESTABLISHED, this.url);
        if (indicator != null) {
            indicator.add(1L);
        }
    }

    private void driverConnect() throws JDBCException {
        this.setConnectionProperties();
        Driver d = this.driver;
        try {
            boolean isWrapped = this.driver instanceof XQEDriverWrapper;
            if (isWrapped) {
                d = ((XQEDriverWrapper)this.driver).getRawDriver();
            }
            this.connection = (IAdaptorConnection)ConnectionFactory.createAndWrapConnection((Driver)d, (String)this.url, (Properties)this.connectionProps, (boolean)false);
            if (this.jdbcTraceFileName != null) {
                try {
                    FileOutputStream fStream = new FileOutputStream(this.jdbcTraceFileName, true);
                    this.connection.startTrace((Handler)new JDBCTraceStreamHandler(fStream, (Formatter)new SimpleFormatter()), true, ".*");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if (isWrapped) {
                this.connection = new XQEConnectionWrapper(this.connection);
            }
        }
        catch (UnsupportedOperationException uop) {
            JDBCLog.getLogger(LogLevel.ERROR).log(String.format(uop.toString() + " JDBC driver [%1$s].", this.driverName));
            throw new XQERuntimeException(XQEMessageKeys.DS_DataSourceLogonFailureCauseByBadDriver, (Throwable)uop, (Object)this.driverName, (Object)uop.toString());
        }
        catch (UncertifiedAdaptorException uae) {
            JDBCLog.getLogger(LogLevel.ERROR).log(String.format("Uncertified driver: " + d.getClass().toString(), new Object[0]));
            throw new JDBCException(XQEMessageKeys.JDB_UncertifiedAdaptor, uae, d.getClass().toString());
        }
        catch (SQLException e) {
            JDBCLog.getLogger(LogLevel.ERROR).log(String.format("Connection failed: " + e.toString(), new Object[0]));
            this.mapConnectionException(e);
        }
        catch (Exception e) {
            JDBCLog.getLogger(LogLevel.ERROR).log(String.format("Unexpected error from the JDBC driver [%1$s]: " + e.toString(), this.driverName));
            throw new XQERuntimeException(XQEMessageKeys.DS_DataSourceLogonFailureCauseByBadDriver, (Throwable)e, (Object)this.driverName, (Object)e.toString());
        }
    }

    protected void setConnectionProperties() {
        if (!this.isKerberized && null == this.mOIDCAccessToken) {
            if (this.userId != null) {
                this.connectionProps.put(USER_CONNECTION_PROP, this.userId);
            }
            if (this.password != null && this.passwordRequired) {
                this.connectionProps.put(PASSWORD_CONNECTION_PROP, this.password);
            }
        }
    }

    @Override
    public void connect(Locale runLocale) throws JDBCException {
        String encryptedSignon;
        long startTime = System.currentTimeMillis();
        IDataSourceConnection dsConnection = this.dataSource.getDataSourceConnection();
        IDataSourceConnectionSignon dsConnectionSignon = dsConnection.getSignon();
        this.connectionString = dsConnection.getConnectionString(dsConnectionSignon);
        this.connectionStringNoSignon = dsConnection.getConnectionString(null);
        this.userId = null;
        this.password = null;
        try {
            try {
                this.parseConnectionString(this.connectionString);
            }
            catch (JDBCException e) {
                JDBCLog.getLogger(LogLevel.ERROR).log(e);
                throw e;
            }
            if (dsConnectionSignon != null && dsConnectionSignon instanceof IUsernamePasswordSignon) {
                this.userId = ((IUsernamePasswordSignon)dsConnectionSignon).getUserName();
                if (this.isTransformUid()) {
                    String[] parts;
                    if (this.userId.contains(BACKSLASH)) {
                        parts = this.userId.split("\\\\");
                        JDBCLog.getLogger(LogLevel.INFO).log(String.format("Removed domain name from domain\\user_Id" + this.userId, new Object[0]));
                        this.userId = parts[1];
                    }
                    if (this.userId.contains(ATCHAR)) {
                        parts = this.userId.split(ATCHAR);
                        JDBCLog.getLogger(LogLevel.INFO).log(String.format("Removed domain name from user_Id@domain" + this.userId, new Object[0]));
                        this.userId = parts[0];
                    }
                }
                if (((IUsernamePasswordSignon)dsConnectionSignon).getPassword() != null) {
                    this.password = ((IUsernamePasswordSignon)dsConnectionSignon).getPassword().decrypt();
                    String signonName = ((IUsernamePasswordSignon)dsConnectionSignon).getName();
                    if (signonName == "V5Credential" || signonName == "DataSourceCredential") {
                        this.passwordRequired = true;
                    }
                }
            }
            if (dsConnectionSignon != null && dsConnectionSignon instanceof IApiTokenSignon) {
                if (((IApiTokenSignon)dsConnectionSignon).getAuthKey() != null) {
                    this.authKey = ((IApiTokenSignon)dsConnectionSignon).getAuthKey().decrypt();
                }
                if (((IApiTokenSignon)dsConnectionSignon).getSecretKey() != null) {
                    this.secretKey = ((IApiTokenSignon)dsConnectionSignon).getSecretKey().decrypt();
                }
            }
            if (dsConnectionSignon != null && dsConnectionSignon.getType() == IDataSourceConnectionSignon.SignonType.OIDC) {
                IOIDCSignon oidcSignon = (IOIDCSignon)dsConnectionSignon;
                this.setOIDCAccessToken(oidcSignon.getAccessToken());
                this.setOIDCIdToken(oidcSignon.getIdToken().decrypt());
                this.mOIDCNamespaceName = JDBCConnection.getNameSpaceName(dsConnection);
                if (null == this.mOIDCNamespaceName) {
                    throw new JDBCException(XQEMessageKeys.JDB_InvalidDriver, this.url, this.driverName);
                }
            }
            try {
                if (JDBCLog.getLogger(LogLevel.INFO).isOn() || UsageTrackingService.isEnabled()) {
                    this.driver = new XQEDriverWrapper(this.driverName);
                } else {
                    this.driver = (Driver)Class.forName(this.driverName).newInstance();
                    JDBCLog.getLogger(LogLevel.INFO).log(String.format(LOADED_JDBC_DRIVER, this.driverName));
                }
            }
            catch (Exception e) {
                JDBCLog.getLogger(LogLevel.ERROR).log(String.format("Failed to load JDBC driver [%1$s]", this.driverName));
                throw new JDBCException(XQEMessageKeys.JDB_ClassLoadProblem, e, this.driverName);
            }
            if (this.driver == null) {
                JDBCLog.getLogger(LogLevel.ERROR).log(String.format("Cannot load JDBC driver [%1$s]", this.driverName));
                throw new JDBCException(XQEMessageKeys.JDB_CannotLoadDriver);
            }
            if (!JDBCConnection.checkLoadLocation(this.driver)) {
                throw new JDBCException(XQEMessageKeys.JDB_IncorrectDriverLocation);
            }
            this.driverVersion = String.format(VERSION_FORMAT, this.driver.getMajorVersion(), this.driver.getMinorVersion());
            this.connectWithAuthentication(runLocale);
            if (this.connection == null) {
                JDBCLog.getLogger(LogLevel.ERROR).log(String.format("JDBC driver returned an invalid connection object", new Object[0]));
                throw new JDBCException(XQEMessageKeys.JDB_InvalidDriver, this.url, this.driverName);
            }
            this.jdbcDriverName = this.connection.getMetaData().getDriverName();
            this.jdbcDriverVersion = this.connection.getMetaData().getDriverVersion();
            this.checkConnectionBlacklist();
            ExecutionEnvironment env = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
            if (env == null) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
            }
            RequestEnvironment reqEnv = (RequestEnvironment)env.getRequestEnvironment();
            if (!reqEnv.getMacroInCommandBlocks()) {
                this.updateConnection(Commands.CMD_OPEN_CONNECTION);
            }
            if (this.qualifierList != null && this.qualifierList.size() != 0) {
                this.connection.setQualifierList(this.qualifierList);
            }
        }
        catch (SQLException e) {
            JDBCLog.getLogger(LogLevel.ERROR).log(String.format("Driver.connect('%1$s') failed - connection cannot be established: ", e));
            throw new JDBCException(XQEMessageKeys.JDB_ConnectionProblem);
        }
        try {
            DatabaseMetaData metadata = this.connection.getMetaData();
            try {
                this.databaseProductName = metadata.getDatabaseProductName();
                this.databaseProductVersion = metadata.getDatabaseProductVersion();
            }
            catch (Exception e) {
                JDBCLog.getLogger(LogLevel.WARN).log("Fail to call metadata getDatabaseProductName or getDatabaseProductVersion.");
            }
            String version = new String();
            this.subtype = new String();
            try {
                String subminorVersion = this.getSubminorVersion();
                version = subminorVersion != null ? this.getVersion(metadata) + '.' + this.getSubminorVersion() : this.getVersion(metadata);
            }
            catch (Exception e) {
                JDBCLog.getLogger(LogLevel.WARN).log("Failed to get db version from metadata, hence loading sub-optimal default properties. " + e.toString());
            }
            try {
                this.subtype = this.getSubtype(metadata);
            }
            catch (SQLException e) {
                JDBCLog.getLogger(LogLevel.WARN).log("Failed to get subType from metadata");
            }
            if (this.capabilities == null) {
                this.capabilities = ProviderCapabilites.getInstance().getCapabilities(new CapabilitiesKey(null, null, null, this.connectionStringNoSignon));
                if (this.capabilities != null && JDBCLog.isOn(LogLevel.INFO)) {
                    JDBCLog.getLogger(LogLevel.INFO).log(String.format("Loaded capabilities from cache with key [%1$s], CMDS=%2$s", this.connectionStringNoSignon, this.dataSource.getCMDataSourceName()));
                }
            }
            if (this.capabilities == null) {
                String dataSourceTypeOverride = null;
                boolean isGenericJDBC = false;
                JDBCLog.getLogger(LogLevel.INFO).log("Loading database capabilities reported by metadata calls");
                JDBCConfiguration defaultConfig = new JDBCConfiguration();
                defaultConfig.setJDBCCapabilities(metadata);
                if (this.dataSource.getType().equalsIgnoreCase("D2") && this.subtype != null && this.subtype.equalsIgnoreCase("SQL")) {
                    defaultConfig.setDatatypesProperties(metadata);
                }
                JDBCLog.getLogger(LogLevel.INFO).log(defaultConfig.toString());
                this.configs.put("JDBC.metadata", defaultConfig);
                if (DataSourceTypeEnum.isGenericJDBC(this.dataSource.getType())) {
                    dataSourceTypeOverride = "qsq".equalsIgnoreCase(this.subtype) || "bigsql".equalsIgnoreCase(this.subtype) ? "db2" : this.getDataSourceTypeOverride();
                    isGenericJDBC = true;
                }
                CapabilitiesKeyParts parts = new CapabilitiesKeyParts(dataSourceTypeOverride, this.subtype, version, this.driverName, this.driverVersion, this.connectionStringNoSignon);
                parts.setGenericJDBC(isGenericJDBC);
                this.capabilities = this.dataSource.createCapabilities(parts, this.configs);
                if (JDBCLog.isOn(LogLevel.INFO)) {
                    JDBCLog.getLogger(LogLevel.INFO).log(String.format("Loaded capabilities using full key set [%1$s (%2$s) %3$s, %4$s %5$s, %6$s], CMDS=%7$s", dataSourceTypeOverride, this.subtype, version, this.driverName, this.driverVersion, this.connectionStringNoSignon, this.dataSource.getCMDataSourceName()));
                }
            } else {
                this.dataSource.setCapabilities(this.capabilities);
                this.capabilities.getBooleanValue("JDBC");
            }
            if (JDBCLog.isOn(LogLevel.INFO)) {
                JDBCLog.getLogger(LogLevel.INFO).log(this.capabilities.toString());
            }
            this.maxStatements = this.capabilities.getIntegerValue("limits.maxStatements");
        }
        catch (Exception e) {
            JDBCLog.getLogger(LogLevel.ERROR).log(String.format("Post-connection processing failed: %s", e));
            throw new JDBCException(XQEMessageKeys.JDB_RetrieveDatabaseMetaDataFailure, (Throwable)e);
        }
        String dbCollationSequenceName = null;
        try {
            dbCollationSequenceName = this.retrieveDBSessionInfo();
        }
        catch (SQLException e) {
            JDBCLog.getLogger(LogLevel.WARN).log(XQEMessageKeys.JDB_ErrorRetrievingCollationSequence + " Following exception occurred:  ", (Throwable)e);
        }
        String charset = null;
        try {
            charset = this.retrieveCharset();
        }
        catch (SQLException e) {
            JDBCLog.getLogger(LogLevel.ERROR).log(XQEMessageKeys.JDB_ErrorRetrievingDatabaseCharset + " Following exception occurred: ", (Throwable)e);
            throw new JDBCException(XQEMessageKeys.JDB_ErrorRetrievingDatabaseCharset, (Throwable)e);
        }
        String portalIsolationLevelStr = dsConnection.getIsolationLevel();
        if (portalIsolationLevelStr != null) {
            Object[] response = new Object[2];
            int bestIsolationLevel = JDBCIsolationLevel.getIsolationLevel(portalIsolationLevelStr, this.capabilities, response);
            Boolean wasAdjusted = (Boolean)response[0];
            if (bestIsolationLevel == -1) {
                XQEMessage msg = new XQEMessage(XQEMessageKeys.JDB_IsolationLevelInvalid, portalIsolationLevelStr, (IXQEQueryNode)null);
                JDBCLog.getLogger(LogLevel.WARN).log(msg.getTitle(null));
            } else {
                if (wasAdjusted.booleanValue()) {
                    XQEMessage msg = new XQEMessage(XQEMessageKeys.JDB_IsolationLevelAdjusted, portalIsolationLevelStr, JDBCIsolationLevel.getIsolationLevelName(bestIsolationLevel), (IXQEQueryNode)null);
                    JDBCLog.getLogger(LogLevel.WARN).log(msg.getTitle(null));
                }
                try {
                    this.connection.setTransactionIsolation(bestIsolationLevel);
                }
                catch (SQLException e) {
                    XQEMessage msg = new XQEMessage(XQEMessageKeys.JDB_setTransactionIsolationFailed, e.getLocalizedMessage(), (IXQEQueryNode)null);
                    JDBCLog.getLogger(LogLevel.ERROR).log(msg.getTitle(null));
                }
                String arrow = " --> ";
                int defIsoLevel = this.capabilities.getIntegerValue("limits.defaultTransactionIsolation");
                JDBCLog.getLogger(LogLevel.INFO).log("default isolation level is set to: " + String.valueOf(defIsoLevel) + " --> " + JDBCIsolationLevel.getIsolationLevelName(defIsoLevel));
                JDBCLog.getLogger(LogLevel.INFO).log("isolation level is set to: " + String.valueOf(bestIsolationLevel) + " --> " + JDBCIsolationLevel.getIsolationLevelName(bestIsolationLevel));
            }
        }
        if (this.userId != null) {
            IDataProvider provider = ProviderManager.getInstance().getProvider(this.dataSource.getType());
            if (provider instanceof TraceRelationalDataProvider) {
                provider = ((TraceRelationalDataProvider)provider).getProvider();
            }
            if (provider instanceof JDBCDataProvider) {
                ((JDBCDataProvider)provider).cacheDBCollationSequenceAndCharset(this.connectionStringNoSignon, this.userId, dbCollationSequenceName, charset);
            }
        }
        this.setProperty(CONNECTION_SIGNON, dsConnectionSignon);
        if (dsConnection.getName() != null && (encryptedSignon = dsConnection.getEncryptedSignon()) != null) {
            this.setProperty(ENCRYPTED_SIGNON_STRING, encryptedSignon);
        }
        this.elapsedTime = System.currentTimeMillis() - startTime;
    }

    private static boolean checkLoadLocation(Driver theDriver) {
        String jar;
        if (theDriver instanceof XQEDriverWrapper) {
            theDriver = ((XQEDriverWrapper)theDriver).getRawDriver();
        }
        Class<?> theClass = theDriver.getClass();
        String className = theClass.getName();
        URL resource = theClass.getResource("/" + className.replace('.', '/') + ".class");
        if (resource != null && ((jar = resource.toString()).contains("v5dataserver") || jar.contains("p2pd/WEB-INF/lib"))) {
            return className.contains("TWCDriver") || className.contains("AutoRESTDriver") || className.contains("SFDCDriver");
        }
        return true;
    }

    protected String getDataSourceTypeOverride() {
        return this.databaseProductName.toLowerCase().replaceAll("\\s+", "_");
    }

    private void checkConnectionBlacklist() throws XQERuntimeException {
        String[] greylistInfo;
        String serverVersion;
        String serverProductname;
        Map info = this.connection.getExtraInformation();
        if (info.containsKey("blacklistDriver")) {
            String[] blacklistInfo = (String[])info.get("blacklistDriver");
            JDBCLog.getLogger(LogLevel.ERROR).log(String.format(DRIVER_BLACKLISTED, this.driverName, this.driverVersion, blacklistInfo[1]));
            if (!this.allowUnsupportedJDBCDatasourceVersions) {
                throw new XQERuntimeException(XQEMessageKeys.DS_DriverBlacklistedTestConnectionUI, this.jdbcDriverVersion, this.driverName);
            }
        }
        String defaultServerProductname = "product";
        if (info.containsKey("blacklistServer")) {
            String[] blacklistInfo = (String[])info.get("blacklistServer");
            serverProductname = null;
            serverVersion = null;
            try {
                serverProductname = this.connection.getMetaData().getDatabaseProductName();
                serverVersion = this.connection.getMetaData().getDatabaseProductVersion();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (serverProductname == null) {
                serverProductname = defaultServerProductname;
            }
            JDBCLog.getLogger(LogLevel.ERROR).log(String.format(SERVER_BLACKLISTED, serverProductname, serverVersion, this.url, blacklistInfo[1]));
            if (!this.allowUnsupportedJDBCDatasourceVersions) {
                throw new XQERuntimeException(XQEMessageKeys.DS_ServerBlacklistedTestConnectionUI, (Object)serverProductname, (Object)serverVersion, (Object)this.url);
            }
        }
        if (info.containsKey("greylistDriver")) {
            greylistInfo = (String[])info.get("greylistDriver");
            JDBCLog.getLogger(LogLevel.ERROR).log(String.format(DRIVER_GREYLISTED, this.driverName, this.driverVersion, greylistInfo[1]));
            if (!this.allowDeprecatedJDBCDatasourceVersions) {
                throw new XQERuntimeException(XQEMessageKeys.DS_DriverGreylistedTestConnectionUI, this.jdbcDriverVersion, this.driverName);
            }
        }
        if (info.containsKey("greylistServer")) {
            greylistInfo = (String[])info.get("greylistServer");
            serverProductname = null;
            serverVersion = null;
            try {
                serverProductname = this.connection.getMetaData().getDatabaseProductName();
                serverVersion = this.connection.getMetaData().getDatabaseProductVersion();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (serverProductname == null) {
                serverProductname = defaultServerProductname;
            }
            JDBCLog.getLogger(LogLevel.ERROR).log(String.format(SERVER_GREYLISTED, serverProductname, serverVersion, this.url, greylistInfo[1]));
            if (!this.allowDeprecatedJDBCDatasourceVersions) {
                throw new XQERuntimeException(XQEMessageKeys.DS_ServerGreylistedTestConnectionUI, serverProductname, serverVersion);
            }
        }
    }

    private String getSubminorVersion() {
        Map info = this.connection.getExtraInformation();
        String subminorVersion = null;
        if (info.containsKey("dbSubminorVersion")) {
            subminorVersion = (String)info.get("dbSubminorVersion");
        }
        return subminorVersion;
    }

    public void updateConnection(Commands key) throws SQLException {
        if (CMD_BLOCK_CACHE_LOGGER.isOnIgnoreSLF4JLogger(LogLevel.INFO)) {
            CMD_BLOCK_CACHE_LOGGER.log(LogLevel.INFO, "Inside JDBCConnection.updateConnection");
        }
        if (key.equals((Object)Commands.CMD_CLOSE_CONNECTION)) {
            if (CMD_BLOCK_CACHE_LOGGER.isOnIgnoreSLF4JLogger(LogLevel.INFO)) {
                CMD_BLOCK_CACHE_LOGGER.log(LogLevel.INFO, "command is close connection");
            }
            if (this.sessionIsOpen) {
                if (CMD_BLOCK_CACHE_LOGGER.isOnIgnoreSLF4JLogger(LogLevel.INFO)) {
                    CMD_BLOCK_CACHE_LOGGER.log(LogLevel.INFO, "session is open: running close session");
                }
                this.runCommandBlocks(Commands.CMD_CLOSE_SESSION, this.closeSessionCommandBlocks);
                this.sessionIsOpen = false;
            }
            if (CMD_BLOCK_CACHE_LOGGER.isOnIgnoreSLF4JLogger(LogLevel.INFO)) {
                CMD_BLOCK_CACHE_LOGGER.log(LogLevel.INFO, "running close connection");
            }
            this.runCommandBlocks(key, this.closeConnectionCommandBlocks);
            this.openSessionCommandBlocks = null;
            this.closeSessionCommandBlocks = null;
            this.closeConnectionCommandBlocks = null;
            return;
        }
        IDataSourceConnection dsConnection = this.dataSource.getDataSourceConnection();
        List<IDataSourceConnectionCommandBlock> commandBlocks = dsConnection.getCommandBlock(key);
        if (key.equals((Object)Commands.CMD_OPEN_CONNECTION)) {
            if (CMD_BLOCK_CACHE_LOGGER.isOnIgnoreSLF4JLogger(LogLevel.INFO)) {
                CMD_BLOCK_CACHE_LOGGER.log(LogLevel.INFO, "command is open connection, running open connection");
            }
            this.runCommandBlocks(Commands.CMD_OPEN_CONNECTION, commandBlocks);
            this.openSessionCommandBlocks = dsConnection.getCommandBlock(Commands.CMD_OPEN_SESSION);
            this.closeSessionCommandBlocks = dsConnection.getCommandBlock(Commands.CMD_CLOSE_SESSION);
            this.closeConnectionCommandBlocks = dsConnection.getCommandBlock(Commands.CMD_CLOSE_CONNECTION);
            this.sessionIsOpen = false;
            this.updateConnection(Commands.CMD_OPEN_SESSION);
        }
        if (key.equals((Object)Commands.CMD_OPEN_SESSION)) {
            if (CMD_BLOCK_CACHE_LOGGER.isOnIgnoreSLF4JLogger(LogLevel.INFO)) {
                CMD_BLOCK_CACHE_LOGGER.log(LogLevel.INFO, "command is open session");
            }
            List<IDataSourceConnectionCommandBlock> newOpenSessionCommandBlocks = dsConnection.getCommandBlock(Commands.CMD_OPEN_SESSION);
            List<IDataSourceConnectionCommandBlock> newCloseSessionCommandBlocks = dsConnection.getCommandBlock(Commands.CMD_CLOSE_SESSION);
            if (this.sessionIsOpen) {
                if (CMD_BLOCK_CACHE_LOGGER.isOnIgnoreSLF4JLogger(LogLevel.INFO)) {
                    CMD_BLOCK_CACHE_LOGGER.log(LogLevel.INFO, "previous session still open");
                }
                if (this.compareCommandBlocks(newCloseSessionCommandBlocks, this.closeSessionCommandBlocks) && this.compareCommandBlocks(newOpenSessionCommandBlocks, this.openSessionCommandBlocks)) {
                    return;
                }
                if (CMD_BLOCK_CACHE_LOGGER.isOnIgnoreSLF4JLogger(LogLevel.INFO)) {
                    CMD_BLOCK_CACHE_LOGGER.log(LogLevel.INFO, "previous close session was not the same, running close session");
                }
                try {
                    this.runCommandBlocks(Commands.CMD_CLOSE_SESSION, this.closeSessionCommandBlocks);
                }
                catch (SQLException se) {
                    JDBCLog.getLogger().log(LogLevel.ERROR, (Throwable)se);
                }
                this.sessionIsOpen = false;
            }
            if (CMD_BLOCK_CACHE_LOGGER.isOnIgnoreSLF4JLogger(LogLevel.INFO)) {
                CMD_BLOCK_CACHE_LOGGER.log(LogLevel.INFO, "running open session");
            }
            this.runCommandBlocks(Commands.CMD_OPEN_SESSION, newOpenSessionCommandBlocks);
            this.openSessionCommandBlocks = newOpenSessionCommandBlocks;
            this.closeSessionCommandBlocks = newCloseSessionCommandBlocks;
            this.sessionIsOpen = true;
            return;
        }
        if (key.equals((Object)Commands.CMD_CLOSE_SESSION)) {
            if (CMD_BLOCK_CACHE_LOGGER.isOnIgnoreSLF4JLogger(LogLevel.INFO)) {
                CMD_BLOCK_CACHE_LOGGER.log(LogLevel.INFO, "command is close session");
            }
            if (this.configDeferCloseSession || this.closeSessionCommandBlocks.isEmpty()) {
                if (this.configDeferCloseSession) {
                    if (CMD_BLOCK_CACHE_LOGGER.isOnIgnoreSLF4JLogger(LogLevel.INFO)) {
                        CMD_BLOCK_CACHE_LOGGER.log(LogLevel.INFO, "configDeferCloseSession is true");
                    }
                } else if (CMD_BLOCK_CACHE_LOGGER.isOnIgnoreSLF4JLogger(LogLevel.INFO)) {
                    CMD_BLOCK_CACHE_LOGGER.log(LogLevel.INFO, "closeSessionCommandBlocks is empty");
                }
                this.sessionIsOpen = true;
                return;
            }
            if (CMD_BLOCK_CACHE_LOGGER.isOnIgnoreSLF4JLogger(LogLevel.INFO)) {
                CMD_BLOCK_CACHE_LOGGER.log(LogLevel.INFO, "running close session");
            }
            this.runCommandBlocks(Commands.CMD_CLOSE_SESSION, this.closeSessionCommandBlocks);
            this.sessionIsOpen = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runCommandBlocks(Commands key, List<IDataSourceConnectionCommandBlock> commandBlocks) throws SQLException {
        if (commandBlocks == null || commandBlocks.size() <= 0) {
            return;
        }
        JDBCLog.getLogger().log(String.format(COMMAND_BLOCK_EXECUTION_STARTED, this.connection.hashCode(), key.getName()));
        JDBCLog.getLogger(LogLevel.WARN).log(String.format(COMMAND_BLOCK_EXECUTION_STARTED, this.connection.hashCode(), key.getName()));
        Statement stmt = this.connection.createStatement();
        try {
            for (int i = 0; i < commandBlocks.size(); ++i) {
                IDataSourceConnectionCommandBlock commandBlock = commandBlocks.get(i);
                if (commandBlock.getType() != IDataSourceConnectionCommandBlock.CommandBlockType.SQL_COMMAND) continue;
                String command = (String)commandBlock.getProperty("sql");
                stmt.execute(command);
            }
        }
        catch (Throwable throwable) {
            stmt.close();
            JDBCLog.getLogger().log(String.format(COMMAND_BLOCK_EXECUTION_COMPLETED, this.connection.hashCode()));
            throw throwable;
        }
        stmt.close();
        JDBCLog.getLogger().log(String.format(COMMAND_BLOCK_EXECUTION_COMPLETED, this.connection.hashCode()));
    }

    public String getCryptoHandle() {
        return this.cryptoHandle;
    }

    private boolean compareCommandBlocks(List<IDataSourceConnectionCommandBlock> lhs, List<IDataSourceConnectionCommandBlock> rhs) {
        if (lhs == null && rhs == null) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        int size = lhs.size();
        if (size != rhs.size()) {
            return false;
        }
        Boolean found = true;
        for (int i = 0; i < size && found.booleanValue(); ++i) {
            IDataSourceConnectionCommandBlock left = lhs.get(i);
            found = false;
            for (int j = 0; j < size && !found.booleanValue(); ++j) {
                IDataSourceConnectionCommandBlock right = rhs.get(i);
                if (!left.compareTo(right)) continue;
                found = true;
            }
        }
        return found;
    }

    protected void mapConnectionException(SQLException e) throws LogonFailureException {
        LogonFailureException logonEx = new LogonFailureException(this.dataSource, e);
        if (e instanceof SQLCognosInvalidLogonException) {
            SQLCognosInvalidLogonException sqle = (SQLCognosInvalidLogonException)e;
            SQLCognosInvalidLogonException.SubCode subCode = sqle.getSubCode();
            if (subCode == SQLCognosInvalidLogonException.SubCode.INVALID_CREDENTIALS) {
                logonEx.setSubCode(LogonFailureException.SubCodeEnum.INVALID_CREDENTIALS);
            } else if (subCode == SQLCognosInvalidLogonException.SubCode.INVALID_CONN_STRING) {
                logonEx.setSubCode(LogonFailureException.SubCodeEnum.INVALID_CONN_STRING);
            } else if (subCode == SQLCognosInvalidLogonException.SubCode.INVALID_CUBE_PWD) {
                logonEx.setSubCode(LogonFailureException.SubCodeEnum.INVALID_CUBE_PWD);
            } else if (subCode == SQLCognosInvalidLogonException.SubCode.INVALID_SERVER) {
                logonEx.setSubCode(LogonFailureException.SubCodeEnum.INVALID_SERVER);
            } else if (subCode == SQLCognosInvalidLogonException.SubCode.MAX_CONNECTIONS) {
                logonEx.setSubCode(LogonFailureException.SubCodeEnum.MAX_CONNECTIONS);
            } else if (subCode == SQLCognosInvalidLogonException.SubCode.NO_CONNECTION) {
                logonEx.setSubCode(LogonFailureException.SubCodeEnum.NO_CONNECTION);
            } else if (subCode == SQLCognosInvalidLogonException.SubCode.XML_TAG_FAULT) {
                logonEx.setSubCode(LogonFailureException.SubCodeEnum.XML_TAG_FAULT);
            } else {
                logonEx.setSubCode(LogonFailureException.SubCodeEnum.UNKNOWN);
            }
            throw logonEx;
        }
        logonEx.setSubCode(LogonFailureException.SubCodeEnum.UNKNOWN);
        throw logonEx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String retrieveDBSessionInfo() throws SQLException {
        String collatorWeight;
        String collationSequenceMappingName;
        StringBuilder collationSequenceName = new StringBuilder();
        String collationSQL = this.capabilities.getStringValue("collation.sequence.sql", null);
        if (collationSQL == null || collationSQL.equals("")) {
            JDBCLog.getLogger().log("No SQL statement found for collation sequence query.");
            return (String)this.dataSource.getDataSourceConnection().getConnectionParameter(LOCALSORT);
        }
        JDBCLog.getLogger().log("Retrieving collation sequence.");
        Statement stmt = null;
        ResultSet rSet = null;
        try {
            stmt = this.connection.createStatement();
            if (!stmt.execute(collationSQL)) {
                String string = null;
                return string;
            }
            rSet = stmt.getResultSet();
            rSet.next();
            collationSequenceMappingName = rSet.getString(1);
            if (collationSequenceMappingName == null || collationSequenceMappingName.length() == 0) {
                JDBCLog.getLogger().log("No results returned for collation sequence query.");
            }
            try {
                collatorWeight = rSet.getString(2);
            }
            catch (Exception e) {
                collatorWeight = CollatorPoolFactory.CollatorWeight.PRIMARY.getName();
            }
        }
        finally {
            if (rSet != null) {
                rSet.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        String property = this.capabilities.getStringValue(String.format("collation.sequence.mapping.%1$s", collationSequenceMappingName), null);
        if (property == null) {
            JDBCLog.getLogger(LogLevel.WARN).log(String.format("No collation sequence mapping found for %1$s. Using run locale", collationSequenceMappingName));
            JDBCLog.getLogger(LogLevel.WARN).log(String.format("Collation sequence weight name is %1$s will be used in the run locale", collatorWeight));
            if (this.dataSource.getDataSourceConnection().getConnectionParameter(LOCALSORT) != null) {
                collationSequenceName.append((String)this.dataSource.getDataSourceConnection().getConnectionParameter(LOCALSORT));
            } else {
                collatorWeight = collatorWeight.equals("CI_AI") ? CollatorPoolFactory.CollatorWeight.PRIMARY.getName() : (collatorWeight.equals("CI_AS") ? CollatorPoolFactory.CollatorWeight.SECONDARY.getName() : CollatorPoolFactory.CollatorWeight.TERTIARY.getName());
                collatorWeight = CollatorPoolFactory.getCollationLevel(collatorWeight);
                collationSequenceName.append(COLON);
                if (collatorWeight != null) {
                    collationSequenceName.append(collatorWeight);
                } else {
                    collationSequenceName.append(CollatorPoolFactory.CollatorWeight.PRIMARY.getAbbreviation());
                }
            }
        } else {
            String[] seqAndWeight = property.split(",");
            if (seqAndWeight.length != 2) {
                JDBCLog.getLogger().log(String.format("Expected <collationName>,<collationWeight> got %1$s", property));
                return null;
            }
            collationSequenceName.append(seqAndWeight[0].trim());
            collatorWeight = CollatorPoolFactory.getCollationLevel(seqAndWeight[1].trim());
            if (collatorWeight != null) {
                collationSequenceName.append(COLON);
                collationSequenceName.append(collatorWeight);
            }
        }
        String ret = collationSequenceName.toString();
        this.setDatabaseCollationSequence(ret);
        return ret;
    }

    private String retrieveCharset() throws SQLException {
        String charsetSQL = null;
        charsetSQL = this.capabilities.getStringValue("database.charset.sql", null);
        if (charsetSQL == null || charsetSQL.equals("")) {
            JDBCLog.getLogger().log("No SQL statement found for datbase charset query.");
            return null;
        }
        String charsetName = null;
        JDBCLog.getLogger().log(String.format("Retrieving database character set: %s", charsetSQL));
        charsetName = this.executeSingleValueSQL(charsetSQL);
        if (charsetName == null) {
            JDBCLog.getLogger().log("No results returned for database charset query.");
            return null;
        }
        this.setProperty(DATABASE_CHARSET_NAME, charsetName);
        return charsetName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeSingleValueSQL(String sqlText) throws SQLException {
        Statement statement = null;
        ResultSet rSet = null;
        String databaseProperty = null;
        try {
            statement = this.connection.createStatement();
            if (!statement.execute(sqlText)) {
                JDBCLog.getLogger().log(String.format("SQL query %1$s failed", sqlText));
            }
            if ((rSet = statement.getResultSet()) == null || !rSet.next()) {
                statement.close();
                String string = null;
                return string;
            }
            databaseProperty = rSet.getString(1);
        }
        finally {
            if (rSet != null) {
                rSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        return databaseProperty;
    }

    protected String getSubtype(DatabaseMetaData metadata) throws SQLException {
        if (this.connection instanceof XQEConnectionWrapper) {
            IAdaptorConnection ac = (IAdaptorConnection)((XQEConnectionWrapper)this.connection).getJDBCConnection();
            return ac.getSubType();
        }
        return this.connection.getSubType();
    }

    protected String getVersion(DatabaseMetaData metadata) throws SQLException {
        String version = String.format(VERSION_FORMAT, metadata.getDatabaseMajorVersion(), metadata.getDatabaseMinorVersion());
        return version;
    }

    public void disconnect() throws JDBCException {
        this.cacheMgr.release();
        try {
            if (this.connection != null) {
                this.updateConnection(Commands.CMD_CLOSE_CONNECTION);
                this.connection.close();
            }
        }
        catch (SQLException e) {
            throw new JDBCException(XQEMessageKeys.JDB_FreeConnectionFailure, (Throwable)e);
        }
    }

    protected PreparedStatement prepareCall(IExecutionEnvironment env, String sqlQuery) throws SQLException {
        this.logIPFNativeQuery(env, sqlQuery);
        return this.connection.prepareStatement(String.format("{%1$s}", sqlQuery));
    }

    public PreparedStatement prepareCall(IExecutionEnvironment env, String canonicalName, String schema, String fullPath, List<XSql.StoredProcedureArgument> arguments) throws SQLException {
        StringBuilder buffer = new StringBuilder();
        StringBuilder name = new StringBuilder(fullPath);
        name.append(canonicalName);
        int numArgs = 0;
        buffer.append("{ CALL ");
        buffer.append((CharSequence)name);
        if (arguments != null) {
            numArgs = arguments.size();
        }
        buffer.append(" (");
        for (int i = 0; i < numArgs; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(arguments.get(i).getArgumentValue());
        }
        buffer.append(") }");
        String query = buffer.toString();
        this.logIPFNativeQuery(env, query);
        return this.connection.prepareCall(query);
    }

    public PreparedStatement prepare(IExecutionEnvironment env, String sqlQuery) throws SQLException {
        this.updateConnection(Commands.CMD_OPEN_SESSION);
        PreparedStatement statement = sqlQuery.startsWith("CALL ") ? this.prepareCall(env, sqlQuery) : this.prepareStatement(env, sqlQuery, 100);
        return statement;
    }

    public PreparedStatement prepare(IExecutionEnvironment env, SQLQueryArguments queryArgs) throws SQLException {
        PreparedStatement statement;
        this.prepareConnection(env, queryArgs);
        if (queryArgs.isCallStatement()) {
            String spSchemaName = queryArgs.getStoredProcedureSchema();
            String spCatalogName = queryArgs.getStoredProcedureCatalog();
            StringBuilder spQualifier = new StringBuilder();
            if (spCatalogName != null) {
                StringBuilder catalogName = new StringBuilder();
                SQLIdentifier.delimitName(catalogName, spCatalogName, this.capabilities.getCatalogDelimiter(), false);
                spQualifier.append(catalogName + this.getCapabilities().getCatalogSeparator());
                if (spSchemaName != null) {
                    StringBuilder schemaName = new StringBuilder();
                    SQLIdentifier.delimitName(schemaName, spCatalogName, this.capabilities.getSchemaDelimiter(), false);
                    spQualifier.append(spSchemaName + DOT);
                } else if (this.capabilities.getBooleanValue("supports.schemasInDataManipulation")) {
                    spQualifier.append(DOT);
                }
            } else if (spSchemaName != null) {
                StringBuilder schemaName = new StringBuilder();
                SQLIdentifier.delimitName(schemaName, spSchemaName, this.capabilities.getSchemaDelimiter(), false);
                spQualifier.append(spSchemaName + DOT);
            }
            this.setStoredProcedureTransactionAccessMode(env);
            statement = this.prepareCall(env, queryArgs.getStoredProcedureName(), spSchemaName, spQualifier.toString(), queryArgs.getStoredProcedureArguments());
            this.registerParameters(statement, queryArgs);
        } else {
            int fetchSize = this.calculateFetchSize(env, queryArgs);
            statement = this.prepareStatement(env, queryArgs.getSQLQuery(), fetchSize);
        }
        return statement;
    }

    public Statement createStatement(IExecutionEnvironment env, SQLQueryArguments queryArgs) throws SQLException {
        this.prepareConnection(env, queryArgs);
        Statement statement = this.connection.createStatement();
        int fetchSize = this.calculateFetchSize(env, queryArgs);
        this.setFetchSizeStatement(statement, fetchSize);
        this.logIPFNativeQuery(env, queryArgs.getSQLQuery());
        return statement;
    }

    private void prepareConnection(IExecutionEnvironment env, SQLQueryArguments queryArgs) throws SQLException {
        this.updateConnection(Commands.CMD_OPEN_SESSION);
        try {
            SQLQueryNode ast = queryArgs.getSqlAST();
            XQEConfiguration xqeConfig = XQEConfigurationManager.getInstance().getOrCreateXQEConfiguration();
            if (HookManager.hooksDefined(HookEvent.JDBC_PREPARE)) {
                HookEnvironment hEnv = new HookEnvironment(env, this.dataSource);
                HookManager.execute(HookEvent.JDBC_PREPARE, new Object[]{hEnv, this.connection, ast});
            }
            if (xqeConfig.connectionAttributesEnabled()) {
                Properties context = (Properties)ast.getPropertyValue("applicationContext");
                JDBCLog.getLogger(LogLevel.INFO).log("Setting connection attributes");
                this.connection.setConnectionAttributes(context);
            }
        }
        catch (Exception e) {
            throw new SQLException(e.getLocalizedMessage());
        }
    }

    private int calculateFetchSize(IExecutionEnvironment env, SQLQueryArguments queryArgs) {
        int rowSize = 1;
        IRowsetInfo rowSetInfo = queryArgs.getCalculatedRowsetInfo();
        if (rowSetInfo != null) {
            rowSize = Math.max(1, ((RowsetInfo)rowSetInfo).getRowLengthNoDefault());
            JDBCLog.getLogger().log(LogLevel.TRACE, "Row size is: " + rowSize + STR_BYTES);
        }
        int bufferSize = defaultFetchBufferSize;
        if (this.fetchBufferSize == -1) {
            Governors governors;
            Governors.ExecutionOptimization optimization;
            if (bufferSize == 102400 && env.getGovernors() != null && (optimization = (governors = env.getGovernors()).getExecutionOptimization()).equals((Object)Governors.ExecutionOptimization.ALLROWS)) {
                bufferSize = 0x200000;
            }
        } else {
            JDBCLog.getLogger().log(LogLevel.TRACE, "Fetch buffer size set in connection is: " + this.fetchBufferSize + STR_KB);
            if (this.fetchBufferSize > 0x1FFFFF) {
                this.fetchBufferSize = 0x1FFFFF;
                JDBCLog.getLogger().log(LogLevel.TRACE, "Fetch buffer size too large, set to MAX: " + this.fetchBufferSize + STR_KB);
            }
            bufferSize = this.fetchBufferSize * 1024;
            JDBCLog.getLogger().log(LogLevel.TRACE, "Buffer size calculated is: " + bufferSize + STR_BYTES);
        }
        if (bufferSize > 0xA00000) {
            bufferSize = 0xA00000;
            JDBCLog.getLogger().log(LogLevel.TRACE, "Buffer size set to MAX: " + bufferSize + STR_BYTES);
        } else if (bufferSize < 10240) {
            bufferSize = 10240;
            JDBCLog.getLogger().log(LogLevel.TRACE, "Buffer size set to MIN: " + bufferSize + STR_BYTES);
        }
        int fetchSize = Math.max(Math.min(bufferSize / rowSize, 25600), 10);
        JDBCLog.getLogger().log(LogLevel.TRACE, "Fetch size is: " + fetchSize);
        return fetchSize;
    }

    private void setStoredProcedureTransactionAccessMode(IExecutionEnvironment executionEnvironment) throws SQLException {
        String accessModeSwitch = "queryExecution.jdbcTransaction.accessMode[@enabled]";
        boolean doTransactionAccessMode = executionEnvironment.getMultiRequestContext().fetchBooleanConfiguration(accessModeSwitch, true);
        if (doTransactionAccessMode) {
            Locale locale;
            Connection connectionWrapper = this.getConnection();
            IDataSource modelDatasource = this.getDataSource();
            String modelDatasourceName = modelDatasource.getName();
            Map<String, Object> dsMetadataProperties = modelDatasource.getMetadataProperties();
            Object property = dsMetadataProperties.get("transactionAccessMode");
            String readOnlyMsg = "read-only";
            String readWriteMsg = "read-write";
            if (JDBCLog.isOn(LogLevel.INFO)) {
                String defaultMsg = connectionWrapper.isReadOnly() ? readOnlyMsg : readWriteMsg;
                IMessageKey.Param3 messageKey = XQEMessageKeys.JDB_DefaultJDBCTransactionAccessMode;
                locale = XQEMessages.getCurrProductLocale();
                String defaultTransactionMSG = XQEMessages.getMessage(messageKey, locale, modelDatasourceName, this.driverName, defaultMsg);
                JDBCLog.getLogger(LogLevel.INFO).log(defaultTransactionMSG);
            }
            if (property != null) {
                String transaction = (String)property;
                String message = null;
                locale = XQEMessages.getCurrProductLocale();
                int severityLevel = executionEnvironment.getRequestEnvironment().getMaxSeverityLevel();
                if (transaction.equals("read")) {
                    connectionWrapper.setReadOnly(true);
                    if (JDBCLog.isOn(LogLevel.INFO) || severityLevel >= 3) {
                        if (connectionWrapper.isReadOnly()) {
                            IMessageKey.Param2 messageKey = XQEMessageKeys.JDB_TransactionAccessMode;
                            message = XQEMessages.getMessage(messageKey, locale, readOnlyMsg, modelDatasourceName);
                        } else {
                            IMessageKey.Param3 messageKey = XQEMessageKeys.JDB_UnsupportedTransactionAccessMode;
                            message = XQEMessages.getMessage(messageKey, locale, this.driverName, readOnlyMsg, modelDatasourceName);
                        }
                    }
                } else if (transaction.equals("write")) {
                    connectionWrapper.setReadOnly(false);
                    if (JDBCLog.isOn(LogLevel.INFO) || severityLevel >= 3) {
                        if (connectionWrapper.isReadOnly()) {
                            IMessageKey.Param3 messageKey = XQEMessageKeys.JDB_UnsupportedTransactionAccessMode;
                            message = XQEMessages.getMessage(messageKey, locale, this.driverName, readWriteMsg, modelDatasourceName);
                        } else {
                            IMessageKey.Param2 messageKey = XQEMessageKeys.JDB_TransactionAccessMode;
                            message = XQEMessages.getMessage(messageKey, locale, readWriteMsg, modelDatasourceName);
                        }
                    }
                }
                if (message != null) {
                    if (severityLevel >= 3) {
                        executionEnvironment.addNag(message);
                    }
                    JDBCLog.getLogger(LogLevel.INFO).log(message);
                }
            }
        }
    }

    public PreparedStatement prepareStatement(IExecutionEnvironment env, String sqlQuery, int fetchSize) throws SQLException {
        this.logIPFNativeQuery(env, sqlQuery);
        PreparedStatement statement = this.connection.prepareStatement(sqlQuery);
        this.setFetchSizeStatement(statement, fetchSize);
        return statement;
    }

    protected JDBCTabularResult getResultSetImpl(XDataContext context, IPooledConnection pooledConnection, SQLQueryArguments queryArgs, Integer nodeId, JDBCDataProvider dataProvider) {
        return new JDBCTabularResult(context, pooledConnection, queryArgs, nodeId, dataProvider);
    }

    public final ITabularResultSet getResultSet(XDataContext nonCacheableContext, IPooledConnection pooledConnection, SQLQueryArguments queryArgs, Integer nodeId, JDBCDataProvider dataProvider) {
        XDataContext context;
        CachedResultSet jdbcTabularResult;
        boolean useCachedResults;
        try {
            this.updateConnection(Commands.CMD_OPEN_SESSION);
        }
        catch (SQLException e) {
            throw new XQERuntimeException(e);
        }
        String key = queryArgs.getSQLQuery();
        boolean bl = useCachedResults = queryArgs.isCacheable() && this.cacheMgr.isCachingEnabled();
        if (null != nonCacheableContext.getEnvironment() && null != nonCacheableContext.getEnvironment().getGovernors() && nonCacheableContext.getEnvironment().getGovernors().getCachePolicyConnectionCommandBlocks()) {
            key = this.prependCommandBlocks(key);
        }
        if (useCachedResults && !this.userSwitched.booleanValue() && (jdbcTabularResult = (CachedResultSet)this.cacheMgr.getCachedResultSet(key)) != null && !this.isExpired(nonCacheableContext.getEnvironment().getGovernors(), jdbcTabularResult.getTimeCreated())) {
            pooledConnection.returnConnection();
            return jdbcTabularResult;
        }
        boolean cacheResultSet = useCachedResults;
        if (cacheResultSet) {
            context = new XDataContext(null, nonCacheableContext.getEnvironment());
            context.setOptions(nonCacheableContext.getOptions());
        } else {
            context = nonCacheableContext;
        }
        JDBCTabularResult jdbcTabularResult2 = this.getResultSetImpl(context, pooledConnection, queryArgs, nodeId, dataProvider);
        IRowsetInfo rowsetInfo = jdbcTabularResult2.getTabularRowsetInfo();
        ITabularResultSet resultSet = jdbcTabularResult2;
        if (cacheResultSet && rowsetInfo != null) {
            cacheResultSet = true;
            for (IColumnInfo columnInfo : rowsetInfo.getColumnInfos()) {
                if (!columnInfo.getDataType().isBlob()) continue;
                cacheResultSet = false;
                break;
            }
            if (cacheResultSet) {
                IDataSource ds = queryArgs.getDataSource();
                resultSet = this.cacheMgr.createCachedResultSet(context, jdbcTabularResult2, jdbcTabularResult2, dataProvider.getResourceTracker(), key, ds.getName());
                if (resultSet != jdbcTabularResult2) {
                    jdbcTabularResult2.setIsCaching(true);
                }
            }
        }
        if (jdbcTabularResult2 == resultSet && nonCacheableContext != context) {
            context.attachToParentAndTakeReference(nonCacheableContext);
        }
        return resultSet;
    }

    @Override
    public String explain(String query) throws SQLException {
        String plan = this.connection.getQueryPlan(query);
        if (plan != null) {
            try {
                XmlValue value = DataValueFactory.createXmlValue();
                value.set(plan);
                plan = value.getString();
            }
            catch (Throwable t) {
                plan = String.format("<exception><![CDATA[%s]]></exception>", plan);
            }
        }
        return plan;
    }

    public IDataType createDataTypeFromJDBCType(ResultSetMetaData metadata, int columnNo) {
        IDataType xqeType = null;
        try {
            switch (metadata.getColumnType(columnNo)) {
                case -1016: {
                    xqeType = DataTypeFactory.getPeriodType(DataTypeFactory.getDateType());
                    break;
                }
                case -1017: {
                    xqeType = DataTypeFactory.getPeriodType(DataTypeFactory.getTimeType());
                    break;
                }
                case -1018: {
                    xqeType = DataTypeFactory.getPeriodType(DataTypeFactory.getTimeWithTZType(metadata.getPrecision(columnNo)));
                    break;
                }
                case -1019: {
                    xqeType = DataTypeFactory.getPeriodType(DataTypeFactory.getTimestampType(metadata.getPrecision(columnNo)));
                    break;
                }
                case -1020: {
                    xqeType = DataTypeFactory.getPeriodType(DataTypeFactory.getTimestampWithTZType(metadata.getPrecision(columnNo)));
                    break;
                }
                case -1002: {
                    xqeType = DataTypeFactory.getTimeWithTZType(metadata.getPrecision(columnNo));
                    break;
                }
                case -1001: {
                    xqeType = DataTypeFactory.getTimestampWithTZType(metadata.getPrecision(columnNo));
                    break;
                }
                case -1003: {
                    xqeType = DataTypeFactory.getIntervalYearMonthType(IntervalQualifier.INTERVAL_YEAR);
                    break;
                }
                case -1004: {
                    xqeType = DataTypeFactory.getIntervalYearMonthType(IntervalQualifier.INTERVAL_YEAR_TO_MONTH);
                    break;
                }
                case -1005: {
                    xqeType = DataTypeFactory.getIntervalYearMonthType(IntervalQualifier.INTERVAL_MONTH);
                    break;
                }
                case -1006: {
                    xqeType = DataTypeFactory.getIntervalDayTimeType(IntervalQualifier.INTERVAL_DAY);
                    break;
                }
                case -1007: {
                    xqeType = DataTypeFactory.getIntervalDayTimeType(IntervalQualifier.INTERVAL_DAY_TO_HOUR);
                    break;
                }
                case -1008: {
                    xqeType = DataTypeFactory.getIntervalDayTimeType(IntervalQualifier.INTERVAL_DAY_TO_MINUTE);
                    break;
                }
                case -1009: {
                    xqeType = DataTypeFactory.getIntervalDayTimeType(IntervalQualifier.INTERVAL_DAY_TO_SECOND);
                    break;
                }
                case -1010: {
                    xqeType = DataTypeFactory.getIntervalDayTimeType(IntervalQualifier.INTERVAL_HOUR);
                    break;
                }
                case -1011: {
                    xqeType = DataTypeFactory.getIntervalDayTimeType(IntervalQualifier.INTERVAL_HOUR_TO_MINUTE);
                    break;
                }
                case -1012: {
                    xqeType = DataTypeFactory.getIntervalDayTimeType(IntervalQualifier.INTERVAL_HOUR_TO_SECOND);
                    break;
                }
                case -1013: {
                    xqeType = DataTypeFactory.getIntervalDayTimeType(IntervalQualifier.INTERVAL_MINUTE);
                    break;
                }
                case -1014: {
                    xqeType = DataTypeFactory.getIntervalDayTimeType(IntervalQualifier.INTERVAL_MINUTE_TO_SECOND);
                    break;
                }
                case -1015: {
                    xqeType = DataTypeFactory.getIntervalDayTimeType(IntervalQualifier.INTERVAL_SECOND);
                    break;
                }
                default: {
                    xqeType = DataTypeFactory.createDataTypeFromStandardJDBCType(metadata, columnNo);
                    break;
                }
            }
        }
        catch (SQLException e) {
            throw new XQERuntimeException(XQEMessageKeys.DAT_RSMDDataSourceAdapterError, e.toString());
        }
        return xqeType;
    }

    public boolean isReusable() {
        return this.maxStatements <= 0 || this.nActiveStatements < this.maxStatements;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, Object val) {
        this.properties.put(key, val);
    }

    public boolean isClosed() throws SQLException {
        return this.connection.isClosed();
    }

    @Override
    public String getDatabaseCharset() {
        return (String)this.getProperty(DATABASE_CHARSET_NAME);
    }

    @Override
    public Set<Object> getCachingStatistics() {
        return this.cacheMgr.getCachedEntrySet();
    }

    public void registerParameters(PreparedStatement statement, SQLQueryArguments queryArgs) throws SQLException {
        List<XSql.StoredProcedureArgument> spArgs = queryArgs.getStoredProcedureArguments();
        int parameterizedPosition = 1;
        ArrayList<Integer> idxListOfParameterizedSPArgsDefinedAsPrompts = new ArrayList<Integer>();
        for (int i = 0; i < spArgs.size(); ++i) {
            int sqlJDBCType;
            if (!spArgs.get(i).getArgumentValue().equals(QUESTIONMARK)) continue;
            String mode = spArgs.get(i).getMode();
            if (("OUT".equalsIgnoreCase(mode) || "INOUT".equalsIgnoreCase(mode)) && statement instanceof CallableStatement) {
                sqlJDBCType = DataTypeFactory.getJdbcDataType(spArgs.get(i).getDataType().getCCLTypeCode());
                ((CallableStatement)statement).registerOutParameter(parameterizedPosition, sqlJDBCType);
            }
            if (("IN".equalsIgnoreCase(mode) || "INOUT".equalsIgnoreCase(mode)) && spArgs.get(i).getInValue() != null) {
                sqlJDBCType = DataTypeFactory.getJdbcDataType(spArgs.get(i).getDataType().getCCLTypeCode());
                this.setParameterValue(statement, parameterizedPosition, spArgs.get(i).getInValue(), sqlJDBCType);
            }
            if (spArgs.get(i).getInValue() == null) {
                idxListOfParameterizedSPArgsDefinedAsPrompts.add(parameterizedPosition);
            }
            ++parameterizedPosition;
        }
        queryArgs.setIndexListOfParameterizedSPArgsDefinedAsPromptsInFM(idxListOfParameterizedSPArgsDefinedAsPrompts);
    }

    protected void setParameterValue(PreparedStatement statement, int parameterizedPosition, String value, int sqlJDBCType) throws SQLException {
        if (JDBCLog.isOn()) {
            JDBCLog.log(String.format(PARAMETER_BINDING_LOG_STR, parameterizedPosition, sqlJDBCType, value));
        }
        switch (sqlJDBCType) {
            case -6: 
            case 5: {
                statement.setShort(parameterizedPosition, Short.valueOf(value));
                break;
            }
            case 4: {
                statement.setInt(parameterizedPosition, Integer.valueOf(value));
                break;
            }
            case -5: {
                statement.setLong(parameterizedPosition, Long.valueOf(value));
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                statement.setString(parameterizedPosition, value);
                break;
            }
            case 2: 
            case 3: {
                statement.setBigDecimal(parameterizedPosition, new BigDecimal(value));
                break;
            }
            case 6: {
                statement.setFloat(parameterizedPosition, Float.valueOf(value).floatValue());
                break;
            }
            case 8: {
                statement.setDouble(parameterizedPosition, Double.valueOf(value));
                break;
            }
            case 91: {
                statement.setDate(parameterizedPosition, Date.valueOf(value));
                break;
            }
            case 92: {
                statement.setTime(parameterizedPosition, Time.valueOf(value));
                break;
            }
            case 93: {
                statement.setTimestamp(parameterizedPosition, Timestamp.valueOf(value));
                break;
            }
            case 2005: {
                statement.setObject(parameterizedPosition, value);
                break;
            }
            default: {
                statement.setObject(parameterizedPosition, value);
            }
        }
    }

    public boolean isGenericConnection() {
        return DataSourceTypeEnum.isGenericJDBC(this.dataSource.getType());
    }

    protected void setFetchSizeStatement(Statement statement, int fetchSize) {
        try {
            statement.setFetchSize(fetchSize);
            JDBCLog.getLogger().log(LogLevel.TRACE, "Using statement fetch size set of " + fetchSize + " rows.");
        }
        catch (SQLException e) {
            JDBCLog.getLogger().log(LogLevel.ERROR, (Throwable)e);
        }
    }

    @Override
    public SQLQueryItemList getMetaData(IExecutionEnvironment environment, IPooledConnection pooledConnection, String sqlText) {
        Statement statement = null;
        ResultSetMetaData descriptor = null;
        SQLQueryItemList queryItems = null;
        try {
            block23: {
                try {
                    statement = this.prepare(environment, sqlText);
                    descriptor = statement.getMetaData();
                }
                catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
                }
                catch (SQLException e) {
                    descriptor = null;
                    e = this.processSQLException(e);
                    if (this.isUnrecoverableConnection(e)) {
                        pooledConnection.setNotReusable();
                        throw e;
                    }
                    try {
                        if (!this.connection.getAutoCommit()) {
                            this.connection.rollback();
                        }
                    }
                    catch (SQLException ex) {
                        pooledConnection.setNotReusable();
                    }
                    if (statement != null) break block23;
                    throw e;
                }
            }
            ResultSet resultSet = null;
            if (descriptor == null) {
                Boolean hasResultSet = true;
                if (statement == null) {
                    statement = this.connection.createStatement();
                    if (!statement.execute(sqlText)) {
                        hasResultSet = false;
                    }
                } else if (!statement.execute()) {
                    hasResultSet = false;
                }
                if (!hasResultSet.booleanValue()) {
                    boolean more = statement.getMoreResults();
                    while (!more && statement.getUpdateCount() != -1) {
                        more = statement.getMoreResults();
                    }
                    if (!more) {
                        throw new BindNativeSQLException(sqlText);
                    }
                }
                resultSet = statement.getResultSet();
                descriptor = resultSet.getMetaData();
            }
            boolean isCaseSensitive = this.capabilities.isSupported("supports.mixedCaseIdentifiers") || this.capabilities.isSupported("supports.mixedCaseQuotedIdentifiers") && this.capabilities.getIdentifierQuoteString() != null;
            boolean forceNullsOk = this.capabilities.isSupported("general.forceNullsOk");
            if (descriptor != null) {
                queryItems = new SQLQueryItemList(descriptor.getColumnCount());
                for (int i = 0; i < descriptor.getColumnCount(); ++i) {
                    SQLQueryItem itemDesc = new SQLQueryItem();
                    itemDesc.setSourceNo(0);
                    itemDesc.setColumnNo(i);
                    itemDesc.setTableName(descriptor.getTableName(i + 1));
                    itemDesc.setName(descriptor.getColumnLabel(i + 1));
                    itemDesc.setDataType(this.createDataTypeFromJDBCType(descriptor, i + 1));
                    itemDesc.setCaseSensitivity(isCaseSensitive);
                    if (forceNullsOk) {
                        itemDesc.setNullable(true);
                    } else {
                        itemDesc.setNullable(descriptor.isNullable(i + 1) != 0);
                    }
                    queryItems.add(itemDesc);
                }
            }
            if (resultSet != null) {
                resultSet.close();
            }
            statement.close();
        }
        catch (SQLException e) {
            e = this.processSQLException(e);
            JDBCLog.getLogger(LogLevel.ERROR).log(sqlText + "\ncaused ", (Throwable)e);
            if (this.isUnrecoverableConnection(e)) {
                pooledConnection.setNotReusable();
                throw new XQEUnrecoverableConnectionException(e, e.toString());
            }
            throw new XQERuntimeException(XQEMessageKeys.DAT_DataSourceAdapterError, (Throwable)e, e.toString());
        }
        return queryItems;
    }

    public boolean isUnrecoverableConnection(SQLException e) {
        return e instanceof SQLCognosUnrecoverableConnectionException;
    }

    public SQLException processSQLException(SQLException e) {
        if (e instanceof SQLCognosUnrecoverableConnectionException) {
            return e;
        }
        if ((e = this.connection.processSQLException(e)) instanceof SQLCognosUnrecoverableConnectionException) {
            return e;
        }
        try {
            if (this.isClosed()) {
                return new SQLCognosUnrecoverableConnectionException(e);
            }
        }
        catch (SQLException ex) {
            JDBCLog.getLogger(LogLevel.ERROR).log(ex);
        }
        return e;
    }

    protected void logIPFNativeQuery(IExecutionEnvironment env, String nativeSql) {
        if (!XQEIPFAppender.instanceCreated()) {
            return;
        }
        LogTypedLogger ipfLog = LogTypedLogger.getInstance((String)"Audit.RTUsage.XQE.V5DataServer", LogAuditIndication.class);
        if (!ipfLog.isEnabled(20000)) {
            return;
        }
        LogAuditAccessIndication indication = new LogAuditAccessIndication("XQE", 0);
        indication.setLevel(20000);
        indication.setThreadID(String.valueOf(Thread.currentThread().getId()));
        indication.setOperation("NativeQuery");
        indication.setLogData(nativeSql);
        if (env != null) {
            String camSessionId;
            String requestId = env.getRequestID();
            if (requestId != null) {
                indication.setRequestID(requestId);
            }
            if (env.getRequestEnvironment() != null && (camSessionId = env.getRequestEnvironment().getCAMUserSessionID()) != null) {
                indication.setSessionID(camSessionId);
            }
        }
        ipfLog.log((Object)indication);
    }

    private void connectWithAuthentication(Locale runLocale) throws JDBCException {
        if (this.mOIDCAccessToken != null) {
            this.driverConnectWithOIDC(runLocale);
            JDBCLog.getLogger(LogLevel.INFO).log(String.format("[JDBC OIDC] Created connection with OIDC authentication for the JDBC '%s' driver", this.driverName));
        } else if (this.authKey != null || this.secretKey != null) {
            this.driverConnectWithApiToken(runLocale);
            JDBCLog.getLogger(LogLevel.INFO).log(String.format("[JDBC ApiToken] Created connection with ApiToken authentication for the JDBC '%s' driver", this.driverName));
        } else {
            this.driverConnectKerberos(runLocale);
        }
    }

    protected void driverConnectKerberos(Locale locale) throws JDBCException {
        JCAMImpersonator.DelegatedCredential credential = null;
        boolean isSingleSignOn = false;
        boolean kerberos = false;
        if (this.connectionString.contains(IBMCOGNOS_AUTHENTICATION_JAVA_KRB5)) {
            this.connectionProps.put(IBMCOGNOS_AUTHENTICATION, JAVA_KRB5);
        }
        if (this.connectionProps.containsKey(IBMCOGNOS_AUTHENTICATION)) {
            if (this.connectionProps.getProperty(IBMCOGNOS_AUTHENTICATION).equals(JAVA_KRB5)) {
                kerberos = true;
            }
            this.connectionProps.remove(IBMCOGNOS_AUTHENTICATION);
        }
        if (kerberos) {
            JDBCLog.getLogger().log(LogLevel.TRACE, String.format("[JDBC Kerberos] Java Vendor Is: " + System.getProperty("java.vendor"), new Object[0]));
            JDBCLog.getLogger().log(LogLevel.TRACE, String.format("[JDBC Kerberos] Discovered propertyibmcognos.authentication=java_krb5.", new Object[0]));
            IDataSourceConnection dsConnection = this.dataSource.getDataSourceConnection();
            IDataSourceConnectionSignon signon = dsConnection.getSignon();
            if (signon == null) {
                JDBCLog.getLogger().log(LogLevel.TRACE, String.format("[JDBC Kerberos] Signon is null, throwing Logon exception.", new Object[0]));
                LogonFailureException logonEx = new LogonFailureException(this.dataSource, LogonFailureException.SubCodeEnum.INVALID_CREDENTIALS);
                throw logonEx;
            }
            if (signon.getType() == IDataSourceConnectionSignon.SignonType.JAASSUBJECT) {
                credential = ((DelegatedCredentialSignon)signon).getDelegatedCredential();
                if (credential == null) {
                    JDBCLog.getLogger().log(String.format("[JDBC Kerberos] Internal error, JAAS Subject is null in the signon, throw exception.", new Object[0]));
                    throw new JDBCException(XQEMessageKeys.GEN_UnexpectedException);
                }
                JDBCLog.getLogger().log(LogLevel.TRACE, String.format("[JDBC kerberos] Extracted JAAS Subject from signon.", new Object[0]));
                isSingleSignOn = true;
            } else if (this.userId != null && this.password != null && !this.password.isEmpty()) {
                JDBCLog.getLogger().log(LogLevel.TRACE, String.format("[JDBC Kerberos] received UID(%s)/PWD signon, will create a JAAS login context", this.userId));
                isSingleSignOn = true;
            } else {
                JDBCLog.getLogger().log(LogLevel.TRACE, String.format("[JDBC Kerberos] received no login information in sign on, switch SSO off.", new Object[0]));
                isSingleSignOn = false;
            }
        }
        if (!isSingleSignOn) {
            JDBCLog.getLogger().log(LogLevel.TRACE, String.format("[JDBC Kerberos] Connecting with current default credentials ( SSO is OFF.", new Object[0]));
            this.driverConnect(locale);
            return;
        }
        this.isKerberized = true;
        ByteArrayOutputStream os = null;
        if (JDBCLog.isOn(LogLevel.TRACE)) {
            os = new ByteArrayOutputStream();
        }
        if (credential == null) {
            try {
                class SimpleCallbackHandler
                implements CallbackHandler {
                    SimpleCallbackHandler() {
                    }

                    @Override
                    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                        for (int i = 0; i < callbacks.length; ++i) {
                            if (callbacks[i] instanceof NameCallback) {
                                NameCallback nc = (NameCallback)callbacks[i];
                                nc.setName(JDBCConnection.this.userId);
                                continue;
                            }
                            if (callbacks[i] instanceof PasswordCallback) {
                                PasswordCallback pc = (PasswordCallback)callbacks[i];
                                pc.setPassword(JDBCConnection.this.password.toCharArray());
                                continue;
                            }
                            throw new UnsupportedCallbackException(callbacks[i], "Internal error - unrecognized Callback");
                        }
                    }
                }
                PrintStream old = System.out;
                if (os != null) {
                    PrintStream ps = new PrintStream(os);
                    System.setOut(ps);
                }
                LoginContext lc = null;
                try {
                    lc = new LoginContext(JAAS_NOSSO_LOGIN_CONFIGURATION, new SimpleCallbackHandler());
                }
                catch (LoginException loginException) {
                    // empty catch block
                }
                if (lc == null) {
                    lc = new LoginContext(JAAS_NOSSO_LOGIN_CONFIGURATION, null, new SimpleCallbackHandler(), new KerberosConnectionHelper.LocalConfiguration());
                }
                lc.login();
                System.setOut(old);
                credential = new JCAMImpersonator.DelegatedCredential(lc.getSubject());
            }
            catch (Exception e) {
                JDBCLog.getLogger(LogLevel.ERROR).log(String.format("[JDBC Kerberos] Login context failed: " + e.toString(), new Object[0]));
                if (os != null) {
                    JDBCLog.getLogger(LogLevel.ERROR).log(String.format("[JDBC Kerberos] Kerberos debug: " + os.toString(), new Object[0]));
                }
                throw new JDBCException(XQEMessageKeys.JDB_SSOConnectionFailed, (Throwable)e);
            }
        }
        class ConnectTask
        implements PrivilegedAction<Exception> {
            Locale locale;
            ByteArrayOutputStream os;
            Exception ex = null;

            ConnectTask(Locale theLocale, ByteArrayOutputStream theOs) {
                this.locale = theLocale;
                this.os = theOs;
            }

            @Override
            public Exception run() {
                PrintStream old = System.out;
                if (this.os != null) {
                    PrintStream ps = new PrintStream(this.os);
                    System.setOut(ps);
                }
                try {
                    JDBCConnection.this.driverConnect(this.locale);
                }
                catch (Exception e) {
                    this.ex = e;
                }
                finally {
                    System.setOut(old);
                }
                return this.ex;
            }

            public Exception getException() {
                return this.ex;
            }
        }
        ConnectTask connectTask = new ConnectTask(locale, os);
        try {
            if (credential.isConstrained()) {
                if (null == credential.getCredential()) {
                    JDBCLog.getLogger().log(LogLevel.TRACE, "[JDBC Kerberos] Using Constrained delegation with null credential.");
                    throw new JDBCException(XQEMessageKeys.JDB_CredentialNull);
                }
                JDBCLog.getLogger().log(LogLevel.TRACE, String.format("[JDBC Kerberos] Using Constrained delegation with credential: " + credential.getCredential().toString(), new Object[0]));
                this.connectionProps.put("JGSSCredential", credential.getCredential());
            } else {
                JDBCLog.getLogger().log(LogLevel.TRACE, String.format("[JDBC Kerberos] Using unconstrained delegation with principal: " + credential.getSubject().getPrincipals().toArray()[0].toString(), new Object[0]));
            }
            Subject.doAs(credential.getSubject(), connectTask);
            if (this.connection == null) {
                throw connectTask.getException();
            }
        }
        catch (Exception e) {
            JDBCLog.getLogger(LogLevel.ERROR).log(String.format("[JDBC Kerberos] Connection failed: %s", e.toString()));
            if (os != null) {
                JDBCLog.getLogger(LogLevel.ERROR).log(String.format("[JDBC Kerberos] Kerberos debug: %s", os.toString()));
            } else {
                JDBCLog.getLogger(LogLevel.ERROR).log("[JDBC Kerberos] Set log level to TRACE to see Kerberos debug output");
            }
            if (this.connection != null) {
                this.disconnect();
                throw new RuntimeException(e);
            }
            throw new JDBCException(XQEMessageKeys.JDB_SSOConnectionFailed, (Throwable)e);
        }
        JDBCLog.getLogger(LogLevel.INFO).log(String.format("[JDBC Kerberos] Connection succeeded", new Object[0]));
    }

    private void driverConnectWithOIDC(Locale runLocale) throws JDBCException {
        this.connectionProps.put(OIDC_NAMESPACE, this.mOIDCNamespaceName);
        this.connectionProps.put(OIDC_ACCESS_TOKEN, this.getOIDCAccessToken());
        this.connectionProps.put(OIDC_ID_TOKEN, this.getOIDCIdToken());
        this.driverConnect(runLocale);
    }

    private void driverConnectWithApiToken(Locale runLocale) throws JDBCException {
        if (this.authKey != null) {
            this.connectionProps.setProperty(AUTHKEY_CONNECTION_PROP, this.authKey);
        }
        if (this.secretKey != null) {
            this.connectionProps.setProperty(SECRETKEY_CONNECTION_PROP, this.secretKey);
        }
        this.driverConnect(runLocale);
    }

    protected List<XQEMessage> getConnectonDetails() {
        ArrayList<XQEMessage> connectionDetails = new ArrayList<XQEMessage>();
        ArrayList<IXQEQueryNode> messageContext = new ArrayList<IXQEQueryNode>();
        Map info = this.connection.getExtraInformation();
        if (info.containsKey("greylistDriver")) {
            connectionDetails.add(new XQEMessage(XQEMessageKeys.DS_DriverGreylistedTestConnectionUI, this.jdbcDriverVersion, this.jdbcDriverName, messageContext));
        }
        if (info.containsKey("greylistServer")) {
            String[] greylistInfo = (String[])info.get("greylistServer");
            connectionDetails.add(new XQEMessage(XQEMessageKeys.DS_ServerGreylistedTestConnectionUI, this.databaseProductName, greylistInfo[0], messageContext));
        }
        connectionDetails.add(new XQEMessage(XQEMessageKeys.DS_DataSourceConnectionInfo, "getDatabaseProductName", this.databaseProductName, messageContext));
        connectionDetails.add(new XQEMessage(XQEMessageKeys.DS_DataSourceConnectionInfo, "getDatabaseProductVersion", this.databaseProductVersion, messageContext));
        connectionDetails.add(new XQEMessage(XQEMessageKeys.DS_DataSourceConnectionInfo, "getDriverName", this.jdbcDriverName, messageContext));
        connectionDetails.add(new XQEMessage(XQEMessageKeys.DS_DataSourceConnectionInfo, "getDriverVersion", this.jdbcDriverVersion, messageContext));
        if (this.subtype != null) {
            connectionDetails.add(new XQEMessage(XQEMessageKeys.DS_DataSourceConnectionInfo, "subtype", this.subtype, messageContext));
        }
        connectionDetails.add(new XQEMessage(XQEMessageKeys.DS_DataSourceConnectionElapsedTime, String.valueOf(this.elapsedTime), messageContext));
        if (this.allowUnsupportedJDBCDatasourceVersions) {
            connectionDetails.add(new XQEMessage(XQEMessageKeys.JDB_BlackListOverride, messageContext));
        }
        return connectionDetails;
    }

    public boolean isTransformUid() {
        return this.localTransformUid;
    }

    public boolean castToNvarchar() {
        return this.castToNvarchar;
    }

    public void incrementActiveStatementCount() {
        ++this.nActiveStatements;
    }

    public void decrementActiveStatementCount() {
        --this.nActiveStatements;
    }

    public void removeResultSet(String key) {
        this.cacheMgr.removeResultSet(key);
    }

    private String prependCommandBlocks(String key) {
        String cmdBlkValue;
        IDataSourceConnectionCommandBlock cmdBlk;
        int iter;
        int cmdBlkSize = 0;
        StringBuilder sb = new StringBuilder();
        sb.append(key);
        if (this.openSessionCommandBlocks != null) {
            cmdBlkSize = this.openSessionCommandBlocks.size();
            for (iter = 0; iter < cmdBlkSize; ++iter) {
                cmdBlk = this.openSessionCommandBlocks.get(iter);
                cmdBlkValue = (String)cmdBlk.getProperty("sql");
                if (null != cmdBlkValue) {
                    sb.insert(0, cmdBlkValue);
                }
                if (null == (cmdBlkValue = (String)cmdBlk.getProperty("userName"))) continue;
                sb.insert(0, cmdBlkValue);
            }
        }
        if (this.closeSessionCommandBlocks != null) {
            cmdBlkSize = this.closeSessionCommandBlocks.size();
            for (iter = 0; iter < cmdBlkSize; ++iter) {
                cmdBlk = this.closeSessionCommandBlocks.get(iter);
                cmdBlkValue = (String)cmdBlk.getProperty("sql");
                if (null != cmdBlkValue) {
                    sb.insert(0, cmdBlkValue);
                }
                if (null == (cmdBlkValue = (String)cmdBlk.getProperty("userName"))) continue;
                sb.insert(0, cmdBlkValue);
            }
        }
        return sb.toString();
    }

    public String getOIDCIdToken() {
        return this.mOIDCIdToken;
    }

    public void setOIDCIdToken(String aOIDCIdToken) {
        this.mOIDCIdToken = aOIDCIdToken;
    }

    public String getOIDCAccessToken() {
        if (null == this.mOIDCAccessToken) {
            return "";
        }
        return this.mOIDCAccessToken.decrypt();
    }

    public void setOIDCAccessToken(IEncryptedObject<String> aOIDCAccessToken) {
        this.mOIDCAccessToken = aOIDCAccessToken;
    }

    private static String getNameSpaceName(IDataSourceConnection dataSourceConnection) {
        String nameSpaceString = dataSourceConnection.getNamespace();
        if (null == nameSpaceString) {
            JDBCLog.getLogger(LogLevel.ERROR).log("[JDBC] Data source connection namespace is not defined.");
            return null;
        }
        if (nameSpaceString.startsWith(CAMID_PREFIX) && nameSpaceString.endsWith(CAMID_SUFFIX)) {
            return nameSpaceString.substring(CAMID_PREFIX.length(), nameSpaceString.length() - CAMID_SUFFIX.length());
        }
        JDBCLog.getLogger(LogLevel.WARN).log(String.format("Unexpected namespace format [%s]. Expected 'namespace=CAMID(\"XXXXX\")'.", nameSpaceString));
        return nameSpaceString;
    }

    public int getMaxVarcharSize() {
        return this.maxVarCharSize;
    }

    public long getMaxRowsRetrieved() {
        return this.maxRowsRetrieved;
    }

    private boolean isExpired(Governors governors, long timeCreated) {
        return governors != null && governors.getDataCacheEffectiveExpiry(null) > 0 && System.currentTimeMillis() > timeCreated + (long)(governors.getDataCacheEffectiveExpiry(null) * 1000);
    }

    static {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        int tmpBufferSize = configuration.getIntegerProperty("general.fetchBufferSize[@value]", 100);
        JDBCLog.getLogger().log(LogLevel.TRACE, "Configured general.fetchBufferSize size: " + tmpBufferSize + STR_KB);
        if (tmpBufferSize > 0x1FFFFF) {
            tmpBufferSize = 0x1FFFFF;
            JDBCLog.getLogger().log(LogLevel.TRACE, "Configured general.fetchBufferSize size too large, set to MAX: " + tmpBufferSize + STR_KB);
        }
        defaultFetchBufferSize = tmpBufferSize * 1024;
        CMD_BLOCK_CACHE_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "CommandBlockCache", LogLevel.INFO);
    }
}

