/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.jdbc;

import com.cognos.xqe.data.model.IDataSourceCapabilities;

public class JDBCIsolationLevel {
    static ObjectModelIsolationLevelInfo[] allObjectModelIsolationInfo = new ObjectModelIsolationLevelInfo[]{ObjectModelIsolationLevelInfo.RU, ObjectModelIsolationLevelInfo.RC, ObjectModelIsolationLevelInfo.CS, ObjectModelIsolationLevelInfo.RR, ObjectModelIsolationLevelInfo.PP, ObjectModelIsolationLevelInfo.SE};
    static JisolationLevelInfo[] allJInfo = new JisolationLevelInfo[]{JisolationLevelInfo.jRU, JisolationLevelInfo.jRC, JisolationLevelInfo.jRR, JisolationLevelInfo.jSE};

    public static int getIsolationLevel(String portalIsolationLevelStr, IDataSourceCapabilities capabilities, Object[] response) {
        int isoLevel = -1;
        boolean bumped = false;
        for (int i = 0; i < allObjectModelIsolationInfo.length; ++i) {
            if (!portalIsolationLevelStr.equals(JDBCIsolationLevel.allObjectModelIsolationInfo[i].isoName)) continue;
            isoLevel = JDBCIsolationLevel.allObjectModelIsolationInfo[i].jdbcIsolationLevel;
            bumped = JDBCIsolationLevel.allObjectModelIsolationInfo[i].bumpedUp;
        }
        int isolationLevelToSet = -1;
        if (isoLevel != -1) {
            block1: for (int i = 0; i < allJInfo.length && isolationLevelToSet == -1; ++i) {
                String cap;
                int j;
                if (JDBCIsolationLevel.allJInfo[i].jdbcIsolationLevel != isoLevel) continue;
                for (j = i; j < allJInfo.length; ++j) {
                    cap = JDBCIsolationLevel.allJInfo[j].capabilityName;
                    if (!capabilities.getBooleanValue(cap)) continue;
                    isolationLevelToSet = JDBCIsolationLevel.allJInfo[j].jdbcIsolationLevel;
                    break;
                }
                if (isolationLevelToSet != -1) continue;
                for (j = i - 1; j >= 0; --j) {
                    cap = JDBCIsolationLevel.allJInfo[j].capabilityName;
                    if (!capabilities.getBooleanValue(cap)) continue;
                    isolationLevelToSet = JDBCIsolationLevel.allJInfo[j].jdbcIsolationLevel;
                    continue block1;
                }
            }
            bumped |= isoLevel != isolationLevelToSet;
        }
        if (response != null) {
            response[0] = bumped;
            response[1] = isolationLevelToSet;
        }
        return isolationLevelToSet;
    }

    public static String getIsolationLevelName(int isoLevel) {
        for (int i = allObjectModelIsolationInfo.length - 1; i >= 0; --i) {
            if (JDBCIsolationLevel.allObjectModelIsolationInfo[i].jdbcIsolationLevel != isoLevel) continue;
            return JDBCIsolationLevel.allObjectModelIsolationInfo[i].isoName;
        }
        return "";
    }

    public static enum JisolationLevelInfo {
        jRU("supports.isolationLevelReadUncommitted", 1),
        jRC("supports.isolationLevelReadCommitted", 2),
        jRR("supports.isolationLevelRepeatableRead", 4),
        jSE("supports.isolationLevelSerializable", 8);

        public final String capabilityName;
        public final int jdbcIsolationLevel;

        private JisolationLevelInfo(String cap, int isoLevel) {
            this.capabilityName = cap;
            this.jdbcIsolationLevel = isoLevel;
        }
    }

    public static enum ObjectModelIsolationLevelInfo {
        RU("readUncommitted", 1, false),
        RC("readCommitted", 2, false),
        CS("cursorStability", 4, true),
        RR("reproducableRead", 4, false),
        PP("phantomProtection", 8, true),
        SE("serializable", 8, false);

        final String isoName;
        final int jdbcIsolationLevel;
        final boolean bumpedUp;

        private ObjectModelIsolationLevelInfo(String lab, int iso, boolean bumped) {
            this.isoName = lab;
            this.jdbcIsolationLevel = iso;
            this.bumpedUp = bumped;
        }
    }
}

