/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.jdbc;

import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.bibushandler.Commands;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.cache.ICaching;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.ProviderResultSetBase;
import com.cognos.xqe.data.providers.relational.SQLQueryArguments;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCCancelHandler;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCConnection;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCDataProvider;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCLog;
import com.cognos.xqe.data.providers.relational.jdbc.util.DirectAccessJDBCRow;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntervalType;
import com.cognos.xqe.data.types.RowType;
import com.cognos.xqe.data.values.DataLinkValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.exception.XQEUnrecoverableConnectionException;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.IColumnInfo;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.caching.CachedResultSetManager;
import com.cognos.xqe.resultsets.tabular.ColumnInfo;
import com.cognos.xqe.resultsets.tabular.RowsetInfo;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatchUtil;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.ConnectionUtil;
import com.cognos.xqe.util.resource.ReleasableResourceTracker;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqe.zipi.ZipiContext;
import com.ibm.cognos.jdbc.adaptor.IAdaptorResultSet;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import com.ibm.icu.text.Collator;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class JDBCTabularResult
extends ProviderResultSetBase
implements ITabularResultSet,
CachedResultSetManager.IPooledConnectionDelegator {
    private static final String CAUSED = "\ncaused ";
    static final long serialVersionUID = 1L;
    static final String CONNECTION_STRING = "connectionString";
    private static final String JDBC_RETURNING_THE_POOLED_CONNECTION = "Returning the pooled connection.";
    private static final String SUPPORTS_CONNECTION_DROPPED_ON_CANCEL = "supports.connectionDroppedOnCancel";
    protected static final int TIMESTAMP_PARTS = 7;
    protected JDBCDataProvider dataProvider;
    protected IPooledConnection pooledConnection;
    protected SQLQueryArguments queryArgs;
    protected JDBCConnection connection;
    protected Statement statement;
    protected ResultSet resultSet;
    protected int nIterators;
    protected List<ITabularResultSet> siblings;
    protected IExecutionEnvironment execEnv;
    protected JDBCCancelHandler cancelHandler;
    protected boolean getTimeTzUsingCalendar;
    protected boolean getTimestampTzUsingCalendar;
    protected boolean getTimeStampTzUsingObject;
    protected boolean bCanceled;
    private boolean isCaching;
    protected XQEBaseQueryNode parent;
    private RowType rowType;
    private boolean vectorizable;

    public JDBCTabularResult(XDataContext context, IPooledConnection thePooledConnection, SQLQueryArguments theQueryArgs, Integer nodeId, JDBCDataProvider theDataProvider) {
        block24: {
            super(theDataProvider, context, theQueryArgs.getRunLocale(), nodeId);
            this.resultSet = null;
            this.siblings = new ArrayList<ITabularResultSet>();
            this.execEnv = null;
            this.cancelHandler = null;
            this.getTimeTzUsingCalendar = false;
            this.getTimestampTzUsingCalendar = false;
            this.getTimeStampTzUsingObject = false;
            this.bCanceled = false;
            this.isCaching = false;
            this.execEnv = context.getEnvironment();
            this.dataProvider = theDataProvider;
            this.queryArgs = theQueryArgs;
            this.parent = this.queryArgs.getParent();
            try {
                this.pooledConnection = thePooledConnection;
                this.connection = (JDBCConnection)this.pooledConnection.getConnection();
                this.cancelHandler = new JDBCCancelHandler(this);
                this.execEnv.getCancelManager().addCancelHandler(this.cancelHandler);
                ResultSetMetaData metadata = null;
                ParameterMetaData parmMetaData = null;
                Object re = this.queryArgs.getExecutionEnvironment().getRequestEnvironment();
                boolean validateMissingMembers = re.isValidateMissingMembers();
                boolean validateRequest = this.queryArgs.getExecutionEnvironment().getRequestEnvironment().isValidateRequest();
                if (validateMissingMembers) {
                    validateRequest = false;
                }
                if (this.connection.getCapabilities().isSupported("supports.preparedstatement") && (this.queryArgs.isUpdateSubject() || this.queryArgs.isCallStatement() || this.queryArgs.getParamNameListForParameterizedSQL() != null && !this.queryArgs.getParamNameListForParameterizedSQL().isEmpty() || validateRequest)) {
                    this.statement = this.connection.prepare(this.execEnv, this.queryArgs);
                    this.connection.incrementActiveStatementCount();
                    parmMetaData = this.getParameterMetaData((PreparedStatement)this.statement, this.queryArgs.getParamNameListForParameterizedSQL(), context);
                    if (this.queryArgs.isUpdateSubject()) {
                        this.executeUpdateSubject(context, parmMetaData);
                    } else if (this.queryArgs.getExecutionEnvironment().getRequestEnvironment().isValidateRequest()) {
                        this.setParameterValues(context, this.queryArgs.getParamNameListForParameterizedSQL(), parmMetaData, 0);
                        metadata = this.getMetaData((PreparedStatement)this.statement, context);
                        if (metadata == null) {
                            this.resultSet = this.createJDBCResultSet(null);
                            metadata = this.resultSet.getMetaData();
                        }
                    } else {
                        this.setParameterValues(context, this.queryArgs.getParamNameListForParameterizedSQL(), parmMetaData, 0);
                        this.resultSet = this.createJDBCResultSet(null);
                        metadata = this.resultSet.getMetaData();
                    }
                } else {
                    this.statement = this.connection.createStatement(this.execEnv, this.queryArgs);
                    this.connection.incrementActiveStatementCount();
                    this.resultSet = this.createJDBCResultSet(this.queryArgs.getSQLQuery());
                    metadata = this.resultSet.getMetaData();
                }
                if (!this.queryArgs.isUpdateSubject() && metadata != null) {
                    IRowsetInfo calculatedRowsetInfo;
                    int i;
                    boolean forceNullsOk = this.connection.getCapabilities().isSupported("general.forceNullsOk");
                    int nColumns = metadata.getColumnCount();
                    this.rowsetInfo = new RowsetInfo();
                    for (i = 0; i < nColumns; ++i) {
                        IDataSourceCapabilities capabilities;
                        IDataType dType = this.createDataTypeFromJDBCType(metadata, i + 1);
                        ColumnInfo columnInfo = this.queryArgs.isCallStatement() ? ("false".equalsIgnoreCase((capabilities = this.connection.getCapabilities()).getStringValue("supports.storedProcedureColumnUnique", "true")) ? new ColumnInfo(metadata.getColumnLabel(i + 1) + "_" + i, dType) : new ColumnInfo(metadata.getColumnLabel(i + 1), dType)) : new ColumnInfo(metadata.getColumnLabel(i + 1), dType);
                        if (forceNullsOk) {
                            columnInfo.setNullable(true);
                        } else {
                            columnInfo.setNullable(metadata.isNullable(i + 1) == 1);
                        }
                        this.rowsetInfo.addColumnInfo(columnInfo);
                    }
                    this.rowType = (RowType)this.rowsetInfo.getDataType();
                    this.vectorizable = true;
                    for (i = 0; i < this.rowsetInfo.getNumColumns(); ++i) {
                        IColumnInfo colInfo = this.rowsetInfo.getColumnInfo(i);
                        IDataType dataType = colInfo.getDataType();
                        if (!dataType.isBlob() && !dataType.isClob() && !dataType.isArray() && !dataType.isPeriod()) continue;
                        this.vectorizable = false;
                    }
                    if ((this.queryArgs.getVectorizationContext() != null || this.queryArgs.getOverwriteDBType()) && (calculatedRowsetInfo = this.queryArgs.getCalculatedRowsetInfo()) != null) {
                        for (int i2 = 0; i2 < calculatedRowsetInfo.getNumColumns(); ++i2) {
                            IDataType dataType2 = calculatedRowsetInfo.getColumnInfo(i2).getDataType();
                            if (!dataType2.isNumeric()) continue;
                            this.rowsetInfo.getColumnInfo(i2).setDataType(dataType2);
                        }
                    }
                }
            }
            catch (OperationCanceledException ce) {
                this.release();
                throw ce;
            }
            catch (XQERuntimeException re) {
                this.release();
                throw re;
            }
            catch (SQLException e) {
                e = this.connection.processSQLException(e);
                boolean unrecoverableConnection = this.connection.isUnrecoverableConnection(e);
                if (unrecoverableConnection) {
                    this.pooledConnection.setNotReusable();
                }
                try {
                    if (!this.connection.getConnection().getAutoCommit()) {
                        this.connection.getConnection().rollback();
                    }
                }
                catch (SQLException ex) {
                    this.pooledConnection.setNotReusable();
                }
                this.release();
                JDBCLog.getLogger(LogLevel.ERROR).log(this.queryArgs.getSQLQuery() + CAUSED, (Throwable)e);
                if (this.bCanceled) break block24;
                if (unrecoverableConnection) {
                    throw new XQEUnrecoverableConnectionException(e, e.toString());
                }
                throw new XQERuntimeException(XQEMessageKeys.DAT_DataSourceAdapterError, (Throwable)e, e.toString());
            }
        }
    }

    @Override
    public boolean isVectorized() {
        return this.vectorizable;
    }

    private ResultSet createJDBCResultSet(String sql) throws SQLException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("JDBCResultSet", this.parent.getNodeTypeName(), ZipiContext.getQRDName());
        ResultSet rs = null;
        try {
            boolean hasResultSet = sql == null ? ((PreparedStatement)this.statement).execute() : this.statement.execute(sql);
            if (!hasResultSet) {
                boolean moreResult = this.statement.getMoreResults();
                while (!moreResult && this.statement.getUpdateCount() != -1) {
                    moreResult = this.statement.getMoreResults();
                }
                if (!moreResult) {
                    if (this.queryArgs.isCallStatement()) {
                        throw new XQERuntimeException(XQEMessageKeys.EXE_ProcedureNoResultset, this.queryArgs.getStoredProcedureName());
                    }
                    throw new XQERuntimeException();
                }
            }
            rs = this.statement.getResultSet();
        }
        catch (SQLException sqlEx) {
            if (this.isCanceled()) {
                if (this.connection.getCapabilities().isSupported(SUPPORTS_CONNECTION_DROPPED_ON_CANCEL)) {
                    this.pooledConnection.setNotReusable();
                }
                throw new OperationCanceledException();
            }
            throw sqlEx;
        }
        finally {
            if (zipiTimer != null) {
                zipiTimer.stop();
            }
        }
        return rs;
    }

    private void executeUpdateSubject(XDataContext context, ParameterMetaData parmMetaData) throws SQLException {
        int i = 0;
        while (this.setParameterValues(context, this.queryArgs.getParamNameListForParameterizedSQL(), parmMetaData, i)) {
            if (((PreparedStatement)this.statement).execute()) {
                while (this.statement.getMoreResults()) {
                }
            }
            ++i;
        }
    }

    protected boolean setParameterValues(XDataContext context, List<String> paramNameList, ParameterMetaData parmMetaData, int row) {
        try {
            if (parmMetaData != null && parmMetaData.getParameterCount() == 0) {
                if (paramNameList != null && paramNameList.size() != 0) {
                    String paramNames = paramNameList.get(0);
                    int nParameters = paramNameList.size();
                    for (int i = 1; i < nParameters; ++i) {
                        paramNames.concat(", " + paramNameList.get(i));
                    }
                    throw new XQERuntimeException(XQEMessageKeys.EXE_ParametersProvided, paramNames, this.queryArgs.getSQLQuery());
                }
                return row == 0;
            }
            int nParameters = 0;
            if (parmMetaData != null) {
                nParameters = parmMetaData.getParameterCount();
                if (nParameters > 0 && paramNameList != null) {
                    nParameters = paramNameList.size();
                }
            } else if (paramNameList != null) {
                nParameters = paramNameList.size();
            }
            if (nParameters == 0 && row > 0) {
                return false;
            }
            for (int i = 0; i < nParameters; ++i) {
                String pName = paramNameList.get(i);
                IValue[] values = context.getParameterValues(pName);
                if (values.length > row) continue;
                return false;
            }
            List<Integer> idxListOfSPArgsDefinedAsPrompt = this.queryArgs.getIndexListOfParameterizedSPArgsDefinedAsPromptsInFM();
            if (idxListOfSPArgsDefinedAsPrompt != null && idxListOfSPArgsDefinedAsPrompt.size() <= nParameters) {
                nParameters = idxListOfSPArgsDefinedAsPrompt.size();
            }
            int idxParameter = 1;
            for (int i = 0; i < nParameters; ++i) {
                String pName = paramNameList.get(i);
                Value pValue = (Value)context.getParameterValues(pName)[row];
                int pType = 0;
                if (parmMetaData != null) {
                    try {
                        pType = parmMetaData.getParameterType(i + 1);
                    }
                    catch (SQLException e) {
                        pType = 0;
                    }
                }
                if (idxListOfSPArgsDefinedAsPrompt != null) {
                    idxParameter = idxListOfSPArgsDefinedAsPrompt.get(i);
                }
                this.setStatementParameter((PreparedStatement)this.statement, idxParameter, pValue, pType);
                ++idxParameter;
            }
        }
        catch (SQLException e2) {
            Object e2 = null;
        }
        return true;
    }

    protected void setStatementParameter(PreparedStatement pstmt, int colNum, Value value, int jdbcType) throws SQLException {
        if (JDBCLog.isOn()) {
            JDBCLog.log(String.format("Parameter binding: position = %1$d, sqltype = %2$d, value = %3$s", colNum, jdbcType, value));
        }
        if (jdbcType == 0) {
            jdbcType = DataTypeFactory.getJdbcDataType(value.getDataType().getCCLTypeCode());
        }
        switch (jdbcType) {
            case -1: 
            case 1: 
            case 12: {
                pstmt.setString(colNum, value.getString());
                break;
            }
            case -6: 
            case 5: {
                pstmt.setShort(colNum, value.getShort());
                break;
            }
            case 4: {
                pstmt.setInt(colNum, value.getInteger());
                break;
            }
            case -5: {
                pstmt.setLong(colNum, value.getLong());
                break;
            }
            case 6: {
                pstmt.setFloat(colNum, value.getFloat());
                break;
            }
            case 8: {
                pstmt.setDouble(colNum, value.getDouble());
                break;
            }
            case 2: 
            case 3: {
                pstmt.setBigDecimal(colNum, value.getBigDecimal());
                break;
            }
            case 91: {
                pstmt.setDate(colNum, ((DateTimeValue)value).getJdbcDate());
                break;
            }
            case 92: {
                pstmt.setTime(colNum, ((DateTimeValue)value).getTime());
                break;
            }
            case 93: {
                pstmt.setTimestamp(colNum, value.getTimestamp());
                break;
            }
            case 2005: {
                pstmt.setObject(colNum, value.getString());
                break;
            }
            default: {
                pstmt.setObject(colNum, value.getString());
            }
        }
    }

    @Override
    public long getRowCount() {
        return -1L;
    }

    @Override
    public ITabularIterator getTabularIterator() {
        return this.getTabularIterator(null);
    }

    @Override
    public ITabularIterator getTabularIterator(XVectorContext vContext) {
        try {
            ITabularIterator tabIt;
            if (this.nIterators == 0) {
                tabIt = new JDBCTabularResultIterator(this.getDataContext(), vContext, this.nodeId);
            } else {
                ITabularResultSet sibling = this.dataProvider.query(this.getDataContext(), this.queryArgs);
                this.siblings.add(sibling);
                tabIt = sibling.getTabularIterator();
            }
            ++this.nIterators;
            return tabIt;
        }
        catch (XQEException e) {
            throw new XQERuntimeException(e);
        }
    }

    @Override
    public IScrollableIterator getScrollableTabularIterator() {
        throw new UnsupportedOperationException();
    }

    private void releaseStatementAndSiblings() throws Exception {
        try {
            if (null != this.statement) {
                this.statement.close();
                this.connection.decrementActiveStatementCount();
                if (null != this.pooledConnection) {
                    this.connection.updateConnection(Commands.CMD_CLOSE_SESSION);
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            for (ITabularResultSet sibling : this.siblings) {
                try {
                    sibling.release();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    protected void releaseImpl() {
        try {
            try {
                this.releaseStatementAndSiblings();
            }
            catch (Exception se) {
                JDBCLog.getLogger().log(LogLevel.ERROR, (Throwable)se);
                if (this.pooledConnection != null) {
                    this.pooledConnection.setNotReusable();
                }
                throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)se);
            }
            finally {
                this.statement = null;
                this.returnConnection();
                if (this.cancelHandler != null) {
                    this.execEnv.getCancelManager().removeCancelHandler(this.cancelHandler);
                    this.cancelHandler = null;
                }
            }
        }
        finally {
            super.releaseImpl();
        }
    }

    public IDataType createDataTypeFromJDBCType(ResultSetMetaData metadata, int columnNo) {
        return this.connection.createDataTypeFromJDBCType(metadata, columnNo);
    }

    public IValue createValueFromJDBCType(Collator collator, ResultSetMetaData metadata, int columnNo) {
        IDataType dataType = this.createDataTypeFromJDBCType(metadata, columnNo);
        return dataType.createValue(collator);
    }

    public IDataSourceCapabilities getCapabilities() {
        return this.connection.getCapabilities();
    }

    public boolean isCanceled() {
        return this.bCanceled;
    }

    public boolean canBeCanceled() {
        if (this.statement == null) {
            return false;
        }
        if (this.nIterators > 1) {
            return false;
        }
        return !this.isCanceled();
    }

    public void setCanceled(boolean cancelled) {
        this.bCanceled = cancelled;
    }

    public boolean cancelImpl() {
        boolean canceled;
        block3: {
            canceled = true;
            Statement localStatement = this.statement;
            if (localStatement != null) {
                try {
                    localStatement.cancel();
                }
                catch (SQLException ex) {
                    if (null == this.statement) break block3;
                    canceled = false;
                    JDBCLog.getLogger().log(LogLevel.ERROR, "Error cancelling request: ", (Throwable)ex);
                }
            }
        }
        return canceled;
    }

    protected ParameterMetaData getParameterMetaData(PreparedStatement pstmt, List<String> map, XDataContext context) throws SQLException {
        ParameterMetaData metadata = null;
        try {
            metadata = pstmt.getParameterMetaData();
        }
        catch (SQLException e) {
            metadata = null;
        }
        return metadata;
    }

    protected ResultSetMetaData getMetaData(PreparedStatement pstmt, XDataContext context) throws SQLException {
        ResultSetMetaData metadata = null;
        try {
            metadata = pstmt.getMetaData();
        }
        catch (SQLException e) {
            metadata = null;
        }
        return metadata;
    }

    private void onEndOfData() {
        try {
            if (this.statement != null) {
                this.statement.close();
                this.connection.decrementActiveStatementCount();
                if (this.pooledConnection != null) {
                    this.connection.updateConnection(Commands.CMD_CLOSE_SESSION);
                }
            }
        }
        catch (SQLException se) {
            JDBCLog.getLogger().log(LogLevel.ERROR, (Throwable)se);
            if (this.pooledConnection != null) {
                this.pooledConnection.setNotReusable();
            }
        }
        finally {
            this.statement = null;
            this.returnConnection();
        }
    }

    private void returnConnection() {
        if (this.pooledConnection != null) {
            this.pooledConnection.returnConnection();
            this.pooledConnection = null;
            JDBCLog.getLogger().log(JDBC_RETURNING_THE_POOLED_CONNECTION);
        }
    }

    @Override
    public IPooledConnection delegatePooledConnection() {
        IPooledConnection result = this.pooledConnection;
        this.pooledConnection = null;
        return result;
    }

    public void setIsCaching(boolean caching) {
        this.isCaching = caching;
    }

    @Override
    public boolean isCaching() {
        return this.isCaching;
    }

    public void setColumnValue(Value value, int column) throws SQLException {
        IDataType xqeType = this.rowType.getFieldDataType(column);
        int jdbcType = JDBCTabularResult.getJDBCType(xqeType);
        if (jdbcType != 0) {
            value.set(((IAdaptorResultSet)this.resultSet).getExtendedData(jdbcType, column + 1));
        } else {
            this.setStandardJDBCColumnValue(value, column);
        }
    }

    private static int getJDBCType(IDataType xqeType) {
        int jdbcType = 0;
        block0 : switch (xqeType.getCCLTypeCode()) {
            case 108: {
                jdbcType = -1016;
                break;
            }
            case 109: {
                jdbcType = -1017;
                break;
            }
            case 110: {
                jdbcType = -1018;
                break;
            }
            case 111: {
                jdbcType = -1019;
                break;
            }
            case 112: {
                jdbcType = -1020;
                break;
            }
            case 17: 
            case 60: {
                switch (((IntervalType)xqeType).getQualifier()) {
                    case INTERVAL_YEAR_TO_MONTH: {
                        jdbcType = -1004;
                        break block0;
                    }
                    case INTERVAL_YEAR: {
                        jdbcType = -1003;
                        break block0;
                    }
                    case INTERVAL_MONTH: {
                        jdbcType = -1005;
                        break block0;
                    }
                    case INTERVAL_DAY_TO_HOUR: {
                        jdbcType = -1007;
                        break block0;
                    }
                    case INTERVAL_DAY_TO_MINUTE: {
                        jdbcType = -1008;
                        break block0;
                    }
                    case INTERVAL_DAY_TO_SECOND: {
                        jdbcType = -1009;
                        break block0;
                    }
                    case INTERVAL_HOUR_TO_MINUTE: {
                        jdbcType = -1011;
                        break block0;
                    }
                    case INTERVAL_HOUR_TO_SECOND: {
                        jdbcType = -1012;
                        break block0;
                    }
                    case INTERVAL_MINUTE_TO_SECOND: {
                        jdbcType = -1014;
                        break block0;
                    }
                    case INTERVAL_DAY: {
                        jdbcType = -1006;
                        break block0;
                    }
                    case INTERVAL_HOUR: {
                        jdbcType = -1010;
                        break block0;
                    }
                    case INTERVAL_MINUTE: {
                        jdbcType = -1013;
                        break block0;
                    }
                    case INTERVAL_SECOND: {
                        jdbcType = -1015;
                        break block0;
                    }
                }
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "JDBC Adaptor result set: Invalid interval qualifier.");
            }
            case 53: {
                jdbcType = -1001;
                break;
            }
            case 52: {
                jdbcType = -1002;
                break;
            }
            case 100: {
                jdbcType = 2009;
                break;
            }
            default: {
                jdbcType = 0;
            }
        }
        return jdbcType;
    }

    private void setStandardJDBCColumnValue(Value value, int column) throws SQLException {
        IDataType dataType = this.rowType.getFieldDataType(column);
        switch (dataType.getCCLTypeCode()) {
            case 51: {
                value.set(this.resultSet.getBoolean(column + 1));
                break;
            }
            case 1: 
            case 45: 
            case 55: 
            case 56: 
            case 114: {
                value.set(this.resultSet.getString(column + 1));
                break;
            }
            case 4: {
                int scale = dataType.getScale();
                if (scale > 0) {
                    BigDecimal bigDecimal = this.resultSet.getBigDecimal(column + 1);
                    if (this.resultSet.wasNull()) break;
                    value.set(bigDecimal.setScale(scale));
                    break;
                }
                value.set(this.resultSet.getShort(column + 1));
                break;
            }
            case 6: {
                int scale = dataType.getScale();
                if (scale > 0) {
                    BigDecimal bigDecimal = this.resultSet.getBigDecimal(column + 1);
                    if (this.resultSet.wasNull()) break;
                    value.set(bigDecimal.setScale(scale));
                    break;
                }
                value.set(this.resultSet.getInt(column + 1));
                break;
            }
            case 8: {
                int scale = dataType.getScale();
                if (scale > 0) {
                    BigDecimal bigDecimal = this.resultSet.getBigDecimal(column + 1);
                    if (this.resultSet.wasNull()) break;
                    value.set(bigDecimal.setScale(scale));
                    break;
                }
                value.set(this.resultSet.getLong(column + 1));
                break;
            }
            case 10: {
                value.set(this.resultSet.getFloat(column + 1));
                break;
            }
            case 11: {
                value.set(this.resultSet.getDouble(column + 1));
                break;
            }
            case 12: {
                value.set(this.resultSet.getBigDecimal(column + 1));
                break;
            }
            case 57: {
                value.set(this.resultSet.getDate(column + 1));
                break;
            }
            case 58: {
                value.set(this.resultSet.getTime(column + 1));
                break;
            }
            case 59: {
                value.set(this.resultSet.getTimestamp(column + 1));
                break;
            }
            case 23: 
            case 24: {
                value.set(this.resultSet.getBytes(column + 1));
                break;
            }
            case 46: {
                value.set(this.resultSet.getClob(column + 1));
                break;
            }
            case 18: {
                value.set(this.resultSet.getBlob(column + 1));
                break;
            }
            case 102: {
                Array arr = this.resultSet.getArray(column + 1);
                value.set(arr.getArray());
                break;
            }
            case 105: {
                value.set(this.resultSet.getObject(column + 1));
                break;
            }
            case 106: {
                value.set(this.resultSet.getObject(column + 1));
                break;
            }
            case 48: {
                ((DataLinkValue)value).set(this.resultSet.getURL(column + 1));
                break;
            }
            default: {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "JDBC tabular result: Invalid type for JDBC result set value.");
            }
        }
    }

    public ResultSet getRawResultSet() {
        return this.resultSet;
    }

    public RuntimeException analyzeSQLException(SQLException e) {
        e = this.connection.processSQLException(e);
        JDBCLog.getLogger(LogLevel.ERROR).log(this.queryArgs.getSQLQuery() + CAUSED, (Throwable)e);
        if (this.connection.isUnrecoverableConnection(e)) {
            if (this.pooledConnection != null) {
                this.pooledConnection.setNotReusable();
            }
            if (e != null) {
                return new XQEUnrecoverableConnectionException(e, e.toString());
            }
            return new XQEUnrecoverableConnectionException(null, "");
        }
        return new XQERuntimeException(XQEMessageKeys.DAT_DataSourceAdapterError, (Throwable)e, e.toString());
    }

    public ITabularIterator getDirectTabularIterator() {
        try {
            if (this.nIterators != 0) {
                throw new RuntimeException("Can have only one direct iterator per result set");
            }
            JDBCTabularResultDirectIterator tabIt = new JDBCTabularResultDirectIterator(this.getDataContext(), this.nodeId);
            ++this.nIterators;
            return tabIt;
        }
        catch (OperationCanceledException cancelEx) {
            throw cancelEx;
        }
        catch (XQERuntimeException e) {
            throw new XQERuntimeException(e);
        }
    }

    @Override
    public long getPooledConnectionBorrowedTimeBegin() {
        return -1L;
    }

    protected class JDBCTabularResultDirectIterator
    extends JDBCTabularResultIterator {
        DirectAccessJDBCRow jdbcRow;

        protected JDBCTabularResultDirectIterator(XDataContext context, Integer id) {
            super(context, null, id);
            this.jdbcRow = null;
            if (this.row != null) {
                this.jdbcRow = new DirectAccessJDBCRow(this.row, JDBCTabularResult.this);
            }
        }

        @Override
        public Object nextImpl() {
            try {
                if (JDBCTabularResult.this.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (JDBCTabularResult.this.resultSet == null || !JDBCTabularResult.this.resultSet.next()) {
                    this.release();
                    JDBCTabularResult.this.onEndOfData();
                    return null;
                }
            }
            catch (SQLException e) {
                if (JDBCTabularResult.this.isCanceled()) {
                    throw new OperationCanceledException();
                }
                RuntimeException en = JDBCTabularResult.this.analyzeSQLException(e);
                throw en;
            }
            ++this.nRows;
            this.jdbcRow.invalidate();
            return this.jdbcRow;
        }
    }

    protected class JDBCTabularResultIterator
    extends XTabularIterator
    implements ICaching {
        protected int nColumns;
        private XVectorRowBatch batch;
        protected RowValue row;
        protected final AtomicBoolean mReleased;
        private boolean eod;

        protected JDBCTabularResultIterator(XDataContext context, Integer id) {
            this(context, null, id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected JDBCTabularResultIterator(XDataContext context, XVectorContext vContext, Integer id) {
            super(context, id);
            this.mReleased = new AtomicBoolean(false);
            try {
                this.startTimer();
                if (JDBCTabularResult.this.resultSet == null) {
                    RequestEnvironment reqEnv;
                    if (JDBCTabularResult.this.statement == null) {
                        IExecutionEnvironment env = context.getEnvironment();
                        if (JDBCTabularResult.this.pooledConnection == null) {
                            JDBCTabularResult.this.pooledConnection = ConnectionUtil.getPooledConnection(env, JDBCTabularResult.this.queryArgs.getDataSource());
                            JDBCTabularResult.this.connection = (JDBCConnection)JDBCTabularResult.this.pooledConnection.getConnection();
                        }
                        if (JDBCTabularResult.this.queryArgs.isUpdateSubject() || JDBCTabularResult.this.queryArgs.isCallStatement() || JDBCTabularResult.this.queryArgs.getParamNameListForParameterizedSQL() != null && !JDBCTabularResult.this.queryArgs.getParamNameListForParameterizedSQL().isEmpty()) {
                            JDBCTabularResult.this.statement = JDBCTabularResult.this.connection.prepare(JDBCTabularResult.this.execEnv, JDBCTabularResult.this.queryArgs);
                            ParameterMetaData parmMetaData = JDBCTabularResult.this.getParameterMetaData((PreparedStatement)JDBCTabularResult.this.statement, JDBCTabularResult.this.queryArgs.getParamNameListForParameterizedSQL(), context);
                            if (JDBCTabularResult.this.queryArgs.isUpdateSubject()) {
                                JDBCTabularResult.this.executeUpdateSubject(context, parmMetaData);
                            } else {
                                JDBCTabularResult.this.setParameterValues(context, JDBCTabularResult.this.queryArgs.getParamNameListForParameterizedSQL(), parmMetaData, 0);
                            }
                        } else {
                            JDBCTabularResult.this.statement = JDBCTabularResult.this.connection.createStatement(JDBCTabularResult.this.execEnv, JDBCTabularResult.this.queryArgs);
                        }
                        JDBCTabularResult.this.connection.incrementActiveStatementCount();
                    }
                    JDBCTabularResult.this.resultSet = JDBCTabularResult.this.queryArgs.isUpdateSubject() ? null : (JDBCTabularResult.this.statement instanceof PreparedStatement ? ((reqEnv = (RequestEnvironment)JDBCTabularResult.this.queryArgs.getExecutionEnvironment().getRequestEnvironment()).isValidateRequest() && !reqEnv.isDMRRequest() && !reqEnv.getMasterDetailProvider().hasMasterDetailQuery() ? null : JDBCTabularResult.this.createJDBCResultSet(null)) : JDBCTabularResult.this.createJDBCResultSet(JDBCTabularResult.this.queryArgs.getSQLQuery()));
                }
                if (JDBCTabularResult.this.connection != null) {
                    this.setMaxRowsRetrievedLimit(JDBCTabularResult.this.connection.getMaxRowsRetrieved());
                }
                this.setMaxRowsLocalProcessing(context.getEnvironment().getMaxRowsLocalProcessing());
                this.nColumns = JDBCTabularResult.this.rowsetInfo.getNumColumns();
                this.row = DataValueFactory.createRowValue(context.getLocalCollator(), JDBCTabularResult.this.rowsetInfo);
                if (JDBCTabularResult.this.vectorizable) {
                    this.batch = XVectorRowBatchUtil.createRowBatch(vContext, JDBCTabularResult.this.rowsetInfo, context.getLocalCollator());
                }
                ReleasableResourceTracker parentTracker = JDBCTabularResult.this.getResourceTracker();
                parentTracker.addInstance(this, Thread.currentThread().getStackTrace());
            }
            catch (OperationCanceledException ce) {
                JDBCTabularResult.this.release();
                throw ce;
            }
            catch (XQERuntimeException re) {
                JDBCTabularResult.this.release();
                throw re;
            }
            catch (SQLException e) {
                e = JDBCTabularResult.this.connection.processSQLException(e);
                boolean unrecoverableConnection = JDBCTabularResult.this.connection.isUnrecoverableConnection(e);
                if (unrecoverableConnection) {
                    JDBCTabularResult.this.pooledConnection.setNotReusable();
                }
                try {
                    if (!JDBCTabularResult.this.connection.getConnection().getAutoCommit()) {
                        JDBCTabularResult.this.connection.getConnection().rollback();
                    }
                }
                catch (SQLException ex) {
                    JDBCTabularResult.this.pooledConnection.setNotReusable();
                }
                this.release();
                JDBCLog.getLogger(LogLevel.ERROR).log(JDBCTabularResult.this.queryArgs.getSQLQuery() + JDBCTabularResult.CAUSED, (Throwable)e);
                if (!JDBCTabularResult.this.bCanceled) {
                    if (unrecoverableConnection) {
                        throw new XQEUnrecoverableConnectionException(e, e.toString());
                    }
                    throw new XQERuntimeException(XQEMessageKeys.DAT_DataSourceAdapterError, (Throwable)e, e.toString());
                }
            }
            finally {
                this.stopTimer();
            }
        }

        @Override
        public Object nextImpl() {
            try {
                if (JDBCTabularResult.this.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (JDBCTabularResult.this.resultSet == null || !JDBCTabularResult.this.resultSet.next()) {
                    this.release();
                    JDBCTabularResult.this.onEndOfData();
                    return null;
                }
                if (this.maxRowsRetrievedLimit > 0L) {
                    this.throwExceptionIfMaxRowsLimitReached();
                }
                if (this.maxRowsLocalProcessing > 0L) {
                    this.throwExceptionIfMaxRowsLocalProcessingLimitReached();
                }
                for (int i = 0; i < this.nColumns; ++i) {
                    Value value = (Value)this.row.getColumn(i);
                    JDBCTabularResult.this.setColumnValue(value, i);
                    if (JDBCTabularResult.this.resultSet.wasNull()) {
                        value.setNull();
                    }
                    this.row.setColumn(i, value);
                }
            }
            catch (SQLException e) {
                RuntimeException en = JDBCTabularResult.this.analyzeSQLException(e);
                throw en;
            }
            ++this.nRows;
            return this.row;
        }

        @Override
        public Object nextBatch() {
            this.batch.reset();
            if (this.eod) {
                this.batch.eod = true;
                return this.batch;
            }
            while (this.batch.size != this.batch.maxBatchSize) {
                IRow tmpRow = (IRow)this.nextImpl();
                if (tmpRow == null) {
                    this.eod = true;
                    if (this.batch.size != 0) break;
                    this.batch.eod = true;
                    break;
                }
                this.batch.addRow(tmpRow);
            }
            return this.batch;
        }

        @Override
        public long getIndex() {
            int rowIndex = 0;
            try {
                rowIndex = JDBCTabularResult.this.resultSet.getRow();
            }
            catch (SQLException e) {
                throw new XQERuntimeException(e);
            }
            return rowIndex;
        }

        public IDataType getDataType() {
            return JDBCTabularResult.this.rowType;
        }

        @Override
        public boolean isCaching() {
            return JDBCTabularResult.this.isCaching();
        }

        @Override
        public void release() {
            try {
                if (this.mReleased.compareAndSet(false, true)) {
                    ReleasableResourceTracker parentTracker = JDBCTabularResult.this.getResourceTracker();
                    parentTracker.removeInstance(this);
                    if (JDBCTabularResult.this.resultSet != null) {
                        JDBCTabularResult.this.resultSet.close();
                        JDBCTabularResult.this.resultSet = null;
                    }
                    --JDBCTabularResult.this.nIterators;
                }
            }
            catch (Throwable e) {
                JDBCLog.getLogger().log(LogLevel.ERROR, e);
            }
        }
    }
}

