/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.jdbc;

import com.cognos.xqe.data.providers.relational.jdbc.JDBCLog;
import com.cognos.xqe.data.providers.relational.jdbc.XQEResultSetWrapper;
import com.cognos.xqe.data.providers.relational.jdbc.XQEStatementWrapper;
import com.cognos.xqe.util.Timer;
import com.cognos.xqe.util.usage.UsageTrackingService;
import com.ibm.cognos.jdbc.adaptor.IAdaptorResultSet;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class XQEPreparedStatementWrapper
extends XQEStatementWrapper
implements PreparedStatement {
    private static final String PREPARED_STATEMENT_EXECUTE_START = "[%1$d] [Start]PreparedStatement.execute()";
    private static final String PREPARED_STATEMENT_EXECUTE_END = "[%1$d] [  End]PreparedStatement.execute() -> [%2$b] (%3$dns)";
    private static final String PREPARED_STATEMENT_EXECUTE_QUERY_START = "[%1$d] PreparedStatement.executeQuery()";
    private static final String PREPARED_STATEMENT_EXECUTE_QUERY_END = "[%1$d] PreparedStatement.executeQuery() -> [%2$s] (%3$dns)";
    private static final String PREPARED_STATEMENT_GET_METADATA = "[%1$d] PreparedStatement.getMetaData() (%2$dns)";

    public XQEPreparedStatementWrapper(Connection connection, Statement statement) {
        super(connection, statement);
    }

    @Override
    public void clearParameters() throws SQLException {
        ((PreparedStatement)this.statement).clearParameters();
    }

    @Override
    public boolean execute() throws SQLException {
        boolean result = false;
        if (JDBCLog.isOn()) {
            JDBCLog.log(String.format(PREPARED_STATEMENT_EXECUTE_START, this.id));
        }
        Timer timer = new Timer();
        try {
            timer.start();
            result = ((PreparedStatement)this.statement).execute();
        }
        catch (SQLException e) {
            JDBCLog.getLogger().log(String.format(PREPARED_STATEMENT_EXECUTE_END, this.id, false, timer.get()));
            JDBCLog.getLogger().log(e.getLocalizedMessage());
            if (e instanceof SQLRecoverableException) {
                JDBCLog.getLogger().log("sql state:" + e.getSQLState() + " error code:" + e.getErrorCode());
            }
            throw e;
        }
        finally {
            long time = timer.stop();
        }
        if (JDBCLog.isOn()) {
            long time;
            JDBCLog.log(String.format(PREPARED_STATEMENT_EXECUTE_END, this.id, result, time));
        }
        JDBCLog.incrementTimeSpentInJDBC(timer.getElapsedTimeInMilliseconds());
        return result;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        XQEResultSetWrapper resultSet = null;
        if (JDBCLog.isOn() || UsageTrackingService.isOn()) {
            if (JDBCLog.isOn()) {
                JDBCLog.log(String.format(PREPARED_STATEMENT_EXECUTE_QUERY_START, this.id));
            }
            Timer timer = new Timer();
            try {
                timer.start();
                resultSet = new XQEResultSetWrapper((IAdaptorResultSet)((PreparedStatement)this.statement).executeQuery());
            }
            catch (SQLException e) {
                JDBCLog.getLogger().log(String.format(PREPARED_STATEMENT_EXECUTE_QUERY_END, this.id, null, timer.get()));
                JDBCLog.getLogger().log(e.getLocalizedMessage());
                throw e;
            }
            finally {
                long time = timer.stop();
            }
            if (JDBCLog.isOn()) {
                long time;
                JDBCLog.log(String.format(PREPARED_STATEMENT_EXECUTE_QUERY_END, this.id, resultSet.getID(), time));
            }
            JDBCLog.incrementTimeSpentInJDBC(timer.getElapsedTimeInMilliseconds());
        } else {
            resultSet = new XQEResultSetWrapper((IAdaptorResultSet)((PreparedStatement)this.statement).executeQuery());
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSetMetaData metaData;
        if (JDBCLog.isOn() || UsageTrackingService.isOn()) {
            long time;
            Timer timer = new Timer();
            try {
                timer.start();
                metaData = ((PreparedStatement)this.statement).getMetaData();
            }
            finally {
                time = timer.stop();
            }
            if (metaData != null) {
                if (JDBCLog.isOn()) {
                    JDBCLog.log(String.format(PREPARED_STATEMENT_GET_METADATA, this.id, time));
                }
                JDBCLog.incrementTimeSpentInJDBC(timer.getElapsedTimeInMilliseconds());
            }
        } else {
            metaData = ((PreparedStatement)this.statement).getMetaData();
        }
        return metaData;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return ((PreparedStatement)this.statement).getParameterMetaData();
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        ((PreparedStatement)this.statement).setArray(i, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        ((PreparedStatement)this.statement).setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        ((PreparedStatement)this.statement).setBigDecimal(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        ((PreparedStatement)this.statement).setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        ((PreparedStatement)this.statement).setBlob(i, x);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        ((PreparedStatement)this.statement).setBoolean(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        ((PreparedStatement)this.statement).setByte(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        ((PreparedStatement)this.statement).setBytes(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        ((PreparedStatement)this.statement).setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        ((PreparedStatement)this.statement).setClob(i, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        ((PreparedStatement)this.statement).setDate(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        ((PreparedStatement)this.statement).setDate(parameterIndex, x, cal);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        ((PreparedStatement)this.statement).setDouble(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        ((PreparedStatement)this.statement).setFloat(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        ((PreparedStatement)this.statement).setInt(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        ((PreparedStatement)this.statement).setLong(parameterIndex, x);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        ((PreparedStatement)this.statement).setNull(parameterIndex, sqlType);
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        ((PreparedStatement)this.statement).setNull(paramIndex, sqlType, typeName);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        ((PreparedStatement)this.statement).setObject(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        ((PreparedStatement)this.statement).setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        ((PreparedStatement)this.statement).setObject(parameterIndex, x, targetSqlType, scale);
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        ((PreparedStatement)this.statement).setRef(i, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        ((PreparedStatement)this.statement).setShort(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        ((PreparedStatement)this.statement).setString(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        ((PreparedStatement)this.statement).setTime(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        ((PreparedStatement)this.statement).setTime(parameterIndex, x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        ((PreparedStatement)this.statement).setTimestamp(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        ((PreparedStatement)this.statement).setTimestamp(parameterIndex, x, cal);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        ((PreparedStatement)this.statement).setURL(parameterIndex, x);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        ((PreparedStatement)this.statement).setUnicodeStream(parameterIndex, x, length);
    }

    @Override
    public void addBatch() throws SQLException {
        ((PreparedStatement)this.statement).addBatch();
    }

    @Override
    public int executeUpdate() throws SQLException {
        return ((PreparedStatement)this.statement).executeUpdate();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        ((PreparedStatement)this.statement).setAsciiStream(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        ((PreparedStatement)this.statement).setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        ((PreparedStatement)this.statement).setBinaryStream(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        ((PreparedStatement)this.statement).setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream x) throws SQLException {
        ((PreparedStatement)this.statement).setBlob(parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream x, long length) throws SQLException {
        ((PreparedStatement)this.statement).setBlob(parameterIndex, x, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        ((PreparedStatement)this.statement).setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        ((PreparedStatement)this.statement).setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        ((PreparedStatement)this.statement).setClob(parameterIndex, reader);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        ((PreparedStatement)this.statement).setClob(parameterIndex, reader, length);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        ((PreparedStatement)this.statement).setNCharacterStream(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        ((PreparedStatement)this.statement).setNCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        ((PreparedStatement)this.statement).setNClob(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        ((PreparedStatement)this.statement).setNClob(parameterIndex, reader);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        ((PreparedStatement)this.statement).setNClob(parameterIndex, reader, length);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        ((PreparedStatement)this.statement).setNString(parameterIndex, value);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        ((PreparedStatement)this.statement).setRowId(parameterIndex, x);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        ((PreparedStatement)this.statement).setSQLXML(parameterIndex, xmlObject);
    }
}

