/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.jdbc;

import com.cognos.xqe.data.providers.relational.jdbc.JDBCLog;
import com.cognos.xqe.data.providers.relational.jdbc.XQEResultSetWrapper;
import com.cognos.xqe.util.Timer;
import com.cognos.xqe.util.usage.UsageTrackingService;
import com.ibm.cognos.jdbc.adaptor.IAdaptorResultSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicInteger;

public class XQEStatementWrapper
implements Statement {
    private static final String STATEMENT_GET_RESULTSET = "[%1$d] Statement.getResultSet() -> [%2$x] (%3$dns)";
    protected static final String STATEMENT_EXECUTE_START_LOG_STR = "[%1$d] [Start]Statement.execute(%2$s)";
    protected static final String STATEMENT_EXECUTE_END_LOG_STR = "[%1$d] [  End]Statement.execute() -> [%2$b] (%3$dns)";
    protected static final String STATEMENT_EXECUTE_QUERY_START_LOG_STR = "[%1$d] [Start]Statement.executeQuery(%2$s)";
    protected static final String STATEMENT_EXECUTE_QUERY_END_LOG_STR = "[%1$d] [  End]Statement.executeQuery() -> [%2$s] (%3$dns)";
    protected static final String STATEMENT_CLOSE_LOG_STR = "[%1$d] Statement.close() (%2$dns)";
    protected static final String STATEMENT_CANCEL_LOG_STR = "[%1$d] Statement.cancel()";
    public static final String METHOD_NOT_SUPPORTED = "Method not supported";
    protected Connection connection;
    protected Statement statement;
    private static AtomicInteger counter = new AtomicInteger(0);
    protected int id = counter.incrementAndGet();

    public XQEStatementWrapper(Connection theConnection, Statement theStatement) {
        this.connection = theConnection;
        this.statement = theStatement;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.statement.addBatch(sql);
    }

    @Override
    public void cancel() throws SQLException {
        if (JDBCLog.isOn()) {
            JDBCLog.log(String.format(STATEMENT_CANCEL_LOG_STR, this.id));
        }
        this.statement.cancel();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.statement.clearBatch();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.statement.clearWarnings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        long time;
        Timer timer = new Timer();
        try {
            timer.start();
            this.statement.close();
        }
        finally {
            time = timer.stop();
        }
        if (JDBCLog.isOn()) {
            JDBCLog.log(String.format(STATEMENT_CLOSE_LOG_STR, this.id, time));
        }
        JDBCLog.incrementTimeSpentInJDBC(timer.getElapsedTimeInMilliseconds());
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.statement.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.statement.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.statement.execute(sql, columnNames);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        boolean result = false;
        if (JDBCLog.isOn() || UsageTrackingService.isOn()) {
            if (JDBCLog.isOn()) {
                JDBCLog.log(String.format(STATEMENT_EXECUTE_START_LOG_STR, this.id, sql.trim()));
            }
            Timer timer = new Timer();
            try {
                timer.start();
                result = this.statement.execute(sql);
            }
            catch (SQLException e) {
                JDBCLog.getLogger().log(String.format(STATEMENT_EXECUTE_END_LOG_STR, this.id, false, timer.get()));
                JDBCLog.getLogger().log(e.getLocalizedMessage());
                throw e;
            }
            finally {
                long time = timer.stop();
            }
            if (JDBCLog.isOn()) {
                long time;
                JDBCLog.log(String.format(STATEMENT_EXECUTE_END_LOG_STR, this.id, result, time));
            }
            JDBCLog.incrementTimeSpentInJDBC(timer.getElapsedTimeInMilliseconds());
        } else {
            result = this.statement.execute(sql);
        }
        return result;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.statement.executeBatch();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        XQEResultSetWrapper resultSet;
        if (JDBCLog.isOn()) {
            JDBCLog.log(String.format(STATEMENT_EXECUTE_QUERY_START_LOG_STR, this.id, sql.trim()));
        }
        Timer timer = new Timer();
        try {
            timer.start();
            resultSet = new XQEResultSetWrapper((IAdaptorResultSet)this.statement.executeQuery(sql));
        }
        catch (SQLException e) {
            JDBCLog.getLogger().log(String.format(STATEMENT_EXECUTE_QUERY_END_LOG_STR, this.id, null, timer.get()));
            JDBCLog.getLogger().log(e.getLocalizedMessage());
            throw e;
        }
        finally {
            long time = timer.stop();
        }
        if (JDBCLog.isOn()) {
            long time;
            JDBCLog.log(String.format(STATEMENT_EXECUTE_QUERY_END_LOG_STR, this.id, resultSet.getID(), time));
        }
        JDBCLog.incrementTimeSpentInJDBC(timer.getElapsedTimeInMilliseconds());
        return resultSet;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.statement.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.statement.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.statement.executeUpdate(sql, columnNames);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.statement.executeUpdate(sql);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.statement.getFetchDirection();
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.statement.getFetchSize();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.statement.getGeneratedKeys();
    }

    public int getID() {
        return this.id;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.statement.getMaxFieldSize();
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.statement.getMaxRows();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.statement.getMoreResults();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.statement.getMoreResults(current);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.statement.getQueryTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getResultSet() throws SQLException {
        XQEResultSetWrapper resultSet;
        if (JDBCLog.isOn() || UsageTrackingService.isOn()) {
            long time;
            Timer timer = new Timer();
            try {
                timer.start();
                resultSet = new XQEResultSetWrapper((IAdaptorResultSet)this.statement.getResultSet());
            }
            finally {
                time = timer.stop();
            }
            if (JDBCLog.isOn()) {
                JDBCLog.log(String.format(STATEMENT_GET_RESULTSET, this.id, resultSet.getID(), time));
            }
            JDBCLog.incrementTimeSpentInJDBC(timer.getElapsedTimeInMilliseconds());
        } else {
            resultSet = new XQEResultSetWrapper((IAdaptorResultSet)this.statement.getResultSet());
        }
        return resultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.statement.getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.statement.getResultSetHoldability();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.statement.getResultSetType();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.statement.getUpdateCount();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.statement.getWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.statement.setCursorName(name);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.statement.setEscapeProcessing(enable);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.statement.setFetchDirection(direction);
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.statement.setFetchSize(rows);
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.statement.setMaxFieldSize(max);
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.statement.setMaxRows(max);
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.statement.setQueryTimeout(seconds);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.statement.isClosed();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.statement.isPoolable();
    }

    @Override
    public void setPoolable(boolean arg0) throws SQLException {
        this.statement.setPoolable(arg0);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.statement.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.statement.unwrap(iface);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }
}

