/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.jdbc.db2;

import com.cognos.xqe.bibushandler.Commands;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnectionCommandBlock;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCConnection;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCException;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCLog;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.XmlValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.util.StringSubstitutionEngine;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public class Db2Connection
extends JDBCConnection {
    private static final int P1 = 1;
    private static final int P2 = 2;
    private static final int P3 = 3;
    private static final int P4 = 4;
    private static final String TRUSTED_CONTEXT = "@TRUSTED_CONTEXT";
    private static final String REGISTRY_NAME = "@REGISTRY_NAME=";
    protected Boolean isTrustedContext = false;
    protected String registryName = null;

    public Db2Connection(IDataSource dataSource) {
        super(dataSource);
    }

    @Override
    public void parseConnectionString(String inConnectionString) throws JDBCException {
        if (inConnectionString.contains(TRUSTED_CONTEXT)) {
            this.isTrustedContext = true;
        }
        if (inConnectionString.contains(REGISTRY_NAME)) {
            if (!this.isTrustedContext.booleanValue()) {
                JDBCLog.getLogger().log("TRUSTED_CONTEXT is not enabled, REGISTRY NAME can not be specified.");
                throw new XQERuntimeException(XQEMessageKeys.JDB_TrustedContextDisabled, this.getConnectionString());
            }
            String[] tokens = inConnectionString.split(REGISTRY_NAME);
            int offset = tokens[1].indexOf("@");
            this.registryName = tokens[1].substring(0, offset).trim();
        }
        super.parseConnectionString(inConnectionString);
    }

    @Override
    protected void setConnectionProperties() {
        if (this.userId != null) {
            this.connectionProps.put("user", this.userId);
        }
        if (this.password != null && this.passwordRequired) {
            this.connectionProps.put("password", this.password);
        }
        if (this.isTrustedContext.booleanValue()) {
            this.connectionProps.put("trustedContext", "true");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String explain(String query) throws SQLException {
        String plan = null;
        String command = "CALL SYSPROC.EXPLAIN_SQL(?, ?, 'en_US', BLOB('<?xml version=\"1.0\" encoding=\"UTF-8\"?><plist version=\"1.0\"><dict><key>RETAIN</key><string>N</string><key>SQL_TEXT</key><string>" + StringSubstitutionEngine.escapeString(query.replace("'", "''"), "<>") + "</string></dict></plist>'), NULL, ?, ?)";
        CallableStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = this.connection.prepareCall(command);
            stmt.setInt(1, 1);
            stmt.setInt(2, 0);
            stmt.registerOutParameter(1, 4);
            stmt.registerOutParameter(2, 4);
            stmt.registerOutParameter(3, 2004);
            stmt.registerOutParameter(4, 2004);
            if (!stmt.execute()) {
                String string = null;
                return string;
            }
            Blob b = stmt.getBlob(4);
            if (b != null) {
                XmlValue value = DataValueFactory.createXmlValue();
                value.set(new String(b.getBytes(1L, (int)b.length())));
                plan = value.getString();
            } else {
                StringBuilder builder = new StringBuilder();
                result = stmt.getResultSet();
                while (result.next()) {
                    b = result.getBlob(1);
                    builder.append(new String(b.getBytes(1L, (int)b.length())));
                }
                plan = builder.toString();
            }
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return plan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void runCommandBlocks(Commands key, List<IDataSourceConnectionCommandBlock> commandBlocks) throws SQLException {
        block13: {
            if (commandBlocks == null) return;
            if (commandBlocks.size() <= 0) {
                return;
            }
            JDBCLog.getLogger().log(String.format("[%1$x] Command block execution started [%2$s].", this.connection.hashCode(), key.getName()));
            Statement pStmt = null;
            try {
                for (int i = 0; i < commandBlocks.size(); ++i) {
                    IDataSourceConnectionCommandBlock commandBlock = commandBlocks.get(i);
                    if (commandBlock.getType() == IDataSourceConnectionCommandBlock.CommandBlockType.SESSION_START_COMMAND) {
                        if (this.isTrustedContext.booleanValue()) {
                            try {
                                this.connection.switchUser(Boolean.valueOf(true), (String)commandBlock.getProperty("userName"), (String)commandBlock.getProperty("password"), this.registryName);
                                this.userSwitched = true;
                                continue;
                            }
                            catch (SQLException e) {
                                JDBCLog.getLogger().log(String.format("set session user to [%1$s] failed", (String)commandBlock.getProperty("userName")));
                                throw e;
                            }
                        }
                        if (commandBlock.getProperty("userName") == null) continue;
                        JDBCLog.getLogger().log("TRUSTED_CONTEXT is not enabled, cannot set session user.");
                        throw new XQERuntimeException(XQEMessageKeys.JDB_TrustedContextDisabled, this.getConnectionString());
                    }
                    if (commandBlock.getType() == IDataSourceConnectionCommandBlock.CommandBlockType.SESSION_END_COMMAND) {
                        if (this.isTrustedContext.booleanValue()) {
                            try {
                                this.connection.switchUser(Boolean.valueOf(false), (String)commandBlock.getProperty("userName"), (String)commandBlock.getProperty("password"), this.registryName);
                                this.userSwitched = false;
                                continue;
                            }
                            catch (SQLException e) {
                                JDBCLog.getLogger().log(String.format("close session user [%1$s] failed", this.getUserId()));
                                throw e;
                            }
                        }
                        if (commandBlock.getProperty("userName") == null) continue;
                        JDBCLog.getLogger().log("TRUSTED_CONTEXT is not enabled, cannot close session user.");
                        throw new XQERuntimeException(XQEMessageKeys.JDB_TrustedContextDisabled, this.getConnectionString());
                    }
                    if (commandBlock.getType() != IDataSourceConnectionCommandBlock.CommandBlockType.SQL_COMMAND) continue;
                    String command = (String)commandBlock.getProperty("sql");
                    pStmt = this.connection.prepareStatement(command);
                    pStmt.execute();
                }
                if (pStmt == null) break block13;
            }
            catch (Throwable throwable) {
                if (pStmt != null) {
                    pStmt.close();
                }
                JDBCLog.getLogger().log(String.format("[%1$x] Command block execution completed.", this.connection.hashCode()));
                throw throwable;
            }
            pStmt.close();
        }
        JDBCLog.getLogger().log(String.format("[%1$x] Command block execution completed.", this.connection.hashCode()));
    }

    @Override
    protected String getDataSourceTypeOverride() {
        return "db2";
    }
}

