/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.jdbc.oracle;

import com.cognos.xqe.bibushandler.Commands;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnectionCommandBlock;
import com.cognos.xqe.data.providers.relational.SQLQueryArguments;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCConnection;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCDataProvider;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCLog;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCTabularResult;
import com.cognos.xqe.data.providers.relational.jdbc.XQECallableStatementWrapper;
import com.cognos.xqe.data.providers.relational.jdbc.oracle.OracleTabularResult;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.XSql;
import com.cognos.xqe.trace.LogLevel;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class OracleConnection
extends JDBCConnection {
    private static final int REF_CURSOR = -10;
    private static final int SP_NOT_OVERLOADED = -1;
    private static final String NO_DBLINK = "";
    private static final String REF_CURSOR_STUB = "REF_CURSOR_STUB";
    private static final String QUESTION_MARK = "?";

    public OracleConnection(IDataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected JDBCTabularResult getResultSetImpl(XDataContext context, IPooledConnection pooledConnection, SQLQueryArguments queryArgs, Integer nodeId, JDBCDataProvider dataProvider) {
        return new OracleTabularResult(context, pooledConnection, queryArgs, nodeId, dataProvider);
    }

    @Override
    public PreparedStatement prepareCall(IExecutionEnvironment env, String canonicalName, String schema, String spQualifier, List<XSql.StoredProcedureArgument> arguments) throws SQLException {
        String pSchema = schema;
        String pName = null;
        String pPackage = null;
        String pDbLink = NO_DBLINK;
        String[] splitName = canonicalName.split("\\.");
        if (splitName.length == 2) {
            pPackage = splitName[0];
            pName = splitName[1];
            int index = pPackage.indexOf("@");
            if (index != -1) {
                pPackage = pPackage.substring(0, index - 1);
                pDbLink = pPackage.substring(index);
            }
        } else {
            pName = canonicalName;
        }
        List<ProcedureSignature> signatures = this.findSignatures(pSchema, pPackage, pName, pDbLink);
        ProcedureSignature signature = null;
        if (signatures.size() == 1) {
            signature = signatures.get(0);
        } else {
            for (int i = 0; i < signatures.size() && signature == null; ++i) {
                if (!signatures.get(i).matches(arguments.size())) continue;
                signature = signatures.get(i);
            }
        }
        signature.setProcedureArguments(arguments);
        String query = String.format("{ CALL %1$s}", signature.generateSignature());
        this.logIPFNativeQuery(env, query);
        CallableStatement callableStatement = this.connection.prepareCall(query);
        OracleCallableStatement pStmt = new OracleCallableStatement((Connection)this.connection, callableStatement, signature);
        return pStmt;
    }

    private List<ProcedureSignature> findSignatures(String pSchema, String pPackage, String pName, String pDbLink) throws SQLException {
        String procedurePackage = null;
        String schema = null;
        int sequence = 0;
        int overloadIndex = -1;
        ProcedureSignature sig = null;
        ArrayList<ProcedureSignature> signatures = new ArrayList<ProcedureSignature>();
        StringBuilder sqlStatement = new StringBuilder();
        sqlStatement.append(String.format("select B.SEQUENCE, B.DATA_TYPE, B.OVERLOAD, B.IN_OUT, B.PACKAGE_NAME, B.OWNER from ALL_ARGUMENTS%1$s B where B.OBJECT_NAME='%2$s' and B.DATA_LEVEL=0 and B.ARGUMENT_NAME IS NOT NULL ", pDbLink, pName));
        if (pSchema != null) {
            sqlStatement.append(String.format("and B.OWNER='%1$s' ", pSchema));
        }
        if (pPackage != null) {
            sqlStatement.append(String.format("and B.PACKAGE_NAME='%1$s' ", pPackage));
        } else {
            sqlStatement.append("and B.PACKAGE_NAME IS NULL ");
        }
        sqlStatement.append("ORDER BY OVERLOAD asc, SEQUENCE");
        PreparedStatement stmt = this.connection.prepareStatement(sqlStatement.toString());
        if (!stmt.execute()) {
            throw new XQERuntimeException();
        }
        ResultSet rs = stmt.getResultSet();
        while (rs.next()) {
            boolean isRefCursor = false;
            procedurePackage = rs.getString("PACKAGE_NAME");
            schema = rs.getString("OWNER");
            String columnType = rs.getString("IN_OUT");
            String dataTypeName = rs.getString("DATA_TYPE");
            sequence = Integer.parseInt(rs.getString("SEQUENCE"));
            String overloadTempString = rs.getString("OVERLOAD");
            overloadIndex = overloadTempString == null ? -1 : Integer.parseInt(overloadTempString);
            if ("REF CURSOR".equals(dataTypeName)) {
                isRefCursor = true;
            } else if ("PL/SQL RECORD".equals(dataTypeName)) continue;
            ProcedureArgument arg = new ProcedureArgument(columnType, isRefCursor, sequence);
            if (sig == null || sig.index != overloadIndex) {
                sig = new ProcedureSignature();
                sig.catalog = procedurePackage;
                sig.schema = schema;
                sig.name = pName;
                sig.index = overloadIndex;
                signatures.add(sig);
            }
            sig.addArgument(arg);
        }
        if (sig == null) {
            sig = new ProcedureSignature();
            sig.catalog = pPackage;
            sig.schema = pSchema;
            sig.name = pName;
            sig.index = 0;
            signatures.add(sig);
        }
        rs.close();
        stmt.close();
        return signatures;
    }

    public int getCardinality(String schemaName, String tableName) {
        int nRows = -1;
        StringBuilder sqlStatement = new StringBuilder();
        sqlStatement.append("SELECT NUM_ROWS FROM USER_TABLES WHERE");
        if (schemaName != null) {
            sqlStatement.append(String.format("OWNER = '%1$s' AND", schemaName));
        }
        sqlStatement.append(String.format("TABLE_NAME = '%1$s'", tableName));
        try {
            Statement statement = this.connection.createStatement();
            ResultSet result = statement.executeQuery(sqlStatement.toString());
            if (result.next()) {
                nRows = result.getInt(1);
            }
            result.close();
            statement.close();
        }
        catch (SQLException e) {
            JDBCLog.getLogger().log(e);
            nRows = -1;
        }
        return nRows;
    }

    @Override
    public IDataType createDataTypeFromJDBCType(ResultSetMetaData metadata, int columnNo) {
        IDataType datatype;
        String typeName = "unknown";
        try {
            typeName = metadata.getColumnTypeName(columnNo).trim();
            datatype = "long".equalsIgnoreCase(typeName) ? DataTypeFactory.getVarcharType() : super.createDataTypeFromJDBCType(metadata, columnNo);
        }
        catch (SQLException e) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)e);
        }
        return datatype;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void runCommandBlocks(Commands key, List<IDataSourceConnectionCommandBlock> commandBlocks) throws SQLException {
        block11: {
            if (commandBlocks == null) return;
            if (commandBlocks.size() <= 0) {
                return;
            }
            JDBCLog.getLogger(LogLevel.WARN).log(String.format("[%1$x] Command block execution started [%2$s].", this.connection.hashCode(), key.getName()));
            JDBCLog.getLogger().log(String.format("[%1$x] Command block execution started [%2$s].", this.connection.hashCode(), key.getName()));
            Statement stmt = null;
            try {
                for (int i = 0; i < commandBlocks.size(); ++i) {
                    IDataSourceConnectionCommandBlock commandBlock = commandBlocks.get(i);
                    if (commandBlock.getType() == IDataSourceConnectionCommandBlock.CommandBlockType.SESSION_START_COMMAND) {
                        try {
                            this.connection.switchUser(Boolean.valueOf(true), (String)commandBlock.getProperty("userName"), (String)commandBlock.getProperty("password"), null);
                            this.userSwitched = true;
                            continue;
                        }
                        catch (SQLException e) {
                            JDBCLog.getLogger().log(String.format("set session user to [%1$s] failed", (String)commandBlock.getProperty("userName")));
                            throw e;
                        }
                    }
                    if (commandBlock.getType() == IDataSourceConnectionCommandBlock.CommandBlockType.SESSION_END_COMMAND) {
                        try {
                            this.connection.switchUser(Boolean.valueOf(false), (String)commandBlock.getProperty("userName"), (String)commandBlock.getProperty("password"), null);
                            this.userSwitched = false;
                            continue;
                        }
                        catch (SQLException e) {
                            JDBCLog.getLogger().log(String.format("close session user [%1$s] failed", (String)commandBlock.getProperty("userName")));
                            throw e;
                        }
                    }
                    if (commandBlock.getType() != IDataSourceConnectionCommandBlock.CommandBlockType.SQL_COMMAND) continue;
                    String command = (String)commandBlock.getProperty("sql");
                    stmt = this.connection.prepareStatement(command);
                    JDBCLog.getLogger(LogLevel.WARN).log("Executing command block: " + command);
                    stmt.execute(command);
                }
                if (stmt == null) break block11;
            }
            catch (Throwable throwable) {
                if (stmt != null) {
                    stmt.close();
                }
                JDBCLog.getLogger().log(String.format("[%1$x] Command block execution completed.", this.connection.hashCode()));
                throw throwable;
            }
            stmt.close();
        }
        JDBCLog.getLogger().log(String.format("[%1$x] Command block execution completed.", this.connection.hashCode()));
    }

    @Override
    public void registerParameters(PreparedStatement callStmt, SQLQueryArguments queryArgs) throws SQLException {
        List<XSql.StoredProcedureArgument> spArgs = ((OracleCallableStatement)callStmt).getSignature().getProcedureArugments();
        int parameterizedPosition = 1;
        ArrayList<Integer> idxListOfParameterizedSPArgsDefinedAsPrompts = new ArrayList<Integer>();
        for (int i = 0; i < spArgs.size(); ++i) {
            String procedureArgument = spArgs.get(i).getArgumentValue();
            if (procedureArgument.equals(QUESTION_MARK)) {
                int sqlJDBCType;
                String mode = spArgs.get(i).getMode();
                if ("OUT".equalsIgnoreCase(mode) || "INOUT".equalsIgnoreCase(mode)) {
                    sqlJDBCType = DataTypeFactory.getJdbcDataType(spArgs.get(i).getDataType().getCCLTypeCode());
                    ((OracleCallableStatement)callStmt).registerOutParameter(parameterizedPosition, sqlJDBCType);
                }
                if (("IN".equalsIgnoreCase(mode) || "INOUT".equalsIgnoreCase(mode)) && spArgs.get(i).getInValue() != null) {
                    sqlJDBCType = DataTypeFactory.getJdbcDataType(spArgs.get(i).getDataType().getCCLTypeCode());
                    this.setParameterValue(callStmt, parameterizedPosition, spArgs.get(i).getInValue(), sqlJDBCType);
                }
                if (spArgs.get(i).getInValue() == null) {
                    idxListOfParameterizedSPArgsDefinedAsPrompts.add(parameterizedPosition);
                }
                ++parameterizedPosition;
                continue;
            }
            if (!procedureArgument.equals(REF_CURSOR_STUB)) continue;
            ((OracleCallableStatement)callStmt).registerOutParameter(parameterizedPosition, -10);
            ++parameterizedPosition;
        }
        queryArgs.setIndexListOfParameterizedSPArgsDefinedAsPromptsInFM(idxListOfParameterizedSPArgsDefinedAsPrompts);
    }

    @Override
    protected String getDataSourceTypeOverride() {
        return "oracle";
    }

    class OracleCallableStatement
    extends XQECallableStatementWrapper {
        private ProcedureSignature signature;

        OracleCallableStatement(Connection connection, CallableStatement callableStatement, ProcedureSignature aSignature) {
            super(connection, callableStatement);
            this.signature = aSignature;
        }

        @Override
        public boolean execute() throws SQLException {
            super.execute();
            return true;
        }

        @Override
        public ResultSet getResultSet() throws SQLException {
            ResultSet rs = (ResultSet)((CallableStatement)this.statement).getObject(this.signature.getFirstRefCursorPos());
            if (rs == null) {
                throw new XQERuntimeException();
            }
            return rs;
        }

        public int getNumParameters() {
            return this.signature.numParameters();
        }

        public ProcedureSignature getSignature() {
            return this.signature;
        }

        public int positionOfParam(int parameterNum) {
            return this.signature.getArgumentPosition(parameterNum);
        }
    }

    private class ProcedureSignature {
        private List<ProcedureArgument> signatureArgs = new ArrayList<ProcedureArgument>();
        private List<XSql.StoredProcedureArgument> procedureArguments;
        private String name = null;
        private String catalog = null;
        private String schema = null;
        private int index = -1;

        ProcedureSignature() {
        }

        public void addArgument(ProcedureArgument arg) {
            for (ProcedureArgument procArg : this.signatureArgs) {
                if (!procArg.sameArg(arg)) continue;
                return;
            }
            this.signatureArgs.add(arg);
        }

        public int getFirstRefCursorPos() {
            int refCursorPosition = 1;
            for (int i = 0; i < this.procedureArguments.size(); ++i) {
                String argument = this.procedureArguments.get(i).getArgumentValue();
                if (argument.equals(OracleConnection.REF_CURSOR_STUB)) {
                    return refCursorPosition;
                }
                if (!argument.equals(OracleConnection.QUESTION_MARK)) continue;
                ++refCursorPosition;
            }
            return -1;
        }

        public boolean matches(int numProcArguments) {
            int numRefCursors = this.numRefCursors();
            int argCount = this.signatureArgs.size() - numRefCursors;
            return argCount == numProcArguments;
        }

        private int numRefCursors() {
            int count = 0;
            for (ProcedureArgument arg : this.signatureArgs) {
                if (!arg.isRefCursor()) continue;
                ++count;
            }
            return count;
        }

        private String getArgumentString() {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < this.procedureArguments.size(); ++i) {
                String procedureArgument;
                if (i > 0) {
                    buf.append(",");
                }
                if ((procedureArgument = this.procedureArguments.get(i).getArgumentValue()).equals(OracleConnection.REF_CURSOR_STUB)) {
                    buf.append(OracleConnection.QUESTION_MARK);
                    continue;
                }
                buf.append(procedureArgument);
            }
            return buf.toString();
        }

        public String generateSignature() {
            StringBuilder spQualifier = new StringBuilder();
            if (this.schema != null) {
                spQualifier.append(OracleConnection.this.getCapabilities().getSchemaDelimiter());
                spQualifier.append(this.schema);
                spQualifier.append(OracleConnection.this.getCapabilities().getSchemaDelimiter());
                spQualifier.append(".");
            }
            if (this.catalog != null) {
                spQualifier.append(OracleConnection.this.getCapabilities().getTableDelimiter());
                spQualifier.append(this.catalog);
                spQualifier.append(OracleConnection.this.getCapabilities().getTableDelimiter());
                spQualifier.append(".");
            }
            spQualifier.append(OracleConnection.this.getCapabilities().getTableDelimiter());
            spQualifier.append(this.name);
            spQualifier.append(OracleConnection.this.getCapabilities().getTableDelimiter());
            String sig = String.format("%1$s (%2$s)", spQualifier.toString(), this.getArgumentString());
            return sig;
        }

        public int numParameters() {
            int count = 0;
            for (XSql.StoredProcedureArgument arg : this.procedureArguments) {
                if (!OracleConnection.QUESTION_MARK.equals(arg.getArgumentValue())) continue;
                ++count;
            }
            return count;
        }

        public int getArgumentPosition(int position) {
            int i;
            int argCounter = 1;
            for (i = 0; i < this.signatureArgs.size(); ++i) {
                if (this.signatureArgs.get(i).isRefCursor()) continue;
                if (argCounter == position) break;
                ++argCounter;
            }
            return i + 1;
        }

        public void setProcedureArguments(List<XSql.StoredProcedureArgument> procArgs) {
            this.procedureArguments = new ArrayList<XSql.StoredProcedureArgument>();
            int procedureCounter = 0;
            for (int i = 0; i < this.signatureArgs.size(); ++i) {
                if (this.signatureArgs.get(i).isRefCursor()) {
                    this.procedureArguments.add(new XSql.StoredProcedureArgument(OracleConnection.REF_CURSOR_STUB, null, null, null));
                    continue;
                }
                this.procedureArguments.add(procArgs.get(procedureCounter));
                ++procedureCounter;
            }
        }

        public List<XSql.StoredProcedureArgument> getProcedureArugments() {
            return this.procedureArguments;
        }
    }

    private class ProcedureArgument {
        final int position;
        final boolean isRefCursor;
        final String columnType;

        ProcedureArgument(String aColumnType, boolean refCursor, int aPosition) {
            this.columnType = aColumnType;
            this.isRefCursor = refCursor;
            this.position = aPosition;
        }

        public boolean isRefCursor() {
            return this.isRefCursor;
        }

        public boolean sameArg(Object obj) {
            if (obj == null || !(obj instanceof ProcedureArgument)) {
                return false;
            }
            ProcedureArgument arg = (ProcedureArgument)obj;
            return this.columnType.equals(arg.columnType) && this.isRefCursor == arg.isRefCursor && this.position == arg.position;
        }
    }
}

