/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.jdbc.oracle;

import com.cognos.xqe.data.providers.relational.SQLQueryArguments;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCDataProvider;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCTabularResult;
import com.cognos.xqe.data.providers.relational.jdbc.oracle.OracleConnection;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.runtree.XDataContext;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

public class OracleTabularResult
extends JDBCTabularResult {
    static final long serialVersionUID = 1L;
    static final int TZMINUTE_INDEX = 6;
    static final int TZHOUR_INDEX = 5;
    static final String PLUS_SIGN = "+";
    static final String MINUS_SIGN = "-";

    public OracleTabularResult(XDataContext context, IPooledConnection pooledConnection, SQLQueryArguments queryArgs, Integer nodeId, JDBCDataProvider dataProvider) {
        super(context, pooledConnection, queryArgs, nodeId, dataProvider);
    }

    @Override
    protected ParameterMetaData getParameterMetaData(PreparedStatement statement, List<String> map, XDataContext context) throws SQLException {
        if (!(statement instanceof OracleConnection.OracleCallableStatement)) {
            return super.getParameterMetaData(statement, map, context);
        }
        OracleConnection.OracleCallableStatement call = (OracleConnection.OracleCallableStatement)statement;
        return new OracleParameterMetadata(call.getNumParameters(), context, map);
    }

    private final class OracleParameterMetadata
    implements ParameterMetaData {
        private int nParameters;
        private XDataContext context;
        private List<String> paramNameList;

        private OracleParameterMetadata(int theNParameters, XDataContext theContext, List<String> theParamNameList) {
            this.nParameters = theNParameters;
            this.context = theContext;
            this.paramNameList = theParamNameList;
        }

        @Override
        public String getParameterClassName(int param) throws SQLException {
            return null;
        }

        @Override
        public int getParameterCount() throws SQLException {
            return this.nParameters;
        }

        @Override
        public int getParameterMode(int param) throws SQLException {
            return 1;
        }

        @Override
        public int getParameterType(int param) throws SQLException {
            String name = this.paramNameList.get(param - 1);
            Value value = (Value)this.context.getParameterValues(name)[0];
            int type = DataTypeFactory.getJdbcDataType(value.getDataType().getCCLTypeCode());
            return type;
        }

        @Override
        public String getParameterTypeName(int param) throws SQLException {
            return null;
        }

        @Override
        public int getPrecision(int param) throws SQLException {
            String name = this.paramNameList.get(param - 1);
            Value value = (Value)this.context.getParameterValues(name)[0];
            return value.getDataType().getPrecision();
        }

        @Override
        public int getScale(int param) throws SQLException {
            String name = this.paramNameList.get(param - 1);
            Value value = (Value)this.context.getParameterValues(name)[0];
            return value.getDataType().getScale();
        }

        @Override
        public int isNullable(int param) throws SQLException {
            return 2;
        }

        @Override
        public boolean isSigned(int param) throws SQLException {
            return false;
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return false;
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            throw new UnsupportedOperationException();
        }
    }
}

