/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.jdbc.teradata;

import com.cognos.xqe.data.model.ICAMCryptoSignon;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCConnection;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCException;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCLog;
import com.cognos.xqe.data.providers.secbridge.IImpersonator;
import com.cognos.xqe.data.providers.secbridge.ImpersonatorFactory;
import com.cognos.xqe.data.providers.secbridge.NativeException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.runtree.relational.XSql;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.LocaleConverter;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;

public class TeradataConnection
extends JDBCConnection {
    private static final int NOT_STORED_PROCEDURE_ERROR_CODE = 5494;

    public TeradataConnection(IDataSource dataSource) {
        super(dataSource);
    }

    public <T> T invokeWithWinImpersonation(Callable<T> task, String domainName, String userName, String password, int errorLocale) throws JDBCException {
        IImpersonator winImpersonater = ImpersonatorFactory.createWinImpersonater(domainName, userName, password, errorLocale);
        try {
            T t = winImpersonater.runPrivilegedTask(task);
            return t;
        }
        catch (InterruptedException e) {
            throw new JDBCException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)e);
        }
        catch (NativeException e) {
            throw new JDBCException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)e);
        }
        catch (Throwable e) {
            throw new JDBCException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL, e);
        }
        finally {
            winImpersonater.release();
        }
    }

    public <T> T invokeWithCAMImpersonation(Callable<T> task, String camCryptoHandle, int errorLocale) throws JDBCException {
        IImpersonator camImpersonater = ImpersonatorFactory.createCAMImpersonater(camCryptoHandle, errorLocale);
        try {
            T t = camImpersonater.runPrivilegedTask(task);
            return t;
        }
        catch (InterruptedException e) {
            throw new JDBCException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)e);
        }
        catch (NativeException e) {
            throw new JDBCException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)e);
        }
        catch (Throwable e) {
            throw new JDBCException(XQEMessageKeys.GEN_UnexpectedException, e);
        }
        finally {
            camImpersonater.release();
        }
    }

    @Override
    protected void driverConnectKerberos(Locale locale) throws JDBCException {
        if (this.connectionString.contains("ibmcognos.authentication=java_krb5")) {
            this.connectionProps.put("ibmcognos.authentication", "java_krb5");
            TeradataConnection.super.driverConnectKerberos(locale);
            return;
        }
        this.cryptoHandle = null;
        boolean isSingleSignOn = false;
        JDBCLog.getLogger().log(LogLevel.TRACE, String.format("[Teradata SSO] Java Vendor Is: " + System.getProperty("java.vendor"), new Object[0]));
        if (this.url.toUpperCase().contains("LOGMECH=KRB5")) {
            JDBCLog.getLogger().log(LogLevel.TRACE, String.format("[Teradata SSO] Discovered property LOGMECH=KRB5.", new Object[0]));
            IDataSourceConnection dsConnection = this.dataSource.getDataSourceConnection();
            IDataSourceConnectionSignon signon = dsConnection.getSignon();
            if (signon == null) {
                JDBCLog.getLogger().log(LogLevel.TRACE, String.format("[Teradata SSO] Signon is null, will not attempt single signon.", new Object[0]));
                isSingleSignOn = false;
            } else if (signon.getType() == IDataSourceConnectionSignon.SignonType.CAMCRYPTO) {
                this.cryptoHandle = ((ICAMCryptoSignon)signon).getCryptoHandle();
                if (this.cryptoHandle == null) {
                    JDBCLog.getLogger().log(String.format("[Teradata SSO] CAM crypto handle is null, throw exception.", new Object[0]));
                    throw new JDBCException(XQEMessageKeys.GEN_UnexpectedException);
                }
                JDBCLog.getLogger().log(LogLevel.TRACE, String.format("[Teradata SSO] Received CAM-CRYPTO token.", new Object[0]));
                isSingleSignOn = true;
            } else if (this.userId != null && this.password != null) {
                JDBCLog.getLogger().log(LogLevel.TRACE, String.format("[Teradata SSO] received user id and password.", new Object[0]));
                isSingleSignOn = true;
            } else {
                JDBCLog.getLogger().log(LogLevel.TRACE, String.format("[Teradata SSO] received no login information, switch SSO off.", new Object[0]));
                isSingleSignOn = false;
            }
        }
        if (!isSingleSignOn) {
            JDBCLog.getLogger().log(LogLevel.TRACE, String.format("[Teradata SSO] Connecting with SSO off.", new Object[0]));
            super.driverConnect(locale);
            return;
        }
        ByteArrayOutputStream os = null;
        if (JDBCLog.isOn(LogLevel.TRACE)) {
            os = new ByteArrayOutputStream();
        }
        class ConnectTask
        implements Callable<Object> {
            Locale locale;
            ByteArrayOutputStream os;

            ConnectTask(Locale theLocale, ByteArrayOutputStream theOs) {
                this.locale = theLocale;
                this.os = theOs;
            }

            @Override
            public Object call() throws SQLException, JDBCException {
                PrintStream old = System.out;
                if (this.os != null) {
                    PrintStream ps = new PrintStream(this.os);
                    System.setOut(ps);
                }
                try {
                    TeradataConnection.super.driverConnect(this.locale);
                }
                catch (JDBCException e) {
                    throw e;
                }
                finally {
                    System.setOut(old);
                }
                return null;
            }
        }
        ConnectTask connectTask = new ConnectTask(locale, os);
        int runLocale = Integer.parseInt(LocaleConverter.toLCID(locale));
        try {
            if (this.cryptoHandle != null) {
                JDBCLog.getLogger().log(LogLevel.TRACE, String.format("[Teradata SSO] Impersonating with CAM token.", new Object[0]));
                this.invokeWithCAMImpersonation(connectTask, this.cryptoHandle, runLocale);
            } else {
                JDBCLog.getLogger().log(LogLevel.TRACE, String.format("[Teradata SSO] SSO Impersonating with user " + this.userId, new Object[0]));
                String domainName = "";
                String uId = this.userId;
                int slashPos = uId.indexOf(92);
                if (slashPos > 0) {
                    domainName = uId.substring(0, slashPos);
                    this.userId = uId.substring(slashPos + 1);
                }
                JDBCLog.getLogger().log(LogLevel.TRACE, String.format("[Teradata SSO] SSO Impersonating with final user id " + this.userId, new Object[0]));
                this.invokeWithWinImpersonation(connectTask, domainName, this.userId, this.password, runLocale);
            }
        }
        catch (JDBCException e) {
            JDBCLog.getLogger(LogLevel.ERROR).log(String.format("[Teradata SSO] SSO connection failed: " + e.toString(), new Object[0]));
            if (os != null) {
                JDBCLog.getLogger(LogLevel.ERROR).log(String.format("[Teradata SSO] Kerberos debug: " + os.toString(), new Object[0]));
            } else {
                JDBCLog.getLogger(LogLevel.ERROR).log(String.format("[Teradata SSO] Set log level to TRACE to see Kerberos debug output", new Object[0]));
            }
            if (this.connection != null) {
                this.disconnect();
                throw e;
            }
            throw new JDBCException(XQEMessageKeys.JDB_SSOConnectionFailed, (Throwable)e);
        }
        JDBCLog.getLogger(LogLevel.INFO).log(String.format("[Teradata SSO] SSO connection succeeded", new Object[0]));
    }

    @Override
    public PreparedStatement prepareCall(IExecutionEnvironment env, String canonicalName, String schema, String spQualifier, List<XSql.StoredProcedureArgument> arguments) throws SQLException {
        try {
            PreparedStatement statement = super.prepareCall(env, canonicalName, schema, spQualifier, arguments);
            return statement;
        }
        catch (SQLException e) {
            int code = e.getErrorCode();
            if (code != 5494) {
                throw e;
            }
            StringBuilder buffer = new StringBuilder();
            StringBuilder name = new StringBuilder(spQualifier);
            name.append(canonicalName);
            int numArgs = 0;
            buffer.append("EXECUTE ");
            buffer.append((CharSequence)name);
            if (arguments != null) {
                numArgs = arguments.size();
            }
            for (int i = 0; i < numArgs; ++i) {
                if (i == 0) {
                    buffer.append(" (");
                } else {
                    buffer.append(", ");
                }
                buffer.append(arguments.get(i).getArgumentValue());
                if (i != numArgs - 1) continue;
                buffer.append(")");
            }
            String query = buffer.toString();
            this.logIPFNativeQuery(env, query);
            return this.connection.prepareStatement(query);
        }
    }

    @Override
    protected void setFetchSizeStatement(Statement statement, int fetchSize) {
    }

    @Override
    protected String getDataSourceTypeOverride() {
        return "teradata";
    }
}

