/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.jdbc.util;

import com.cognos.xqe.data.providers.relational.jdbc.JDBCTabularResult;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.util.xml.XMLWriter;
import com.ibm.icu.text.Collator;
import java.sql.SQLException;

public class DirectAccessJDBCValue
implements IValue {
    private static final String DIRECT_ACCESS_JDBC_VALUES_ARE_IMMUTABLE = "Direct Access JDBC Values are immutable";
    Value realValue = null;
    JDBCTabularResult jt = null;
    int index;
    boolean valid = false;

    public DirectAccessJDBCValue(Value theRealValue, JDBCTabularResult theJt, int theIndex) {
        this.realValue = theRealValue;
        this.jt = theJt;
        this.index = theIndex;
    }

    @Override
    public int compareTo(Object o) {
        return this.load().compareTo(o);
    }

    @Override
    public void release() {
    }

    @Override
    public IDataType getDataType() {
        return this.realValue.getDataType();
    }

    @Override
    public boolean isPrimitive() {
        return this.realValue.isPrimitive();
    }

    @Override
    public boolean isMetadata() {
        return false;
    }

    @Override
    public boolean isResultSet() {
        return false;
    }

    @Override
    public boolean isNull() {
        return this.load().isNull();
    }

    @Override
    public void setNull() {
        throw new RuntimeException(DIRECT_ACCESS_JDBC_VALUES_ARE_IMMUTABLE);
    }

    @Override
    public void toXML(XMLWriter xmlWriter) {
        this.load().toXML(xmlWriter);
    }

    @Override
    public Object toJSON() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object copy() {
        return this.load().copy();
    }

    @Override
    public void copyFrom(IValue value) {
        throw new RuntimeException(DIRECT_ACCESS_JDBC_VALUES_ARE_IMMUTABLE);
    }

    @Override
    public Object hashKey() {
        return this.load().hashKey();
    }

    @Override
    public Object hashKey(Collator collator) {
        return this.load().hashKey(collator);
    }

    @Override
    public int fastHash() {
        return this.load().fastHash();
    }

    @Override
    public int sizeOf() {
        return this.load().sizeOf();
    }

    public String toString() {
        String s = this.load().toString();
        return s;
    }

    public int hashCode() {
        return this.load().hashCode();
    }

    public boolean equals(Object iv) {
        return this.load().equals(iv);
    }

    Value load() {
        if (!this.valid) {
            try {
                this.jt.setColumnValue(this.realValue, this.index);
                if (this.jt.getRawResultSet().wasNull()) {
                    this.realValue.setNull();
                }
                if (this.realValue instanceof TextValue) {
                    ((TextValue)this.realValue).setCollator(null);
                }
                this.valid = true;
            }
            catch (SQLException e) {
                RuntimeException en = this.jt.analyzeSQLException(e);
                throw en;
            }
        }
        return this.realValue;
    }

    public void invalidate() {
        this.valid = false;
    }

    public IValue getValue() {
        this.load();
        return this.realValue;
    }

    public boolean wasNull() {
        boolean b = false;
        try {
            b = this.jt.getRawResultSet().wasNull();
        }
        catch (SQLException e) {
            RuntimeException en = this.jt.analyzeSQLException(e);
            throw en;
        }
        return b;
    }

    public String getString() {
        String s;
        try {
            s = this.jt.getRawResultSet().getString(this.index + 1);
        }
        catch (SQLException e) {
            RuntimeException en = this.jt.analyzeSQLException(e);
            throw en;
        }
        return s;
    }

    public double getDouble() {
        double s;
        try {
            s = this.jt.getRawResultSet().getDouble(this.index + 1);
        }
        catch (SQLException e) {
            RuntimeException en = this.jt.analyzeSQLException(e);
            throw en;
        }
        return s;
    }
}

