/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.jdbc.util;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.exception.XQERuntimeException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JDBCDB2ConnectionStringConverter {
    private static final String D2_JDBC_UNIVERSAL_DRIVER = "com.ibm.db2.jcc.DB2Driver";
    private static final String SEMICOLON = ";";
    private static final String PROPERTYSEPARATOR = "=";
    private static final String COMMA = ",";
    private static Map<String, DB2ConnectionInformation> databaseConnectionMap = new HashMap<String, DB2ConnectionInformation>();

    public static boolean isConnectionMapEmpty() {
        return databaseConnectionMap.isEmpty();
    }

    public static String convertConnectionString(String connectionString) {
        if (connectionString.startsWith("jdbc:")) {
            return connectionString;
        }
        if (JDBCDB2ConnectionStringConverter.isConnectionMapEmpty()) {
            try {
                JDBCDB2ConnectionStringConverter.parseConnectionFromFile();
            }
            catch (IOException e) {
                throw new XQERuntimeException(e);
            }
        }
        String[] parts = connectionString.split(SEMICOLON);
        String databaseLogicalName = null;
        StringBuilder buffer = new StringBuilder();
        if (!JDBCDB2ConnectionStringConverter.isConnectionMapEmpty()) {
            buffer.append(parts[0]);
            buffer.append(SEMICOLON);
            buffer.append(parts[1]);
            buffer.append(";JD-D2;URL=");
            buffer.append("jdbc:db2://");
            for (int i = 0; i < parts.length; ++i) {
                if (!parts[i].startsWith("DSN=")) continue;
                databaseLogicalName = parts[i].substring(parts[i].indexOf(61) + 1);
            }
            if (databaseLogicalName == null) {
                LogonFailureException ex = new LogonFailureException(LogonFailureException.SubCodeEnum.INVALID_SERVER);
                throw ex;
            }
            DB2ConnectionInformation cs = databaseConnectionMap.get(databaseLogicalName);
            if (cs == null) {
                LogonFailureException ex = new LogonFailureException(LogonFailureException.SubCodeEnum.INVALID_CONN_STRING);
                throw ex;
            }
            buffer.append(cs.toString());
            buffer.append(";DRIVER_NAME=");
            buffer.append(JDBCDB2ConnectionStringConverter.getDB2JDBCDriveNameFromType(cs.getServerType()));
            String localSort = null;
            String level = null;
            for (int i = 0; i < parts.length; ++i) {
                int colseqIDX = parts[i].indexOf("@COLSEQ=");
                int levelIDX = parts[i].indexOf("@LEVEL=");
                if (colseqIDX == -1 || levelIDX == -1) continue;
                String[] colsqeAndLevel = parts[i].split(COMMA);
                localSort = colsqeAndLevel[0].substring(colsqeAndLevel[0].indexOf(61) + 1);
                level = colsqeAndLevel[1].substring(colsqeAndLevel[1].indexOf(61) + 1);
            }
            if (localSort != null) {
                buffer.append(";LOCALSORT=");
                buffer.append(localSort);
                buffer.append(",LEVEL=");
                buffer.append(level);
            }
        }
        return buffer.toString();
    }

    private static String getDB2JDBCDriveNameFromType(String serverType) {
        String driverName = null;
        if (serverType.equalsIgnoreCase("DB2NT") || serverType.equalsIgnoreCase("DB2OS390") || serverType.equalsIgnoreCase("DB2400")) {
            driverName = D2_JDBC_UNIVERSAL_DRIVER;
        }
        return driverName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseConnectionFromFile() throws IOException {
        HashMap<String, DB2DatabaseInformation> databaseContainer = new HashMap<String, DB2DatabaseInformation>();
        HashMap<String, DB2ConnectionInformation> connectionContainer = new HashMap<String, DB2ConnectionInformation>();
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        String db2ConnectionExportFile = config.getConfigDirectory() + "/jdbc/db2config.ini";
        BufferedReader reader = new BufferedReader(new FileReader(db2ConnectionExportFile));
        try {
            String fileLine = reader.readLine();
            while (fileLine != null) {
                Pattern patternNode = Pattern.compile("^\\[NODE>(\\w+)\\]$");
                Matcher matcherSystem = patternNode.matcher(fileLine);
                if (matcherSystem.find()) {
                    DB2ConnectionInformation newDBConnection = new DB2ConnectionInformation(null, null, null, null);
                    String systemID = matcherSystem.group(1);
                    String propertyLine = reader.readLine();
                    while (propertyLine != null) {
                        Scanner scanner = new Scanner(propertyLine);
                        scanner.useDelimiter(PROPERTYSEPARATOR);
                        if (!scanner.hasNext()) break;
                        String name = scanner.next();
                        String value = scanner.next();
                        if (name.equalsIgnoreCase("Hostname")) {
                            newDBConnection.setServerName(value);
                        } else if (name.equalsIgnoreCase("Portnumber")) {
                            newDBConnection.setPortNumber(value);
                        } else if (name.equalsIgnoreCase("ServerType")) {
                            newDBConnection.setServerType(value);
                        }
                        propertyLine = reader.readLine();
                    }
                    connectionContainer.put(systemID, newDBConnection);
                } else {
                    Pattern patternDB = Pattern.compile("^\\[DB>(\\w+):(\\w+)\\]$");
                    Matcher matcherDB = patternDB.matcher(fileLine);
                    if (matcherDB.find()) {
                        DB2DatabaseInformation newDB = new DB2DatabaseInformation();
                        newDB.setSystemNode(matcherDB.group(1));
                        String aliasName = matcherDB.group(2);
                        String propertyLine = reader.readLine();
                        while (propertyLine != null) {
                            Scanner scanner = new Scanner(propertyLine);
                            scanner.useDelimiter(PROPERTYSEPARATOR);
                            if (!scanner.hasNext()) break;
                            String name = scanner.next();
                            String value = scanner.next();
                            if (name.equalsIgnoreCase("DBName")) {
                                newDB.setDatabaseName(value);
                            }
                            if (name.equalsIgnoreCase("TargetDatabase")) {
                                newDB.setDatabaseName(value);
                            }
                            propertyLine = reader.readLine();
                        }
                        databaseContainer.put(aliasName, newDB);
                    }
                }
                fileLine = reader.readLine();
            }
            databaseConnectionMap.clear();
            for (String key : databaseContainer.keySet()) {
                DB2DatabaseInformation dbInfo = (DB2DatabaseInformation)databaseContainer.get(key);
                String systemNode = dbInfo.getSystemNode();
                String databaseName = dbInfo.getDatabaseName();
                DB2ConnectionInformation connInfo = (DB2ConnectionInformation)connectionContainer.get(systemNode);
                DB2ConnectionInformation newConnInfo = new DB2ConnectionInformation(connInfo.getServerName(), connInfo.getPortNumber(), connInfo.getServerType(), databaseName);
                databaseConnectionMap.put(key, newConnInfo);
            }
        }
        finally {
            databaseContainer.clear();
            connectionContainer.clear();
            reader.close();
        }
    }

    public static void terminate() {
        databaseConnectionMap = null;
    }

    private static class DB2ConnectionInformation {
        private String serverName;
        private String portNumber;
        private String serverType;
        private String databaseName;

        DB2ConnectionInformation(String sName, String pNumber, String sType, String dName) {
            this.serverName = sName;
            this.portNumber = pNumber;
            this.serverType = sType;
            this.databaseName = dName;
        }

        public String getServerName() {
            return this.serverName;
        }

        public String getPortNumber() {
            return this.portNumber;
        }

        public String getServerType() {
            return this.serverType;
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public void setServerName(String sName) {
            this.serverName = sName;
        }

        public void setPortNumber(String pNumber) {
            this.portNumber = pNumber;
        }

        public void setServerType(String sType) {
            this.serverType = sType;
        }

        public void setDatabaseName(String dName) {
            this.databaseName = dName;
        }

        public String toString() {
            return new String(this.serverName + ":" + this.portNumber + "/" + this.databaseName);
        }
    }

    private static class DB2DatabaseInformation {
        private String databaseName;
        private String systemNode;

        private DB2DatabaseInformation() {
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public String getSystemNode() {
            return this.systemNode;
        }

        public void setDatabaseName(String dName) {
            this.databaseName = dName;
        }

        public void setSystemNode(String sNode) {
            this.systemNode = sNode;
        }
    }
}

