/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.jdbc.util;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.exception.XQERuntimeException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class JDBCORConnectionStringConverter {
    private static final String OR_JDBC_THIN_DRIVER_NAME = "oracle.jdbc.OracleDriver";
    private static final String SEMICOLON = ";";
    private static final String AT = "@";
    private static final String EQUAL = "=";
    private static final String COMMA = ",";
    private static final int CNX_STR_INDX = 3;
    private static final String SLASH = "/";
    private static final String DOUBLE_SLASH = "//";
    private static final String OR_HOST = "HOST=";
    private static final String OR_PORT = "PORT=";
    private static final String OR_SERVICE_NAME = "SERVICE_NAME=";
    private static final String OR_SID = "SID=";
    private static final String OR_COMMENT = "#";
    private static final String LEFT_BRACKET = "(";
    private static final String CLOSING_BRACKET = ")";
    private static final String EMPTY_CHAR = "";
    private static final String SPACE_CHAR = " ";
    private static Map<String, ORConnectionInfo> databaseConnectionMap = new HashMap<String, ORConnectionInfo>();

    public static boolean isConnectionMapEmpty() {
        return databaseConnectionMap.isEmpty();
    }

    public static String convertConnectionString(String connectionString) {
        if (connectionString.startsWith("jdbc:")) {
            return connectionString;
        }
        if (JDBCORConnectionStringConverter.isConnectionMapEmpty()) {
            try {
                JDBCORConnectionStringConverter.parseConnectionFromFile();
            }
            catch (IOException e) {
                throw new XQERuntimeException(e);
            }
        }
        String[] parts = connectionString.split(SEMICOLON);
        StringBuilder jdbcCnxStr = new StringBuilder();
        if (!JDBCORConnectionStringConverter.isConnectionMapEmpty() && parts.length > 3) {
            String[] tokens;
            String hostInfo = null;
            if (parts[3].startsWith("ORACLE@")) {
                tokens = parts[3].split(AT);
                String logicalDbName = tokens[2].substring(0, tokens[2].indexOf(SLASH));
                ORConnectionInfo cnxInfo = databaseConnectionMap.get(logicalDbName.toUpperCase());
                if (cnxInfo != null) {
                    hostInfo = cnxInfo.toString();
                }
            } else {
                tokens = parts[3].split(DOUBLE_SLASH);
                hostInfo = tokens[1];
            }
            jdbcCnxStr.append(parts[0]);
            jdbcCnxStr.append(SEMICOLON);
            jdbcCnxStr.append(parts[1]);
            jdbcCnxStr.append(";JD-OR;URL=");
            jdbcCnxStr.append("jdbc:oracle:thin:@//");
            jdbcCnxStr.append(hostInfo);
            jdbcCnxStr.append(";DRIVER_NAME=");
            jdbcCnxStr.append(OR_JDBC_THIN_DRIVER_NAME);
            String localSort = null;
            String level = null;
            for (int i = 0; i < parts.length; ++i) {
                int colseqIDX = parts[i].indexOf("@COLSEQ=");
                int levelIDX = parts[i].indexOf("@LEVEL=");
                if (colseqIDX == -1 || levelIDX == -1) continue;
                String[] colsqeAndLevel = parts[i].split(COMMA);
                localSort = colsqeAndLevel[0].substring(colsqeAndLevel[0].indexOf(61) + 1);
                level = colsqeAndLevel[1].substring(colsqeAndLevel[1].indexOf(61) + 1);
            }
            if (localSort != null) {
                jdbcCnxStr.append(";LOCALSORT=");
                jdbcCnxStr.append(localSort);
                jdbcCnxStr.append(",LEVEL=");
                jdbcCnxStr.append(level);
            }
        } else {
            LogonFailureException ex = new LogonFailureException(LogonFailureException.SubCodeEnum.INVALID_CONN_STRING);
            throw ex;
        }
        return jdbcCnxStr.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseConnectionFromFile() throws IOException {
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        String oracleTnsFile = config.getConfigDirectory() + "/jdbc/tnsnames.ora";
        try (BufferedReader reader = new BufferedReader(new FileReader(oracleTnsFile));){
            String oracleHostName = null;
            String oraclePort = null;
            String oracleServiceName = null;
            String tnsName = null;
            boolean done = false;
            int start = 0;
            int end = 0;
            String line = reader.readLine();
            while (line != null) {
                if ((line = line.replace(SPACE_CHAR, EMPTY_CHAR)).length() > 0 && !line.startsWith(OR_COMMENT) && !line.startsWith(LEFT_BRACKET) && line.contains(EQUAL)) {
                    tnsName = line.substring(0, line.indexOf(EQUAL));
                    while (line != null && !done) {
                        if (line.contains(OR_HOST)) {
                            start = line.indexOf(OR_HOST);
                            end = line.indexOf(CLOSING_BRACKET, start);
                            oracleHostName = line.substring(start + OR_HOST.length(), end);
                        }
                        if (line.contains(OR_PORT)) {
                            start = line.indexOf(OR_PORT);
                            end = line.indexOf(CLOSING_BRACKET, start);
                            oraclePort = line.substring(start + OR_PORT.length(), end);
                        }
                        if (line.contains(OR_SERVICE_NAME)) {
                            start = line.indexOf(OR_SERVICE_NAME);
                            end = line.indexOf(CLOSING_BRACKET, start);
                            oracleServiceName = line.substring(start + OR_SERVICE_NAME.length(), end);
                            done = true;
                        }
                        if (line.contains(OR_SID)) {
                            start = line.indexOf(OR_SID);
                            end = line.indexOf(CLOSING_BRACKET, start);
                            oracleServiceName = line.substring(start + OR_SID.length(), end);
                            done = true;
                        }
                        if (!done) {
                            line = reader.readLine();
                            line = line.replace(SPACE_CHAR, EMPTY_CHAR);
                            continue;
                        }
                        ORConnectionInfo cnxInfo = new ORConnectionInfo(oracleHostName, oraclePort, oracleServiceName);
                        databaseConnectionMap.put(tnsName.toUpperCase(), cnxInfo);
                    }
                    done = false;
                }
                line = reader.readLine();
            }
        }
    }

    public static void terminate() {
        databaseConnectionMap = null;
    }

    private static class ORConnectionInfo {
        private String hostName;
        private String portNumber;
        private String serviceName;

        ORConnectionInfo(String oracleHostName, String oraclePortNumber, String oracleServiceName) {
            this.hostName = oracleHostName;
            this.portNumber = oraclePortNumber;
            this.serviceName = oracleServiceName;
        }

        public String getHostName() {
            return this.hostName;
        }

        public String getPortNumber() {
            return this.portNumber;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public String toString() {
            return new String(this.hostName + ":" + this.portNumber + JDBCORConnectionStringConverter.SLASH + this.serviceName);
        }
    }
}

