/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.jdbc.util;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.LogonFailureException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;

public class JDBCSSConnectionStringConverter {
    private static final String ODBCINIFILEPATH = "/jdbc/ssodbc.ini";
    private static final int INITIAL_CAPACITY = 256;
    private static final String SEMICOLON = ";";
    private static final String SECTIONLEFTDELIMITER = "[";
    private static final String SECTIONRIGHTDELIMITER = "]";
    private static final String PROPERTYSEPARATOR = "=";
    private static final String COMMA = ",";
    private static Hashtable<String, ConnInfo> connInfos = new Hashtable(256);

    public static String convertConnectionString(String connectionString) throws IOException {
        int i;
        StringBuilder buffer = new StringBuilder();
        String dsnName = null;
        String serverName = null;
        String portNumber = null;
        String databaseName = null;
        boolean integratedSecurity = false;
        String localSort = null;
        String level = null;
        if (connectionString.startsWith("jdbc:")) {
            return connectionString;
        }
        if (connInfos.size() == 0) {
            XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            JDBCSSConnectionStringConverter.loadINIFile(config.getConfigDirectory() + ODBCINIFILEPATH);
        }
        String[] parts = connectionString.split(SEMICOLON);
        if (connectionString.indexOf("Provider=") != -1) {
            for (i = 0; i < parts.length; ++i) {
                if (parts[i].startsWith("Data Source=")) {
                    serverName = parts[i].substring(parts[i].indexOf(61) + 1);
                    continue;
                }
                if (parts[i].contains("Initial Catalog=")) {
                    String[] oledbPorperties = parts[i].split(PROPERTYSEPARATOR);
                    for (int j = 0; j < oledbPorperties.length; ++j) {
                        if (!oledbPorperties[j].equalsIgnoreCase("Initial Catalog") || j + 1 >= oledbPorperties.length) continue;
                        databaseName = oledbPorperties[j + 1];
                    }
                    continue;
                }
                if (!parts[i].startsWith("INTEGRATED SECURITY=")) continue;
                integratedSecurity = true;
            }
        } else {
            for (int i2 = 0; i2 < parts.length; ++i2) {
                if (parts[i2].startsWith("DSN=")) {
                    dsnName = parts[i2].substring(parts[i2].indexOf(61) + 1);
                    continue;
                }
                if (!parts[i2].startsWith("Trusted_Connection=yes")) continue;
                integratedSecurity = true;
            }
            ConnInfo connInfo = connInfos.get(dsnName);
            if (connInfo == null) {
                LogonFailureException ex = new LogonFailureException(LogonFailureException.SubCodeEnum.INVALID_CONN_STRING);
                throw ex;
            }
            serverName = connInfo.getServerName();
            if (serverName == null) {
                LogonFailureException ex = new LogonFailureException(LogonFailureException.SubCodeEnum.INVALID_SERVER);
                throw ex;
            }
            portNumber = connInfo.getPortNumber();
            databaseName = connInfo.getDBName();
        }
        for (i = 0; i < parts.length; ++i) {
            int colseqIDX = parts[i].indexOf("@COLSEQ=");
            int levelIDX = parts[i].indexOf("@LEVEL=");
            if (colseqIDX == -1 || levelIDX == -1) continue;
            String[] colsqeAndLevel = parts[i].split(COMMA);
            localSort = colsqeAndLevel[0].substring(colsqeAndLevel[0].indexOf(61) + 1);
            level = colsqeAndLevel[1].substring(colsqeAndLevel[1].indexOf(61) + 1);
        }
        buffer.append(parts[0]);
        buffer.append(SEMICOLON);
        buffer.append(parts[1]);
        buffer.append(";JD-SS;URL=");
        buffer.append("jdbc:sqlserver://");
        buffer.append(serverName);
        if (portNumber != null) {
            buffer.append(":" + portNumber);
        }
        if (databaseName != null) {
            buffer.append(";databaseName=");
            buffer.append(databaseName);
        }
        buffer.append(";DRIVER_NAME=com.microsoft.sqlserver.jdbc.SQLServerDriver");
        if (integratedSecurity) {
            buffer.append(";integratedSecurity=true");
        }
        if (localSort != null) {
            buffer.append(";LOCALSORT=");
            buffer.append(localSort);
            buffer.append(",LEVEL=");
            buffer.append(level);
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadINIFile(String filePath) throws IOException {
        connInfos.clear();
        try (BufferedReader rd = new BufferedReader(new FileReader(filePath));){
            String dsnName = null;
            ConnInfo connInfo = null;
            String lineStr = rd.readLine();
            while (lineStr != null) {
                String tmpStr = JDBCSSConnectionStringConverter.getDNSName(lineStr);
                if (tmpStr != null) {
                    if (dsnName != null) {
                        connInfos.put(dsnName, connInfo);
                    }
                    dsnName = tmpStr;
                    connInfo = new ConnInfo();
                }
                if (lineStr.indexOf(SECTIONLEFTDELIMITER) == -1) {
                    String[] property = lineStr.split(PROPERTYSEPARATOR);
                    if (property[0].equalsIgnoreCase("Address")) {
                        String[] severAndPort = property[1].split(COMMA);
                        connInfo.setServerName(severAndPort[0]);
                        connInfo.setPortNumber(severAndPort[1]);
                    } else if (property[0].equalsIgnoreCase("Database")) {
                        connInfo.setDBName(property[1]);
                    }
                }
                if ((lineStr = rd.readLine()) != null || dsnName == null) continue;
                connInfos.put(dsnName, connInfo);
            }
        }
    }

    private static String getDNSName(String str) {
        String sectionName;
        String dnsName = null;
        int leftIndex = str.indexOf(SECTIONLEFTDELIMITER);
        int rightIndex = str.indexOf(SECTIONRIGHTDELIMITER);
        if (leftIndex != -1 && rightIndex != -1 && !(sectionName = str.substring(leftIndex + 1, rightIndex)).equalsIgnoreCase("ODBC") && !sectionName.equalsIgnoreCase("ODBC Data Sources")) {
            dnsName = sectionName;
        }
        return dnsName;
    }

    public static void terminate() {
        connInfos = null;
    }

    private static class ConnInfo {
        private String serverName = null;
        private String portNumber = null;
        private String databaseName = null;

        private ConnInfo() {
        }

        public String getServerName() {
            return this.serverName;
        }

        public void setServerName(String aServerName) {
            this.serverName = aServerName;
        }

        public String getPortNumber() {
            return this.portNumber;
        }

        public void setPortNumber(String aPortNumber) {
            this.portNumber = aPortNumber;
        }

        public String getDBName() {
            return this.databaseName;
        }

        public void setDBName(String aDatabaseName) {
            this.databaseName = aDatabaseName;
        }
    }
}

