/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.rscache;

import com.cognos.xqe.data.providers.rscache.CachedResultSet;
import com.cognos.xqe.data.providers.rscache.IncompleteCacheException;
import com.cognos.xqe.data.providers.rscache.accessors.ICellIteratorAccessor;
import com.cognos.xqe.data.providers.rscache.accessors.IResultSetAccessor;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XScrollableCellIterator;

public class CachedCellIterator
extends XScrollableCellIterator {
    private static final String OVERFLOW_ERROR = "Current ordinal overflows the integer limit";
    private final CachedResultSet resultSet;
    private ICellIteratorAccessor accessor;
    private final boolean scrollable;

    CachedCellIterator(CachedResultSet rs, ICellIteratorAccessor acc, boolean isScrollable, XDataContext xDataContext, Integer nodeId) {
        super(xDataContext, nodeId);
        this.scrollable = isScrollable;
        this.resultSet = rs;
        this.accessor = acc;
        this.resultSet.addCellIterator(this);
    }

    @Override
    public void release() {
        try {
            try {
                if (this.accessor != null) {
                    this.accessor.release();
                    this.accessor = null;
                }
            }
            finally {
                this.resultSet.removeCellIterator(this);
            }
        }
        finally {
            super.release();
        }
    }

    @Override
    public ICell nextImpl() {
        ICell cell = null;
        try {
            cell = this.accessor.next();
        }
        catch (IncompleteCacheException ex) {
            this.resultSet.repairCacheHole();
            cell = this.accessor.next();
        }
        if (cell == null) {
            return null;
        }
        this.currentOrdinal = cell.getOrdinal();
        if (this.currentOrdinal > Integer.MAX_VALUE) {
            throw new IllegalStateException(OVERFLOW_ERROR);
        }
        return cell;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.accessor.hasNext();
        }
        catch (IncompleteCacheException ex) {
            this.resultSet.repairCacheHole();
            return this.accessor.hasNext();
        }
    }

    @Override
    public boolean absolute(long index) {
        boolean result = false;
        try {
            result = this.accessor.absolute(index);
        }
        catch (IncompleteCacheException ex) {
            this.resultSet.repairCacheHole();
            result = this.accessor.absolute(index);
        }
        if (result) {
            this.currentOrdinal = index;
        }
        if (this.currentOrdinal > Integer.MAX_VALUE) {
            throw new IllegalStateException(OVERFLOW_ERROR);
        }
        return result;
    }

    @Override
    public ICell byOrdinal(long ordinal) {
        ICell cell = null;
        try {
            cell = this.accessor.byOrdinal(ordinal);
        }
        catch (IncompleteCacheException ex) {
            this.resultSet.repairCacheHole();
            cell = this.accessor.byOrdinal(ordinal);
        }
        if (cell == null) {
            return null;
        }
        return cell;
    }

    @Override
    public ICell current() {
        return this.accessor.current();
    }

    @Override
    public boolean reset() {
        boolean result = this.accessor.reset();
        if (result) {
            this.currentOrdinal = 0L;
        }
        return result;
    }

    @Override
    public boolean hasPrevious() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ICell previous() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void swapAccessor(IResultSetAccessor rsAccessor) {
        block6: {
            ICellIteratorAccessor oldAccessor = this.accessor;
            try {
                this.accessor = rsAccessor.getCellIterator(this.scrollable);
                if (this.scrollable) {
                    this.accessor.absolute(this.currentOrdinal);
                    break block6;
                }
                long ord = -1L;
                while (ord < this.currentOrdinal) {
                    ICell c = this.accessor.next();
                    if (null == c) {
                        break;
                    }
                    ord = c.getOrdinal();
                }
            }
            finally {
                oldAccessor.release();
            }
        }
    }
}

