/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.rscache;

import com.cognos.xqe.cache.ICaching;
import com.cognos.xqe.data.providers.connection.parameters.MissingSecurityContextException;
import com.cognos.xqe.data.providers.connection.parameters.ModelPathParameter;
import com.cognos.xqe.data.providers.connection.parameters.RunLocaleParameter;
import com.cognos.xqe.data.providers.olap.MDXQueryArguments;
import com.cognos.xqe.data.providers.rscache.CachedCellIterator;
import com.cognos.xqe.data.providers.rscache.CachedEdgeIterator;
import com.cognos.xqe.data.providers.rscache.CachingProvider;
import com.cognos.xqe.data.providers.rscache.RSCacheLog;
import com.cognos.xqe.data.providers.rscache.RSCacheMetrics;
import com.cognos.xqe.data.providers.rscache.ResultSetCacheManager;
import com.cognos.xqe.data.providers.rscache.ResultSetData;
import com.cognos.xqe.data.providers.rscache.accessors.IResultSetAccessor;
import com.cognos.xqe.data.providers.rscache.accessors.real.RealResultSetAccessor;
import com.cognos.xqe.data.providers.rscache.pool.CachingProviderParameter;
import com.cognos.xqe.data.providers.rscache.pool.CubeRevisionParameter;
import com.cognos.xqe.data.providers.rscache.pool.MDXParameter;
import com.cognos.xqe.data.providers.rscache.pool.RSCacheSelector;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionSelector;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.md.CacheHints;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XScrollableCellIterator;
import com.cognos.xqe.runtree.XScrollableIterator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.LinkedStack;
import java.util.LinkedList;
import java.util.List;

public final class CachedResultSet
extends XResultSetBase
implements ICubeResultSet,
ICaching {
    private final CachingProvider cachingProvider;
    private final MDXQueryArguments queryArguments;
    private IResultSetAccessor accessor;
    private boolean wasRepaired = false;
    private final List<CachedCellIterator> cellIterators = new LinkedList<CachedCellIterator>();
    private final List<CachedEdgeIterator> edgeIterators = new LinkedList<CachedEdgeIterator>();

    CachedResultSet(XDataContext xDataContext, CachingProvider theCachingProvider, MDXQueryArguments theQueryArguments) {
        super(xDataContext, xDataContext.getNodeId());
        this.cachingProvider = theCachingProvider;
        this.queryArguments = theQueryArguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean initialize() {
        boolean success = false;
        XDataContext xDataContext = this.getDataContext();
        try {
            ConnectionParameters connParams = this.cachingProvider.createConnectionParameters((ExecutionEnvironment)xDataContext.getEnvironment(), this.queryArguments);
            ConnectionParameters cacheParams = this.createCacheParameters(connParams, xDataContext, this.cachingProvider, this.queryArguments);
            cacheParams.put(new CachingProviderParameter(this.cachingProvider));
            String providerType = this.queryArguments.getDataSource().getType();
            IConnectionSelector selector = this.cachingProvider.getConnectionSelector(providerType, null);
            XQELogger poolLogger = RSCacheLog.getPoolLogger();
            if (poolLogger.isOn(LogLevel.INFO)) {
                poolLogger.log(LogLevel.INFO, "Borrowing ResultSetData with parameters: " + cacheParams);
            }
            ResultSetData data = null;
            try {
                data = ResultSetCacheManager.getInstance().borrowResultSetData(this.cachingProvider.getProviderInstanceName(), cacheParams, new RSCacheSelector(selector));
            }
            catch (MissingSecurityContextException e) {
                Object securityContext = this.cachingProvider.getSecurityContext(connParams);
                if (securityContext == null) {
                    throw e;
                }
                IConnectionSelector newSelector = this.cachingProvider.getConnectionSelector(providerType, securityContext);
                if (poolLogger.isOn(LogLevel.INFO)) {
                    poolLogger.log(LogLevel.INFO, "Retry borrowing with security context: " + securityContext);
                }
                data = ResultSetCacheManager.getInstance().borrowResultSetData(this.cachingProvider.getProviderInstanceName(), cacheParams, new RSCacheSelector(newSelector));
            }
            try {
                this.accessor = data.createResultSetAccessor(this.cachingProvider, xDataContext, this.queryArguments);
                success = true;
            }
            catch (RuntimeException ex) {
                XQELogger dataLogger = RSCacheLog.getDataLogger();
                if (dataLogger.isOn(LogLevel.ERROR)) {
                    dataLogger.log(LogLevel.ERROR, (Throwable)ex);
                }
                data.returnToPool();
                this.release();
                throw ex;
            }
        }
        finally {
            if (!success) {
                this.release();
            }
        }
        return success;
    }

    private ConnectionParameters createCacheParameters(ConnectionParameters params, XDataContext xDataContext, CachingProvider theCachingProvider, MDXQueryArguments theQueryArguments) {
        ConnectionParameters ans = params.duplicate();
        String mdx = theQueryArguments.getMDXText();
        MDXParameter mdxParameter = new MDXParameter(mdx);
        RunLocaleParameter runLocaleParameter = new RunLocaleParameter(theQueryArguments.getRunLocale(), true);
        CubeRevisionParameter revParameter = theCachingProvider.getCubeRevision((ExecutionEnvironment)xDataContext.getEnvironment(), params, theQueryArguments);
        ans.put(mdxParameter);
        ans.put(runLocaleParameter);
        ans.put(revParameter);
        MetadataConnection connection = theQueryArguments.getMDXQuery().getReferencedCube().getConnection();
        if (connection != null) {
            ModelPathParameter modelPathParameter = new ModelPathParameter(connection.getModelPath());
            ans.put(modelPathParameter);
        }
        theCachingProvider.getSecurityContext(ans);
        return ans;
    }

    ICubeResultSet queryRealProvider() {
        return this.cachingProvider.queryRealProvider(this.getDataContext(), this.queryArguments);
    }

    void addCellIterator(CachedCellIterator cellIter) {
        this.cellIterators.add(cellIter);
    }

    void removeCellIterator(CachedCellIterator cellIter) {
        this.cellIterators.remove(cellIter);
    }

    void addEdgeIterator(CachedEdgeIterator edgeIter) {
        this.edgeIterators.add(edgeIter);
    }

    void removeEdgeIterator(CachedEdgeIterator edgeIter) {
        this.edgeIterators.remove(edgeIter);
    }

    @Override
    public XIterator getAxisIterator(int edgeNo) {
        CachedEdgeIterator iter = new CachedEdgeIterator(this, this.accessor.getEdgeIterator(edgeNo), this.getDataContext(), this.nodeId);
        iter.setEdgeNumber(edgeNo);
        return iter;
    }

    @Override
    public XScrollableIterator getScrollableAxisIterator(int edgeNo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public XCellIterator getCellIterator() {
        return new CachedCellIterator(this, this.accessor.getCellIterator(false), false, this.getDataContext(), this.nodeId);
    }

    @Override
    public XScrollableCellIterator getScrollableCellIterator() {
        return new CachedCellIterator(this, this.accessor.getCellIterator(true), true, this.getDataContext(), this.nodeId);
    }

    @Override
    public int getNumAxes() {
        return this.accessor.getNumEdges();
    }

    @Override
    public ITuple getSlicer() {
        return this.accessor.getSlicer();
    }

    @Override
    public IDimension[] getDimensions(int edgeNo) {
        return this.accessor.getDimensions(edgeNo);
    }

    @Override
    public long getAxisSize(int edgeNo) {
        return this.accessor.getAxisSize(edgeNo);
    }

    @Override
    public int getNumTabularMeasures() {
        return 0;
    }

    @Override
    public int getNumDataItemForSummary(int rowsetId) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void releaseImpl() {
        try {
            CachedEdgeIterator[] openEdgeIters;
            CachedCellIterator[] openCellIters;
            XQELogger dataLogger = RSCacheLog.getDataLogger();
            for (CachedCellIterator iter : openCellIters = this.cellIterators.toArray(new CachedCellIterator[0])) {
                dataLogger.log(LogLevel.WARN, "Detected an unreleased CachedCellIterator.");
                iter.release();
            }
            this.cellIterators.clear();
            for (CachedEdgeIterator iter : openEdgeIters = this.edgeIterators.toArray(new CachedEdgeIterator[0])) {
                dataLogger.log(LogLevel.WARN, "Detected an unreleased CachedEdgeIterator.");
                iter.release();
            }
            this.edgeIterators.clear();
        }
        finally {
            if (this.accessor != null) {
                this.accessor.getCachedData().returnToPool();
                this.accessor.release();
                this.accessor = null;
            }
        }
    }

    @Override
    public boolean isCaching() {
        return true;
    }

    @Override
    public void optimizeCache(LinkedStack<CacheHints> hints) {
    }

    public boolean wasRepaired() {
        return this.wasRepaired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IResultSetAccessor repairCacheHole() {
        XQELogger logger = RSCacheLog.getDataLogger();
        if (logger.isOn(LogLevel.INFO)) {
            logger.log(LogLevel.INFO, "Repairing a cache hole for a CachedResultSet with arguments " + this.queryArguments);
        }
        RSCacheMetrics.getCacheHoleCount().increment();
        IResultSetAccessor oldAccessor = this.accessor;
        try {
            ICubeResultSet rs = this.queryRealProvider();
            this.accessor = new RealResultSetAccessor(oldAccessor.getCachedData(), rs);
            for (CachedCellIterator cachedCellIterator : this.cellIterators) {
                cachedCellIterator.swapAccessor(this.accessor);
            }
            for (CachedEdgeIterator cachedEdgeIterator : this.edgeIterators) {
                cachedEdgeIterator.swapAccessor(this.accessor);
            }
        }
        finally {
            oldAccessor.release();
        }
        this.wasRepaired = true;
        return this.accessor;
    }
}

