/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.rscache;

import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.ConnectionTestQueryArguments;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.MDXQueryArguments;
import com.cognos.xqe.data.providers.olap.MetadataQueryArguments;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.rscache.CachedCubeRevision;
import com.cognos.xqe.data.providers.rscache.CachedResultSet;
import com.cognos.xqe.data.providers.rscache.RSCacheLog;
import com.cognos.xqe.data.providers.rscache.pool.CubeRevisionParameter;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.metadata.ICatalog;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.record.CubeRecord;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionFactory;
import com.cognos.xqe.pool.connection.IConnectionSelector;
import com.cognos.xqe.pool.connection.IExpirationPolicy;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.resource.ReleasableResourceTracker;
import com.cognos.xqe.util.xml.serializer.DefaultProcessor;
import java.io.StringWriter;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CachingProvider
implements IOLAPDataProvider {
    private IOLAPDataProvider provider;
    private final long cubeUpdateCheckPeriod;
    private final ConcurrentMap<Object, CachedCubeRevision> cubeUpdateLastCheckTime;

    public CachingProvider(IOLAPDataProvider theProvider) {
        XQELogger logger = RSCacheLog.getProviderLogger();
        if (logger.isOn(LogLevel.INFO)) {
            logger.log(LogLevel.INFO, "Creating CachingProvider for OLAPDataProvider: " + theProvider.getProviderInstanceName());
        }
        this.provider = theProvider;
        this.cubeUpdateLastCheckTime = new ConcurrentHashMap<Object, CachedCubeRevision>();
        this.cubeUpdateCheckPeriod = Long.valueOf(this.provider.getProperty("cubeUpdateCheckPeriod"));
    }

    @Override
    public List<XQEMessage> testConnection(ConnectionTestQueryArguments theQueryArguments) {
        return this.provider.testConnection(theQueryArguments);
    }

    @Override
    public IOLAPMetadataProvider getMetadataProvider(MetadataQueryArguments theQueryArguments) {
        return this.provider.getMetadataProvider(theQueryArguments);
    }

    @Override
    public ICubeResultSet query(XDataContext dataContext, MDXQueryArguments queryArguments) {
        XQELogger logger = RSCacheLog.getProviderLogger();
        if (logger.isOn(LogLevel.INFO)) {
            logger.log(LogLevel.INFO, "Creating CachedResultSet for arguments " + queryArguments.toString());
        }
        CachedResultSet resultSet = new CachedResultSet(dataContext, this, queryArguments);
        resultSet.initialize();
        return resultSet;
    }

    @Override
    public ConnectionParameters createConnectionParameters(IExecutionEnvironment env, MDXQueryArguments queryArgs) {
        return this.provider.createConnectionParameters(env, queryArgs);
    }

    @Override
    public IConnectionSelector getConnectionSelector(String providerType, Object securityContext) {
        return this.provider.getConnectionSelector(providerType, securityContext);
    }

    @Override
    public Object getSecurityContext(ConnectionParameters params) {
        return this.provider.getSecurityContext(params);
    }

    ICubeResultSet queryRealProvider(XDataContext dataContext, MDXQueryArguments queryArguments) {
        XQELogger logger = RSCacheLog.getProviderLogger();
        if (logger.isOn(LogLevel.INFO)) {
            logger.log(LogLevel.INFO, "Querying real provider with arguments " + queryArguments.toString());
        }
        return this.provider.query(dataContext, queryArguments);
    }

    @Override
    public String getProperty(String propertyName) {
        return this.provider.getProperty(propertyName);
    }

    @Override
    public String getProviderInstanceName() {
        return this.provider.getProviderInstanceName();
    }

    @Override
    public String cognosUNToNativeUN(String providerType, IHierarchy hierarchy, String cognosUN) {
        return this.provider.cognosUNToNativeUN(providerType, hierarchy, cognosUN);
    }

    @Override
    public String nativeUNToCognosUN(String providerType, String nativeUN) {
        return this.provider.nativeUNToCognosUN(providerType, nativeUN);
    }

    @Override
    public IConnectionFactory getConnectionFactory() {
        return this.provider.getConnectionFactory();
    }

    @Override
    public IPooledConnection borrowConnection(ConnectionParameters connParams, IExecutionEnvironment executionEnvironment) {
        return this.provider.borrowConnection(connParams, executionEnvironment);
    }

    @Override
    public void release() {
        if (this.provider != null) {
            this.provider.release();
            this.provider = null;
        }
    }

    public String toString() {
        return this.provider.toString();
    }

    public boolean equals(Object o) {
        return this.provider.equals(o);
    }

    public int hashCode() {
        return this.provider.hashCode();
    }

    @Override
    public void resolveDataSourceCapabilities(IExecutionEnvironment executionEnv, IDataSource dataSource, Locale exprLocale) {
        this.provider.resolveDataSourceCapabilities(executionEnv, dataSource, exprLocale);
    }

    @Override
    public ReleasableResourceTracker getResourceTracker() {
        return this.provider.getResourceTracker();
    }

    public CubeRevisionParameter getCubeRevision(ExecutionEnvironment env, ConnectionParameters params, MDXQueryArguments args) {
        Object key = this.getCubeUniqueId(params, args);
        if (key != null) {
            long lastCheckTime;
            long currentTime;
            CachedCubeRevision newRev = new CachedCubeRevision();
            CachedCubeRevision oldRev = this.cubeUpdateLastCheckTime.putIfAbsent(key, newRev);
            if (oldRev == null) {
                this.updateCubeRevision(args, env, newRev);
                return newRev.getCubeRevision();
            }
            if (oldRev.isUpdating()) {
                oldRev.waitForUpdate();
            }
            if ((currentTime = System.currentTimeMillis()) - (lastCheckTime = oldRev.getTimestamp()) < this.cubeUpdateCheckPeriod) {
                return oldRev.getCubeRevision();
            }
            this.updateCubeRevision(args, env, oldRev);
            return oldRev.getCubeRevision();
        }
        return this.getCurrentCubeRevision(args, env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCubeRevision(MDXQueryArguments args, ExecutionEnvironment env, CachedCubeRevision cachedRev) {
        cachedRev.startUpdating();
        try {
            CubeRevisionParameter newRev = this.getCurrentCubeRevision(args, env);
            cachedRev.setTimestamp(System.currentTimeMillis());
            cachedRev.setCubeRevision(newRev);
        }
        finally {
            cachedRev.stopUpdating();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CubeRevisionParameter getCurrentCubeRevision(MDXQueryArguments args, ExecutionEnvironment env) {
        XQELogger logger;
        MetadataQueryArguments mdQueryArgs = MetadataQueryArguments.buildArguments(args.getDataSource(), env, null);
        MetadataRestriction restrictions = new MetadataRestriction();
        restrictions.add(RestrictionType.CUBE, args.getCube().getName());
        ICatalog catalog = args.getCube().getCatalog();
        if (catalog != null) {
            restrictions.add(RestrictionType.CATALOG, catalog.getName());
        }
        List<CubeRecord> cubes = null;
        IOLAPMetadataProvider mdProvider = null;
        try {
            mdProvider = this.provider.getMetadataProvider(mdQueryArgs);
            cubes = mdProvider.getCubes(restrictions);
        }
        finally {
            if (mdProvider != null) {
                mdProvider.release();
            }
        }
        if (cubes != null && cubes.size() == 1) {
            CubeRecord r = cubes.get(0);
            return CachingProvider.createCubeRevisionParameter(this.provider.getProviderInstanceName(), r);
        }
        if (cubes != null && cubes.size() > 1) {
            for (CubeRecord cr : cubes) {
                if (!cr.getName().equals(args.getCube().getName())) continue;
                return CachingProvider.createCubeRevisionParameter(this.provider.getProviderInstanceName(), cr);
            }
        }
        if ((logger = RSCacheLog.getPoolLogger()).isOn(LogLevel.ERROR)) {
            StringWriter buffer = new StringWriter();
            buffer.write("Received invalid CubeRecord(s) when retrieving revision stamp.");
            try {
                buffer.write("\nConnectionString: ");
                buffer.write(args.getDataSource().getDataSourceConnection().getConnectionString(null));
                DefaultProcessor proc = new DefaultProcessor();
                buffer.write("\nRestrictions: ");
                proc.serialize((Object)restrictions, buffer);
                if (cubes != null) {
                    buffer.write("\nCubeRecord: ");
                    proc.reset();
                    proc.serialize(cubes, buffer);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            buffer.write("\nQuery will be executed against data provider instead of cache.");
            logger.log(LogLevel.ERROR, buffer.toString());
        }
        return new CubeRevisionParameter(System.currentTimeMillis());
    }

    private static CubeRevisionParameter createCubeRevisionParameter(String providerName, CubeRecord record) {
        DateTimeValue revision = record.getCubeRevision();
        if (revision != null) {
            return new CubeRevisionParameter(revision.getMilliseconds());
        }
        XQELogger dataLogger = RSCacheLog.getDataLogger();
        if (dataLogger.isOn(LogLevel.WARN)) {
            StringBuilder buf = new StringBuilder("Cube DataUpdateDate attribute is not supported by ");
            buf.append(providerName);
            buf.append(" provider. Please turn off the result set caching");
            buf.append(" feature for this provider in xqe.provider.xml");
            dataLogger.log(LogLevel.WARN, buf.toString());
        }
        return new CubeRevisionParameter(System.currentTimeMillis());
    }

    @Override
    public Object getCubeUniqueId(ConnectionParameters params, MDXQueryArguments args) {
        return this.provider.getCubeUniqueId(params, args);
    }

    @Override
    public IExpirationPolicy getConnectionExpirationPolicy() {
        return this.provider.getConnectionExpirationPolicy();
    }
}

