/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.rscache.accessors.inmemory;

import com.cognos.xqe.data.providers.rscache.IncompleteCacheException;
import com.cognos.xqe.data.providers.rscache.RSCacheLog;
import com.cognos.xqe.data.providers.rscache.RSCacheMetrics;
import com.cognos.xqe.data.providers.rscache.ResultSetData;
import com.cognos.xqe.data.providers.rscache.accessors.ICellIteratorAccessor;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.usage.UsageTrackingService;

public class InMemoryCellIteratorAccessor
implements ICellIteratorAccessor {
    private ResultSetData data;
    private int pos = -1;
    private boolean executeLoggingAndMetrics = false;

    public InMemoryCellIteratorAccessor(ResultSetData dat) {
        this.data = dat;
        this.executeLoggingAndMetrics = UsageTrackingService.isEnabled() || RSCacheLog.getCellDataLogger().isOn(LogLevel.TRACE);
    }

    @Override
    public boolean absolute(long index) {
        if (index < 0L) {
            return false;
        }
        if (index > (long)this.data.getMaxCellOrdinal()) {
            if (this.data.wasLastCellSeen()) {
                RSCacheMetrics.getCellHitCount().increment();
                return false;
            }
            RSCacheMetrics.getCellMissCount().increment();
            throw new IncompleteCacheException(index);
        }
        this.pos = (int)index;
        return true;
    }

    @Override
    public ICell byOrdinal(long ordinal) {
        if (!this.absolute(ordinal)) {
            return null;
        }
        return this.current();
    }

    @Override
    public ICell current() {
        if (this.pos == -1) {
            return null;
        }
        return this.data.getCell(this.pos, this.executeLoggingAndMetrics);
    }

    @Override
    public boolean hasNext() {
        Boolean hasDataInRange;
        Boolean resultSetHasData = this.data.hasData();
        if (!(null == resultSetHasData || resultSetHasData.booleanValue() && this.pos != -1)) {
            RSCacheMetrics.getCellHitCount().increment();
            return resultSetHasData;
        }
        if (this.pos < this.data.getMaxCellOrdinal() && null != (hasDataInRange = this.data.hasData(this.pos + 1, this.data.getMaxCellOrdinal())) && hasDataInRange.booleanValue()) {
            RSCacheMetrics.getCellHitCount().increment();
            return hasDataInRange;
        }
        if (this.data.wasLastCellSeen()) {
            RSCacheMetrics.getCellHitCount().increment();
            return false;
        }
        RSCacheMetrics.getCellMissCount().increment();
        throw new IncompleteCacheException(this.pos);
    }

    @Override
    public ICell next() {
        int nextPos = this.data.getNextNonNullCellPos(this.pos + 1, this.executeLoggingAndMetrics);
        if (nextPos == -1) {
            return null;
        }
        this.pos = nextPos;
        return this.data.getCell(this.pos, this.executeLoggingAndMetrics);
    }

    @Override
    public boolean reset() {
        return this.absolute(0L);
    }

    @Override
    public void release() {
        this.data = null;
    }
}

