/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.secbridge;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.secbridge.IImpersonator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.TraceContext;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.context.ContextTransfer;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

abstract class AbstractImpersonator
implements IImpersonator {
    private final ExecutorService mExecutorService;
    private final boolean mManagesExecutor;
    private final int mErrorLocale;
    private volatile boolean mReleased = false;
    private static final XQELogger ERROR_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    AbstractImpersonator(ExecutorService executorService, boolean managesExecutor, int errorLocale) {
        if (null == executorService) {
            throw new IllegalArgumentException("executorService was null.");
        }
        this.mExecutorService = executorService;
        this.mManagesExecutor = managesExecutor;
        this.mErrorLocale = errorLocale;
    }

    final int getErrorLocale() {
        return this.mErrorLocale;
    }

    final <T> T runTask(Callable<T> task) throws Throwable {
        Future<T> future = this.mExecutorService.submit(task);
        ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
        ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
        traceCtxTransfer.push();
        execEnvTransfer.push();
        try {
            T t = future.get();
            return t;
        }
        catch (ExecutionException ex) {
            throw ex.getCause();
        }
        finally {
            execEnvTransfer.pop();
            traceCtxTransfer.pop();
        }
    }

    @Override
    public void release() {
        if (this.mReleased) {
            return;
        }
        this.mReleased = true;
        try {
            if (this.mManagesExecutor) {
                this.mExecutorService.shutdownNow();
            }
        }
        catch (Throwable ex) {
            ERROR_LOGGER.log(ex);
        }
    }
}

