/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.secbridge;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.secbridge.CAMImpersonate;
import com.cognos.xqe.data.providers.secbridge.NativeException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class CAMImpersonationTask<T>
implements Callable<T> {
    private static final long SSO_HANDLE_LOCK_TIMEOUT = 30000L;
    private static final int MAX_NUMBER_OF_LOCK = 16;
    private static final Lock[] SSO_HANDLE_STRIPES = new Lock[16];
    private final Callable<T> task;
    private final String ssoDelegationHandle;
    private final int errorLocale;
    private static final XQELogger SECBRIDGE_EXCEPTION_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public static boolean lockDelegationHandle(String ssoHandle) {
        boolean isLocked;
        int lockIndex = Math.abs(ssoHandle.hashCode() % SSO_HANDLE_STRIPES.length);
        Lock lock = SSO_HANDLE_STRIPES[lockIndex];
        try {
            isLocked = lock.tryLock(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL, (Throwable)ex);
        }
        if (!isLocked) {
            SECBRIDGE_EXCEPTION_LOGGER.log(LogLevel.WARN, "Timed out while waiting to acquire a lock before performing a CAM impersonation.");
            throw new XQERuntimeException(XQEMessageKeys.WSB_CAM_COULD_NOT_AQCUIRE_LOCK);
        }
        return isLocked;
    }

    public static void unlockDelegationHandle(String ssoHandle) {
        int lockIndex = Math.abs(ssoHandle.hashCode() % SSO_HANDLE_STRIPES.length);
        Lock lock = SSO_HANDLE_STRIPES[lockIndex];
        lock.unlock();
    }

    public CAMImpersonationTask(Callable<T> theTask, String thessoDelegationHandle, int theErrorLocale) {
        this.task = theTask;
        this.ssoDelegationHandle = thessoDelegationHandle;
        this.errorLocale = theErrorLocale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T call() throws Exception {
        T result = null;
        if (CAMImpersonationTask.lockDelegationHandle(this.ssoDelegationHandle)) {
            try {
                try {
                    CAMImpersonate.beginImpersonation(this.errorLocale, this.ssoDelegationHandle);
                }
                catch (NativeException ex) {
                    throw new XQERuntimeException(XQEMessageKeys.WSB_CAM_COULD_NOT_IMPERSONATE, (Throwable)ex);
                }
                boolean success = false;
                try {
                    result = this.task.call();
                    success = true;
                }
                finally {
                    try {
                        CAMImpersonate.revertImpersonation(this.errorLocale, this.ssoDelegationHandle);
                    }
                    catch (NativeException ex) {
                        if (success) {
                            throw new XQERuntimeException(XQEMessageKeys.WSB_CAM_COULD_NOT_REVERT, (Throwable)ex);
                        }
                        SECBRIDGE_EXCEPTION_LOGGER.log(LogLevel.WARN, "Error occurs during reverting Impersonation: " + ex.getMessage());
                    }
                }
            }
            finally {
                CAMImpersonationTask.unlockDelegationHandle(this.ssoDelegationHandle);
            }
        }
        return result;
    }

    static {
        for (int i = 0; i < SSO_HANDLE_STRIPES.length; ++i) {
            CAMImpersonationTask.SSO_HANDLE_STRIPES[i] = new ReentrantLock();
        }
    }
}

