/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.secbridge;

public final class ErrorStatus {
    private boolean error = false;
    private Category category = Category.UNSPECIFIED;
    private long statusCode = 0L;
    private long causeCode = 0L;
    private String source = null;
    private String message = null;

    public ErrorStatus() {
    }

    public ErrorStatus(Category theCategory, long theStatusCode, long theCauseCode, String theSource, String theMessage) {
        this.setError(theCategory, theStatusCode, theCauseCode, theSource, theMessage);
    }

    public ErrorStatus(int theCategoryOrdinal, long theStatusCode, long theCauseCode, String theSource, String theMessage) {
        this.setError(Category.fromOrdinal(theCategoryOrdinal), theStatusCode, theCauseCode, theSource, theMessage);
    }

    public boolean hasError() {
        return this.error;
    }

    public Category getCategory() {
        return this.category;
    }

    public long getStatusCode() {
        return this.statusCode;
    }

    public long getCauseCode() {
        return this.causeCode;
    }

    public String getSource() {
        return this.source;
    }

    public String getMessage() {
        return this.message;
    }

    public void clearError() {
        this.error = false;
        this.category = Category.UNSPECIFIED;
        this.statusCode = 0L;
        this.causeCode = 0L;
        this.source = null;
        this.message = null;
    }

    public void setError(Category theCategory, long theStatusCode, long theCauseCode, String theSource, String theMessage) {
        this.error = true;
        this.category = theCategory;
        this.statusCode = theStatusCode;
        this.causeCode = theCauseCode;
        this.source = theSource;
        this.message = theMessage;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.error) {
            buffer.append("ERROR [category=").append((Object)this.category);
            buffer.append(",statusCode=").append(this.statusCode);
            buffer.append(",causeCode=").append(this.causeCode);
            if (null != this.source) {
                buffer.append(",source=").append(this.source);
            }
            buffer.append("]");
            if (null != this.message) {
                buffer.append(": ").append(this.message);
            }
        } else {
            buffer.append("OK");
        }
        return buffer.toString();
    }

    public static enum Category {
        UNSPECIFIED,
        WIN_API,
        COM_API,
        OLEDB_API,
        CAM_API,
        ASSERTION,
        LOGON_FAILURE,
        OUT_OF_MEMORY;


        public static Category fromOrdinal(int ordinal) {
            for (Category cat : Category.values()) {
                if (cat.ordinal() != ordinal) continue;
                return cat;
            }
            throw new IllegalArgumentException("Invalid ordinal.");
        }
    }
}

