/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.types;

import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.DataType;
import com.cognos.xqe.data.values.BinaryValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;

public final class BinaryType
extends DataType {
    static final long serialVersionUID = 1L;
    public static final String TYPE_NAME = "binary";
    public static final int DEFAULT_MAXIMUM_LENGTH = 1;
    public static final BinaryType DEFAULTBINARYTYPE = new BinaryType(1);
    protected int maximumLength;

    BinaryType(int maxLength) {
        super((byte)23, DataSubType.BINARYTYPE);
        this.maximumLength = maxLength;
    }

    @Override
    public IValue createValue() {
        return DataValueFactory.createBinaryValue(this);
    }

    @Override
    public int getEncodedValueSize() {
        return BinaryValue.getEncodedSize();
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getSQLText() {
        return String.format("%s(%d)", this.getTypeName(), this.maximumLength);
    }

    @Override
    public int getPrecision() {
        return this.maximumLength;
    }

    @Override
    public int getMaxLength() {
        return this.maximumLength;
    }

    @Override
    public int getJDBCType() {
        return -2;
    }
}

