/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.types;

import com.cognos.xqe.data.types.ExternalBufferType;
import com.cognos.xqe.data.types.TypeInvalidArgumentException;
import com.cognos.xqe.data.values.CharValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.ibm.icu.text.Collator;

public class CharType
extends ExternalBufferType {
    static final long serialVersionUID = -5117305801160082662L;
    public static final String TYPE_NAME = "char";
    public static final int DEFAULT_MAXIMUM_CHAR_LENGTH = 256;
    public static final CharType DEFAULTCHARTYPE = new CharType(256);

    CharType(int maxStrLength) {
        super(maxStrLength);
        if (maxStrLength < -1) {
            throw new TypeInvalidArgumentException(XQEMessageKeys.DAT_InvalidStringLength, Integer.toString(maxStrLength), this.getTypeName());
        }
        this.maximumLength = maxStrLength;
    }

    protected CharType(byte dType, int maxStrLength) throws TypeInvalidArgumentException {
        super(dType, maxStrLength);
    }

    @Override
    public IValue createValue(Collator collator) {
        CharValue v = DataValueFactory.createCharValue(this, collator);
        return v;
    }

    @Override
    public IValue createValue() {
        return DataValueFactory.createCharValue(this);
    }

    @Override
    public int getEncodedValueSize() {
        return CharValue.getEncodedSize();
    }

    @Override
    public boolean hasMaximumLength() {
        return true;
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean exactlyEquivalent(Object obj) {
        boolean status = super.exactlyEquivalent(obj);
        if (status) {
            status = obj instanceof CharType;
        }
        return status;
    }

    @Override
    public int getJDBCType() {
        return 1;
    }
}

